/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.retain.store;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.store.api.IKVIterator;
import org.apache.bifromq.basekv.store.api.IKVRangeCoProc;
import org.apache.bifromq.basekv.store.api.IKVRangeReader;
import org.apache.bifromq.basekv.store.api.IKVRangeRefreshableReader;
import org.apache.bifromq.basekv.store.api.IKVWriter;
import org.apache.bifromq.basekv.store.proto.ROCoProcInput;
import org.apache.bifromq.basekv.store.proto.ROCoProcOutput;
import org.apache.bifromq.basekv.store.proto.RWCoProcInput;
import org.apache.bifromq.basekv.store.proto.RWCoProcOutput;
import org.apache.bifromq.basekv.utils.KVRangeIdUtil;
import org.apache.bifromq.retain.rpc.proto.BatchMatchReply;
import org.apache.bifromq.retain.rpc.proto.BatchMatchRequest;
import org.apache.bifromq.retain.rpc.proto.BatchRetainReply;
import org.apache.bifromq.retain.rpc.proto.BatchRetainRequest;
import org.apache.bifromq.retain.rpc.proto.GCReply;
import org.apache.bifromq.retain.rpc.proto.GCRequest;
import org.apache.bifromq.retain.rpc.proto.MatchParam;
import org.apache.bifromq.retain.rpc.proto.MatchResult;
import org.apache.bifromq.retain.rpc.proto.MatchResultPack;
import org.apache.bifromq.retain.rpc.proto.RetainMessage;
import org.apache.bifromq.retain.rpc.proto.RetainParam;
import org.apache.bifromq.retain.rpc.proto.RetainResult;
import org.apache.bifromq.retain.rpc.proto.RetainServiceROCoProcInput;
import org.apache.bifromq.retain.rpc.proto.RetainServiceROCoProcOutput;
import org.apache.bifromq.retain.rpc.proto.RetainServiceRWCoProcInput;
import org.apache.bifromq.retain.rpc.proto.RetainServiceRWCoProcOutput;
import org.apache.bifromq.retain.store.TenantsStats;
import org.apache.bifromq.retain.store.index.RetainTopicIndex;
import org.apache.bifromq.retain.store.index.RetainedMsgInfo;
import org.apache.bifromq.retain.store.schema.KVSchemaUtil;
import org.apache.bifromq.type.Message;
import org.apache.bifromq.type.TopicMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RetainStoreCoProc
implements IKVRangeCoProc {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetainStoreCoProc.class);
    private final Supplier<IKVRangeRefreshableReader> rangeReaderProvider;
    private final TenantsStats tenantsStats;
    private final String[] tags;
    private RetainTopicIndex index;

    RetainStoreCoProc(String clusterId, String storeId, KVRangeId id, Supplier<IKVRangeRefreshableReader> rangeReaderProvider) {
        this.tags = new String[]{"clusterId", clusterId, "storeId", storeId, "rangeId", KVRangeIdUtil.toString((KVRangeId)id)};
        this.rangeReaderProvider = rangeReaderProvider;
        this.tenantsStats = new TenantsStats(rangeReaderProvider, this.tags);
    }

    public CompletableFuture<ROCoProcOutput> query(ROCoProcInput input, IKVRangeReader reader) {
        RetainServiceROCoProcInput coProcInput = input.getRetainService();
        return switch (coProcInput.getTypeCase()) {
            case RetainServiceROCoProcInput.TypeCase.BATCHMATCH -> this.batchMatch(coProcInput.getBatchMatch(), reader).thenApply(v -> ROCoProcOutput.newBuilder().setRetainService(RetainServiceROCoProcOutput.newBuilder().setBatchMatch(v).build()).build());
            default -> {
                log.error("Unknown co proc type {}", (Object)coProcInput.getTypeCase());
                yield CompletableFuture.failedFuture(new IllegalStateException("Unknown co proc type " + String.valueOf(coProcInput.getTypeCase())));
            }
        };
    }

    public Supplier<IKVRangeCoProc.MutationResult> mutate(RWCoProcInput input, IKVRangeReader reader, IKVWriter writer, boolean isLeader) {
        RetainServiceRWCoProcInput coProcInput = input.getRetainService();
        RetainServiceRWCoProcOutput.Builder outputBuilder = RetainServiceRWCoProcOutput.newBuilder();
        AtomicReference<Runnable> afterMutate = new AtomicReference<Runnable>();
        switch (coProcInput.getTypeCase()) {
            case BATCHRETAIN: {
                BatchRetainReply.Builder replyBuilder = BatchRetainReply.newBuilder();
                afterMutate.set(this.batchRetain(coProcInput.getBatchRetain(), replyBuilder, isLeader, writer));
                outputBuilder.setBatchRetain(replyBuilder);
                break;
            }
            case GC: {
                BatchRetainReply.Builder replyBuilder = GCReply.newBuilder();
                afterMutate.set(this.gc(coProcInput.getGc(), (GCReply.Builder)replyBuilder, isLeader, writer));
                outputBuilder.setGc((GCReply.Builder)replyBuilder);
            }
        }
        RWCoProcOutput output = RWCoProcOutput.newBuilder().setRetainService(outputBuilder.build()).build();
        return () -> {
            ((Runnable)afterMutate.get()).run();
            return new IKVRangeCoProc.MutationResult(output, Optional.empty());
        };
    }

    public Any reset(Boundary boundary) {
        this.load();
        return Any.getDefaultInstance();
    }

    public void onLeader(boolean isLeader) {
        this.tenantsStats.toggleMetering(isLeader);
    }

    public void close() {
        this.index = null;
        this.tenantsStats.close();
    }

    private CompletableFuture<BatchMatchReply> batchMatch(BatchMatchRequest request, IKVRangeReader reader) {
        BatchMatchReply.Builder replyBuilder = BatchMatchReply.newBuilder().setReqId(request.getReqId());
        for (String tenantId : request.getMatchParamsMap().keySet()) {
            MatchResultPack.Builder resultPackBuilder = MatchResultPack.newBuilder();
            for (String topicFilter : ((MatchParam)request.getMatchParamsMap().get(tenantId)).getTopicFiltersMap().keySet()) {
                MatchResult.Builder resultBuilder = MatchResult.newBuilder();
                resultBuilder.addAllMessages(this.match(tenantId, topicFilter, (Integer)((MatchParam)request.getMatchParamsMap().get(tenantId)).getTopicFiltersMap().get(topicFilter), ((MatchParam)request.getMatchParamsMap().get(tenantId)).getNow(), reader));
                resultPackBuilder.putResults(topicFilter, resultBuilder.build());
            }
            replyBuilder.putResultPack(tenantId, resultPackBuilder.build());
        }
        return CompletableFuture.completedFuture(replyBuilder.build());
    }

    private List<TopicMessage> match(String tenantId, String topicFilter, int limit, long now, IKVRangeReader reader) {
        if (limit == 0) {
            return Collections.emptyList();
        }
        Set<RetainedMsgInfo> matchedMsgInfos = this.index.match(tenantId, topicFilter);
        LinkedList<TopicMessage> messages = new LinkedList<TopicMessage>();
        for (RetainedMsgInfo msgInfo : matchedMsgInfos) {
            TopicMessage message;
            if (messages.size() >= limit) break;
            Optional val = reader.get(KVSchemaUtil.retainMessageKey((String)msgInfo.tenantId, (String)msgInfo.topic));
            if (!val.isPresent() || this.expireAt((message = TopicMessage.parseFrom((ByteString)((ByteString)val.get()))).getMessage()) <= now) continue;
            messages.add(message);
        }
        return messages;
    }

    private Runnable batchRetain(BatchRetainRequest request, BatchRetainReply.Builder replyBuilder, boolean isLeader, IKVWriter writer) {
        replyBuilder.setReqId(request.getReqId());
        HashMap<String, Map> addTopics = new HashMap<String, Map>();
        HashMap<String, Map> updateTopics = new HashMap<String, Map>();
        HashMap<String, Set> removeTopics = new HashMap<String, Set>();
        for (String tenantId : request.getParamsMap().keySet()) {
            HashMap<String, RetainResult.Code> results = new HashMap<String, RetainResult.Code>();
            for (Map.Entry entry : ((RetainParam)request.getParamsMap().get(tenantId)).getTopicMessagesMap().entrySet()) {
                String topic = (String)entry.getKey();
                RetainMessage retainMessage = (RetainMessage)entry.getValue();
                TopicMessage topicMessage = TopicMessage.newBuilder().setTopic(topic).setMessage(retainMessage.getMessage()).setPublisher(retainMessage.getPublisher()).build();
                ByteString retainKey = KVSchemaUtil.retainMessageKey((String)tenantId, (String)topicMessage.getTopic());
                Set<RetainedMsgInfo> retainedMsgInfos = this.index.match(tenantId, topic);
                if (topicMessage.getMessage().getPayload().isEmpty()) {
                    if (!retainedMsgInfos.isEmpty()) {
                        writer.delete(retainKey);
                        removeTopics.computeIfAbsent(tenantId, k -> new HashSet()).add(topic);
                    }
                    results.put(topic, RetainResult.Code.CLEARED);
                    continue;
                }
                if (retainedMsgInfos.isEmpty()) {
                    writer.put(retainKey, topicMessage.toByteString());
                    addTopics.computeIfAbsent(tenantId, k -> new HashMap()).put(topic, topicMessage.getMessage());
                } else {
                    writer.put(retainKey, topicMessage.toByteString());
                    updateTopics.computeIfAbsent(tenantId, k -> new HashMap()).put(topic, topicMessage.getMessage());
                }
                results.put(topic, RetainResult.Code.RETAINED);
            }
            replyBuilder.putResults(tenantId, RetainResult.newBuilder().putAllResults(results).build());
        }
        return () -> {
            addTopics.forEach((tenantId, topics) -> {
                topics.forEach((topic, msg) -> this.index.add((String)tenantId, (String)topic, msg.getTimestamp(), msg.getExpiryInterval()));
                this.tenantsStats.increaseTopicCount((String)tenantId, topics.size());
            });
            updateTopics.forEach((tenantId, topics) -> {
                topics.forEach((topic, msg) -> this.index.remove((String)tenantId, (String)topic));
                topics.forEach((topic, msg) -> this.index.add((String)tenantId, (String)topic, msg.getTimestamp(), msg.getExpiryInterval()));
            });
            removeTopics.forEach((tenantId, topics) -> {
                topics.forEach(topic -> this.index.remove((String)tenantId, (String)topic));
                this.tenantsStats.increaseTopicCount((String)tenantId, -topics.size());
            });
            this.tenantsStats.toggleMetering(isLeader);
        };
    }

    private Runnable gc(GCRequest request, GCReply.Builder replyBuilder, boolean isLeader, IKVWriter writer) {
        replyBuilder.setReqId(request.getReqId());
        long now = request.getNow();
        HashMap<String, Set> removedTopics = new HashMap<String, Set>();
        Set<RetainedMsgInfo> retainedMsgInfos = request.hasTenantId() ? this.index.match(request.getTenantId(), "#") : this.index.findAll();
        for (RetainedMsgInfo msgInfo : retainedMsgInfos) {
            long expireTime = this.expireAt(msgInfo.timestamp, request.hasExpirySeconds() ? request.getExpirySeconds() : msgInfo.expirySeconds);
            if (expireTime > now) continue;
            writer.delete(KVSchemaUtil.retainMessageKey((String)msgInfo.tenantId, (String)msgInfo.topic));
            removedTopics.computeIfAbsent(msgInfo.tenantId, k -> new HashSet()).add(msgInfo.topic);
        }
        return () -> {
            removedTopics.forEach((tenantId, topics) -> topics.forEach(topic -> this.index.remove((String)tenantId, (String)topic)));
            removedTopics.forEach((tenantId, topics) -> this.tenantsStats.increaseTopicCount((String)tenantId, -topics.size()));
            this.tenantsStats.toggleMetering(isLeader);
        };
    }

    private void load() {
        this.index = new RetainTopicIndex();
        this.tenantsStats.reset();
        try (IKVRangeRefreshableReader reader = this.rangeReaderProvider.get();
             IKVIterator itr = reader.iterator();){
            itr.seekToFirst();
            while (itr.isValid()) {
                try {
                    String tenantId = KVSchemaUtil.parseTenantId((ByteString)itr.key());
                    TopicMessage topicMessage = TopicMessage.parseFrom((ByteString)itr.value());
                    this.index.add(tenantId, topicMessage.getTopic(), topicMessage.getMessage().getTimestamp(), topicMessage.getMessage().getExpiryInterval());
                    this.tenantsStats.increaseTopicCount(tenantId, 1);
                }
                catch (InvalidProtocolBufferException e) {
                    log.error("Failed to parse retained message", (Throwable)e);
                }
                itr.next();
            }
        }
    }

    private long expireAt(Message message) {
        return this.expireAt(message.getTimestamp(), message.getExpiryInterval());
    }

    private long expireAt(long hlc, int expirySeconds) {
        return Duration.ofMillis(HLC.INST.getPhysical(hlc)).plusSeconds(expirySeconds).toMillis();
    }
}

