/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.store.range;

import com.google.protobuf.ByteString;
import java.util.Optional;
import org.apache.bifromq.basekv.localengine.IKVSpaceReader;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.proto.State;
import org.apache.bifromq.basekv.raft.proto.ClusterConfig;
import org.apache.bifromq.basekv.store.api.IKVIterator;
import org.apache.bifromq.basekv.store.api.IKVRangeReader;
import org.apache.bifromq.basekv.store.range.KVIterator;
import org.apache.bifromq.basekv.store.range.KVRangeKeys;
import org.apache.bifromq.basekv.store.util.KVUtil;

class KVRangeReader
implements IKVRangeReader {
    protected final IKVSpaceReader kvSpaceReader;

    public KVRangeReader(IKVSpaceReader spaceReader) {
        this.kvSpaceReader = spaceReader;
    }

    public final long version() {
        return this.kvSpaceReader.metadata(KVRangeKeys.METADATA_VER_BYTES).map(KVUtil::toLongNativeOrder).orElse(-1L);
    }

    public final State state() {
        return this.kvSpaceReader.metadata(KVRangeKeys.METADATA_STATE_BYTES).map(stateBytes -> {
            try {
                return State.parseFrom((ByteString)stateBytes);
            }
            catch (Throwable e) {
                return State.newBuilder().setType(State.StateType.NoUse).build();
            }
        }).orElse(State.newBuilder().setType(State.StateType.NoUse).build());
    }

    public final long lastAppliedIndex() {
        return this.kvSpaceReader.metadata(KVRangeKeys.METADATA_LAST_APPLIED_INDEX_BYTES).map(KVUtil::toLong).orElse(-1L);
    }

    public final Boundary boundary() {
        return this.kvSpaceReader.metadata(KVRangeKeys.METADATA_RANGE_BOUND_BYTES).map(boundaryBytes -> {
            try {
                return Boundary.parseFrom((ByteString)boundaryBytes);
            }
            catch (Throwable e) {
                return Boundary.getDefaultInstance();
            }
        }).orElse(Boundary.getDefaultInstance());
    }

    public final ClusterConfig clusterConfig() {
        return this.kvSpaceReader.metadata(KVRangeKeys.METADATA_CLUSTER_CONFIG_BYTES).map(clusterConfigBytes -> {
            try {
                return ClusterConfig.parseFrom((ByteString)clusterConfigBytes);
            }
            catch (Throwable e) {
                return ClusterConfig.getDefaultInstance();
            }
        }).orElse(ClusterConfig.getDefaultInstance());
    }

    public final long size(Boundary boundary) {
        return this.kvSpaceReader.size(boundary);
    }

    public final boolean exist(ByteString key) {
        return this.kvSpaceReader.exist(key);
    }

    public final Optional<ByteString> get(ByteString key) {
        return this.kvSpaceReader.get(key);
    }

    public final IKVIterator iterator() {
        return new KVIterator(this.kvSpaceReader.newIterator());
    }

    public final IKVIterator iterator(Boundary boundary) {
        return new KVIterator(this.kvSpaceReader.newIterator(boundary));
    }

    public final void close() {
        this.kvSpaceReader.close();
    }
}

