/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.server.scheduler;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import lombok.Generated;
import org.apache.bifromq.basekv.client.IMutationPipeline;
import org.apache.bifromq.basekv.client.exception.BadVersionException;
import org.apache.bifromq.basekv.client.exception.TryLaterException;
import org.apache.bifromq.basekv.client.scheduler.BatchMutationCall;
import org.apache.bifromq.basekv.client.scheduler.MutationCallBatcherKey;
import org.apache.bifromq.basekv.store.proto.RWCoProcInput;
import org.apache.bifromq.basekv.store.proto.RWCoProcOutput;
import org.apache.bifromq.baserpc.client.exception.ServerNotFoundException;
import org.apache.bifromq.basescheduler.ICallTask;
import org.apache.bifromq.inbox.rpc.proto.DeleteReply;
import org.apache.bifromq.inbox.rpc.proto.DeleteRequest;
import org.apache.bifromq.inbox.storage.proto.BatchDeleteReply;
import org.apache.bifromq.inbox.storage.proto.BatchDeleteRequest;
import org.apache.bifromq.inbox.storage.proto.InboxServiceRWCoProcInput;
import org.apache.bifromq.inbox.storage.proto.InboxVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchDeleteCall
extends BatchMutationCall<DeleteRequest, DeleteReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchDeleteCall.class);

    protected BatchDeleteCall(IMutationPipeline pipeline, MutationCallBatcherKey batcherKey) {
        super(pipeline, batcherKey);
    }

    protected BatchMutationCall.MutationCallTaskBatch<DeleteRequest, DeleteReply> newBatch(long ver) {
        return new BatchDeleteCallTask(ver);
    }

    protected RWCoProcInput makeBatch(Iterable<ICallTask<DeleteRequest, DeleteReply, MutationCallBatcherKey>> callTasks) {
        BatchDeleteRequest.Builder reqBuilder = BatchDeleteRequest.newBuilder();
        callTasks.forEach(call -> {
            DeleteRequest request = (DeleteRequest)call.call();
            BatchDeleteRequest.Params.Builder paramsBuilder = BatchDeleteRequest.Params.newBuilder().setTenantId(request.getTenantId()).setInboxId(request.getInboxId()).setVersion(request.getVersion());
            reqBuilder.addParams(paramsBuilder.build());
        });
        long reqId = System.nanoTime();
        return RWCoProcInput.newBuilder().setInboxService(InboxServiceRWCoProcInput.newBuilder().setReqId(reqId).setBatchDelete(reqBuilder.build()).build()).build();
    }

    protected void handleOutput(Queue<ICallTask<DeleteRequest, DeleteReply, MutationCallBatcherKey>> batchedTasks, RWCoProcOutput output) {
        ICallTask<DeleteRequest, DeleteReply, MutationCallBatcherKey> callTask;
        assert (batchedTasks.size() == output.getInboxService().getBatchDelete().getResultCount());
        int i = 0;
        block5: while ((callTask = batchedTasks.poll()) != null) {
            BatchDeleteReply.Result result = output.getInboxService().getBatchDelete().getResult(i++);
            DeleteReply.Builder replyBuilder = DeleteReply.newBuilder().setReqId(((DeleteRequest)callTask.call()).getReqId());
            switch (result.getCode()) {
                case OK: {
                    callTask.resultPromise().complete(replyBuilder.setCode(DeleteReply.Code.OK).putAllTopicFilters(result.getTopicFiltersMap()).build());
                    continue block5;
                }
                case NO_INBOX: {
                    callTask.resultPromise().complete(replyBuilder.setCode(DeleteReply.Code.NO_INBOX).build());
                    continue block5;
                }
                case CONFLICT: {
                    callTask.resultPromise().complete(replyBuilder.setCode(DeleteReply.Code.CONFLICT).build());
                    continue block5;
                }
            }
            log.error("Unexpected delete result: {}", (Object)result.getCode());
            callTask.resultPromise().complete(replyBuilder.setCode(DeleteReply.Code.ERROR).build());
        }
    }

    protected void handleException(ICallTask<DeleteRequest, DeleteReply, MutationCallBatcherKey> callTask, Throwable e) {
        if (e instanceof ServerNotFoundException) {
            callTask.resultPromise().complete(DeleteReply.newBuilder().setReqId(((DeleteRequest)callTask.call()).getReqId()).setCode(DeleteReply.Code.TRY_LATER).build());
            return;
        }
        if (e instanceof BadVersionException) {
            callTask.resultPromise().complete(DeleteReply.newBuilder().setReqId(((DeleteRequest)callTask.call()).getReqId()).setCode(DeleteReply.Code.TRY_LATER).build());
            return;
        }
        if (e instanceof TryLaterException) {
            callTask.resultPromise().complete(DeleteReply.newBuilder().setReqId(((DeleteRequest)callTask.call()).getReqId()).setCode(DeleteReply.Code.TRY_LATER).build());
            return;
        }
        callTask.resultPromise().completeExceptionally(e);
    }

    private static class BatchDeleteCallTask
    extends BatchMutationCall.MutationCallTaskBatch<DeleteRequest, DeleteReply> {
        private final Map<String, Set<InboxVersion>> inboxes = new HashMap<String, Set<InboxVersion>>();

        private BatchDeleteCallTask(long ver) {
            super(ver);
        }

        protected void add(ICallTask<DeleteRequest, DeleteReply, MutationCallBatcherKey> callTask) {
            super.add(callTask);
            this.inboxes.computeIfAbsent(((DeleteRequest)callTask.call()).getTenantId(), k -> new HashSet()).add(((DeleteRequest)callTask.call()).getVersion());
        }

        protected boolean isBatchable(ICallTask<DeleteRequest, DeleteReply, MutationCallBatcherKey> callTask) {
            return !this.inboxes.getOrDefault(((DeleteRequest)callTask.call()).getTenantId(), Collections.emptySet()).contains(((DeleteRequest)callTask.call()).getVersion());
        }
    }
}

