/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baseenv;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufAllocatorMetric;
import io.netty.buffer.ByteBufAllocatorMetricProvider;
import io.netty.buffer.PoolArenaMetric;
import io.netty.buffer.PoolChunkListMetric;
import io.netty.buffer.PoolChunkMetric;
import io.netty.buffer.PooledByteBufAllocatorMetric;
import io.netty.util.internal.PlatformDependent;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.bifromq.baseenv.EnvProvider;

public class MemUsage {
    private static final long UPDATE_INTERVAL = Duration.ofMillis(10L).toNanos();
    private static final long JVM_MAX_DIRECT_MEMORY = PlatformDependent.estimateMaxDirectMemory();
    private static final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    private static final ThreadLocal<MemUsage> THREAD_LOCAL = ThreadLocal.withInitial(MemUsage::new);
    private static final NonblockingNettyDirectMemoryUsage nonblockingNettyDirectMemoryUsage = new NonblockingNettyDirectMemoryUsage();
    private double nettyDirectMemoryUsage = 0.0;
    private double heapMemoryUsage = 0.0;
    private long refreshNettyDirectMemoryUsageAt = 0L;
    private long refreshHeapMemoryUsageAt = 0L;

    public static MemUsage local() {
        return THREAD_LOCAL.get();
    }

    public double nettyDirectMemoryUsage() {
        this.scheduleNettyDirectMemoryUsage();
        return this.nettyDirectMemoryUsage;
    }

    public double heapMemoryUsage() {
        this.scheduleHeapMemoryUsage();
        return this.heapMemoryUsage;
    }

    private void scheduleNettyDirectMemoryUsage() {
        long now = System.nanoTime();
        if (now - this.refreshNettyDirectMemoryUsageAt > UPDATE_INTERVAL) {
            this.nettyDirectMemoryUsage = nonblockingNettyDirectMemoryUsage.usage();
            this.refreshNettyDirectMemoryUsageAt = System.nanoTime();
        }
    }

    private void scheduleHeapMemoryUsage() {
        long now = System.nanoTime();
        if (now - this.refreshHeapMemoryUsageAt > UPDATE_INTERVAL) {
            this.heapMemoryUsage = this.calculateHeapMemoryUsage();
            this.refreshHeapMemoryUsageAt = System.nanoTime();
        }
    }

    private double calculateHeapMemoryUsage() {
        try {
            MemoryUsage memoryUsage = memoryMXBean.getHeapMemoryUsage();
            long usedHeapMemory = memoryUsage.getUsed();
            long maxHeapMemory = memoryUsage.getMax();
            return (double)usedHeapMemory / (double)maxHeapMemory;
        }
        catch (IllegalArgumentException e) {
            return 0.0;
        }
    }

    private static class NonblockingNettyDirectMemoryUsage {
        private final Executor executor = Executors.newSingleThreadExecutor(EnvProvider.INSTANCE.newThreadFactory("netty-pool-usage-reader", true));
        private final AtomicBoolean isRefreshing = new AtomicBoolean(false);
        private final int[] buckets = new int[101];
        private volatile double nettyDirectMemoryUsage = 0.0;

        private NonblockingNettyDirectMemoryUsage() {
        }

        double usage() {
            this.scheduleRefresh();
            return this.nettyDirectMemoryUsage;
        }

        void scheduleRefresh() {
            if (this.isRefreshing.compareAndSet(false, true)) {
                this.executor.execute(() -> {
                    this.nettyDirectMemoryUsage = this.calculateNettyDirectMemoryUsage();
                    this.isRefreshing.set(false);
                });
            }
        }

        private double calculateNettyDirectMemoryUsage() {
            if (PlatformDependent.useDirectBufferNoCleaner()) {
                if (ByteBufAllocator.DEFAULT.isDirectBufferPooled()) {
                    long pooledDirectMemory = PlatformDependent.usedDirectMemory();
                    double pooledDirectMemoryUsage = this.pooledDirectMemoryUsage();
                    double jvmDirectMemoryUsage = (double)pooledDirectMemory / (double)JVM_MAX_DIRECT_MEMORY;
                    return Math.min(pooledDirectMemoryUsage, jvmDirectMemoryUsage);
                }
                return (double)PlatformDependent.usedDirectMemory() / (double)PlatformDependent.maxDirectMemory();
            }
            ByteBufAllocatorMetric allocatorMetric = ((ByteBufAllocatorMetricProvider)ByteBufAllocator.DEFAULT).metric();
            long usedDirectMemory = allocatorMetric.usedDirectMemory();
            if (ByteBufAllocator.DEFAULT.isDirectBufferPooled()) {
                double pooledDirectMemoryUsage = this.pooledDirectMemoryUsage();
                double jvmDirectMemoryUsage = (double)usedDirectMemory / (double)JVM_MAX_DIRECT_MEMORY;
                return Math.min(pooledDirectMemoryUsage, jvmDirectMemoryUsage);
            }
            return (double)usedDirectMemory / (double)Math.min(PlatformDependent.maxDirectMemory(), JVM_MAX_DIRECT_MEMORY);
        }

        private double pooledDirectMemoryUsage() {
            PooledByteBufAllocatorMetric allocatorMetric = (PooledByteBufAllocatorMetric)((ByteBufAllocatorMetricProvider)ByteBufAllocator.DEFAULT).metric();
            Arrays.fill(this.buckets, 0);
            int totalChunks = 0;
            for (PoolArenaMetric arenaMetric : allocatorMetric.directArenas()) {
                totalChunks += this.collectChunkUsages(arenaMetric, this.buckets);
            }
            return this.calculatePercentile(this.buckets, totalChunks, 90.0) / 100.0;
        }

        private int collectChunkUsages(PoolArenaMetric arenaMetric, int[] buckets) {
            int totalChunks = 0;
            for (PoolChunkListMetric chunkListMetric : arenaMetric.chunkLists()) {
                for (PoolChunkMetric chunkMetric : chunkListMetric) {
                    int usage;
                    int n = usage = chunkMetric.usage();
                    buckets[n] = buckets[n] + 1;
                    ++totalChunks;
                }
            }
            return totalChunks;
        }

        private double calculatePercentile(int[] buckets, int totalChunks, double percentile) {
            if (totalChunks == 0) {
                return 0.0;
            }
            int threshold = (int)Math.ceil(percentile / 100.0 * (double)totalChunks);
            int cumulativeCount = 0;
            for (int i = 0; i < buckets.length; ++i) {
                if ((cumulativeCount += buckets[i]) < threshold) continue;
                return i;
            }
            return 100.0;
        }
    }
}

