/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.store;

import com.google.protobuf.ByteString;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.store.api.IKVRangeCoProc;
import org.apache.bifromq.basekv.store.api.IKVRangeCoProcFactory;
import org.apache.bifromq.basekv.store.api.IKVRangeRefreshableReader;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.apache.bifromq.dist.client.IDistClient;
import org.apache.bifromq.inbox.client.IInboxClient;
import org.apache.bifromq.inbox.store.InboxStoreCoProc;
import org.apache.bifromq.inbox.store.schema.KVSchemaUtil;
import org.apache.bifromq.plugin.eventcollector.IEventCollector;
import org.apache.bifromq.plugin.resourcethrottler.IResourceThrottler;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.retain.client.IRetainClient;
import org.apache.bifromq.sessiondict.client.ISessionDictClient;

public class InboxStoreCoProcFactory
implements IKVRangeCoProcFactory {
    private final IDistClient distClient;
    private final IInboxClient inboxClient;
    private final IRetainClient retainClient;
    private final ISessionDictClient sessionDictClient;
    private final ISettingProvider settingProvider;
    private final IEventCollector eventCollector;
    private final IResourceThrottler resourceThrottler;
    private final Duration detachTimeout;
    private final Duration metaCacheExpireTime;
    private final int expireRateLimit;

    public InboxStoreCoProcFactory(IDistClient distClient, IInboxClient inboxClient, IRetainClient retainClient, ISessionDictClient sessionDictClient, ISettingProvider settingProvider, IEventCollector eventCollector, IResourceThrottler resourceThrottler, Duration detachTimeout, Duration metaCacheExpireTime, int expireRateLimit) {
        this.distClient = distClient;
        this.inboxClient = inboxClient;
        this.retainClient = retainClient;
        this.sessionDictClient = sessionDictClient;
        this.settingProvider = settingProvider;
        this.eventCollector = eventCollector;
        this.resourceThrottler = resourceThrottler;
        this.detachTimeout = detachTimeout;
        this.metaCacheExpireTime = metaCacheExpireTime;
        this.expireRateLimit = expireRateLimit;
    }

    public Optional<ByteString> toSplitKey(ByteString key, Boundary boundary) {
        ByteString splitKey = BoundaryUtil.upperBound((ByteString)KVSchemaUtil.parseInboxBucketPrefix((ByteString)key));
        if (splitKey != null && BoundaryUtil.compareStartKey((ByteString)BoundaryUtil.startKey((Boundary)boundary), (ByteString)splitKey) < 0 && BoundaryUtil.compareEndKeys((ByteString)splitKey, (ByteString)BoundaryUtil.endKey((Boundary)boundary)) < 0) {
            return Optional.of(splitKey);
        }
        return Optional.empty();
    }

    public IKVRangeCoProc createCoProc(String clusterId, String storeId, KVRangeId id, Supplier<IKVRangeRefreshableReader> rangeReaderProvider) {
        return new InboxStoreCoProc(clusterId, storeId, id, this.distClient, this.inboxClient, this.retainClient, this.sessionDictClient, this.settingProvider, this.eventCollector, this.resourceThrottler, rangeReaderProvider, this.detachTimeout, this.metaCacheExpireTime, this.expireRateLimit);
    }

    public void close() {
    }
}

