/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements. See the NOTICE file distributed with this
work for additional information regarding copyright ownership. The ASF
licenses this file to You under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
License for the specific language governing permissions and limitations
under the License.
*/
// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.0
// 	protoc        v3.21.1
// source: pd_pulse.proto

package pulse

import (
	reflect "reflect"
	sync "sync"
	common "vermeer/apps/protos/hugegraph-pd-grpc/common"
	metapb "vermeer/apps/protos/hugegraph-pd-grpc/metapb"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// enums
type PulseType int32

const (
	PulseType_PULSE_TYPE_UNKNOWN             PulseType = 0
	PulseType_PULSE_TYPE_PARTITION_HEARTBEAT PulseType = 1
)

// Enum value maps for PulseType.
var (
	PulseType_name = map[int32]string{
		0: "PULSE_TYPE_UNKNOWN",
		1: "PULSE_TYPE_PARTITION_HEARTBEAT",
	}
	PulseType_value = map[string]int32{
		"PULSE_TYPE_UNKNOWN":             0,
		"PULSE_TYPE_PARTITION_HEARTBEAT": 1,
	}
)

func (x PulseType) Enum() *PulseType {
	p := new(PulseType)
	*p = x
	return p
}

func (x PulseType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PulseType) Descriptor() protoreflect.EnumDescriptor {
	return file_pd_pulse_proto_enumTypes[0].Descriptor()
}

func (PulseType) Type() protoreflect.EnumType {
	return &file_pd_pulse_proto_enumTypes[0]
}

func (x PulseType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PulseType.Descriptor instead.
func (PulseType) EnumDescriptor() ([]byte, []int) {
	return file_pd_pulse_proto_rawDescGZIP(), []int{0}
}

type PulseChangeType int32

const (
	PulseChangeType_PULSE_CHANGE_TYPE_UNKNOWN PulseChangeType = 0
	PulseChangeType_PULSE_CHANGE_TYPE_ADD     PulseChangeType = 1
	PulseChangeType_PULSE_CHANGE_TYPE_ALTER   PulseChangeType = 2
	PulseChangeType_PULSE_CHANGE_TYPE_DEL     PulseChangeType = 3
)

// Enum value maps for PulseChangeType.
var (
	PulseChangeType_name = map[int32]string{
		0: "PULSE_CHANGE_TYPE_UNKNOWN",
		1: "PULSE_CHANGE_TYPE_ADD",
		2: "PULSE_CHANGE_TYPE_ALTER",
		3: "PULSE_CHANGE_TYPE_DEL",
	}
	PulseChangeType_value = map[string]int32{
		"PULSE_CHANGE_TYPE_UNKNOWN": 0,
		"PULSE_CHANGE_TYPE_ADD":     1,
		"PULSE_CHANGE_TYPE_ALTER":   2,
		"PULSE_CHANGE_TYPE_DEL":     3,
	}
)

func (x PulseChangeType) Enum() *PulseChangeType {
	p := new(PulseChangeType)
	*p = x
	return p
}

func (x PulseChangeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PulseChangeType) Descriptor() protoreflect.EnumDescriptor {
	return file_pd_pulse_proto_enumTypes[1].Descriptor()
}

func (PulseChangeType) Type() protoreflect.EnumType {
	return &file_pd_pulse_proto_enumTypes[1]
}

func (x PulseChangeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PulseChangeType.Descriptor instead.
func (PulseChangeType) EnumDescriptor() ([]byte, []int) {
	return file_pd_pulse_proto_rawDescGZIP(), []int{1}
}

type ConfChangeType int32

const (
	ConfChangeType_CONF_CHANGE_TYPE_UNKNOWN          ConfChangeType = 0
	ConfChangeType_CONF_CHANGE_TYPE_ADD_NODE         ConfChangeType = 1
	ConfChangeType_CONF_CHANGE_TYPE_REMOVE_NODE      ConfChangeType = 2
	ConfChangeType_CONF_CHANGE_TYPE_ADD_LEARNER_NODE ConfChangeType = 3
	ConfChangeType_CONF_CHANGE_TYPE_ADJUST           ConfChangeType = 4 // 调整shard，leader根据新的配置动态增减。
)

// Enum value maps for ConfChangeType.
var (
	ConfChangeType_name = map[int32]string{
		0: "CONF_CHANGE_TYPE_UNKNOWN",
		1: "CONF_CHANGE_TYPE_ADD_NODE",
		2: "CONF_CHANGE_TYPE_REMOVE_NODE",
		3: "CONF_CHANGE_TYPE_ADD_LEARNER_NODE",
		4: "CONF_CHANGE_TYPE_ADJUST",
	}
	ConfChangeType_value = map[string]int32{
		"CONF_CHANGE_TYPE_UNKNOWN":          0,
		"CONF_CHANGE_TYPE_ADD_NODE":         1,
		"CONF_CHANGE_TYPE_REMOVE_NODE":      2,
		"CONF_CHANGE_TYPE_ADD_LEARNER_NODE": 3,
		"CONF_CHANGE_TYPE_ADJUST":           4,
	}
)

func (x ConfChangeType) Enum() *ConfChangeType {
	p := new(ConfChangeType)
	*p = x
	return p
}

func (x ConfChangeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConfChangeType) Descriptor() protoreflect.EnumDescriptor {
	return file_pd_pulse_proto_enumTypes[2].Descriptor()
}

func (ConfChangeType) Type() protoreflect.EnumType {
	return &file_pd_pulse_proto_enumTypes[2]
}

func (x ConfChangeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConfChangeType.Descriptor instead.
func (ConfChangeType) EnumDescriptor() ([]byte, []int) {
	return file_pd_pulse_proto_rawDescGZIP(), []int{2}
}

type CleanType int32

const (
	CleanType_CLEAN_TYPE_KEEP_RANGE    CleanType = 0 // 仅保留这个range
	CleanType_CLEAN_TYPE_EXCLUDE_RANGE CleanType = 1 // 删除这个range
)

// Enum value maps for CleanType.
var (
	CleanType_name = map[int32]string{
		0: "CLEAN_TYPE_KEEP_RANGE",
		1: "CLEAN_TYPE_EXCLUDE_RANGE",
	}
	CleanType_value = map[string]int32{
		"CLEAN_TYPE_KEEP_RANGE":    0,
		"CLEAN_TYPE_EXCLUDE_RANGE": 1,
	}
)

func (x CleanType) Enum() *CleanType {
	p := new(CleanType)
	*p = x
	return p
}

func (x CleanType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CleanType) Descriptor() protoreflect.EnumDescriptor {
	return file_pd_pulse_proto_enumTypes[3].Descriptor()
}

func (CleanType) Type() protoreflect.EnumType {
	return &file_pd_pulse_proto_enumTypes[3]
}

func (x CleanType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CleanType.Descriptor instead.
func (CleanType) EnumDescriptor() ([]byte, []int) {
	return file_pd_pulse_proto_rawDescGZIP(), []int{3}
}

// requests
type PulseRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	CreateRequest *PulseCreateRequest `protobuf:"bytes,1,opt,name=create_request,json=createRequest,proto3" json:"create_request,omitempty"`
	CancelRequest *PulseCancelRequest `protobuf:"bytes,2,opt,name=cancel_request,json=cancelRequest,proto3" json:"cancel_request,omitempty"`
	NoticeRequest *PulseNoticeRequest `protobuf:"bytes,3,opt,name=notice_request,json=noticeRequest,proto3" json:"notice_request,omitempty"`
	AckRequest    *PulseAckRequest    `protobuf:"bytes,4,opt,name=ack_request,json=ackRequest,proto3" json:"ack_request,omitempty"`
}

func (x *PulseRequest) Reset() {
	*x = PulseRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pd_pulse_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PulseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PulseRequest) ProtoMessage() {}

func (x *PulseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pd_pulse_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PulseRequest.ProtoReflect.Descriptor instead.
func (*PulseRequest) Descriptor() ([]byte, []int) {
	return file_pd_pulse_proto_rawDescGZIP(), []int{0}
}

func (x *PulseRequest) GetCreateRequest() *PulseCreateRequest {
	if x != nil {
		return x.CreateRequest
	}
	return nil
}

func (x *PulseRequest) GetCancelRequest() *PulseCancelRequest {
	if x != nil {
		return x.CancelRequest
	}
	return nil
}

func (x *PulseRequest) GetNoticeRequest() *PulseNoticeRequest {
	if x != nil {
		return x.NoticeRequest
	}
	return nil
}

func (x *PulseRequest) GetAckRequest() *PulseAckRequest {
	if x != nil {
		return x.AckRequest
	}
	return nil
}

type PulseCreateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PulseType PulseType `protobuf:"varint,1,opt,name=pulse_type,json=pulseType,proto3,enum=PulseType" json:"pulse_type,omitempty"`
}

func (x *PulseCreateRequest) Reset() {
	*x = PulseCreateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pd_pulse_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PulseCreateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PulseCreateRequest) ProtoMessage() {}

func (x *PulseCreateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pd_pulse_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PulseCreateRequest.ProtoReflect.Descriptor instead.
func (*PulseCreateRequest) Descriptor() ([]byte, []int) {
	return file_pd_pulse_proto_rawDescGZIP(), []int{1}
}

func (x *PulseCreateRequest) GetPulseType() PulseType {
	if x != nil {
		return x.PulseType
	}
	return PulseType_PULSE_TYPE_UNKNOWN
}

type PulseCancelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ObserverId int64 `protobuf:"varint,1,opt,name=observer_id,json=observerId,proto3" json:"observer_id,omitempty"`
}

func (x *PulseCancelRequest) Reset() {
	*x = PulseCancelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pd_pulse_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PulseCancelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PulseCancelRequest) ProtoMessage() {}

func (x *PulseCancelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pd_pulse_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PulseCancelRequest.ProtoReflect.Descriptor instead.
func (*PulseCancelRequest) Descriptor() ([]byte, []int) {
	return file_pd_pulse_proto_rawDescGZIP(), []int{2}
}

func (x *PulseCancelRequest) GetObserverId() int64 {
	if x != nil {
		return x.ObserverId
	}
	return 0
}

type PulseNoticeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ObserverId int64 `protobuf:"varint,1,opt,name=observer_id,json=observerId,proto3" json:"observer_id,omitempty"`
	// Types that are assignable to RequestUnion:
	//	*PulseNoticeRequest_PartitionHeartbeatRequest
	RequestUnion isPulseNoticeRequest_RequestUnion `protobuf_oneof:"request_union"`
}

func (x *PulseNoticeRequest) Reset() {
	*x = PulseNoticeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pd_pulse_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PulseNoticeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PulseNoticeRequest) ProtoMessage() {}

func (x *PulseNoticeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pd_pulse_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PulseNoticeRequest.ProtoReflect.Descriptor instead.
func (*PulseNoticeRequest) Descriptor() ([]byte, []int) {
	return file_pd_pulse_proto_rawDescGZIP(), []int{3}
}

func (x *PulseNoticeRequest) GetObserverId() int64 {
	if x != nil {
		return x.ObserverId
	}
	return 0
}

func (m *PulseNoticeRequest) GetRequestUnion() isPulseNoticeRequest_RequestUnion {
	if m != nil {
		return m.RequestUnion
	}
	return nil
}

func (x *PulseNoticeRequest) GetPartitionHeartbeatRequest() *PartitionHeartbeatRequest {
	if x, ok := x.GetRequestUnion().(*PulseNoticeRequest_PartitionHeartbeatRequest); ok {
		return x.PartitionHeartbeatRequest
	}
	return nil
}

type isPulseNoticeRequest_RequestUnion interface {
	isPulseNoticeRequest_RequestUnion()
}

type PulseNoticeRequest_PartitionHeartbeatRequest struct {
	PartitionHeartbeatRequest *PartitionHeartbeatRequest `protobuf:"bytes,10,opt,name=partition_heartbeat_request,json=partitionHeartbeatRequest,proto3,oneof"`
}

func (*PulseNoticeRequest_PartitionHeartbeatRequest) isPulseNoticeRequest_RequestUnion() {}

type PulseAckRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ObserverId int64 `protobuf:"varint,1,opt,name=observer_id,json=observerId,proto3" json:"observer_id,omitempty"`
	NoticeId   int64 `protobuf:"varint,2,opt,name=notice_id,json=noticeId,proto3" json:"notice_id,omitempty"`
}

func (x *PulseAckRequest) Reset() {
	*x = PulseAckRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pd_pulse_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PulseAckRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PulseAckRequest) ProtoMessage() {}

func (x *PulseAckRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pd_pulse_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PulseAckRequest.ProtoReflect.Descriptor instead.
func (*PulseAckRequest) Descriptor() ([]byte, []int) {
	return file_pd_pulse_proto_rawDescGZIP(), []int{4}
}

func (x *PulseAckRequest) GetObserverId() int64 {
	if x != nil {
		return x.ObserverId
	}
	return 0
}

func (x *PulseAckRequest) GetNoticeId() int64 {
	if x != nil {
		return x.NoticeId
	}
	return 0
}

// 分区心跳，分区的peer增减、leader改变等事件发生时，由leader发送心跳。
// 同时pd对分区进行shard增减通过Response发送给leader
type PartitionHeartbeatRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *common.RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// Leader Peer sending the heartbeat
	States *metapb.PartitionStats `protobuf:"bytes,4,opt,name=states,proto3" json:"states,omitempty"`
}

func (x *PartitionHeartbeatRequest) Reset() {
	*x = PartitionHeartbeatRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pd_pulse_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionHeartbeatRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionHeartbeatRequest) ProtoMessage() {}

func (x *PartitionHeartbeatRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pd_pulse_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionHeartbeatRequest.ProtoReflect.Descriptor instead.
func (*PartitionHeartbeatRequest) Descriptor() ([]byte, []int) {
	return file_pd_pulse_proto_rawDescGZIP(), []int{5}
}

func (x *PartitionHeartbeatRequest) GetHeader() *common.RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *PartitionHeartbeatRequest) GetStates() *metapb.PartitionStats {
	if x != nil {
		return x.States
	}
	return nil
}

// responses
type PulseResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PulseType  PulseType `protobuf:"varint,1,opt,name=pulse_type,json=pulseType,proto3,enum=PulseType" json:"pulse_type,omitempty"`
	ObserverId int64     `protobuf:"varint,2,opt,name=observer_id,json=observerId,proto3" json:"observer_id,omitempty"`
	Status     int32     `protobuf:"varint,3,opt,name=status,proto3" json:"status,omitempty"` //0=ok,1=fail
	NoticeId   int64     `protobuf:"varint,4,opt,name=notice_id,json=noticeId,proto3" json:"notice_id,omitempty"`
	// Types that are assignable to ResponseUnion:
	//	*PulseResponse_PartitionHeartbeatResponse
	ResponseUnion isPulseResponse_ResponseUnion `protobuf_oneof:"response_union"`
}

func (x *PulseResponse) Reset() {
	*x = PulseResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pd_pulse_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PulseResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PulseResponse) ProtoMessage() {}

func (x *PulseResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pd_pulse_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PulseResponse.ProtoReflect.Descriptor instead.
func (*PulseResponse) Descriptor() ([]byte, []int) {
	return file_pd_pulse_proto_rawDescGZIP(), []int{6}
}

func (x *PulseResponse) GetPulseType() PulseType {
	if x != nil {
		return x.PulseType
	}
	return PulseType_PULSE_TYPE_UNKNOWN
}

func (x *PulseResponse) GetObserverId() int64 {
	if x != nil {
		return x.ObserverId
	}
	return 0
}

func (x *PulseResponse) GetStatus() int32 {
	if x != nil {
		return x.Status
	}
	return 0
}

func (x *PulseResponse) GetNoticeId() int64 {
	if x != nil {
		return x.NoticeId
	}
	return 0
}

func (m *PulseResponse) GetResponseUnion() isPulseResponse_ResponseUnion {
	if m != nil {
		return m.ResponseUnion
	}
	return nil
}

func (x *PulseResponse) GetPartitionHeartbeatResponse() *PartitionHeartbeatResponse {
	if x, ok := x.GetResponseUnion().(*PulseResponse_PartitionHeartbeatResponse); ok {
		return x.PartitionHeartbeatResponse
	}
	return nil
}

type isPulseResponse_ResponseUnion interface {
	isPulseResponse_ResponseUnion()
}

type PulseResponse_PartitionHeartbeatResponse struct {
	PartitionHeartbeatResponse *PartitionHeartbeatResponse `protobuf:"bytes,10,opt,name=partition_heartbeat_response,json=partitionHeartbeatResponse,proto3,oneof"`
}

func (*PulseResponse_PartitionHeartbeatResponse) isPulseResponse_ResponseUnion() {}

type PartitionHeartbeatResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header         *common.ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Id             uint64                 `protobuf:"varint,3,opt,name=id,proto3" json:"id,omitempty"`
	Partition      *metapb.Partition      `protobuf:"bytes,2,opt,name=partition,proto3" json:"partition,omitempty"`
	ChangeShard    *ChangeShard           `protobuf:"bytes,4,opt,name=change_shard,json=changeShard,proto3" json:"change_shard,omitempty"`
	TransferLeader *TransferLeader        `protobuf:"bytes,5,opt,name=transfer_leader,json=transferLeader,proto3" json:"transfer_leader,omitempty"`
	// 拆分成多个分区，第一个SplitPartition是原分区，从第二开始是新分区
	SplitPartition *SplitPartition `protobuf:"bytes,6,opt,name=split_partition,json=splitPartition,proto3" json:"split_partition,omitempty"`
	// rocksdb compaction 指定的表，null是针对所有
	DbCompaction *DbCompaction `protobuf:"bytes,7,opt,name=db_compaction,json=dbCompaction,proto3" json:"db_compaction,omitempty"`
	// 将partition的数据，迁移到 target
	MovePartition *MovePartition `protobuf:"bytes,8,opt,name=move_partition,json=movePartition,proto3" json:"move_partition,omitempty"`
	// 清理partition的graph的数据
	CleanPartition *CleanPartition `protobuf:"bytes,9,opt,name=clean_partition,json=cleanPartition,proto3" json:"clean_partition,omitempty"`
	// partition key range 变化
	KeyRange *PartitionKeyRange `protobuf:"bytes,10,opt,name=key_range,json=keyRange,proto3" json:"key_range,omitempty"`
}

func (x *PartitionHeartbeatResponse) Reset() {
	*x = PartitionHeartbeatResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pd_pulse_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionHeartbeatResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionHeartbeatResponse) ProtoMessage() {}

func (x *PartitionHeartbeatResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pd_pulse_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionHeartbeatResponse.ProtoReflect.Descriptor instead.
func (*PartitionHeartbeatResponse) Descriptor() ([]byte, []int) {
	return file_pd_pulse_proto_rawDescGZIP(), []int{7}
}

func (x *PartitionHeartbeatResponse) GetHeader() *common.ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *PartitionHeartbeatResponse) GetId() uint64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *PartitionHeartbeatResponse) GetPartition() *metapb.Partition {
	if x != nil {
		return x.Partition
	}
	return nil
}

func (x *PartitionHeartbeatResponse) GetChangeShard() *ChangeShard {
	if x != nil {
		return x.ChangeShard
	}
	return nil
}

func (x *PartitionHeartbeatResponse) GetTransferLeader() *TransferLeader {
	if x != nil {
		return x.TransferLeader
	}
	return nil
}

func (x *PartitionHeartbeatResponse) GetSplitPartition() *SplitPartition {
	if x != nil {
		return x.SplitPartition
	}
	return nil
}

func (x *PartitionHeartbeatResponse) GetDbCompaction() *DbCompaction {
	if x != nil {
		return x.DbCompaction
	}
	return nil
}

func (x *PartitionHeartbeatResponse) GetMovePartition() *MovePartition {
	if x != nil {
		return x.MovePartition
	}
	return nil
}

func (x *PartitionHeartbeatResponse) GetCleanPartition() *CleanPartition {
	if x != nil {
		return x.CleanPartition
	}
	return nil
}

func (x *PartitionHeartbeatResponse) GetKeyRange() *PartitionKeyRange {
	if x != nil {
		return x.KeyRange
	}
	return nil
}

// Date model
type ChangeShard struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Shard      []*metapb.Shard `protobuf:"bytes,1,rep,name=shard,proto3" json:"shard,omitempty"`
	ChangeType ConfChangeType  `protobuf:"varint,2,opt,name=change_type,json=changeType,proto3,enum=ConfChangeType" json:"change_type,omitempty"`
}

func (x *ChangeShard) Reset() {
	*x = ChangeShard{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pd_pulse_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChangeShard) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeShard) ProtoMessage() {}

func (x *ChangeShard) ProtoReflect() protoreflect.Message {
	mi := &file_pd_pulse_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeShard.ProtoReflect.Descriptor instead.
func (*ChangeShard) Descriptor() ([]byte, []int) {
	return file_pd_pulse_proto_rawDescGZIP(), []int{8}
}

func (x *ChangeShard) GetShard() []*metapb.Shard {
	if x != nil {
		return x.Shard
	}
	return nil
}

func (x *ChangeShard) GetChangeType() ConfChangeType {
	if x != nil {
		return x.ChangeType
	}
	return ConfChangeType_CONF_CHANGE_TYPE_UNKNOWN
}

type TransferLeader struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Shard *metapb.Shard `protobuf:"bytes,1,opt,name=shard,proto3" json:"shard,omitempty"`
}

func (x *TransferLeader) Reset() {
	*x = TransferLeader{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pd_pulse_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferLeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferLeader) ProtoMessage() {}

func (x *TransferLeader) ProtoReflect() protoreflect.Message {
	mi := &file_pd_pulse_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferLeader.ProtoReflect.Descriptor instead.
func (*TransferLeader) Descriptor() ([]byte, []int) {
	return file_pd_pulse_proto_rawDescGZIP(), []int{9}
}

func (x *TransferLeader) GetShard() *metapb.Shard {
	if x != nil {
		return x.Shard
	}
	return nil
}

type SplitPartition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	NewPartition []*metapb.Partition `protobuf:"bytes,1,rep,name=new_partition,json=newPartition,proto3" json:"new_partition,omitempty"`
}

func (x *SplitPartition) Reset() {
	*x = SplitPartition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pd_pulse_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SplitPartition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SplitPartition) ProtoMessage() {}

func (x *SplitPartition) ProtoReflect() protoreflect.Message {
	mi := &file_pd_pulse_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SplitPartition.ProtoReflect.Descriptor instead.
func (*SplitPartition) Descriptor() ([]byte, []int) {
	return file_pd_pulse_proto_rawDescGZIP(), []int{10}
}

func (x *SplitPartition) GetNewPartition() []*metapb.Partition {
	if x != nil {
		return x.NewPartition
	}
	return nil
}

type DbCompaction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TableName string `protobuf:"bytes,3,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
}

func (x *DbCompaction) Reset() {
	*x = DbCompaction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pd_pulse_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DbCompaction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DbCompaction) ProtoMessage() {}

func (x *DbCompaction) ProtoReflect() protoreflect.Message {
	mi := &file_pd_pulse_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DbCompaction.ProtoReflect.Descriptor instead.
func (*DbCompaction) Descriptor() ([]byte, []int) {
	return file_pd_pulse_proto_rawDescGZIP(), []int{11}
}

func (x *DbCompaction) GetTableName() string {
	if x != nil {
		return x.TableName
	}
	return ""
}

type MovePartition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// target partition的key range为，迁移后的新range
	TargetPartition *metapb.Partition `protobuf:"bytes,1,opt,name=target_partition,json=targetPartition,proto3" json:"target_partition,omitempty"`
	// partition 的 key start 和 key end的所有数据，
	// 会迁移到 target partition 上
	KeyStart uint64 `protobuf:"varint,2,opt,name=key_start,json=keyStart,proto3" json:"key_start,omitempty"`
	KeyEnd   uint64 `protobuf:"varint,3,opt,name=key_end,json=keyEnd,proto3" json:"key_end,omitempty"`
}

func (x *MovePartition) Reset() {
	*x = MovePartition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pd_pulse_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MovePartition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MovePartition) ProtoMessage() {}

func (x *MovePartition) ProtoReflect() protoreflect.Message {
	mi := &file_pd_pulse_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MovePartition.ProtoReflect.Descriptor instead.
func (*MovePartition) Descriptor() ([]byte, []int) {
	return file_pd_pulse_proto_rawDescGZIP(), []int{12}
}

func (x *MovePartition) GetTargetPartition() *metapb.Partition {
	if x != nil {
		return x.TargetPartition
	}
	return nil
}

func (x *MovePartition) GetKeyStart() uint64 {
	if x != nil {
		return x.KeyStart
	}
	return 0
}

func (x *MovePartition) GetKeyEnd() uint64 {
	if x != nil {
		return x.KeyEnd
	}
	return 0
}

type CleanPartition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	KeyStart        uint64    `protobuf:"varint,1,opt,name=key_start,json=keyStart,proto3" json:"key_start,omitempty"`
	KeyEnd          uint64    `protobuf:"varint,2,opt,name=key_end,json=keyEnd,proto3" json:"key_end,omitempty"`
	CleanType       CleanType `protobuf:"varint,3,opt,name=clean_type,json=cleanType,proto3,enum=CleanType" json:"clean_type,omitempty"`
	DeletePartition bool      `protobuf:"varint,4,opt,name=delete_partition,json=deletePartition,proto3" json:"delete_partition,omitempty"` //是否删除分区
}

func (x *CleanPartition) Reset() {
	*x = CleanPartition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pd_pulse_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CleanPartition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CleanPartition) ProtoMessage() {}

func (x *CleanPartition) ProtoReflect() protoreflect.Message {
	mi := &file_pd_pulse_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CleanPartition.ProtoReflect.Descriptor instead.
func (*CleanPartition) Descriptor() ([]byte, []int) {
	return file_pd_pulse_proto_rawDescGZIP(), []int{13}
}

func (x *CleanPartition) GetKeyStart() uint64 {
	if x != nil {
		return x.KeyStart
	}
	return 0
}

func (x *CleanPartition) GetKeyEnd() uint64 {
	if x != nil {
		return x.KeyEnd
	}
	return 0
}

func (x *CleanPartition) GetCleanType() CleanType {
	if x != nil {
		return x.CleanType
	}
	return CleanType_CLEAN_TYPE_KEEP_RANGE
}

func (x *CleanPartition) GetDeletePartition() bool {
	if x != nil {
		return x.DeletePartition
	}
	return false
}

type PartitionKeyRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PartitionId uint32 `protobuf:"varint,1,opt,name=partition_id,json=partitionId,proto3" json:"partition_id,omitempty"`
	KeyStart    uint64 `protobuf:"varint,2,opt,name=key_start,json=keyStart,proto3" json:"key_start,omitempty"`
	KeyEnd      uint64 `protobuf:"varint,3,opt,name=key_end,json=keyEnd,proto3" json:"key_end,omitempty"`
}

func (x *PartitionKeyRange) Reset() {
	*x = PartitionKeyRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pd_pulse_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionKeyRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionKeyRange) ProtoMessage() {}

func (x *PartitionKeyRange) ProtoReflect() protoreflect.Message {
	mi := &file_pd_pulse_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionKeyRange.ProtoReflect.Descriptor instead.
func (*PartitionKeyRange) Descriptor() ([]byte, []int) {
	return file_pd_pulse_proto_rawDescGZIP(), []int{14}
}

func (x *PartitionKeyRange) GetPartitionId() uint32 {
	if x != nil {
		return x.PartitionId
	}
	return 0
}

func (x *PartitionKeyRange) GetKeyStart() uint64 {
	if x != nil {
		return x.KeyStart
	}
	return 0
}

func (x *PartitionKeyRange) GetKeyEnd() uint64 {
	if x != nil {
		return x.KeyEnd
	}
	return 0
}

var File_pd_pulse_proto protoreflect.FileDescriptor

var file_pd_pulse_proto_rawDesc = []byte{
	0x0a, 0x0e, 0x70, 0x64, 0x5f, 0x70, 0x75, 0x6c, 0x73, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x0c, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x0f,
	0x70, 0x64, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xf5, 0x01, 0x0a, 0x0c, 0x50, 0x75, 0x6c, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3a, 0x0a, 0x0e, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x50, 0x75, 0x6c, 0x73, 0x65,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x0d, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x0e,
	0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x50, 0x75, 0x6c, 0x73, 0x65, 0x43, 0x61, 0x6e, 0x63,
	0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x0d, 0x63, 0x61, 0x6e, 0x63, 0x65,
	0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x0e, 0x6e, 0x6f, 0x74, 0x69,
	0x63, 0x65, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x13, 0x2e, 0x50, 0x75, 0x6c, 0x73, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x63, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x0d, 0x6e, 0x6f, 0x74, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x31, 0x0a, 0x0b, 0x61, 0x63, 0x6b, 0x5f, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x50, 0x75, 0x6c, 0x73,
	0x65, 0x41, 0x63, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x0a, 0x61, 0x63, 0x6b,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x3f, 0x0a, 0x12, 0x50, 0x75, 0x6c, 0x73, 0x65,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x29, 0x0a,
	0x0a, 0x70, 0x75, 0x6c, 0x73, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x0a, 0x2e, 0x50, 0x75, 0x6c, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x70,
	0x75, 0x6c, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x22, 0x35, 0x0a, 0x12, 0x50, 0x75, 0x6c, 0x73,
	0x65, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1f,
	0x0a, 0x0b, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0a, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x49, 0x64, 0x22,
	0xa4, 0x01, 0x0a, 0x12, 0x50, 0x75, 0x6c, 0x73, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x63, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x6f, 0x62, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x49, 0x64, 0x12, 0x5c, 0x0a, 0x1b, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x68, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x5f, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x19, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x0f, 0x0a, 0x0d, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x75, 0x6e, 0x69, 0x6f, 0x6e, 0x22, 0x4f, 0x0a, 0x0f, 0x50, 0x75, 0x6c, 0x73, 0x65, 0x41,
	0x63, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x6f, 0x62, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a,
	0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x6e, 0x6f,
	0x74, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x6e,
	0x6f, 0x74, 0x69, 0x63, 0x65, 0x49, 0x64, 0x22, 0x73, 0x0a, 0x19, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x48, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x26, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x2e, 0x0a, 0x06,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x6d,
	0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x74, 0x61, 0x74, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x65, 0x73, 0x22, 0x83, 0x02, 0x0a,
	0x0d, 0x50, 0x75, 0x6c, 0x73, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x29,
	0x0a, 0x0a, 0x70, 0x75, 0x6c, 0x73, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x0a, 0x2e, 0x50, 0x75, 0x6c, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09,
	0x70, 0x75, 0x6c, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x6f, 0x62, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a,
	0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x6e, 0x6f, 0x74, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x6e, 0x6f, 0x74, 0x69, 0x63, 0x65, 0x49, 0x64, 0x12,
	0x5f, 0x0a, 0x1c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x68, 0x65, 0x61,
	0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x48, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x48, 0x00, 0x52, 0x1a, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x42, 0x10, 0x0a, 0x0e, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x75, 0x6e, 0x69,
	0x6f, 0x6e, 0x22, 0x81, 0x04, 0x0a, 0x1a, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x48, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x27, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x0f, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x02, 0x69, 0x64, 0x12, 0x2f, 0x0a, 0x09, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e,
	0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x0c, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x0c, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x68, 0x61, 0x72, 0x64, 0x52,
	0x0b, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x68, 0x61, 0x72, 0x64, 0x12, 0x38, 0x0a, 0x0f,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x6c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x4c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x4c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x38, 0x0a, 0x0f, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x5f,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x0f, 0x2e, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0e, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x32, 0x0a, 0x0d, 0x64, 0x62, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x44, 0x62, 0x43, 0x6f, 0x6d, 0x70,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x64, 0x62, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x35, 0x0a, 0x0e, 0x6d, 0x6f, 0x76, 0x65, 0x5f, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x4d,
	0x6f, 0x76, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x6d, 0x6f,
	0x76, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x38, 0x0a, 0x0f, 0x63,
	0x6c, 0x65, 0x61, 0x6e, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x43, 0x6c, 0x65, 0x61, 0x6e, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x63, 0x6c, 0x65, 0x61, 0x6e, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x09, 0x6b, 0x65, 0x79, 0x5f, 0x72, 0x61, 0x6e,
	0x67, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x08, 0x6b, 0x65,
	0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x22, 0x64, 0x0a, 0x0b, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x53, 0x68, 0x61, 0x72, 0x64, 0x12, 0x23, 0x0a, 0x05, 0x73, 0x68, 0x61, 0x72, 0x64, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x53, 0x68,
	0x61, 0x72, 0x64, 0x52, 0x05, 0x73, 0x68, 0x61, 0x72, 0x64, 0x12, 0x30, 0x0a, 0x0b, 0x63, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x0f, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x0a, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x22, 0x35, 0x0a, 0x0e,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x23,
	0x0a, 0x05, 0x73, 0x68, 0x61, 0x72, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0d, 0x2e,
	0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x53, 0x68, 0x61, 0x72, 0x64, 0x52, 0x05, 0x73, 0x68,
	0x61, 0x72, 0x64, 0x22, 0x48, 0x0a, 0x0e, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x36, 0x0a, 0x0d, 0x6e, 0x65, 0x77, 0x5f, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x6d,
	0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0c, 0x6e, 0x65, 0x77, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x2d, 0x0a,
	0x0c, 0x44, 0x62, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a,
	0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x83, 0x01, 0x0a,
	0x0d, 0x4d, 0x6f, 0x76, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3c,
	0x0a, 0x10, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70,
	0x62, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x09,
	0x6b, 0x65, 0x79, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x08, 0x6b, 0x65, 0x79, 0x53, 0x74, 0x61, 0x72, 0x74, 0x12, 0x17, 0x0a, 0x07, 0x6b, 0x65, 0x79,
	0x5f, 0x65, 0x6e, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x6b, 0x65, 0x79, 0x45,
	0x6e, 0x64, 0x22, 0x9c, 0x01, 0x0a, 0x0e, 0x43, 0x6c, 0x65, 0x61, 0x6e, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x6b, 0x65, 0x79, 0x5f, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x6b, 0x65, 0x79, 0x53, 0x74, 0x61,
	0x72, 0x74, 0x12, 0x17, 0x0a, 0x07, 0x6b, 0x65, 0x79, 0x5f, 0x65, 0x6e, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x06, 0x6b, 0x65, 0x79, 0x45, 0x6e, 0x64, 0x12, 0x29, 0x0a, 0x0a, 0x63,
	0x6c, 0x65, 0x61, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x0a, 0x2e, 0x43, 0x6c, 0x65, 0x61, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x63, 0x6c, 0x65,
	0x61, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x6c, 0x0a, 0x11, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65,
	0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x6b, 0x65, 0x79,
	0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x6b, 0x65,
	0x79, 0x53, 0x74, 0x61, 0x72, 0x74, 0x12, 0x17, 0x0a, 0x07, 0x6b, 0x65, 0x79, 0x5f, 0x65, 0x6e,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x6b, 0x65, 0x79, 0x45, 0x6e, 0x64, 0x2a,
	0x47, 0x0a, 0x09, 0x50, 0x75, 0x6c, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x16, 0x0a, 0x12,
	0x50, 0x55, 0x4c, 0x53, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f,
	0x57, 0x4e, 0x10, 0x00, 0x12, 0x22, 0x0a, 0x1e, 0x50, 0x55, 0x4c, 0x53, 0x45, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x50, 0x41, 0x52, 0x54, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x48, 0x45, 0x41,
	0x52, 0x54, 0x42, 0x45, 0x41, 0x54, 0x10, 0x01, 0x2a, 0x83, 0x01, 0x0a, 0x0f, 0x50, 0x75, 0x6c,
	0x73, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19,
	0x50, 0x55, 0x4c, 0x53, 0x45, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x19, 0x0a, 0x15, 0x50,
	0x55, 0x4c, 0x53, 0x45, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x41, 0x44, 0x44, 0x10, 0x01, 0x12, 0x1b, 0x0a, 0x17, 0x50, 0x55, 0x4c, 0x53, 0x45, 0x5f,
	0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x41, 0x4c, 0x54, 0x45,
	0x52, 0x10, 0x02, 0x12, 0x19, 0x0a, 0x15, 0x50, 0x55, 0x4c, 0x53, 0x45, 0x5f, 0x43, 0x48, 0x41,
	0x4e, 0x47, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x44, 0x45, 0x4c, 0x10, 0x03, 0x2a, 0xb3,
	0x01, 0x0a, 0x0e, 0x43, 0x6f, 0x6e, 0x66, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x1c, 0x0a, 0x18, 0x43, 0x4f, 0x4e, 0x46, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12,
	0x1d, 0x0a, 0x19, 0x43, 0x4f, 0x4e, 0x46, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x41, 0x44, 0x44, 0x5f, 0x4e, 0x4f, 0x44, 0x45, 0x10, 0x01, 0x12, 0x20,
	0x0a, 0x1c, 0x43, 0x4f, 0x4e, 0x46, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x52, 0x45, 0x4d, 0x4f, 0x56, 0x45, 0x5f, 0x4e, 0x4f, 0x44, 0x45, 0x10, 0x02,
	0x12, 0x25, 0x0a, 0x21, 0x43, 0x4f, 0x4e, 0x46, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x41, 0x44, 0x44, 0x5f, 0x4c, 0x45, 0x41, 0x52, 0x4e, 0x45, 0x52,
	0x5f, 0x4e, 0x4f, 0x44, 0x45, 0x10, 0x03, 0x12, 0x1b, 0x0a, 0x17, 0x43, 0x4f, 0x4e, 0x46, 0x5f,
	0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x41, 0x44, 0x4a, 0x55,
	0x53, 0x54, 0x10, 0x04, 0x2a, 0x44, 0x0a, 0x09, 0x43, 0x6c, 0x65, 0x61, 0x6e, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x19, 0x0a, 0x15, 0x43, 0x4c, 0x45, 0x41, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x4b, 0x45, 0x45, 0x50, 0x5f, 0x52, 0x41, 0x4e, 0x47, 0x45, 0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18,
	0x43, 0x4c, 0x45, 0x41, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x45, 0x58, 0x43, 0x4c, 0x55,
	0x44, 0x45, 0x5f, 0x52, 0x41, 0x4e, 0x47, 0x45, 0x10, 0x01, 0x32, 0x37, 0x0a, 0x09, 0x48, 0x67,
	0x50, 0x64, 0x50, 0x75, 0x6c, 0x73, 0x65, 0x12, 0x2a, 0x0a, 0x05, 0x50, 0x75, 0x6c, 0x73, 0x65,
	0x12, 0x0d, 0x2e, 0x50, 0x75, 0x6c, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x0e, 0x2e, 0x50, 0x75, 0x6c, 0x73, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x28,
	0x01, 0x30, 0x01, 0x42, 0x4f, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x62, 0x61, 0x69, 0x64, 0x75,
	0x2e, 0x68, 0x75, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x70, 0x64, 0x2e, 0x67, 0x72,
	0x70, 0x63, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x65, 0x42, 0x0e, 0x48, 0x67, 0x50, 0x64, 0x50, 0x75,
	0x6c, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x18, 0x2f, 0x68, 0x75, 0x67,
	0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2d, 0x70, 0x64, 0x2d, 0x67, 0x72, 0x70, 0x63, 0x2f, 0x70,
	0x75, 0x6c, 0x73, 0x65, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_pd_pulse_proto_rawDescOnce sync.Once
	file_pd_pulse_proto_rawDescData = file_pd_pulse_proto_rawDesc
)

func file_pd_pulse_proto_rawDescGZIP() []byte {
	file_pd_pulse_proto_rawDescOnce.Do(func() {
		file_pd_pulse_proto_rawDescData = protoimpl.X.CompressGZIP(file_pd_pulse_proto_rawDescData)
	})
	return file_pd_pulse_proto_rawDescData
}

var file_pd_pulse_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_pd_pulse_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_pd_pulse_proto_goTypes = []interface{}{
	(PulseType)(0),                     // 0: PulseType
	(PulseChangeType)(0),               // 1: PulseChangeType
	(ConfChangeType)(0),                // 2: ConfChangeType
	(CleanType)(0),                     // 3: CleanType
	(*PulseRequest)(nil),               // 4: PulseRequest
	(*PulseCreateRequest)(nil),         // 5: PulseCreateRequest
	(*PulseCancelRequest)(nil),         // 6: PulseCancelRequest
	(*PulseNoticeRequest)(nil),         // 7: PulseNoticeRequest
	(*PulseAckRequest)(nil),            // 8: PulseAckRequest
	(*PartitionHeartbeatRequest)(nil),  // 9: PartitionHeartbeatRequest
	(*PulseResponse)(nil),              // 10: PulseResponse
	(*PartitionHeartbeatResponse)(nil), // 11: PartitionHeartbeatResponse
	(*ChangeShard)(nil),                // 12: ChangeShard
	(*TransferLeader)(nil),             // 13: TransferLeader
	(*SplitPartition)(nil),             // 14: SplitPartition
	(*DbCompaction)(nil),               // 15: DbCompaction
	(*MovePartition)(nil),              // 16: MovePartition
	(*CleanPartition)(nil),             // 17: CleanPartition
	(*PartitionKeyRange)(nil),          // 18: PartitionKeyRange
	(*common.RequestHeader)(nil),       // 19: RequestHeader
	(*metapb.PartitionStats)(nil),      // 20: metapb.PartitionStats
	(*common.ResponseHeader)(nil),      // 21: ResponseHeader
	(*metapb.Partition)(nil),           // 22: metapb.Partition
	(*metapb.Shard)(nil),               // 23: metapb.Shard
}
var file_pd_pulse_proto_depIdxs = []int32{
	5,  // 0: PulseRequest.create_request:type_name -> PulseCreateRequest
	6,  // 1: PulseRequest.cancel_request:type_name -> PulseCancelRequest
	7,  // 2: PulseRequest.notice_request:type_name -> PulseNoticeRequest
	8,  // 3: PulseRequest.ack_request:type_name -> PulseAckRequest
	0,  // 4: PulseCreateRequest.pulse_type:type_name -> PulseType
	9,  // 5: PulseNoticeRequest.partition_heartbeat_request:type_name -> PartitionHeartbeatRequest
	19, // 6: PartitionHeartbeatRequest.header:type_name -> RequestHeader
	20, // 7: PartitionHeartbeatRequest.states:type_name -> metapb.PartitionStats
	0,  // 8: PulseResponse.pulse_type:type_name -> PulseType
	11, // 9: PulseResponse.partition_heartbeat_response:type_name -> PartitionHeartbeatResponse
	21, // 10: PartitionHeartbeatResponse.header:type_name -> ResponseHeader
	22, // 11: PartitionHeartbeatResponse.partition:type_name -> metapb.Partition
	12, // 12: PartitionHeartbeatResponse.change_shard:type_name -> ChangeShard
	13, // 13: PartitionHeartbeatResponse.transfer_leader:type_name -> TransferLeader
	14, // 14: PartitionHeartbeatResponse.split_partition:type_name -> SplitPartition
	15, // 15: PartitionHeartbeatResponse.db_compaction:type_name -> DbCompaction
	16, // 16: PartitionHeartbeatResponse.move_partition:type_name -> MovePartition
	17, // 17: PartitionHeartbeatResponse.clean_partition:type_name -> CleanPartition
	18, // 18: PartitionHeartbeatResponse.key_range:type_name -> PartitionKeyRange
	23, // 19: ChangeShard.shard:type_name -> metapb.Shard
	2,  // 20: ChangeShard.change_type:type_name -> ConfChangeType
	23, // 21: TransferLeader.shard:type_name -> metapb.Shard
	22, // 22: SplitPartition.new_partition:type_name -> metapb.Partition
	22, // 23: MovePartition.target_partition:type_name -> metapb.Partition
	3,  // 24: CleanPartition.clean_type:type_name -> CleanType
	4,  // 25: HgPdPulse.Pulse:input_type -> PulseRequest
	10, // 26: HgPdPulse.Pulse:output_type -> PulseResponse
	26, // [26:27] is the sub-list for method output_type
	25, // [25:26] is the sub-list for method input_type
	25, // [25:25] is the sub-list for extension type_name
	25, // [25:25] is the sub-list for extension extendee
	0,  // [0:25] is the sub-list for field type_name
}

func init() { file_pd_pulse_proto_init() }
func file_pd_pulse_proto_init() {
	if File_pd_pulse_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_pd_pulse_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PulseRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pd_pulse_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PulseCreateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pd_pulse_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PulseCancelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pd_pulse_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PulseNoticeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pd_pulse_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PulseAckRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pd_pulse_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionHeartbeatRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pd_pulse_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PulseResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pd_pulse_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionHeartbeatResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pd_pulse_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChangeShard); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pd_pulse_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferLeader); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pd_pulse_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SplitPartition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pd_pulse_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DbCompaction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pd_pulse_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MovePartition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pd_pulse_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CleanPartition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pd_pulse_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionKeyRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_pd_pulse_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*PulseNoticeRequest_PartitionHeartbeatRequest)(nil),
	}
	file_pd_pulse_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*PulseResponse_PartitionHeartbeatResponse)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_pd_pulse_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_pd_pulse_proto_goTypes,
		DependencyIndexes: file_pd_pulse_proto_depIdxs,
		EnumInfos:         file_pd_pulse_proto_enumTypes,
		MessageInfos:      file_pd_pulse_proto_msgTypes,
	}.Build()
	File_pd_pulse_proto = out.File
	file_pd_pulse_proto_rawDesc = nil
	file_pd_pulse_proto_goTypes = nil
	file_pd_pulse_proto_depIdxs = nil
}
