/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

class V1Metadata {
    static final Schema MANIFEST_LIST_SCHEMA = new Schema(new Types.NestedField[]{ManifestFile.PATH, ManifestFile.LENGTH, ManifestFile.SPEC_ID, ManifestFile.SNAPSHOT_ID, ManifestFile.ADDED_FILES_COUNT, ManifestFile.EXISTING_FILES_COUNT, ManifestFile.DELETED_FILES_COUNT, ManifestFile.PARTITION_SUMMARIES, ManifestFile.ADDED_ROWS_COUNT, ManifestFile.EXISTING_ROWS_COUNT, ManifestFile.DELETED_ROWS_COUNT, ManifestFile.KEY_METADATA});
    private static final Types.NestedField BLOCK_SIZE = Types.NestedField.required((int)105, (String)"block_size_in_bytes", (Type)Types.LongType.get());

    private V1Metadata() {
    }

    static Schema entrySchema(Types.StructType partitionType) {
        return V1Metadata.wrapFileSchema(V1Metadata.dataFileSchema(partitionType));
    }

    static Schema wrapFileSchema(Types.StructType fileSchema) {
        return new Schema(new Types.NestedField[]{ManifestEntry.STATUS, ManifestEntry.SNAPSHOT_ID, Types.NestedField.required((int)2, (String)"data_file", (Type)fileSchema)});
    }

    static Types.StructType dataFileSchema(Types.StructType partitionType) {
        return Types.StructType.of((Types.NestedField[])new Types.NestedField[]{DataFile.FILE_PATH, DataFile.FILE_FORMAT, Types.NestedField.required((int)102, (String)"partition", (Type)partitionType), DataFile.RECORD_COUNT, DataFile.FILE_SIZE, BLOCK_SIZE, DataFile.COLUMN_SIZES, DataFile.VALUE_COUNTS, DataFile.NULL_VALUE_COUNTS, DataFile.NAN_VALUE_COUNTS, DataFile.LOWER_BOUNDS, DataFile.UPPER_BOUNDS, DataFile.KEY_METADATA, DataFile.SPLIT_OFFSETS, DataFile.SORT_ORDER_ID});
    }

    static class DataFileWrapper
    implements DataFile,
    StructLike {
        private static final long DEFAULT_BLOCK_SIZE = 0x4000000L;
        private final int size = V1Metadata.dataFileSchema(Types.StructType.of((Types.NestedField[])new Types.NestedField[0])).fields().size();
        private DataFile wrapped = null;

        DataFileWrapper() {
        }

        DataFileWrapper wrap(DataFile file) {
            this.wrapped = file;
            return this;
        }

        public int size() {
            return this.size;
        }

        public <T> void set(int pos, T value) {
            throw new UnsupportedOperationException("Cannot modify DataFileWrapper wrapper via set");
        }

        public <T> T get(int pos, Class<T> javaClass) {
            return javaClass.cast(this.get(pos));
        }

        private Object get(int pos) {
            switch (pos) {
                case 0: {
                    return this.wrapped.location();
                }
                case 1: {
                    return this.wrapped.format() != null ? this.wrapped.format().toString() : null;
                }
                case 2: {
                    return this.wrapped.partition();
                }
                case 3: {
                    return this.wrapped.recordCount();
                }
                case 4: {
                    return this.wrapped.fileSizeInBytes();
                }
                case 5: {
                    return 0x4000000L;
                }
                case 6: {
                    return this.wrapped.columnSizes();
                }
                case 7: {
                    return this.wrapped.valueCounts();
                }
                case 8: {
                    return this.wrapped.nullValueCounts();
                }
                case 9: {
                    return this.wrapped.nanValueCounts();
                }
                case 10: {
                    return this.wrapped.lowerBounds();
                }
                case 11: {
                    return this.wrapped.upperBounds();
                }
                case 12: {
                    return this.wrapped.keyMetadata();
                }
                case 13: {
                    return this.wrapped.splitOffsets();
                }
                case 14: {
                    return this.wrapped.sortOrderId();
                }
            }
            throw new IllegalArgumentException("Unknown field ordinal: " + pos);
        }

        public Long pos() {
            return null;
        }

        public String manifestLocation() {
            return null;
        }

        public int specId() {
            return this.wrapped.specId();
        }

        public FileContent content() {
            return this.wrapped.content();
        }

        public CharSequence path() {
            return this.wrapped.location();
        }

        public FileFormat format() {
            return this.wrapped.format();
        }

        public StructLike partition() {
            return this.wrapped.partition();
        }

        public long recordCount() {
            return this.wrapped.recordCount();
        }

        public long fileSizeInBytes() {
            return this.wrapped.fileSizeInBytes();
        }

        public Map<Integer, Long> columnSizes() {
            return this.wrapped.columnSizes();
        }

        public Map<Integer, Long> valueCounts() {
            return this.wrapped.valueCounts();
        }

        public Map<Integer, Long> nullValueCounts() {
            return this.wrapped.nullValueCounts();
        }

        public Map<Integer, Long> nanValueCounts() {
            return this.wrapped.nanValueCounts();
        }

        public Map<Integer, ByteBuffer> lowerBounds() {
            return this.wrapped.lowerBounds();
        }

        public Map<Integer, ByteBuffer> upperBounds() {
            return this.wrapped.upperBounds();
        }

        public ByteBuffer keyMetadata() {
            return this.wrapped.keyMetadata();
        }

        public List<Long> splitOffsets() {
            return this.wrapped.splitOffsets();
        }

        public Integer sortOrderId() {
            return this.wrapped.sortOrderId();
        }

        public Long dataSequenceNumber() {
            return this.wrapped.dataSequenceNumber();
        }

        public Long fileSequenceNumber() {
            return this.wrapped.fileSequenceNumber();
        }

        public DataFile copy() {
            return (DataFile)this.wrapped.copy();
        }

        public DataFile copyWithStats(Set<Integer> requestedColumnIds) {
            return (DataFile)this.wrapped.copyWithStats(requestedColumnIds);
        }

        public DataFile copyWithoutStats() {
            return (DataFile)this.wrapped.copyWithoutStats();
        }
    }

    static class ManifestEntryWrapper
    implements ManifestEntry<DataFile>,
    StructLike {
        private final int size = V1Metadata.entrySchema(Types.StructType.of((Types.NestedField[])new Types.NestedField[0])).columns().size();
        private final DataFileWrapper fileWrapper = new DataFileWrapper();
        private ManifestEntry<DataFile> wrapped = null;

        ManifestEntryWrapper() {
        }

        public ManifestEntryWrapper wrap(ManifestEntry<DataFile> entry) {
            this.wrapped = entry;
            return this;
        }

        public int size() {
            return this.size;
        }

        public <T> void set(int pos, T value) {
            throw new UnsupportedOperationException("Cannot modify ManifestEntryWrapper wrapper via set");
        }

        public <T> T get(int pos, Class<T> javaClass) {
            return javaClass.cast(this.get(pos));
        }

        private Object get(int pos) {
            switch (pos) {
                case 0: {
                    return this.wrapped.status().id();
                }
                case 1: {
                    return this.wrapped.snapshotId();
                }
                case 2: {
                    DataFile file = this.wrapped.file();
                    if (file != null) {
                        return this.fileWrapper.wrap(file);
                    }
                    return null;
                }
            }
            throw new UnsupportedOperationException("Unknown field ordinal: " + pos);
        }

        @Override
        public ManifestEntry.Status status() {
            return this.wrapped.status();
        }

        @Override
        public Long snapshotId() {
            return this.wrapped.snapshotId();
        }

        @Override
        public void setSnapshotId(long snapshotId) {
            this.wrapped.setSnapshotId(snapshotId);
        }

        @Override
        public Long dataSequenceNumber() {
            return this.wrapped.dataSequenceNumber();
        }

        @Override
        public void setDataSequenceNumber(long dataSequenceNumber) {
            this.wrapped.setDataSequenceNumber(dataSequenceNumber);
        }

        @Override
        public Long fileSequenceNumber() {
            return this.wrapped.fileSequenceNumber();
        }

        @Override
        public void setFileSequenceNumber(long fileSequenceNumber) {
            this.wrapped.setFileSequenceNumber(fileSequenceNumber);
        }

        @Override
        public DataFile file() {
            return this.wrapped.file();
        }

        @Override
        public ManifestEntry<DataFile> copy() {
            return this.wrapped.copy();
        }

        @Override
        public ManifestEntry<DataFile> copyWithoutStats() {
            return this.wrapped.copyWithoutStats();
        }
    }

    static class ManifestFileWrapper
    implements ManifestFile,
    StructLike {
        private ManifestFile wrapped = null;

        ManifestFileWrapper() {
        }

        public ManifestFile wrap(ManifestFile file) {
            this.wrapped = file;
            return this;
        }

        public int size() {
            return MANIFEST_LIST_SCHEMA.columns().size();
        }

        public <T> void set(int pos, T value) {
            throw new UnsupportedOperationException("Cannot modify ManifestFileWrapper wrapper via set");
        }

        public <T> T get(int pos, Class<T> javaClass) {
            return javaClass.cast(this.get(pos));
        }

        private Object get(int pos) {
            switch (pos) {
                case 0: {
                    return this.path();
                }
                case 1: {
                    return this.length();
                }
                case 2: {
                    return this.partitionSpecId();
                }
                case 3: {
                    return this.snapshotId();
                }
                case 4: {
                    return this.addedFilesCount();
                }
                case 5: {
                    return this.existingFilesCount();
                }
                case 6: {
                    return this.deletedFilesCount();
                }
                case 7: {
                    return this.partitions();
                }
                case 8: {
                    return this.addedRowsCount();
                }
                case 9: {
                    return this.existingRowsCount();
                }
                case 10: {
                    return this.deletedRowsCount();
                }
                case 11: {
                    return this.keyMetadata();
                }
            }
            throw new UnsupportedOperationException("Unknown field ordinal: " + pos);
        }

        public String path() {
            return this.wrapped.path();
        }

        public long length() {
            return this.wrapped.length();
        }

        public int partitionSpecId() {
            return this.wrapped.partitionSpecId();
        }

        public ManifestContent content() {
            return this.wrapped.content();
        }

        public long sequenceNumber() {
            return this.wrapped.sequenceNumber();
        }

        public long minSequenceNumber() {
            return this.wrapped.minSequenceNumber();
        }

        public Long snapshotId() {
            return this.wrapped.snapshotId();
        }

        public boolean hasAddedFiles() {
            return this.wrapped.hasAddedFiles();
        }

        public Integer addedFilesCount() {
            return this.wrapped.addedFilesCount();
        }

        public Long addedRowsCount() {
            return this.wrapped.addedRowsCount();
        }

        public boolean hasExistingFiles() {
            return this.wrapped.hasExistingFiles();
        }

        public Integer existingFilesCount() {
            return this.wrapped.existingFilesCount();
        }

        public Long existingRowsCount() {
            return this.wrapped.existingRowsCount();
        }

        public boolean hasDeletedFiles() {
            return this.wrapped.hasDeletedFiles();
        }

        public Integer deletedFilesCount() {
            return this.wrapped.deletedFilesCount();
        }

        public Long deletedRowsCount() {
            return this.wrapped.deletedRowsCount();
        }

        public List<ManifestFile.PartitionFieldSummary> partitions() {
            return this.wrapped.partitions();
        }

        public ByteBuffer keyMetadata() {
            return this.wrapped.keyMetadata();
        }

        public ManifestFile copy() {
            return this.wrapped.copy();
        }
    }
}

