/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.context.catalog;

import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import java.util.HashMap;
import org.apache.iceberg.catalog.Catalog;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.auth.PolarisPrincipal;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.entity.CatalogEntity;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.resolver.PolarisResolutionManifest;
import org.apache.polaris.core.persistence.resolver.PolarisResolutionManifestCatalogView;
import org.apache.polaris.core.persistence.resolver.ResolverFactory;
import org.apache.polaris.service.catalog.iceberg.IcebergCatalog;
import org.apache.polaris.service.catalog.io.FileIOFactory;
import org.apache.polaris.service.catalog.io.StorageAccessConfigProvider;
import org.apache.polaris.service.context.catalog.CallContextCatalogFactory;
import org.apache.polaris.service.events.listeners.PolarisEventListener;
import org.apache.polaris.service.task.TaskExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class PolarisCallContextCatalogFactory
implements CallContextCatalogFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisCallContextCatalogFactory.class);
    private final PolarisDiagnostics diagnostics;
    private final TaskExecutor taskExecutor;
    private final StorageAccessConfigProvider storageAccessConfigProvider;
    private final FileIOFactory fileIOFactory;
    private final ResolverFactory resolverFactory;
    private final PolarisEventListener polarisEventListener;
    private final PolarisMetaStoreManager metaStoreManager;
    private final CallContext callContext;
    private final PolarisPrincipal principal;

    @Inject
    public PolarisCallContextCatalogFactory(PolarisDiagnostics diagnostics, ResolverFactory resolverFactory, TaskExecutor taskExecutor, StorageAccessConfigProvider storageAccessConfigProvider, FileIOFactory fileIOFactory, PolarisEventListener polarisEventListener, PolarisMetaStoreManager metaStoreManager, CallContext callContext, PolarisPrincipal principal) {
        this.diagnostics = diagnostics;
        this.resolverFactory = resolverFactory;
        this.taskExecutor = taskExecutor;
        this.storageAccessConfigProvider = storageAccessConfigProvider;
        this.fileIOFactory = fileIOFactory;
        this.polarisEventListener = polarisEventListener;
        this.metaStoreManager = metaStoreManager;
        this.callContext = callContext;
        this.principal = principal;
    }

    public Catalog createCallContextCatalog(PolarisResolutionManifest resolvedManifest) {
        CatalogEntity catalog = resolvedManifest.getResolvedCatalogEntity();
        String catalogName = catalog.getName();
        String realm = this.callContext.getRealmContext().getRealmIdentifier();
        String catalogKey = realm + "/" + catalogName;
        LOGGER.debug("Initializing new BasePolarisCatalog for key: {}", (Object)catalogKey);
        IcebergCatalog catalogInstance = new IcebergCatalog(this.diagnostics, this.resolverFactory, this.metaStoreManager, this.callContext, (PolarisResolutionManifestCatalogView)resolvedManifest, this.principal, this.taskExecutor, this.storageAccessConfigProvider, this.fileIOFactory, this.polarisEventListener);
        HashMap<String, String> catalogProperties = new HashMap<String, String>(catalog.getPropertiesAsMap());
        String defaultBaseLocation = catalog.getBaseLocation();
        LOGGER.debug("Looked up defaultBaseLocation {} for catalog {}", (Object)defaultBaseLocation, (Object)catalogKey);
        if (defaultBaseLocation == null) {
            throw new IllegalStateException(String.format("Catalog '%s' does not have a configured warehouse location. Please configure a default base location for this catalog.", catalogKey));
        }
        catalogProperties.put("warehouse", defaultBaseLocation);
        catalogInstance.initialize(catalogName, catalogProperties);
        return catalogInstance;
    }

    public PolarisCallContextCatalogFactory() {
    }
}

