/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.entity;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nullable;
import org.apache.polaris.core.entity.AsyncTaskType;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityConstants;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.persistence.PolarisObjectMapperUtil;

public class TaskEntity
extends PolarisEntity {
    public TaskEntity(PolarisBaseEntity sourceEntity) {
        super(sourceEntity);
        Preconditions.checkState((this.getType() == PolarisEntityType.TASK ? 1 : 0) != 0, (String)"Invalid entity type: %s", (Object)((Object)this.getType()));
        Preconditions.checkState((this.getSubType() == PolarisEntitySubType.NULL_SUBTYPE ? 1 : 0) != 0, (String)"Invalid entity sub type: %s", (Object)((Object)this.getSubType()));
    }

    @Nullable
    public static TaskEntity of(@Nullable PolarisBaseEntity sourceEntity) {
        if (sourceEntity != null) {
            return new TaskEntity(sourceEntity);
        }
        return null;
    }

    public <T> T readData(Class<T> klass) {
        return PolarisObjectMapperUtil.deserialize(this.getPropertiesAsMap().get("data"), klass);
    }

    public AsyncTaskType getTaskType() {
        return PolarisObjectMapperUtil.deserialize(this.getPropertiesAsMap().get("taskType"), AsyncTaskType.class);
    }

    public static class Builder
    extends PolarisEntity.BaseBuilder<TaskEntity, Builder> {
        public Builder() {
            this.setType(PolarisEntityType.TASK);
            this.setCatalogId(PolarisEntityConstants.getNullId());
            this.setParentId(PolarisEntityConstants.getRootEntityId());
        }

        public Builder(TaskEntity original) {
            super(original);
        }

        public Builder withTaskType(AsyncTaskType taskType) {
            this.properties.put("taskType", PolarisObjectMapperUtil.serialize((Object)taskType));
            return this;
        }

        public Builder withData(Object data) {
            this.properties.put("data", PolarisObjectMapperUtil.serialize(data));
            return this;
        }

        public Builder withLastAttemptExecutorId(String executorId) {
            this.properties.put("lastAttemptExecutorId", executorId);
            return this;
        }

        public Builder withAttemptCount(int count) {
            this.properties.put("attemptCount", String.valueOf(count));
            return this;
        }

        public Builder withLastAttemptStartedTimestamp(long timestamp) {
            this.properties.put("lastAttemptStartTime", String.valueOf(timestamp));
            return this;
        }

        @Override
        public TaskEntity build() {
            return new TaskEntity(this.buildBase());
        }
    }
}

