/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer;

import javax.annotation.concurrent.NotThreadSafe;
import org.apache.fory.Fory;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.type.TypeUtils;

@NotThreadSafe
public abstract class Serializer<T> {
    protected final Fory fory;
    protected final Class<T> type;
    protected final boolean isJava;
    protected final boolean needToWriteRef;
    protected final boolean needToCopyRef;
    protected final boolean immutable;

    public void write(MemoryBuffer buffer, T value) {
        throw new UnsupportedOperationException();
    }

    public T copy(T value) {
        if (this.isImmutable()) {
            return value;
        }
        throw new UnsupportedOperationException(String.format("Copy for %s is not supported", value.getClass()));
    }

    public T read(MemoryBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    public void xwrite(MemoryBuffer buffer, T value) {
        throw new UnsupportedOperationException();
    }

    public T xread(MemoryBuffer buffer) {
        throw new UnsupportedOperationException(this.getClass() + " doesn't support xlang serialization for " + this.type);
    }

    public Serializer(Fory fory, Class<T> type) {
        this.fory = fory;
        this.type = type;
        boolean bl = this.isJava = !fory.isCrossLanguage();
        this.needToWriteRef = fory.trackingRef() ? !TypeUtils.isBoxed(TypeUtils.wrap(type)) || !fory.isBasicTypesRefIgnored() : false;
        this.needToCopyRef = fory.copyTrackingRef();
        this.immutable = false;
    }

    public Serializer(Fory fory, Class<T> type, boolean immutable) {
        this.fory = fory;
        this.type = type;
        boolean bl = this.isJava = !fory.isCrossLanguage();
        this.needToWriteRef = fory.trackingRef() ? !TypeUtils.isBoxed(TypeUtils.wrap(type)) || !fory.isBasicTypesRefIgnored() : false;
        this.needToCopyRef = fory.copyTrackingRef() && !immutable;
        this.immutable = immutable;
    }

    public Serializer(Fory fory, Class<T> type, boolean needToWriteRef, boolean immutable) {
        this.fory = fory;
        this.type = type;
        this.isJava = !fory.isCrossLanguage();
        this.needToWriteRef = needToWriteRef;
        this.needToCopyRef = fory.copyTrackingRef() && !immutable;
        this.immutable = immutable;
    }

    public final boolean needToWriteRef() {
        return this.needToWriteRef;
    }

    public final boolean needToCopyRef() {
        return this.needToCopyRef;
    }

    public Class<T> getType() {
        return this.type;
    }

    public boolean isImmutable() {
        return this.immutable;
    }
}

