/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.mcp.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.apache.seata.common.exception.AuthenticationFailedException;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.console.utils.JwtTokenUtils;
import org.apache.seata.mcp.core.props.NameSpaceDetail;
import org.apache.seata.mcp.core.props.NamingServerProperties;
import org.apache.seata.mcp.core.utils.UrlUtils;
import org.apache.seata.mcp.exception.ServiceCallException;
import org.apache.seata.mcp.service.ConsoleApiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@ConditionalOnMissingBean(name={"consoleLocalServiceImpl"})
@Service
public class ConsoleRemoteServiceImpl
implements ConsoleApiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsoleRemoteServiceImpl.class);
    private final JwtTokenUtils jwtTokenUtils;
    private final RestTemplate restTemplate;
    private final ObjectMapper objectMapper;
    private final NamingServerProperties namingServerProperties;

    public ConsoleRemoteServiceImpl(JwtTokenUtils jwtTokenUtils, RestTemplate restTemplate, ObjectMapper objectMapper, NamingServerProperties namingServerProperties) {
        this.jwtTokenUtils = jwtTokenUtils;
        this.restTemplate = restTemplate;
        this.objectMapper = objectMapper;
        this.namingServerProperties = namingServerProperties;
        LOGGER.info("ConsoleRemoteServiceImpl initialized.");
    }

    public String getToken() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth == null || !auth.isAuthenticated()) {
            throw new AuthenticationFailedException("No right to be identified");
        }
        String originJwt = (String)auth.getCredentials();
        if (!this.jwtTokenUtils.validateToken(originJwt)) {
            throw new AuthenticationFailedException("Invalid token, please log in to get a new token");
        }
        return "Bearer " + originJwt;
    }

    public void setNamespaceHeaderAndQueryParam(NameSpaceDetail nameSpaceDetail, HttpHeaders headers, Map<String, String> queryParams) {
        headers.add("x-seata-namespace", nameSpaceDetail.getNamespace());
        if (StringUtils.isNotBlank((String)nameSpaceDetail.getvGroup())) {
            if (queryParams != null) {
                queryParams.put("vGroup", nameSpaceDetail.getvGroup());
            }
            return;
        }
        if (nameSpaceDetail.getCluster() != null) {
            headers.add("x-seata-cluster", nameSpaceDetail.getCluster());
        }
    }

    @Override
    public String getCallNameSpace(String path) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", this.getToken());
        String url = UrlUtils.buildUrl(this.namingServerProperties.getNamingServerUrl(), path, null, null);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, String.class, new Object[0]);
            String responseBody = (String)response.getBody();
            if (!response.getStatusCode().is2xxSuccessful()) {
                String errorMsg = String.format("MCP GET request failed with status: %s, response: %s", response.getStatusCode(), response.getBody());
                LOGGER.warn(errorMsg);
                throw new ServiceCallException(errorMsg, response.getStatusCode());
            }
            return responseBody;
        }
        catch (RestClientException e) {
            String errorMsg = "MCP GET Call NameSpace Failed.";
            LOGGER.error(errorMsg, (Throwable)e);
            throw new ServiceCallException(errorMsg);
        }
    }

    @Override
    public String getCallTC(NameSpaceDetail nameSpaceDetail, String path, Object objectQueryParams, Map<String, String> queryParams, HttpHeaders headers) {
        if (headers == null) {
            headers = new HttpHeaders();
        }
        if (nameSpaceDetail == null || !nameSpaceDetail.isValid()) {
            return "If you have not specified the namespace of the TC/Server, specify the namespace first";
        }
        this.setNamespaceHeaderAndQueryParam(nameSpaceDetail, headers, queryParams);
        headers.add("Authorization", this.getToken());
        Map<String, Object> queryParamsMap = UrlUtils.objectToQueryParamMap(objectQueryParams, this.objectMapper);
        String url = UrlUtils.buildUrl(this.namingServerProperties.getNamingServerUrl(), path, queryParams, queryParamsMap);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, String.class, new Object[0]);
            String responseBody = (String)response.getBody();
            if (!response.getStatusCode().is2xxSuccessful()) {
                String errorMsg = String.format("MCP GET request failed with status: %s, response: %s", response.getStatusCode(), response.getBody());
                LOGGER.warn(errorMsg);
                throw new ServiceCallException(errorMsg, response.getStatusCode());
            }
            return responseBody;
        }
        catch (RestClientException e) {
            String errorMsg = "MCP GET Call TC Failed.";
            LOGGER.error(errorMsg, (Throwable)e);
            throw new ServiceCallException(errorMsg);
        }
    }

    @Override
    public String deleteCallTC(NameSpaceDetail nameSpaceDetail, String path, Object objectQueryParams, Map<String, String> queryParams, HttpHeaders headers) {
        if (headers == null) {
            headers = new HttpHeaders();
        }
        if (nameSpaceDetail == null || !nameSpaceDetail.isValid()) {
            return "If you have not specified the namespace of the TC/Server, specify the namespace first";
        }
        this.setNamespaceHeaderAndQueryParam(nameSpaceDetail, headers, queryParams);
        headers.add("Authorization", this.getToken());
        Map<String, Object> queryParamsMap = UrlUtils.objectToQueryParamMap(objectQueryParams, this.objectMapper);
        String url = UrlUtils.buildUrl(this.namingServerProperties.getNamingServerUrl(), path, queryParams, queryParamsMap);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.DELETE, entity, String.class, new Object[0]);
            String responseBody = (String)response.getBody();
            if (!response.getStatusCode().is2xxSuccessful()) {
                String errorMsg = String.format("MCP DELETE request returned non-success status: %s, response: %s", response.getStatusCode(), response.getBody());
                LOGGER.warn(errorMsg);
                throw new ServiceCallException(errorMsg, response.getStatusCode());
            }
            return responseBody;
        }
        catch (RestClientException e) {
            String errorMsg = "MCP DELETE Call TC Failed.";
            LOGGER.error(errorMsg, (Throwable)e);
            throw new ServiceCallException(errorMsg);
        }
    }

    @Override
    public String putCallTC(NameSpaceDetail nameSpaceDetail, String path, Object objectQueryParams, Map<String, String> queryParams, HttpHeaders headers) {
        if (headers == null) {
            headers = new HttpHeaders();
        }
        if (nameSpaceDetail == null || !nameSpaceDetail.isValid()) {
            return "If you have not specified the namespace of the TC/Server, specify the namespace first";
        }
        this.setNamespaceHeaderAndQueryParam(nameSpaceDetail, headers, queryParams);
        headers.add("Authorization", this.getToken());
        Map<String, Object> queryParamsMap = UrlUtils.objectToQueryParamMap(objectQueryParams, this.objectMapper);
        String url = UrlUtils.buildUrl(this.namingServerProperties.getNamingServerUrl(), path, queryParams, queryParamsMap);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.PUT, entity, String.class, new Object[0]);
            String responseBody = (String)response.getBody();
            if (!response.getStatusCode().is2xxSuccessful()) {
                String errorMsg = String.format("MCP PUT request returned non-success status: %s, response: %s", response.getStatusCode(), response.getBody());
                LOGGER.warn(errorMsg);
                throw new ServiceCallException(errorMsg, response.getStatusCode());
            }
            return responseBody;
        }
        catch (RestClientException e) {
            String errorMsg = "MCP PUT Call TC Failed.";
            LOGGER.error(errorMsg, (Throwable)e);
            throw new ServiceCallException(errorMsg);
        }
    }
}

