<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 -->

### 1.1.0

<details>	
  <summary><mark>Release notes</mark></summary>

### Seata-go 1.1.0

Seata-go 1.1.0 Released.

Seata-go is an easy-to-use, high-performance, open source distributed transaction solution.

The version is updated as follows:

### feature：

- [[#491](https://github.com/apache/incubator-seata-go/pull/491)] support query global lock key
- [[#482](https://github.com/apache/incubator-seata-go/pull/482)] support multi delete SQL executor in AT
- [[#481](https://github.com/apache/incubator-seata-go/pull/481)] support multi update SQL executor in AT
- [[#478](https://github.com/apache/incubator-seata-go/pull/478)] support select for update SQL executor in AT
- [[#477](https://github.com/apache/incubator-seata-go/pull/477)] support the json serialization method of undo log
- [[#456](https://github.com/apache/incubator-seata-go/pull/456)] support insert on update SQL executor in AT
- [[#444](https://github.com/apache/incubator-seata-go/pull/444)] support BZip2Compressor
- [[#436](https://github.com/apache/incubator-seata-go/pull/436)] use rm config file
- [[#433](https://github.com/apache/incubator-seata-go/pull/433)] support xa connect manager
- [[#430](https://github.com/apache/incubator-seata-go/pull/430)] use getty config file

### bugfix：

- [[#509](https://github.com/apache/incubator-seata-go/pull/509)] fix undo log SQLType when execute insert on update SQL in AT
- [[#495](https://github.com/apache/incubator-seata-go/pull/495)] fix undo log SQLType bug
- [[#487](https://github.com/apache/incubator-seata-go/pull/487)] fix at bug when execute
- [[#472](https://github.com/apache/incubator-seata-go/pull/472)] fix missing value of context When using global transactions
- [[#461](https://github.com/apache/incubator-seata-go/pull/461)] fix the problem of error_code_test
- [[#459](https://github.com/apache/incubator-seata-go/pull/459)] fix the rollback error log
- [[#452](https://github.com/apache/incubator-seata-go/pull/452)] fix the error of id self-increment when executing insert sql in AT

### optimize:

- [[#507](https://github.com/apache/incubator-seata-go/pull/507)] refactor logic of multiple update sql in AT
- [[#505](https://github.com/apache/incubator-seata-go/pull/505)] optimize multi SQL executor in AT
- [[#453](https://github.com/apache/incubator-seata-go/pull/453)] optimize the messageType and transactionErrorCode enum
- [[#447](https://github.com/apache/incubator-seata-go/pull/447)] optimize the datasource init process
- [[#466](https://github.com/apache/incubator-seata-go/pull/466)] optimize variable naming

### test:

- [[#445](https://github.com/apache/incubator-seata-go/pull/445)] add unit test for TransactionErrorCode and MessageType

### doc:

- [[#492](https://github.com/apache/incubator-seata-go/pull/492)] update feature list of readme
- [[#489](https://github.com/apache/incubator-seata-go/pull/489)] add change-log of version 1.1.0

### contributors:

Thanks to these contributors for their code commits. Please report an unintended omission.

- [luky116](https://github.com/luky116)
- [georgehao](https://github.com/georgehao)
- [lxfeng1997](https://github.com/lxfeng1997)
- [106umao](https://github.com/106umao)
- [wang1309](https://github.com/wang1309)
- [iSuperCoder](https://github.com/iSuperCoder)
- [Charlie17Li](https://github.com/Charlie17Li)
- [Code-Fight](https://github.com/Code-Fight)
- [Kirhaku](https://github.com/Kirhaku)
- [Vaderkai](https://github.com/VaderKai)
- [springrain](https://github.com/springrain)
- [Shaozhou Hu](https://github.com/raspberry-hu)
- [finkyky](https://github.com/Finkyky)

Also, we receive many valuable issues, questions and advices from our community. Thanks all.

</detail>