/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class SetPublishingModeRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=797");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=799");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=798");
    private final RequestHeader requestHeader;
    private final Boolean publishingEnabled;
    private final UInteger[] subscriptionIds;

    public SetPublishingModeRequest(RequestHeader requestHeader, Boolean publishingEnabled, UInteger[] subscriptionIds) {
        this.requestHeader = requestHeader;
        this.publishingEnabled = publishingEnabled;
        this.subscriptionIds = subscriptionIds;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public Boolean getPublishingEnabled() {
        return this.publishingEnabled;
    }

    public UInteger[] getSubscriptionIds() {
        return this.subscriptionIds;
    }

    protected SetPublishingModeRequest(SetPublishingModeRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((SetPublishingModeRequestBuilder)b).requestHeader;
        this.publishingEnabled = ((SetPublishingModeRequestBuilder)b).publishingEnabled;
        this.subscriptionIds = ((SetPublishingModeRequestBuilder)b).subscriptionIds;
    }

    public static SetPublishingModeRequestBuilder<?, ?> builder() {
        return new SetPublishingModeRequestBuilderImpl();
    }

    public SetPublishingModeRequestBuilder<?, ?> toBuilder() {
        return new SetPublishingModeRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetPublishingModeRequest)) {
            return false;
        }
        SetPublishingModeRequest other = (SetPublishingModeRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$publishingEnabled = this.getPublishingEnabled();
        Boolean other$publishingEnabled = other.getPublishingEnabled();
        if (this$publishingEnabled == null ? other$publishingEnabled != null : !((Object)this$publishingEnabled).equals(other$publishingEnabled)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        return Arrays.deepEquals(this.getSubscriptionIds(), other.getSubscriptionIds());
    }

    protected boolean canEqual(Object other) {
        return other instanceof SetPublishingModeRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $publishingEnabled = this.getPublishingEnabled();
        result = result * 59 + ($publishingEnabled == null ? 43 : ((Object)$publishingEnabled).hashCode());
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSubscriptionIds());
        return result;
    }

    @Override
    public String toString() {
        return "SetPublishingModeRequest(requestHeader=" + this.getRequestHeader() + ", publishingEnabled=" + this.getPublishingEnabled() + ", subscriptionIds=" + Arrays.deepToString(this.getSubscriptionIds()) + ")";
    }

    private static final class SetPublishingModeRequestBuilderImpl
    extends SetPublishingModeRequestBuilder<SetPublishingModeRequest, SetPublishingModeRequestBuilderImpl> {
        private SetPublishingModeRequestBuilderImpl() {
        }

        @Override
        protected SetPublishingModeRequestBuilderImpl self() {
            return this;
        }

        @Override
        public SetPublishingModeRequest build() {
            return new SetPublishingModeRequest(this);
        }
    }

    public static abstract class SetPublishingModeRequestBuilder<C extends SetPublishingModeRequest, B extends SetPublishingModeRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private Boolean publishingEnabled;
        private UInteger[] subscriptionIds;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SetPublishingModeRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(SetPublishingModeRequest instance, SetPublishingModeRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.publishingEnabled(instance.publishingEnabled);
            b.subscriptionIds(instance.subscriptionIds);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B publishingEnabled(Boolean publishingEnabled) {
            this.publishingEnabled = publishingEnabled;
            return (B)this.self();
        }

        public B subscriptionIds(UInteger[] subscriptionIds) {
            this.subscriptionIds = subscriptionIds;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "SetPublishingModeRequest.SetPublishingModeRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", publishingEnabled=" + this.publishingEnabled + ", subscriptionIds=" + Arrays.deepToString(this.subscriptionIds) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<SetPublishingModeRequest> {
        @Override
        public Class<SetPublishingModeRequest> getType() {
            return SetPublishingModeRequest.class;
        }

        @Override
        public SetPublishingModeRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            Boolean publishingEnabled = decoder.readBoolean("PublishingEnabled");
            UInteger[] subscriptionIds = decoder.readUInt32Array("SubscriptionIds");
            return new SetPublishingModeRequest(requestHeader, publishingEnabled, subscriptionIds);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, SetPublishingModeRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeBoolean("PublishingEnabled", value.getPublishingEnabled());
            encoder.writeUInt32Array("SubscriptionIds", value.getSubscriptionIds());
        }
    }
}

