/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.filter.basic;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.filter.basic.ValueFilter;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public abstract class IntegerFilter
extends ValueFilter {
    protected IntegerFilter(int measurementIndex) {
        super(measurementIndex);
    }

    protected IntegerFilter(ByteBuffer buffer) {
        super(buffer);
    }

    @Override
    public boolean satisfyInteger(long time, int value) {
        return this.valueSatisfy(value);
    }

    @Override
    public ReadWriteIOUtils.ClassSerializeId getClassSerializeId() {
        return ReadWriteIOUtils.ClassSerializeId.INTEGER;
    }

    protected abstract boolean valueSatisfy(int var1);

    @Override
    public boolean[] satisfyTsBlock(boolean[] selection, TsBlock tsBlock) {
        Column valueColumn = tsBlock.getValueColumns()[this.measurementIndex];
        boolean[] satisfyInfo = new boolean[selection.length];
        System.arraycopy(selection, 0, satisfyInfo, 0, selection.length);
        for (int i = 0; i < selection.length; ++i) {
            if (!selection[i]) continue;
            satisfyInfo[i] = valueColumn.isNull(i) ? false : this.valueSatisfy(valueColumn.getInt(i));
        }
        return satisfyInfo;
    }

    @Override
    public void serialize(DataOutputStream outputStream) throws IOException {
        super.serialize(outputStream);
    }
}

