/*
 * Decompiled with CFR 0.152.
 */
package com.linagora.logback.elasticsearch;

import com.fasterxml.jackson.core.JsonGenerator;
import com.linagora.logback.elasticsearch.util.AbstractPropertyAndEncoder;
import java.io.IOException;

class PropertySerializer<T> {
    PropertySerializer() {
    }

    void serializeProperty(JsonGenerator jsonGenerator, T event, AbstractPropertyAndEncoder<T> propertyAndEncoder) throws IOException {
        String value = propertyAndEncoder.encode(event);
        if (propertyAndEncoder.allowEmpty() || value != null && !value.isEmpty()) {
            switch (propertyAndEncoder.getType()) {
                case INT: {
                    this.serializeIntField(jsonGenerator, propertyAndEncoder, value);
                    break;
                }
                case FLOAT: {
                    this.serializeFloatField(jsonGenerator, propertyAndEncoder, value);
                    break;
                }
                case BOOLEAN: {
                    this.serializeBooleanField(jsonGenerator, propertyAndEncoder, value);
                    break;
                }
                case OBJECT: {
                    this.serializeJsonObjectField(jsonGenerator, propertyAndEncoder, value);
                    break;
                }
                default: {
                    this.serializeStringField(jsonGenerator, propertyAndEncoder, value);
                }
            }
        }
    }

    private void serializeStringField(JsonGenerator jsonGenerator, AbstractPropertyAndEncoder<T> propertyAndEncoder, String value) throws IOException {
        jsonGenerator.writeObjectField(propertyAndEncoder.getName(), (Object)value);
    }

    private void serializeIntField(JsonGenerator jsonGenerator, AbstractPropertyAndEncoder<T> propertyAndEncoder, String value) throws IOException {
        try {
            jsonGenerator.writeNumberField(propertyAndEncoder.getName(), Integer.valueOf(value).intValue());
        }
        catch (NumberFormatException e) {
            this.serializeStringField(jsonGenerator, propertyAndEncoder, value);
        }
    }

    private void serializeFloatField(JsonGenerator jsonGenerator, AbstractPropertyAndEncoder<T> propertyAndEncoder, String value) throws IOException {
        try {
            jsonGenerator.writeNumberField(propertyAndEncoder.getName(), Float.valueOf(value).floatValue());
        }
        catch (NumberFormatException e) {
            this.serializeStringField(jsonGenerator, propertyAndEncoder, value);
        }
    }

    private void serializeBooleanField(JsonGenerator jsonGenerator, AbstractPropertyAndEncoder<T> propertyAndEncoder, String value) throws IOException {
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
            jsonGenerator.writeBooleanField(propertyAndEncoder.getName(), Boolean.valueOf(value).booleanValue());
        } else {
            this.serializeStringField(jsonGenerator, propertyAndEncoder, value);
        }
    }

    private void serializeJsonObjectField(JsonGenerator jsonGenerator, AbstractPropertyAndEncoder<T> propertyAndEncoder, String value) throws IOException {
        String trimmed;
        String string = trimmed = value != null ? value.trim() : "";
        if ("".equals(value)) {
            jsonGenerator.writeFieldName(propertyAndEncoder.getName());
            jsonGenerator.writeRawValue("{}");
        } else if (trimmed.startsWith("{") && trimmed.endsWith("}") || trimmed.startsWith("[") && trimmed.endsWith("]")) {
            jsonGenerator.writeFieldName(propertyAndEncoder.getName());
            jsonGenerator.writeRawValue(trimmed);
        } else {
            this.serializeStringField(jsonGenerator, propertyAndEncoder, value);
        }
    }
}

