/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.opensearch._types.query_dsl.RangeQueryBase;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class RangeQuery
extends RangeQueryBase
implements QueryVariant {
    private final String field;
    @Nullable
    private final JsonData gt;
    @Nullable
    private final JsonData gte;
    @Nullable
    private final JsonData lt;
    @Nullable
    private final JsonData lte;
    @Nullable
    private final JsonData from;
    @Nullable
    private final JsonData to;
    @Nullable
    private final String format;
    @Nullable
    private final String timeZone;
    public static final JsonpDeserializer<RangeQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RangeQuery::setupRangeQueryDeserializer);

    private RangeQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.gt = builder.gt;
        this.gte = builder.gte;
        this.lt = builder.lt;
        this.lte = builder.lte;
        this.from = builder.from;
        this.to = builder.to;
        this.format = builder.format;
        this.timeZone = builder.timeZone;
    }

    public static RangeQuery of(Function<Builder, ObjectBuilder<RangeQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Range;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final JsonData gt() {
        return this.gt;
    }

    @Nullable
    public final JsonData gte() {
        return this.gte;
    }

    @Nullable
    public final JsonData lt() {
        return this.lt;
    }

    @Nullable
    public final JsonData lte() {
        return this.lte;
    }

    @Nullable
    public final JsonData from() {
        return this.from;
    }

    @Nullable
    public final JsonData to() {
        return this.to;
    }

    @Nullable
    public final String format() {
        return this.format;
    }

    @Nullable
    public final String timeZone() {
        return this.timeZone;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        if (this.gt != null) {
            generator.writeKey("gt");
            this.gt.serialize(generator, mapper);
        }
        if (this.gte != null) {
            generator.writeKey("gte");
            this.gte.serialize(generator, mapper);
        }
        if (this.lt != null) {
            generator.writeKey("lt");
            this.lt.serialize(generator, mapper);
        }
        if (this.lte != null) {
            generator.writeKey("lte");
            this.lte.serialize(generator, mapper);
        }
        if (this.from != null) {
            generator.writeKey("from");
            this.from.serialize(generator, mapper);
        }
        if (this.to != null) {
            generator.writeKey("to");
            this.to.serialize(generator, mapper);
        }
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.timeZone != null) {
            generator.writeKey("time_zone");
            generator.write(this.timeZone);
        }
        generator.writeEnd();
    }

    public Builder toBuilder() {
        return this.toBuilder(new Builder()).field(this.field).gt(this.gt).gte(this.gte).lt(this.lt).lte(this.lte).from(this.from).to(this.to).format(this.format).timeZone(this.timeZone);
    }

    protected static void setupRangeQueryDeserializer(ObjectDeserializer<Builder> op) {
        RangeQueryBase.setupRangeQueryBaseDeserializer(op);
        op.add(Builder::gt, JsonData._DESERIALIZER, "gt");
        op.add(Builder::gte, JsonData._DESERIALIZER, "gte");
        op.add(Builder::lt, JsonData._DESERIALIZER, "lt");
        op.add(Builder::lte, JsonData._DESERIALIZER, "lte");
        op.add(Builder::from, JsonData._DESERIALIZER, "from");
        op.add(Builder::to, JsonData._DESERIALIZER, "to");
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format");
        op.add(Builder::timeZone, JsonpDeserializer.stringDeserializer(), "time_zone");
        op.setKey(Builder::field, JsonpDeserializer.stringDeserializer());
    }

    public static class Builder
    extends RangeQueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RangeQuery> {
        private String field;
        @Nullable
        private JsonData gt;
        @Nullable
        private JsonData gte;
        @Nullable
        private JsonData lt;
        @Nullable
        private JsonData lte;
        @Nullable
        private JsonData from;
        @Nullable
        private JsonData to;
        @Nullable
        private String format;
        @Nullable
        private String timeZone;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder gt(@Nullable JsonData value) {
            this.gt = value;
            return this;
        }

        public final Builder gte(@Nullable JsonData value) {
            this.gte = value;
            return this;
        }

        public final Builder lt(@Nullable JsonData value) {
            this.lt = value;
            return this;
        }

        public final Builder lte(@Nullable JsonData value) {
            this.lte = value;
            return this;
        }

        public final Builder from(@Nullable JsonData value) {
            this.from = value;
            return this;
        }

        public final Builder to(@Nullable JsonData value) {
            this.to = value;
            return this;
        }

        public final Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        public final Builder timeZone(@Nullable String value) {
            this.timeZone = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RangeQuery build() {
            this._checkSingleUse();
            return new RangeQuery(this);
        }
    }
}

