/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ml;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.ml.ModelConfig;
import org.opensearch.client.opensearch.ml.ModelFormat;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class GetModelResponse
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, GetModelResponse> {
    @Nullable
    private final String algorithm;
    @Nullable
    private final Long createdTime;
    @Nullable
    private final Boolean isHidden;
    @Nullable
    private final Long lastRegisteredTime;
    @Nullable
    private final Long lastUpdatedTime;
    @Nullable
    private final ModelConfig modelConfig;
    @Nullable
    private final String modelContentHashValue;
    @Nullable
    private final Long modelContentSizeInBytes;
    @Nullable
    private final ModelFormat modelFormat;
    @Nullable
    private final String modelGroupId;
    @Nonnull
    private final String modelState;
    @Nullable
    private final String modelVersion;
    @Nullable
    private final String name;
    @Nullable
    private final Long totalChunks;
    public static final JsonpDeserializer<GetModelResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetModelResponse::setupGetModelResponseDeserializer);

    private GetModelResponse(Builder builder) {
        this.algorithm = builder.algorithm;
        this.createdTime = builder.createdTime;
        this.isHidden = builder.isHidden;
        this.lastRegisteredTime = builder.lastRegisteredTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.modelConfig = builder.modelConfig;
        this.modelContentHashValue = builder.modelContentHashValue;
        this.modelContentSizeInBytes = builder.modelContentSizeInBytes;
        this.modelFormat = builder.modelFormat;
        this.modelGroupId = builder.modelGroupId;
        this.modelState = ApiTypeHelper.requireNonNull(builder.modelState, this, "modelState");
        this.modelVersion = builder.modelVersion;
        this.name = builder.name;
        this.totalChunks = builder.totalChunks;
    }

    public static GetModelResponse of(Function<Builder, ObjectBuilder<GetModelResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String algorithm() {
        return this.algorithm;
    }

    @Nullable
    public final Long createdTime() {
        return this.createdTime;
    }

    @Nullable
    public final Boolean isHidden() {
        return this.isHidden;
    }

    @Nullable
    public final Long lastRegisteredTime() {
        return this.lastRegisteredTime;
    }

    @Nullable
    public final Long lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    @Nullable
    public final ModelConfig modelConfig() {
        return this.modelConfig;
    }

    @Nullable
    public final String modelContentHashValue() {
        return this.modelContentHashValue;
    }

    @Nullable
    public final Long modelContentSizeInBytes() {
        return this.modelContentSizeInBytes;
    }

    @Nullable
    public final ModelFormat modelFormat() {
        return this.modelFormat;
    }

    @Nullable
    public final String modelGroupId() {
        return this.modelGroupId;
    }

    @Nonnull
    public final String modelState() {
        return this.modelState;
    }

    @Nullable
    public final String modelVersion() {
        return this.modelVersion;
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    @Nullable
    public final Long totalChunks() {
        return this.totalChunks;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.algorithm != null) {
            generator.writeKey("algorithm");
            generator.write(this.algorithm);
        }
        if (this.createdTime != null) {
            generator.writeKey("created_time");
            generator.write(this.createdTime.longValue());
        }
        if (this.isHidden != null) {
            generator.writeKey("is_hidden");
            generator.write(this.isHidden.booleanValue());
        }
        if (this.lastRegisteredTime != null) {
            generator.writeKey("last_registered_time");
            generator.write(this.lastRegisteredTime.longValue());
        }
        if (this.lastUpdatedTime != null) {
            generator.writeKey("last_updated_time");
            generator.write(this.lastUpdatedTime.longValue());
        }
        if (this.modelConfig != null) {
            generator.writeKey("model_config");
            this.modelConfig.serialize(generator, mapper);
        }
        if (this.modelContentHashValue != null) {
            generator.writeKey("model_content_hash_value");
            generator.write(this.modelContentHashValue);
        }
        if (this.modelContentSizeInBytes != null) {
            generator.writeKey("model_content_size_in_bytes");
            generator.write(this.modelContentSizeInBytes.longValue());
        }
        if (this.modelFormat != null) {
            generator.writeKey("model_format");
            this.modelFormat.serialize(generator, mapper);
        }
        if (this.modelGroupId != null) {
            generator.writeKey("model_group_id");
            generator.write(this.modelGroupId);
        }
        generator.writeKey("model_state");
        generator.write(this.modelState);
        if (this.modelVersion != null) {
            generator.writeKey("model_version");
            generator.write(this.modelVersion);
        }
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
        if (this.totalChunks != null) {
            generator.writeKey("total_chunks");
            generator.write(this.totalChunks.longValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupGetModelResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::algorithm, JsonpDeserializer.stringDeserializer(), "algorithm");
        op.add(Builder::createdTime, JsonpDeserializer.longDeserializer(), "created_time");
        op.add(Builder::isHidden, JsonpDeserializer.booleanDeserializer(), "is_hidden");
        op.add(Builder::lastRegisteredTime, JsonpDeserializer.longDeserializer(), "last_registered_time");
        op.add(Builder::lastUpdatedTime, JsonpDeserializer.longDeserializer(), "last_updated_time");
        op.add(Builder::modelConfig, ModelConfig._DESERIALIZER, "model_config");
        op.add(Builder::modelContentHashValue, JsonpDeserializer.stringDeserializer(), "model_content_hash_value");
        op.add(Builder::modelContentSizeInBytes, JsonpDeserializer.longDeserializer(), "model_content_size_in_bytes");
        op.add(Builder::modelFormat, ModelFormat._DESERIALIZER, "model_format");
        op.add(Builder::modelGroupId, JsonpDeserializer.stringDeserializer(), "model_group_id");
        op.add(Builder::modelState, JsonpDeserializer.stringDeserializer(), "model_state");
        op.add(Builder::modelVersion, JsonpDeserializer.stringDeserializer(), "model_version");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::totalChunks, JsonpDeserializer.longDeserializer(), "total_chunks");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.algorithm);
        result = 31 * result + Objects.hashCode(this.createdTime);
        result = 31 * result + Objects.hashCode(this.isHidden);
        result = 31 * result + Objects.hashCode(this.lastRegisteredTime);
        result = 31 * result + Objects.hashCode(this.lastUpdatedTime);
        result = 31 * result + Objects.hashCode(this.modelConfig);
        result = 31 * result + Objects.hashCode(this.modelContentHashValue);
        result = 31 * result + Objects.hashCode(this.modelContentSizeInBytes);
        result = 31 * result + Objects.hashCode(this.modelFormat);
        result = 31 * result + Objects.hashCode(this.modelGroupId);
        result = 31 * result + this.modelState.hashCode();
        result = 31 * result + Objects.hashCode(this.modelVersion);
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.totalChunks);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetModelResponse other = (GetModelResponse)o;
        return Objects.equals(this.algorithm, other.algorithm) && Objects.equals(this.createdTime, other.createdTime) && Objects.equals(this.isHidden, other.isHidden) && Objects.equals(this.lastRegisteredTime, other.lastRegisteredTime) && Objects.equals(this.lastUpdatedTime, other.lastUpdatedTime) && Objects.equals(this.modelConfig, other.modelConfig) && Objects.equals(this.modelContentHashValue, other.modelContentHashValue) && Objects.equals(this.modelContentSizeInBytes, other.modelContentSizeInBytes) && Objects.equals(this.modelFormat, other.modelFormat) && Objects.equals(this.modelGroupId, other.modelGroupId) && this.modelState.equals(other.modelState) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals(this.name, other.name) && Objects.equals(this.totalChunks, other.totalChunks);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, GetModelResponse> {
        @Nullable
        private String algorithm;
        @Nullable
        private Long createdTime;
        @Nullable
        private Boolean isHidden;
        @Nullable
        private Long lastRegisteredTime;
        @Nullable
        private Long lastUpdatedTime;
        @Nullable
        private ModelConfig modelConfig;
        @Nullable
        private String modelContentHashValue;
        @Nullable
        private Long modelContentSizeInBytes;
        @Nullable
        private ModelFormat modelFormat;
        @Nullable
        private String modelGroupId;
        private String modelState;
        @Nullable
        private String modelVersion;
        @Nullable
        private String name;
        @Nullable
        private Long totalChunks;

        public Builder() {
        }

        private Builder(GetModelResponse o) {
            this.algorithm = o.algorithm;
            this.createdTime = o.createdTime;
            this.isHidden = o.isHidden;
            this.lastRegisteredTime = o.lastRegisteredTime;
            this.lastUpdatedTime = o.lastUpdatedTime;
            this.modelConfig = o.modelConfig;
            this.modelContentHashValue = o.modelContentHashValue;
            this.modelContentSizeInBytes = o.modelContentSizeInBytes;
            this.modelFormat = o.modelFormat;
            this.modelGroupId = o.modelGroupId;
            this.modelState = o.modelState;
            this.modelVersion = o.modelVersion;
            this.name = o.name;
            this.totalChunks = o.totalChunks;
        }

        private Builder(Builder o) {
            this.algorithm = o.algorithm;
            this.createdTime = o.createdTime;
            this.isHidden = o.isHidden;
            this.lastRegisteredTime = o.lastRegisteredTime;
            this.lastUpdatedTime = o.lastUpdatedTime;
            this.modelConfig = o.modelConfig;
            this.modelContentHashValue = o.modelContentHashValue;
            this.modelContentSizeInBytes = o.modelContentSizeInBytes;
            this.modelFormat = o.modelFormat;
            this.modelGroupId = o.modelGroupId;
            this.modelState = o.modelState;
            this.modelVersion = o.modelVersion;
            this.name = o.name;
            this.totalChunks = o.totalChunks;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder algorithm(@Nullable String value) {
            this.algorithm = value;
            return this;
        }

        @Nonnull
        public final Builder createdTime(@Nullable Long value) {
            this.createdTime = value;
            return this;
        }

        @Nonnull
        public final Builder isHidden(@Nullable Boolean value) {
            this.isHidden = value;
            return this;
        }

        @Nonnull
        public final Builder lastRegisteredTime(@Nullable Long value) {
            this.lastRegisteredTime = value;
            return this;
        }

        @Nonnull
        public final Builder lastUpdatedTime(@Nullable Long value) {
            this.lastUpdatedTime = value;
            return this;
        }

        @Nonnull
        public final Builder modelConfig(@Nullable ModelConfig value) {
            this.modelConfig = value;
            return this;
        }

        @Nonnull
        public final Builder modelConfig(Function<ModelConfig.Builder, ObjectBuilder<ModelConfig>> fn) {
            return this.modelConfig(fn.apply(new ModelConfig.Builder()).build());
        }

        @Nonnull
        public final Builder modelContentHashValue(@Nullable String value) {
            this.modelContentHashValue = value;
            return this;
        }

        @Nonnull
        public final Builder modelContentSizeInBytes(@Nullable Long value) {
            this.modelContentSizeInBytes = value;
            return this;
        }

        @Nonnull
        public final Builder modelFormat(@Nullable ModelFormat value) {
            this.modelFormat = value;
            return this;
        }

        @Nonnull
        public final Builder modelGroupId(@Nullable String value) {
            this.modelGroupId = value;
            return this;
        }

        @Nonnull
        public final Builder modelState(String value) {
            this.modelState = value;
            return this;
        }

        @Nonnull
        public final Builder modelVersion(@Nullable String value) {
            this.modelVersion = value;
            return this;
        }

        @Nonnull
        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        @Nonnull
        public final Builder totalChunks(@Nullable Long value) {
            this.totalChunks = value;
            return this;
        }

        @Override
        @Nonnull
        public GetModelResponse build() {
            this._checkSingleUse();
            return new GetModelResponse(this);
        }
    }
}

