/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.utils.base16;

public class NSAPRecord
extends Record {
    private byte[] address;

    NSAPRecord() {
    }

    private static byte[] checkAndConvertAddress(String address) {
        if (!address.substring(0, 2).equalsIgnoreCase("0x")) {
            return null;
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        boolean partial = false;
        int current = 0;
        for (int i = 2; i < address.length(); ++i) {
            char c = address.charAt(i);
            if (c == '.') continue;
            int value = Character.digit(c, 16);
            if (value == -1) {
                return null;
            }
            if (partial) {
                bytes.write(current += value);
                partial = false;
                continue;
            }
            current = value << 4;
            partial = true;
        }
        if (partial) {
            return null;
        }
        return bytes.toByteArray();
    }

    public NSAPRecord(Name name, int dclass, long ttl, String address) {
        super(name, 22, dclass, ttl);
        this.address = NSAPRecord.checkAndConvertAddress(address);
        if (this.address == null) {
            throw new IllegalArgumentException("invalid NSAP address " + address);
        }
    }

    @Override
    protected void rrFromWire(DNSInput in) {
        this.address = in.readByteArray();
    }

    @Override
    protected void rdataFromString(Tokenizer st, Name origin) throws IOException {
        String addr = st.getString();
        this.address = NSAPRecord.checkAndConvertAddress(addr);
        if (this.address == null) {
            throw st.exception("invalid NSAP address " + addr);
        }
    }

    public String getAddress() {
        return NSAPRecord.byteArrayToString(this.address, false);
    }

    @Override
    protected void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeByteArray(this.address);
    }

    @Override
    protected String rrToString() {
        return "0x" + base16.toString(this.address);
    }
}

