/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ReplicationServerMonitorEntry
extends MonitorEntry {
    @NotNull
    static final String REPLICATION_SERVER_MONITOR_OC = "ds-replication-server-monitor-entry";
    @NotNull
    private static final String ATTR_BASE_DN = "base-dn";
    @NotNull
    private static final String ATTR_BASE_DN_GENERATION_ID = "base-dn-generation-id";
    @NotNull
    private static final String ATTR_REPLICATION_SERVER_ID = "replication-server-id";
    @NotNull
    private static final String ATTR_REPLICATION_SERVER_PORT = "replication-server-port";
    @NotNull
    private static final String ATTR_SSL_AVAILABLE = "ssl-encryption-available";
    private static final long serialVersionUID = 7488640967498574690L;
    @Nullable
    private final Boolean sslEncryptionAvailable;
    @NotNull
    private final List<String> baseDNs = this.getStrings("base-dn");
    @Nullable
    private final Long replicationServerPort;
    @NotNull
    private final Map<DN, String> generationIDs;
    @Nullable
    private final String replicationServerID = this.getString("replication-server-id");

    public ReplicationServerMonitorEntry(@NotNull Entry entry) {
        super(entry);
        this.replicationServerPort = this.getLong(ATTR_REPLICATION_SERVER_PORT);
        this.sslEncryptionAvailable = this.getBoolean(ATTR_SSL_AVAILABLE);
        List<String> baseDNsAndIDs = this.getStrings(ATTR_BASE_DN_GENERATION_ID);
        LinkedHashMap<DN, String> idMap = new LinkedHashMap<DN, String>(StaticUtils.computeMapCapacity(baseDNsAndIDs.size()));
        for (String s : baseDNsAndIDs) {
            try {
                int lastSpacePos = s.lastIndexOf(32);
                DN dn = new DN(s.substring(0, lastSpacePos));
                idMap.put(dn, s.substring(lastSpacePos + 1));
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        this.generationIDs = Collections.unmodifiableMap(idMap);
    }

    @NotNull
    public List<String> getBaseDNs() {
        return this.baseDNs;
    }

    @NotNull
    public Map<DN, String> getGenerationIDs() {
        return this.generationIDs;
    }

    @Nullable
    public String getGenerationID(@NotNull String baseDN) {
        try {
            return this.getGenerationID(new DN(baseDN));
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    @Nullable
    public String getGenerationID(@NotNull DN baseDN) {
        return this.generationIDs.get(baseDN);
    }

    @Nullable
    public String getReplicationServerID() {
        return this.replicationServerID;
    }

    @Nullable
    public Long getReplicationServerPort() {
        return this.replicationServerPort;
    }

    @Nullable
    public Boolean sslEncryptionAvailable() {
        return this.sslEncryptionAvailable;
    }

    @Override
    @NotNull
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_REPLICATION_SERVER_MONITOR_DISPNAME.get();
    }

    @Override
    @NotNull
    public String getMonitorDescription() {
        return MonitorMessages.INFO_REPLICATION_SERVER_MONITOR_DESC.get();
    }

    @Override
    @NotNull
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>(StaticUtils.computeMapCapacity(10));
        if (!this.baseDNs.isEmpty()) {
            ReplicationServerMonitorEntry.addMonitorAttribute(attrs, ATTR_BASE_DN, MonitorMessages.INFO_REPLICATION_SERVER_DISPNAME_BASE_DN.get(), MonitorMessages.INFO_REPLICATION_SERVER_DESC_BASE_DN.get(), this.baseDNs);
        }
        if (!this.generationIDs.isEmpty()) {
            ArrayList<String> idStrings = new ArrayList<String>(this.generationIDs.size());
            for (Map.Entry<DN, String> e : this.generationIDs.entrySet()) {
                idStrings.add(e.getKey().toNormalizedString() + ' ' + e.getValue());
            }
            ReplicationServerMonitorEntry.addMonitorAttribute(attrs, ATTR_BASE_DN_GENERATION_ID, MonitorMessages.INFO_REPLICATION_SERVER_DISPNAME_BASE_DN_GENERATION_ID.get(), MonitorMessages.INFO_REPLICATION_SERVER_DESC_BASE_DN_GENERATION_ID.get(), idStrings);
        }
        if (this.replicationServerID != null) {
            ReplicationServerMonitorEntry.addMonitorAttribute(attrs, ATTR_REPLICATION_SERVER_ID, MonitorMessages.INFO_REPLICATION_SERVER_DISPNAME_REPLICATION_SERVER_ID.get(), MonitorMessages.INFO_REPLICATION_SERVER_DESC_REPLICATION_SERVER_ID.get(), this.replicationServerID);
        }
        if (this.replicationServerPort != null) {
            ReplicationServerMonitorEntry.addMonitorAttribute(attrs, ATTR_REPLICATION_SERVER_PORT, MonitorMessages.INFO_REPLICATION_SERVER_DISPNAME_REPLICATION_SERVER_PORT.get(), MonitorMessages.INFO_REPLICATION_SERVER_DESC_REPLICATION_SERVER_PORT.get(), this.replicationServerPort);
        }
        if (this.sslEncryptionAvailable != null) {
            ReplicationServerMonitorEntry.addMonitorAttribute(attrs, ATTR_SSL_AVAILABLE, MonitorMessages.INFO_REPLICATION_SERVER_DISPNAME_SSL_AVAILABLE.get(), MonitorMessages.INFO_REPLICATION_SERVER_DESC_SSL_AVAILABLE.get(), this.sslEncryptionAvailable);
        }
        return Collections.unmodifiableMap(attrs);
    }
}

