/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail.task;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import jakarta.mail.Flags;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.mail.CassandraDeletedMessageDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxRecentsDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageIdDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageMetadata;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.task.Task;
import org.apache.james.util.streams.Limit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class SolveMailboxFlagInconsistenciesService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SolveMailboxFlagInconsistenciesService.class);
    private final Set<SolveMessageFlagInconsistencyStrategy> fixInconsistenciesStrategies;
    private final CassandraMessageIdDAO messageIdDAO;
    private final CassandraMailboxDAO mailboxDAO;

    @Inject
    public SolveMailboxFlagInconsistenciesService(Set<SolveMessageFlagInconsistencyStrategy> fixInconsistenciesStrategies, CassandraMessageIdDAO messageIdDAO, CassandraMailboxDAO mailboxDAO) {
        this.messageIdDAO = messageIdDAO;
        this.fixInconsistenciesStrategies = fixInconsistenciesStrategies;
        this.mailboxDAO = mailboxDAO;
    }

    public Mono<Task.Result> fixInconsistencies(Context context, TargetFlag targetFlag) {
        SolveMessageFlagInconsistencyStrategy fixInconsistencyStrategy = this.getFixInconsistencyStrategy(targetFlag);
        return this.mailboxDAO.retrieveAllMailboxes().concatMap(mailbox -> this.fixDeletedMessagesInconsistencyPerMailbox(fixInconsistencyStrategy, (CassandraId)mailbox.getMailboxId(), context).doOnNext(any -> context.incrementProcessedMailboxEntries())).reduce((Object)Task.Result.COMPLETED, Task::combine);
    }

    private Mono<Task.Result> fixDeletedMessagesInconsistencyPerMailbox(SolveMessageFlagInconsistencyStrategy fixInconsistenciesStrategy, CassandraId cassandraId, Context context) {
        return fixInconsistenciesStrategy.removeAllByMailboxId(cassandraId).then(this.messageIdDAO.retrieveMessages(cassandraId, MessageRange.all(), Limit.unlimited()).filter(fixInconsistenciesStrategy.filterOutFlagInconsistencies()).map(metadata -> metadata.getComposedMessageId().getComposedMessageId().getUid()).collectList().filter(uids -> !uids.isEmpty()).flatMap(uids -> fixInconsistenciesStrategy.addEntry(cassandraId, (List<MessageUid>)uids))).thenReturn((Object)Task.Result.COMPLETED).onErrorResume(e -> {
            LOGGER.error("Error while fixing inconsistencies for mailbox {}", (Object)cassandraId, e);
            context.addError(cassandraId);
            return Mono.just((Object)Task.Result.PARTIAL);
        });
    }

    private SolveMessageFlagInconsistencyStrategy getFixInconsistencyStrategy(TargetFlag targetFlag) {
        return this.fixInconsistenciesStrategies.stream().filter(strategy -> strategy.targetFlag() == targetFlag).findFirst().orElseThrow(() -> new IllegalArgumentException("No strategy found for " + String.valueOf((Object)targetFlag)));
    }

    public static enum TargetFlag {
        RECENT,
        DELETED;


        public static TargetFlag from(String value) {
            return TargetFlag.valueOf(value);
        }
    }

    public static interface SolveMessageFlagInconsistencyStrategy {
        public Predicate<CassandraMessageMetadata> filterOutFlagInconsistencies();

        public Mono<Void> removeAllByMailboxId(CassandraId var1);

        public Mono<Void> addEntry(CassandraId var1, List<MessageUid> var2);

        public TargetFlag targetFlag();
    }

    public record Context(AtomicLong processedMailboxEntries, ConcurrentLinkedDeque<CassandraId> errors) {
        public Context() {
            this(new AtomicLong(0L), new ConcurrentLinkedDeque<CassandraId>());
        }

        void incrementProcessedMailboxEntries() {
            this.processedMailboxEntries.incrementAndGet();
        }

        void addError(CassandraId cassandraId) {
            this.errors.add(cassandraId);
        }

        Snapshot snapshot() {
            return new Snapshot(this.processedMailboxEntries.get(), (ImmutableList<CassandraId>)ImmutableList.copyOf(this.errors));
        }

        record Snapshot(long processedMailboxEntries, ImmutableList<CassandraId> errors) {
        }
    }

    public record SoleMailboxRecentFlagInconsistenciesStrategy(CassandraMailboxRecentsDAO mailboxRecentDAO) implements SolveMessageFlagInconsistencyStrategy
    {
        @Override
        public Predicate<CassandraMessageMetadata> filterOutFlagInconsistencies() {
            return metaData -> metaData.getComposedMessageId().getFlags().contains(Flags.Flag.RECENT);
        }

        @Override
        public Mono<Void> removeAllByMailboxId(CassandraId cassandraId) {
            return this.mailboxRecentDAO.delete(cassandraId);
        }

        @Override
        public Mono<Void> addEntry(CassandraId cassandraId, List<MessageUid> uids) {
            return this.mailboxRecentDAO.addToRecent(cassandraId, uids);
        }

        @Override
        public TargetFlag targetFlag() {
            return TargetFlag.RECENT;
        }
    }

    public record SolveMailboxDeletedFlagInconsistenciesStrategy(CassandraDeletedMessageDAO deletedMessageDAO) implements SolveMessageFlagInconsistencyStrategy
    {
        @Override
        public Predicate<CassandraMessageMetadata> filterOutFlagInconsistencies() {
            return metaData -> metaData.getComposedMessageId().getFlags().contains(Flags.Flag.DELETED);
        }

        @Override
        public Mono<Void> removeAllByMailboxId(CassandraId cassandraId) {
            return this.deletedMessageDAO.removeAll(cassandraId);
        }

        @Override
        public Mono<Void> addEntry(CassandraId cassandraId, List<MessageUid> uids) {
            return this.deletedMessageDAO.addDeleted(cassandraId, uids);
        }

        @Override
        public TargetFlag targetFlag() {
            return TargetFlag.DELETED;
        }
    }
}

