/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class VirtualAttributesOnlyRequestControl
extends Control {
    @NotNull
    public static final String VIRTUAL_ATTRIBUTES_ONLY_REQUEST_OID = "2.16.840.1.113730.3.4.19";
    private static final long serialVersionUID = 1509094615426408618L;

    public VirtualAttributesOnlyRequestControl() {
        this(false);
    }

    public VirtualAttributesOnlyRequestControl(boolean isCritical) {
        super(VIRTUAL_ATTRIBUTES_ONLY_REQUEST_OID, isCritical, null);
    }

    public VirtualAttributesOnlyRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        if (control.hasValue()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_VIRTUAL_ATTRS_ONLY_REQUEST_HAS_VALUE.get());
        }
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_VIRTUAL_ATTRS_ONLY_REQUEST.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        return new JSONObject(new JSONField("oid", VIRTUAL_ATTRIBUTES_ONLY_REQUEST_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_VIRTUAL_ATTRS_ONLY_REQUEST.get()), new JSONField("criticality", this.isCritical()));
    }

    @NotNull
    public static VirtualAttributesOnlyRequestControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, false, false);
        return new VirtualAttributesOnlyRequestControl(jsonControl.getCriticality());
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("VirtualAttributesOnlyRequestControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(')');
    }
}

