/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.postgres;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSource;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.backends.postgres.utils.PostgresUtils;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.apache.james.blob.api.ObjectNotFoundException;
import org.apache.james.blob.api.ObjectStoreIOException;
import org.apache.james.blob.postgres.PostgresBlobStorageDataDefinition;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.impl.DSL;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresBlobStoreDAO
implements BlobStoreDAO {
    private final PostgresExecutor postgresExecutor;
    private final BlobId.Factory blobIdFactory;

    @Inject
    public PostgresBlobStoreDAO(PostgresExecutor postgresExecutor, BlobId.Factory blobIdFactory) {
        this.postgresExecutor = postgresExecutor;
        this.blobIdFactory = blobIdFactory;
    }

    public InputStream read(BucketName bucketName, BlobId blobId) throws ObjectStoreIOException, ObjectNotFoundException {
        return (InputStream)Mono.from(this.readReactive(bucketName, blobId)).block();
    }

    public Mono<InputStream> readReactive(BucketName bucketName, BlobId blobId) {
        return Mono.from(this.readBytes(bucketName, blobId)).map(ByteArrayInputStream::new);
    }

    public Mono<byte[]> readBytes(BucketName bucketName, BlobId blobId) {
        return this.postgresExecutor.executeRow(dsl -> Mono.from((Publisher)dsl.select(PostgresBlobStorageDataDefinition.PostgresBlobStorageTable.DATA).from(PostgresBlobStorageDataDefinition.PostgresBlobStorageTable.TABLE_NAME).where(PostgresBlobStorageDataDefinition.PostgresBlobStorageTable.BUCKET_NAME.eq((Object)bucketName.asString())).and(PostgresBlobStorageDataDefinition.PostgresBlobStorageTable.BLOB_ID.eq((Object)blobId.asString())))).map(record -> (byte[])record.get(PostgresBlobStorageDataDefinition.PostgresBlobStorageTable.DATA)).switchIfEmpty(Mono.error(() -> new ObjectNotFoundException("Blob " + String.valueOf(blobId) + " does not exist in bucket " + String.valueOf(bucketName))));
    }

    public Mono<Void> save(BucketName bucketName, BlobId blobId, byte[] data) {
        Preconditions.checkNotNull((Object)data);
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.insertInto(PostgresBlobStorageDataDefinition.PostgresBlobStorageTable.TABLE_NAME, PostgresBlobStorageDataDefinition.PostgresBlobStorageTable.BUCKET_NAME, PostgresBlobStorageDataDefinition.PostgresBlobStorageTable.BLOB_ID, PostgresBlobStorageDataDefinition.PostgresBlobStorageTable.DATA, PostgresBlobStorageDataDefinition.PostgresBlobStorageTable.SIZE).values((Object)bucketName.asString(), (Object)blobId.asString(), (Object)data, (Object)data.length).onConflict(new Field[]{PostgresBlobStorageDataDefinition.PostgresBlobStorageTable.BUCKET_NAME, PostgresBlobStorageDataDefinition.PostgresBlobStorageTable.BLOB_ID}).doUpdate().set(PostgresBlobStorageDataDefinition.PostgresBlobStorageTable.DATA, (Object)data).set(PostgresBlobStorageDataDefinition.PostgresBlobStorageTable.SIZE, (Object)data.length)));
    }

    public Mono<Void> save(BucketName bucketName, BlobId blobId, InputStream inputStream) {
        Preconditions.checkNotNull((Object)inputStream);
        return Mono.fromCallable(() -> {
            try {
                return IOUtils.toByteArray((InputStream)inputStream);
            }
            catch (IOException e) {
                throw new ObjectStoreIOException("IOException occurred", (Throwable)e);
            }
        }).flatMap(bytes -> this.save(bucketName, blobId, (byte[])bytes));
    }

    public Mono<Void> save(BucketName bucketName, BlobId blobId, ByteSource content) {
        return Mono.fromCallable(() -> {
            try {
                return content.read();
            }
            catch (IOException e) {
                throw new ObjectStoreIOException("IOException occurred", (Throwable)e);
            }
        }).flatMap(bytes -> this.save(bucketName, blobId, (byte[])bytes));
    }

    public Mono<Void> delete(BucketName bucketName, BlobId blobId) {
        return this.postgresExecutor.executeVoid(dsl -> Mono.from((Publisher)dsl.deleteFrom(PostgresBlobStorageDataDefinition.PostgresBlobStorageTable.TABLE_NAME).where(PostgresBlobStorageDataDefinition.PostgresBlobStorageTable.BUCKET_NAME.eq((Object)bucketName.asString())).and(PostgresBlobStorageDataDefinition.PostgresBlobStorageTable.BLOB_ID.eq((Object)blobId.asString()))));
    }

    public Mono<Void> delete(BucketName bucketName, Collection<BlobId> blobIds) {
        if (blobIds.isEmpty()) {
            return Mono.empty();
        }
        return this.postgresExecutor.executeVoid(dsl -> Mono.from((Publisher)dsl.deleteFrom(PostgresBlobStorageDataDefinition.PostgresBlobStorageTable.TABLE_NAME).where(PostgresBlobStorageDataDefinition.PostgresBlobStorageTable.BUCKET_NAME.eq((Object)bucketName.asString())).and(PostgresBlobStorageDataDefinition.PostgresBlobStorageTable.BLOB_ID.in((Collection)blobIds.stream().map(BlobId::asString).collect(ImmutableList.toImmutableList())))));
    }

    public Mono<Void> deleteBucket(BucketName bucketName) {
        return this.postgresExecutor.executeVoid(dsl -> Mono.from((Publisher)dsl.deleteFrom(PostgresBlobStorageDataDefinition.PostgresBlobStorageTable.TABLE_NAME).where(PostgresBlobStorageDataDefinition.PostgresBlobStorageTable.BUCKET_NAME.eq((Object)bucketName.asString()))));
    }

    public Flux<BucketName> listBuckets() {
        return this.postgresExecutor.executeRows(dsl -> Flux.from((Publisher)dsl.selectDistinct(PostgresBlobStorageDataDefinition.PostgresBlobStorageTable.BUCKET_NAME).from(PostgresBlobStorageDataDefinition.PostgresBlobStorageTable.TABLE_NAME))).map(record -> BucketName.of((String)((String)record.get(PostgresBlobStorageDataDefinition.PostgresBlobStorageTable.BUCKET_NAME))));
    }

    public Flux<BlobId> listBlobs(BucketName bucketName) {
        return Flux.defer(() -> this.listBlobsBatch(bucketName, Optional.empty(), PostgresUtils.QUERY_BATCH_SIZE)).expand(blobIds -> {
            if (blobIds.isEmpty() || blobIds.size() < PostgresUtils.QUERY_BATCH_SIZE) {
                return Mono.empty();
            }
            return this.listBlobsBatch(bucketName, Optional.of((BlobId)blobIds.getLast()), PostgresUtils.QUERY_BATCH_SIZE);
        }).flatMapIterable(Function.identity());
    }

    private Mono<List<BlobId>> listBlobsBatch(BucketName bucketName, Optional<BlobId> blobIdFrom, int batchSize) {
        return this.postgresExecutor.executeRows(dsl -> Flux.from((Publisher)dsl.select(PostgresBlobStorageDataDefinition.PostgresBlobStorageTable.BLOB_ID).from(PostgresBlobStorageDataDefinition.PostgresBlobStorageTable.TABLE_NAME).where(PostgresBlobStorageDataDefinition.PostgresBlobStorageTable.BUCKET_NAME.eq((Object)bucketName.asString())).and(blobIdFrom.map(blobId -> PostgresBlobStorageDataDefinition.PostgresBlobStorageTable.BLOB_ID.greaterThan((Object)blobId.asString())).orElseGet(DSL::noCondition)).orderBy((OrderField)PostgresBlobStorageDataDefinition.PostgresBlobStorageTable.BLOB_ID.asc()).limit((Number)batchSize))).map(record -> this.blobIdFactory.parse((String)record.get(PostgresBlobStorageDataDefinition.PostgresBlobStorageTable.BLOB_ID))).collectList().switchIfEmpty(Mono.just((Object)ImmutableList.of()));
    }
}

