/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.ssl.SSLMessages;
import com.unboundid.util.ssl.cert.CertException;
import com.unboundid.util.ssl.cert.X509Certificate;
import com.unboundid.util.ssl.cert.X509PEMFileReader;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.X509TrustManager;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PEMFileTrustManager
implements X509TrustManager,
Serializable {
    private static final long serialVersionUID = 1973401278035832777L;
    @NotNull
    private final Map<X509Certificate, java.security.cert.X509Certificate> trustedCertificates;

    public PEMFileTrustManager(File ... pemFiles) throws KeyStoreException {
        this(StaticUtils.toList(pemFiles));
    }

    public PEMFileTrustManager(@NotNull List<File> pemFiles) throws KeyStoreException {
        Validator.ensureNotNullWithMessage(pemFiles, "PEMFileTrustManager.pemFiles must not be null.");
        Validator.ensureFalse(pemFiles.isEmpty(), "PEMFileTrustManager.pemFiles must not be empty.");
        HashMap<X509Certificate, java.security.cert.X509Certificate> certMap = new HashMap<X509Certificate, java.security.cert.X509Certificate>();
        for (File f : pemFiles) {
            PEMFileTrustManager.readTrustedCertificates(f, certMap);
        }
        this.trustedCertificates = Collections.unmodifiableMap(certMap);
    }

    private static void readTrustedCertificates(@NotNull File f, @NotNull Map<X509Certificate, java.security.cert.X509Certificate> m) throws KeyStoreException {
        block23: {
            if (!f.exists()) {
                throw new KeyStoreException(SSLMessages.ERR_PEM_FILE_TRUST_MANAGER_NO_SUCH_FILE.get(f.getAbsolutePath()));
            }
            try {
                if (f.isDirectory()) {
                    for (File fileInDir : f.listFiles()) {
                        PEMFileTrustManager.readTrustedCertificates(fileInDir, m);
                    }
                    break block23;
                }
                try (X509PEMFileReader r = new X509PEMFileReader(f);){
                    boolean readCert = false;
                    while (true) {
                        X509Certificate cert;
                        if ((cert = r.readCertificate()) == null) {
                            if (!readCert) {
                                throw new KeyStoreException(SSLMessages.ERR_PEM_FILE_TRUST_MANAGER_EMPTY_FILE.get(f.getAbsolutePath()));
                            }
                            break;
                        }
                        readCert = true;
                        java.security.cert.X509Certificate c = (java.security.cert.X509Certificate)cert.toCertificate();
                        m.put(cert, c);
                    }
                }
            }
            catch (KeyStoreException e) {
                Debug.debugException(e);
                throw e;
            }
            catch (IOException e) {
                Debug.debugException(e);
                throw new KeyStoreException(SSLMessages.ERR_PEM_FILE_TRUST_MANAGER_ERROR_READING_FILE.get(f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
            }
            catch (CertException e) {
                Debug.debugException(e);
                throw new KeyStoreException(SSLMessages.ERR_PEM_FILE_TRUST_MANAGER_ERROR_PARSING_CERT.get(f.getAbsolutePath(), e.getMessage()), e);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new KeyStoreException(SSLMessages.ERR_PEM_FILE_TRUST_MANAGER_ERROR_PROCESSING_FILE.get(f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
            }
        }
    }

    @Override
    public void checkClientTrusted(@NotNull java.security.cert.X509Certificate[] chain, @NotNull String authType) throws CertificateException {
        try {
            this.checkTrusted(chain);
        }
        catch (CertificateException e) {
            Debug.debugException(e);
            throw new CertificateException(SSLMessages.ERR_PEM_FILE_TRUST_MANAGER_CLIENT_NOT_TRUSTED.get(e.getMessage()), e);
        }
    }

    @Override
    public void checkServerTrusted(@NotNull java.security.cert.X509Certificate[] chain, @NotNull String authType) throws CertificateException {
        try {
            this.checkTrusted(chain);
        }
        catch (CertificateException e) {
            Debug.debugException(e);
            throw new CertificateException(SSLMessages.ERR_PEM_FILE_TRUST_MANAGER_SERVER_NOT_TRUSTED.get(e.getMessage()), e);
        }
    }

    private void checkTrusted(@NotNull java.security.cert.X509Certificate[] chain) throws CertificateException {
        if (chain == null || chain.length == 0) {
            throw new CertificateException(SSLMessages.ERR_PEM_FILE_TRUST_MANAGER_EMPTY_CHAIN.get());
        }
        boolean foundCertificate = false;
        X509Certificate firstCertificate = null;
        X509Certificate previousCertificate = null;
        for (java.security.cert.X509Certificate c : chain) {
            X509Certificate parsedCertificate;
            try {
                parsedCertificate = new X509Certificate(c.getEncoded());
            }
            catch (CertException e) {
                Debug.debugException(e);
                throw new CertificateException(SSLMessages.ERR_PEM_FILE_TRUST_MANAGER_CANNOT_PARSE_CERT_FROM_CHAIN.get(c.getSubjectX500Principal().getName("RFC2253"), StaticUtils.getExceptionMessage(e)), e);
            }
            if (firstCertificate == null) {
                firstCertificate = parsedCertificate;
            }
            if (!parsedCertificate.isWithinValidityWindow()) {
                throw new CertificateException(SSLMessages.ERR_PEM_FILE_TRUST_MANAGER_CERT_NOT_VALID.get(String.valueOf(parsedCertificate.getSubjectDN()), StaticUtils.encodeRFC3339Time(parsedCertificate.getNotBeforeDate()), StaticUtils.encodeRFC3339Time(parsedCertificate.getNotAfterDate())));
            }
            if (previousCertificate != null && !parsedCertificate.isIssuerFor(previousCertificate)) {
                throw new CertificateException(SSLMessages.ERR_PEM_FILE_TRUST_MANAGER_CERT_NOT_ISSUER.get(String.valueOf(parsedCertificate.getSubjectDN()), String.valueOf(previousCertificate.getSubjectDN())));
            }
            foundCertificate |= this.trustedCertificates.containsKey(parsedCertificate);
            previousCertificate = parsedCertificate;
        }
        if (!foundCertificate && !previousCertificate.isSelfSigned()) {
            for (X509Certificate c : this.trustedCertificates.keySet()) {
                if (!c.isIssuerFor(previousCertificate)) continue;
                foundCertificate = true;
                break;
            }
        }
        if (!foundCertificate) {
            throw new CertificateException(SSLMessages.ERR_PEM_FILE_TRUST_MANAGER_NOT_TRUSTED.get(String.valueOf(firstCertificate.getSubjectDN())));
        }
    }

    @Override
    @NotNull
    public java.security.cert.X509Certificate[] getAcceptedIssuers() {
        long currentTime = System.currentTimeMillis();
        ArrayList<java.security.cert.X509Certificate> certList = new ArrayList<java.security.cert.X509Certificate>(this.trustedCertificates.size());
        for (Map.Entry<X509Certificate, java.security.cert.X509Certificate> e : this.trustedCertificates.entrySet()) {
            if (!e.getKey().isWithinValidityWindow(currentTime)) continue;
            certList.add(e.getValue());
        }
        java.security.cert.X509Certificate[] certArray = new java.security.cert.X509Certificate[certList.size()];
        return certList.toArray(certArray);
    }
}

