/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Iterator;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.CharSpace;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.riot.system.StreamRDFOps;
import org.apache.jena.riot.writer.WriterGraphRIOTBase;
import org.apache.jena.riot.writer.WriterStreamRDFPlain;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.util.iterator.ExtendedIterator;

public class NTriplesWriter
extends WriterGraphRIOTBase {
    private final CharSpace charSpace;

    public static void write(OutputStream out, Iterator<Triple> iter) {
        NTriplesWriter.write(out, iter, CharSpace.UTF8);
    }

    public static void write(OutputStream out, Iterator<Triple> iter, CharSpace charSpace) {
        StreamRDF s = StreamRDFLib.writer(out, charSpace);
        NTriplesWriter.write$(s, iter);
    }

    public static void write(Writer out, Iterator<Triple> iter) {
        NTriplesWriter.write(out, iter, CharSpace.UTF8);
    }

    public static void write(Writer out, Iterator<Triple> iter, CharSpace charSpace) {
        StreamRDF s = StreamRDFLib.writer(out, charSpace);
        NTriplesWriter.write$(s, iter);
    }

    private static void write$(StreamRDF s, Iterator<Triple> iter) {
        s.start();
        StreamRDFOps.sendTriplesToStream(iter, s);
        s.finish();
    }

    public NTriplesWriter() {
        this(CharSpace.UTF8);
    }

    public NTriplesWriter(CharSpace charSpace) {
        this.charSpace = charSpace;
    }

    @Override
    public Lang getLang() {
        return Lang.NTRIPLES;
    }

    @Override
    public void write(Writer out, Graph graph, PrefixMap prefixMap, String baseURI, Context context2) {
        ExtendedIterator iter = graph.find(null, null, null);
        if (this.charSpace == CharSpace.UTF8) {
            NTriplesWriter.write(out, (Iterator<Triple>)iter);
        } else {
            WriterStreamRDFPlain s = new WriterStreamRDFPlain(IO.wrap((Writer)out), CharSpace.ASCII);
            NTriplesWriter.write$(s, (Iterator<Triple>)iter);
        }
    }

    @Override
    public void write(OutputStream out, Graph graph, PrefixMap prefixMap, String baseURI, Context context2) {
        ExtendedIterator iter = graph.find(null, null, null);
        if (this.charSpace == CharSpace.UTF8) {
            NTriplesWriter.write(out, (Iterator<Triple>)iter);
        } else {
            WriterStreamRDFPlain s = new WriterStreamRDFPlain(IO.wrapASCII((OutputStream)out), CharSpace.ASCII);
            NTriplesWriter.write$(s, (Iterator<Triple>)iter);
        }
    }
}

