/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rfc3986;

import org.apache.jena.rfc3986.IRI3986;

public class Builder {
    private String scheme = null;
    private String authority = null;
    private String host = null;
    private int port = -1;
    private String path = "";
    private String query = null;
    private String fragment = null;

    Builder() {
    }

    public String scheme() {
        return this.scheme;
    }

    public Builder scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public String authority() {
        return this.authority;
    }

    public Builder authority(String authority) {
        this.authority = authority;
        this.host = null;
        this.port = -1;
        return this;
    }

    public String host() {
        return this.host;
    }

    public Builder host(String host) {
        this.authority = null;
        this.host = host;
        return this;
    }

    public int port() {
        return this.port;
    }

    public Builder port(int port) {
        if (port < 0) {
            throw new IRIBuildException("port is less than zero");
        }
        this.authority = null;
        this.port = port;
        return this;
    }

    public String path() {
        return this.path;
    }

    public Builder path(String path) {
        this.path = path;
        return this;
    }

    public String query() {
        return this.query;
    }

    public Builder query(String query2) {
        this.query = query2;
        return this;
    }

    public String fragment() {
        return this.fragment;
    }

    public Builder fragment(String fragment) {
        this.fragment = fragment;
        return this;
    }

    public IRI3986 build() {
        Object a = this.authority;
        if (this.host != null) {
            a = this.host;
        }
        if (this.port >= 0) {
            a = this.host == null ? ":" + this.port : this.host + ":" + this.port;
        }
        return IRI3986.build(this.scheme, (String)a, this.path, this.query, this.fragment);
    }

    static class IRIBuildException
    extends RuntimeException {
        public IRIBuildException(String message) {
            super(message);
        }
    }
}

