/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.referencing.operation.matrix.Matrix3;
import org.apache.sis.referencing.operation.transform.CoordinateSystemTransform;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.referencing.operation.transform.SphericalToCartesian;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;

final class CartesianToSpherical
extends CoordinateSystemTransform
implements Serializable {
    private static final long serialVersionUID = 7174557821232512348L;
    static final CartesianToSpherical INSTANCE = new CartesianToSpherical();

    private Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }

    private CartesianToSpherical() {
        super("Cartesian to spherical", null, 3);
        this.context.denormalizeGeographicOutputs(0.0);
    }

    @Override
    public MathTransform inverse() {
        return SphericalToCartesian.INSTANCE;
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) {
        double X2 = srcPts[srcOff];
        double Y = srcPts[srcOff + 1];
        double Z = srcPts[srcOff + 2];
        double \u03c12 = X2 * X2 + Y * Y;
        double r2 = Z * Z + \u03c12;
        double r = Math.sqrt(r2);
        if (dstPts != null) {
            dstPts[dstOff] = Math.atan2(Y, X2);
            dstPts[dstOff + 1] = r == 0.0 ? Z : Math.asin(Z / r);
            dstPts[dstOff + 2] = r;
        }
        if (!derivate) {
            return null;
        }
        double d = r2 * Math.sqrt(r2 - Z * Z);
        return new Matrix3(-Y / \u03c12, X2 / \u03c12, 0.0, -X2 * Z / d, -Y * Z / d, \u03c12 / d, X2 / r, Y / r, Z / r);
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        int srcInc = 0;
        int dstInc = 0;
        if (srcPts == dstPts) {
            switch (IterationStrategy.suggest(srcOff, 3, dstOff, 3, numPts)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    srcOff += 3 * (numPts - 1);
                    dstOff += 3 * (numPts - 1);
                    srcInc = -6;
                    dstInc = -6;
                    break;
                }
                default: {
                    srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * 3);
                    srcOff = 0;
                }
            }
        }
        while (--numPts >= 0) {
            double X2 = srcPts[srcOff++];
            double Y = srcPts[srcOff++];
            double Z = srcPts[srcOff++];
            double r = Math.sqrt(X2 * X2 + Y * Y + Z * Z);
            dstPts[dstOff++] = Math.atan2(Y, X2);
            dstPts[dstOff++] = r == 0.0 ? Z : Math.asin(Z / r);
            dstPts[dstOff++] = r;
            srcOff += srcInc;
            dstOff += dstInc;
        }
    }
}

