/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mod.ui;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.atlas.json.JsonBuilder;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.fuseki.ctl.ActionContainerItem;
import org.apache.jena.fuseki.server.Counter;
import org.apache.jena.fuseki.server.CounterName;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.Endpoint;
import org.apache.jena.fuseki.server.Operation;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;

public class ActionStats
extends ActionContainerItem {
    private static String emptyNameKeyPrefix = "_";

    @Override
    public void validate(HttpAction action) {
    }

    @Override
    protected JsonValue execPostContainer(HttpAction action) {
        return this.execCommonContainer(action);
    }

    @Override
    protected JsonValue execPostItem(HttpAction action) {
        return this.execCommonItem(action);
    }

    @Override
    protected JsonValue execGetContainer(HttpAction action) {
        return this.execCommonContainer(action);
    }

    @Override
    protected JsonValue execGetItem(HttpAction action) {
        return this.execCommonItem(action);
    }

    protected JsonValue execCommonContainer(HttpAction action) {
        if (action.verbose) {
            action.log.info(String.format("[%d] GET stats all", action.id));
        }
        return ActionStats.generateStats(action.getDataAccessPointRegistry());
    }

    public static JsonObject generateStats(DataAccessPointRegistry registry) {
        JsonBuilder builder = new JsonBuilder();
        builder.startObject("top");
        builder.key("datasets");
        builder.startObject("datasets");
        registry.forEach((name, access) -> ActionStats.statsDataset(builder, access));
        builder.finishObject("datasets");
        builder.finishObject("top");
        return builder.build().getAsObject();
    }

    protected JsonValue execCommonItem(HttpAction action) {
        String datasetPath = ActionStats.getItemDatasetName(action);
        if (action.verbose) {
            action.log.info(String.format("[%d] GET stats dataset %s", action.id, datasetPath));
        }
        JsonBuilder builder = new JsonBuilder();
        DataAccessPoint dap = ActionStats.getItemDataAccessPoint(action, datasetPath);
        if (dap == null) {
            ServletOps.errorNotFound(datasetPath);
        }
        builder.startObject("TOP");
        builder.key("datasets");
        builder.startObject("datasets");
        this.statsDataset(builder, datasetPath, action.getDataAccessPointRegistry());
        builder.finishObject("datasets");
        builder.finishObject("TOP");
        return builder.build();
    }

    public static JsonObject generateStats(DataAccessPoint access) {
        JsonBuilder builder = new JsonBuilder();
        ActionStats.statsDataset(builder, access);
        return builder.build().getAsObject();
    }

    private void statsDataset(JsonBuilder builder, String name, DataAccessPointRegistry registry) {
        DataAccessPoint access = registry.get(name);
        ActionStats.statsDataset(builder, access);
    }

    private static void statsDataset(JsonBuilder builder, DataAccessPoint access) {
        builder.key(access.getName());
        DataService dSrv = access.getDataService();
        builder.startObject("counters");
        builder.key(CounterName.Requests.getName()).value(dSrv.getCounters().value(CounterName.Requests));
        builder.key(CounterName.RequestsGood.getName()).value(dSrv.getCounters().value(CounterName.RequestsGood));
        builder.key(CounterName.RequestsBad.getName()).value(dSrv.getCounters().value(CounterName.RequestsBad));
        builder.key("endpoints").startObject("endpoints");
        int unique = 0;
        for (Operation operName : dSrv.getOperations()) {
            List<Endpoint> endpoints = access.getDataService().getEndpoints(operName);
            for (Endpoint endpoint : endpoints) {
                Object k = endpoint.getName();
                if (StringUtils.isEmpty((CharSequence)k)) {
                    k = emptyNameKeyPrefix + ++unique;
                }
                builder.key((String)k);
                builder.startObject();
                ActionStats.operationCounters(builder, endpoint);
                builder.key("operation").value(operName.getJsonName());
                builder.key("description").value(operName.getDescription());
                builder.finishObject();
            }
        }
        builder.finishObject("endpoints");
        builder.finishObject("counters");
    }

    private static void operationCounters(JsonBuilder builder, Endpoint operation) {
        for (CounterName cn : operation.getCounters().counters()) {
            Counter c = operation.getCounters().get(cn);
            builder.key(cn.getName()).value(c.value());
        }
    }
}

