/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.openapi3;

import java.util.Map;
import java.util.Set;
import org.apache.juneau.bean.openapi3.HeaderInfo;
import org.apache.juneau.bean.openapi3.OpenApiElement;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;

public class Encoding
extends OpenApiElement {
    private String contentType;
    private String style;
    private Map<String, HeaderInfo> headers = CollectionUtils.map();
    private Boolean explode;
    private Boolean allowReserved;

    public Encoding() {
    }

    public Encoding(Encoding copyFrom) {
        super(copyFrom);
        this.contentType = copyFrom.contentType;
        this.style = copyFrom.style;
        this.explode = copyFrom.explode;
        this.allowReserved = copyFrom.allowReserved;
        if (Utils.nn(copyFrom.headers)) {
            this.headers.putAll(CollectionUtils.copyOf(copyFrom.headers, HeaderInfo::copy));
        }
    }

    public Encoding addHeader(String key, HeaderInfo value) {
        AssertionUtils.assertArgNotNull("key", key);
        AssertionUtils.assertArgNotNull("value", value);
        this.headers.put(key, value);
        return this;
    }

    public Encoding copy() {
        return new Encoding(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "contentType" -> ConverterUtils.toType(this.getContentType(), type);
            case "style" -> ConverterUtils.toType(this.getStyle(), type);
            case "headers" -> ConverterUtils.toType(this.getHeaders(), type);
            case "explode" -> ConverterUtils.toType(this.getExplode(), type);
            case "allowReserved" -> ConverterUtils.toType(this.getAllowReserved(), type);
            default -> super.get(property, type);
        };
    }

    public Boolean getAllowReserved() {
        return this.allowReserved;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Boolean getExplode() {
        return this.explode;
    }

    public Map<String, HeaderInfo> getHeaders() {
        return Utils.nullIfEmpty(this.headers);
    }

    public String getStyle() {
        return this.style;
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setb(String.class).addIf(Utils.nn(this.allowReserved), "allowReserved").addIf(Utils.nn(this.contentType), "contentType").addIf(Utils.nn(this.explode), "explode").addIf(Utils.ne(this.headers), "headers").addIf(Utils.nn(this.style), "style").build();
        return new MultiSet<String>(s, super.keySet());
    }

    @Override
    public Encoding set(String property, Object value) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "allowReserved" -> this.setAllowReserved(ConverterUtils.toBoolean(value));
            case "contentType" -> this.setContentType(Utils.s(value));
            case "explode" -> this.setExplode(ConverterUtils.toBoolean(value));
            case "headers" -> this.setHeaders(ConverterUtils.toMapBuilder(value, String.class, HeaderInfo.class).sparse().build());
            case "style" -> this.setStyle(Utils.s(value));
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public Encoding setAllowReserved(Boolean value) {
        this.allowReserved = value;
        return this;
    }

    public Encoding setContentType(String value) {
        this.contentType = value;
        return this;
    }

    public Encoding setExplode(Boolean value) {
        this.explode = value;
        return this;
    }

    public Encoding setHeaders(Map<String, HeaderInfo> value) {
        this.headers.clear();
        if (Utils.nn(value)) {
            this.headers.putAll(value);
        }
        return this;
    }

    public Encoding setStyle(String value) {
        this.style = value;
        return this;
    }

    @Override
    public Encoding strict(Object value) {
        super.strict(value);
        return this;
    }

    @Override
    protected Encoding strict() {
        super.strict();
        return this;
    }
}

