/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build;

import aQute.bnd.build.Workspace;
import aQute.bnd.exceptions.Exceptions;
import aQute.bnd.exceptions.FunctionWithException;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.memoize.Memoize;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.resource.MainClassNamespace;
import aQute.bnd.result.Result;
import aQute.bnd.service.Plugin;
import aQute.bnd.service.RegistryPlugin;
import aQute.bnd.service.externalplugin.ExternalPluginNamespace;
import aQute.bnd.service.progress.ProgressPlugin;
import aQute.bnd.service.progress.TaskManager;
import aQute.bnd.version.MavenVersion;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.libg.command.Command;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.osgi.resource.Capability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceExternalPluginHandler
implements AutoCloseable {
    static final Logger logger = LoggerFactory.getLogger((String)"aQute.bnd.build");
    static final Method close = WorkspaceExternalPluginHandler.getMethod(AutoCloseable.class, "close", new Class[0]);
    final Workspace workspace;
    final Map<Capability, Processor.CL> loaders = new HashMap<Capability, Processor.CL>();

    WorkspaceExternalPluginHandler(Workspace workspace) {
        this.workspace = workspace;
    }

    public <T, R> Result<R> call(String pluginName, Class<T> c, FunctionWithException<T, Result<R>> f) {
        return this.call(pluginName, null, c, f);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public <T, R> Result<R> call(String pluginName, VersionRange range, Class<T> c, FunctionWithException<T, Result<R>> f) {
        try {
            String filter = ExternalPluginNamespace.filter(pluginName, c);
            List caps = this.workspace.findProviders("bnd.external.plugin", filter).sorted(this::sort).collect(Collectors.toList());
            if (caps.isEmpty()) {
                return Result.err("no such plugin %s for type %s", pluginName, c.getName());
            }
            Capability cap = (Capability)caps.get(0);
            Result<File> bundle = this.workspace.getBundle(cap.getResource());
            if (bundle.isErr()) {
                return bundle.asError();
            }
            String className = ExternalPluginNamespace.getImplementation(cap);
            if (className == null) {
                return Result.err("no proper class attribute in plugin capability %s is %s", pluginName, cap);
            }
            URL url = bundle.unwrap().toURI().toURL();
            try (URLClassLoader cl = new URLClassLoader(new URL[]{url}, WorkspaceExternalPluginHandler.class.getClassLoader());){
                Class<?> impl = cl.loadClass(className);
                T instance = c.cast(impl.newInstance());
                try {
                    Result<R> result = f.apply(instance);
                    return result;
                }
                catch (Exception e) {
                    Result result2 = Result.err("external plugin '%s' failed with: %s", pluginName, Exceptions.causes(e));
                    cl.close();
                    return result2;
                }
            }
        }
        catch (ClassNotFoundException e2) {
            return Result.err("no such class %s in %s for plugin %s", c.getName(), e2.getMessage(), pluginName);
        }
        catch (Exception e3) {
            return Result.err("could not instantiate class %s in %s for plugin %s: %s", c.getName(), e3.getMessage(), pluginName, Exceptions.causes(e3));
        }
    }

    public Result<Integer> call(String mainClass, VersionRange range, Processor context, Map<String, String> attrs, List<String> args, InputStream stdin, OutputStream stdout, OutputStream stderr) {
        ArrayList<File> cp = new ArrayList<File>();
        try {
            Parameters cpp = new Parameters(attrs.get("classpath"));
            for (Map.Entry<String, Attrs> e : cpp.entrySet()) {
                String v = e.getValue().getVersion();
                MavenVersion mv = MavenVersion.parseMavenString(v);
                Result<File> result = this.workspace.getBundle(e.getKey(), mv.getOSGiVersion(), null);
                if (result.isErr()) {
                    return result.asError();
                }
                cp.add(result.unwrap());
            }
            String filter = MainClassNamespace.filter(mainClass, range);
            List caps = this.workspace.findProviders("bnd.mainclass", filter).sorted(this::sort).collect(Collectors.toList());
            if (caps.isEmpty()) {
                return Result.err("no bundle found with main class %s", mainClass);
            }
            Capability cap = (Capability)caps.get(0);
            Result<File> bundle = this.workspace.getBundle(cap.getResource());
            if (bundle.isErr()) {
                return bundle.asError();
            }
            cp.add(bundle.unwrap());
            Command c = new Command();
            c.setTrace();
            File cwd = context.getBase();
            String workingdir = attrs.get("workingdir");
            if (workingdir != null) {
                cwd = context.getFile(workingdir);
                cwd.mkdirs();
                if (!cwd.isDirectory()) {
                    return Result.err("Working dir set to %s but cannot make it a directory", cwd);
                }
            }
            c.setCwd(cwd);
            c.setTimeout(1L, TimeUnit.MINUTES);
            c.add(context.getProperty("java", IO.getJavaExecutablePath("java")));
            c.add("-cp");
            String classpath = Strings.join(File.pathSeparator, cp);
            c.add(classpath);
            c.add(mainClass);
            for (String arg : args) {
                c.add(arg);
            }
            int exitCode = TaskManager.with(this.getTask(c), () -> {
                PrintWriter lstdout = IO.writer(stdout == null ? System.out : stdout);
                PrintWriter lstderr = IO.writer(stderr == null ? System.err : stderr);
                try {
                    Integer n = c.execute(stdin, (Appendable)lstdout, (Appendable)lstderr);
                    return n;
                }
                finally {
                    lstdout.flush();
                    lstderr.flush();
                }
            });
            return Result.ok(exitCode);
        }
        catch (Exception e) {
            return Result.err("Failed with: %s", Exceptions.causes(e));
        }
    }

    private ProgressPlugin.Task getTask(final Command c) {
        return new ProgressPlugin.Task(){
            private boolean canceled;

            @Override
            public void worked(int units) {
            }

            @Override
            public void done(String message, Throwable e) {
            }

            @Override
            public boolean isCanceled() {
                return this.canceled;
            }

            @Override
            public void abort() {
                this.canceled = true;
                c.cancel();
            }
        };
    }

    @Override
    public void close() {
        this.loaders.values().forEach(IO::close);
    }

    public <T> Result<List<T>> getImplementations(Class<T> interf, Attrs attrs) {
        assert (interf.isInterface());
        try {
            String v = attrs.getVersion();
            VersionRange r = null;
            if (v != null) {
                r = VersionRange.valueOf((String)v);
            }
            String filter = ExternalPluginNamespace.filter(attrs.getOrDefault("name", "*"), interf, r);
            List externalCapabilities = this.workspace.findProviders("bnd.external.plugin", filter).sorted(this::sort).collect(Collectors.toList());
            Class[] interfaces = new Class[]{interf, AutoCloseable.class, Plugin.class, RegistryPlugin.class};
            ProxyClassLoader loader = new ProxyClassLoader(interf.getClassLoader(), interfaces);
            ArrayList<Object> plugins = new ArrayList<Object>();
            for (final Capability c : externalCapabilities) {
                final Memoize<Object> delegate = Memoize.supplier(() -> this.load(c, attrs).unwrap());
                Object proxy = Proxy.newProxyInstance(loader, interfaces, new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        if (method.getDeclaringClass() == Object.class) {
                            return method.invoke((Object)this, args);
                        }
                        if (method.getDeclaringClass() == AutoCloseable.class) {
                            Object object;
                            if (delegate.isPresent() && (object = delegate.get()) instanceof AutoCloseable) {
                                return method.invoke(object, args);
                            }
                            return null;
                        }
                        Object object = delegate.get();
                        if (object == null) {
                            throw new IllegalStateException("Could not load external plugin for capability " + c);
                        }
                        if (method.getDeclaringClass() == Plugin.class && !(object instanceof Plugin)) {
                            return null;
                        }
                        if (method.getDeclaringClass() == RegistryPlugin.class && !(object instanceof RegistryPlugin)) {
                            return null;
                        }
                        return method.invoke(object, args);
                    }

                    public String toString() {
                        return "Proxy plugin: " + c;
                    }
                });
                plugins.add(proxy);
            }
            return Result.ok(plugins);
        }
        catch (Exception e) {
            return Result.err("failed to load external plugins %s (%s): %s", interf, attrs, e);
        }
    }

    private Result<Object> load(Capability cap, Attrs attrs) {
        String implementation = ExternalPluginNamespace.getImplementation(cap);
        if (implementation == null) {
            return Result.err("No implementation class %s", cap);
        }
        try {
            Result<Processor.CL> loader = this.getLoader(cap);
            if (loader.isErr()) {
                return loader.asError();
            }
            Class<?> loadedClass = ((ClassLoader)loader.unwrap()).loadClass(implementation);
            Object plugin = loadedClass.newInstance();
            return Result.ok(plugin);
        }
        catch (Exception e) {
            Workspace.logger.info("failed to load class %s for external plugin load for %s", new Object[]{implementation, cap, e});
            return Result.err("failed to load class %s for external plugin load for %s: %s", implementation, cap, e);
        }
    }

    private synchronized Result<Processor.CL> getLoader(Capability cap) {
        Processor.CL urlClassLoader = this.loaders.get(cap);
        if (urlClassLoader == null) {
            try {
                Result<File> bundle = this.workspace.getBundle(cap.getResource());
                if (bundle.isErr()) {
                    return bundle.asError();
                }
                File file = bundle.unwrap();
                urlClassLoader = new Processor.CL(this.workspace);
                urlClassLoader.add(file);
                this.loaders.put(cap, urlClassLoader);
            }
            catch (Exception e) {
                return Result.err("failed to create class loader for %s: %s", cap, e);
            }
        }
        return Result.ok(urlClassLoader);
    }

    private static Method getMethod(Class<?> class1, String name, Class<?> ... args) {
        try {
            return class1.getMethod(name, args);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw Exceptions.duck(e);
        }
    }

    private int sort(Capability a, Capability b) {
        String av = a.getAttributes().getOrDefault("version", "0.0.0").toString();
        String bv = b.getAttributes().getOrDefault("version", "0.0.0").toString();
        try {
            Version avv = new Version(av);
            Version bvv = new Version(bv);
            return bvv.compareTo(avv);
        }
        catch (Exception e) {
            return bv.compareTo(av);
        }
    }

    static class ProxyClassLoader
    extends ClassLoader {
        private final Class<?>[] classes;
        private final ClassLoader[] loaders;

        public ProxyClassLoader(ClassLoader parent, Class<?>[] classes) {
            super(parent);
            this.classes = Objects.requireNonNull(classes);
            this.loaders = (ClassLoader[])Arrays.stream(classes).map(c -> {
                ClassLoader loader = c.getClassLoader();
                return loader == null ? ProxyClassLoader.getSystemClassLoader() : loader;
            }).distinct().toArray(ClassLoader[]::new);
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            for (Class<?> c : this.classes) {
                if (!name.equals(c.getName())) continue;
                return c;
            }
            for (ClassLoader loader : this.loaders) {
                try {
                    return loader.loadClass(name);
                }
                catch (ClassNotFoundException | NoClassDefFoundError throwable) {
                }
            }
            throw new ClassNotFoundException(name);
        }

        @Override
        public URL findResource(String name) {
            for (ClassLoader loader : this.loaders) {
                URL url = loader.getResource(name);
                if (url == null) continue;
                return url;
            }
            return null;
        }
    }
}

