/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.help.instructions;

import aQute.bnd.help.SyntaxAnnotation;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface ResolutionInstructions {
    @SyntaxAnnotation(lead="Specify the runorder and startlevel behavior of the resolved bundles", example="'-runstartlevel order=leastdependenciesfirst, begin=1, step=1")
    public RunStartLevel runstartlevel(RunStartLevel var1);

    @SyntaxAnnotation(lead="Resolve mode defines when resolving takes place. The default, manual, requires a manual step in bndtools. Auto will resolve on save, and beforelaunch runs the resolver before being launched, batchlaunch is like beforelaunch but only in batch mode", example="'-resolve manual", pattern="(manual|auto|beforelaunch|batch)")
    public ResolveMode resolve();

    public static enum ResolveMode {
        manual,
        auto,
        beforelaunch,
        batch,
        cache;

    }

    public static @interface RunStartLevel {
        @SyntaxAnnotation(lead="Ordering of -runbundles of the resolved bundles", example="'order=leastdependencieslast")
        public Runorder order() default Runorder.MERGESORTBYNAMEVERSION;

        @SyntaxAnnotation(lead="Beginning automatic startlevel calculation,  -1 indicates no automatic calculation. When bdn calculates the startlevel, this will be the first assigned startlevel", example="'begin=10")
        public int begin() default 100;

        @SyntaxAnnotation(lead="Start level step for each next bundle. Startlevel is 0 when < 1", example="'begin=1", pattern="\\d+")
        public int step() default 10;
    }

    public static enum Runorder {
        LEASTDEPENDENCIESFIRST,
        LEASTDEPENDENCIESLAST,
        RANDOM,
        SORTBYNAMEVERSION,
        MERGESORTBYNAMEVERSION;

    }
}

