/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.zip;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.TimeZone;
import java.util.zip.ZipEntry;

public class ZipUtil {
    private static final TimeZone tz = TimeZone.getDefault();
    public static final int EXTID_BND = 48618;

    public static long getModifiedTime(ZipEntry entry) {
        long time = entry.getTime();
        time += (long)tz.getOffset(time);
        return Math.min(time, System.currentTimeMillis() - 1L);
    }

    public static void setModifiedTime(ZipEntry entry, long utc) {
        utc -= (long)tz.getOffset(utc);
        entry.setTime(utc);
    }

    public static String cleanPath(String path) {
        StringBuilder out = new StringBuilder();
        int length = Objects.requireNonNull(path).length();
        State state = State.begin;
        int level = 0;
        block20: for (int i = length - 1; i >= 0; --i) {
            char c = path.charAt(i);
            switch (state) {
                case begin: {
                    switch (c) {
                        case '/': {
                            if (i != length - 1) continue block20;
                            out.append('/');
                            continue block20;
                        }
                        case '.': {
                            state = State.one;
                            continue block20;
                        }
                    }
                    state = State.segment;
                    if (level < 0) continue block20;
                    out.append(c);
                    continue block20;
                }
                case one: {
                    switch (c) {
                        case '/': {
                            state = State.begin;
                            continue block20;
                        }
                        case '.': {
                            state = State.two;
                            continue block20;
                        }
                    }
                    state = State.segment;
                    if (level < 0) continue block20;
                    out.append('.').append(c);
                    continue block20;
                }
                case two: {
                    switch (c) {
                        case '/': {
                            state = State.begin;
                            --level;
                            continue block20;
                        }
                    }
                    state = State.segment;
                    if (level < 0) continue block20;
                    out.append('.').append('.').append(c);
                    continue block20;
                }
                case segment: {
                    switch (c) {
                        case '/': {
                            state = State.begin;
                            if (level >= 0) break;
                            ++level;
                            continue block20;
                        }
                    }
                    if (level < 0) continue block20;
                    out.append(c);
                }
            }
        }
        int last = out.length() - 1;
        if (last > 0 && out.charAt(last) == '/') {
            out.setLength(last);
        }
        if (out.length() == length) {
            return path;
        }
        if (state == State.one && level == -1 || state == State.two || level < -1) {
            throw new UncheckedIOException(new IOException("Entry path is outside of zip file: " + path));
        }
        return out.reverse().toString();
    }

    public static boolean isCompromised(String path) {
        try {
            ZipUtil.cleanPath(path);
            return false;
        }
        catch (UncheckedIOException e) {
            return true;
        }
    }

    public static byte[] extraFieldFromString(byte[] extra, String value) {
        byte[] utf8 = value.getBytes(StandardCharsets.UTF_8);
        int length = 4 + utf8.length;
        if (extra == null) {
            if (length > 65535) {
                throw new IllegalArgumentException("extra data too long");
            }
            return ByteBuffer.allocate(length).order(ByteOrder.LITTLE_ENDIAN).putShort((short)-16918).putShort((short)utf8.length).put(utf8).array();
        }
        ByteBuffer original = ByteBuffer.wrap(extra).order(ByteOrder.LITTLE_ENDIAN);
        int limit = original.limit();
        length += limit;
        int extPosition = 0;
        int extSize = 0;
        while (original.remaining() > 4) {
            int id = Short.toUnsignedInt(original.getShort());
            int size = Short.toUnsignedInt(original.getShort());
            if (size < 0 || size > original.remaining()) break;
            if (id == 48618) {
                extPosition = original.position() - 4;
                extSize = 4 + size;
                length -= extSize;
                break;
            }
            original.position(original.position() + size);
        }
        if (length > 65535) {
            throw new IllegalArgumentException("extra data too long");
        }
        ByteBuffer bb = ByteBuffer.allocate(length).order(ByteOrder.LITTLE_ENDIAN).putShort((short)-16918).putShort((short)utf8.length).put(utf8);
        original.rewind();
        if (extSize > 0) {
            original.limit(extPosition);
            bb.put(original);
            original.limit(limit).position(extPosition + extSize);
        }
        return bb.put(original).array();
    }

    public static String stringFromExtraField(byte[] extra) {
        int length = extra.length;
        if (length > 65535) {
            throw new IllegalArgumentException("extra data too long");
        }
        ByteBuffer original = ByteBuffer.wrap(extra).order(ByteOrder.LITTLE_ENDIAN);
        while (original.remaining() > 4) {
            int id = Short.toUnsignedInt(original.getShort());
            int size = Short.toUnsignedInt(original.getShort());
            if (size < 0 || size > original.remaining()) {
                original.position(original.position() - 4);
                break;
            }
            if (id == 48618) {
                original.limit(original.position() + size);
                break;
            }
            original.position(original.position() + size);
        }
        if (original.hasRemaining()) {
            return StandardCharsets.UTF_8.decode(original).toString();
        }
        return null;
    }

    static enum State {
        begin,
        one,
        two,
        segment;

    }
}

