/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.make.component;

import aQute.bnd.annotation.component.Activate;
import aQute.bnd.annotation.component.Component;
import aQute.bnd.annotation.component.Deactivate;
import aQute.bnd.annotation.component.Modified;
import aQute.bnd.annotation.component.Reference;
import aQute.bnd.osgi.Annotation;
import aQute.bnd.osgi.ClassDataCollector;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Verifier;
import aQute.service.reporter.Reporter;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentAnnotationReader
extends ClassDataCollector {
    String[] EMPTY = new String[0];
    private static final String V1_1 = "1.1.0";
    static Pattern BINDDESCRIPTOR = Pattern.compile("\\(L([^;]*);(Ljava/util/Map;|Lorg/osgi/framework/ServiceReference;)*\\)V");
    static Pattern BINDMETHOD = Pattern.compile("(set|bind|add)(.)(.*)");
    static Pattern ACTIVATEDESCRIPTOR = Pattern.compile("\\(((Lorg/osgi/service/component/ComponentContext;)|(Lorg/osgi/framework/BundleContext;)|(Ljava/util/Map;))*\\)V");
    static Pattern OLDACTIVATEDESCRIPTOR = Pattern.compile("\\(Lorg/osgi/service/component/ComponentContext;\\)V");
    static Pattern OLDBINDDESCRIPTOR = Pattern.compile("\\(L([^;]*);\\)V");
    static Pattern REFERENCEBINDDESCRIPTOR = Pattern.compile("\\(Lorg/osgi/framework/ServiceReference;\\)V");
    static String[] ACTIVATE_ARGUMENTS = new String[]{"org.osgi.service.component.ComponentContext", "org.osgi.framework.BundleContext", Map.class.getName(), "org.osgi.framework.BundleContext"};
    static String[] OLD_ACTIVATE_ARGUMENTS = new String[]{"org.osgi.service.component.ComponentContext"};
    Reporter reporter = new Processor();
    Clazz.MethodDef method;
    Descriptors.TypeRef className;
    Clazz clazz;
    Descriptors.TypeRef[] interfaces;
    Set<String> multiple = new HashSet<String>();
    Set<String> optional = new HashSet<String>();
    Set<String> dynamic = new HashSet<String>();
    Map<String, String> map = new TreeMap<String, String>();
    Set<String> descriptors = new HashSet<String>();
    List<String> properties = new ArrayList<String>();
    String version = null;
    static Pattern PROPERTY_PATTERN = Pattern.compile("\\s*([^=\\s]+)\\s*=(.+)");

    ComponentAnnotationReader(Clazz clazz) {
        this.clazz = clazz;
    }

    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    public static Map<String, String> getDefinition(Clazz c) throws Exception {
        return ComponentAnnotationReader.getDefinition(c, new Processor());
    }

    public static Map<String, String> getDefinition(Clazz c, Reporter reporter) throws Exception {
        ComponentAnnotationReader r = new ComponentAnnotationReader(c);
        r.setReporter(reporter);
        c.parseClassFileWithCollector(r);
        r.finish();
        return r.map;
    }

    @Override
    public void annotation(Annotation annotation) {
        String fqn = annotation.getName().getFQN();
        if (fqn.equals(Component.class.getName())) {
            String[] p;
            String configs;
            this.set("name:", annotation.get("name"), "<>");
            this.set("factory:", annotation.get("factory"), false);
            this.setBoolean("enabled:", annotation.get("enabled"), true);
            this.setBoolean("immediate:", annotation.get("immediate"), false);
            this.setBoolean("servicefactory:", annotation.get("servicefactory"), false);
            if (annotation.get("designate") != null && (configs = (String)annotation.get("designate")) != null) {
                this.set("designate:", Clazz.objectDescriptorToFQN(configs), "");
            }
            if (annotation.get("designateFactory") != null && (configs = (String)annotation.get("designateFactory")) != null) {
                this.set("designateFactory:", Clazz.objectDescriptorToFQN(configs), "");
            }
            this.setVersion((String)annotation.get("version"));
            String configurationPolicy = (String)annotation.get("configurationPolicy");
            if (configurationPolicy != null) {
                this.set("configuration-policy:", configurationPolicy.toLowerCase(), "");
            }
            this.doProperties(annotation);
            Object[] provides = (Object[])annotation.get("provide");
            if (provides == null) {
                if (this.interfaces != null) {
                    ArrayList<String> result = new ArrayList<String>();
                    for (int i = 0; i < this.interfaces.length; ++i) {
                        if (this.interfaces[i].getBinary().equals("scala/ScalaObject")) continue;
                        result.add(this.interfaces[i].getFQN());
                    }
                    p = result.toArray(this.EMPTY);
                } else {
                    p = this.EMPTY;
                }
            } else {
                p = new String[provides.length];
                for (int i = 0; i < provides.length; ++i) {
                    p[i] = this.descriptorToFQN(provides[i].toString());
                }
            }
            if (p.length > 0) {
                this.set("provide:", Processor.join(Arrays.asList(p)), "<>");
            }
        } else if (fqn.equals(Activate.class.getName())) {
            if (!this.checkMethod()) {
                this.setVersion(V1_1);
            }
            if (!ACTIVATEDESCRIPTOR.matcher(this.method.getDescriptor().toString()).matches()) {
                this.reporter.error("Activate method for %s does not have an acceptable prototype, only Map, ComponentContext, or BundleContext is allowed. Found: %s", this.className, this.method.getDescriptor());
            }
            if (!this.method.getName().equals("activate") || !OLDACTIVATEDESCRIPTOR.matcher(this.method.getDescriptor().toString()).matches()) {
                this.setVersion(V1_1);
                this.set("activate:", this.method, "<>");
            }
        } else if (fqn.equals(Deactivate.class.getName())) {
            if (!this.checkMethod()) {
                this.setVersion(V1_1);
            }
            if (!ACTIVATEDESCRIPTOR.matcher(this.method.getDescriptor().toString()).matches()) {
                this.reporter.error("Deactivate method for %s does not have an acceptable prototype, only Map, ComponentContext, or BundleContext is allowed. Found: %s", this.className, this.method.getDescriptor());
            }
            if (!this.method.getName().equals("deactivate") || !OLDACTIVATEDESCRIPTOR.matcher(this.method.getDescriptor().toString()).matches()) {
                this.setVersion(V1_1);
                this.set("deactivate:", this.method, "<>");
            }
        } else if (fqn.equals(Modified.class.getName())) {
            this.set("modified:", this.method, "<>");
            this.setVersion(V1_1);
        } else if (fqn.equals(Reference.class.getName())) {
            Integer c;
            String service;
            String name = (String)annotation.get(Reference.class.getName());
            String bind = this.method.getName();
            String unbind = null;
            if (name == null) {
                Matcher m = BINDMETHOD.matcher(this.method.getName());
                name = m.matches() ? m.group(2).toLowerCase() + m.group(3) : this.method.getName().toLowerCase();
            }
            String simpleName = name;
            unbind = (String)annotation.get("unbind");
            if (bind != null) {
                name = name + "/" + bind;
                if (unbind != null) {
                    name = name + "/" + unbind;
                }
            }
            if ((service = (String)annotation.get("service")) != null) {
                service = Clazz.objectDescriptorToFQN(service);
            } else {
                Matcher m = BINDDESCRIPTOR.matcher(this.method.getDescriptor().toString());
                if (m.matches()) {
                    service = Descriptors.binaryToFQN(m.group(1));
                } else {
                    throw new IllegalArgumentException("Cannot detect the type of a Component Reference from the descriptor: " + this.method.getDescriptor());
                }
            }
            String target = (String)annotation.get("target");
            if (target != null) {
                Verifier.verifyFilter(target, 0);
                service = service + target;
            }
            if ((c = (Integer)annotation.get("type")) != null && !((Object)c).equals(0) && !((Object)c).equals(49)) {
                service = service + (char)c.intValue();
            }
            if (this.map.containsKey(name)) {
                this.reporter.error("In component %s, Multiple references with the same name: %s. Previous def: %s, this def: %s", name, this.map.get(name), service, "");
            }
            this.map.put(name, service);
            if (this.isTrue(annotation.get("multiple"))) {
                this.multiple.add(simpleName);
            }
            if (this.isTrue(annotation.get("optional"))) {
                this.optional.add(simpleName);
            }
            if (this.isTrue(annotation.get("dynamic"))) {
                this.dynamic.add(simpleName);
            }
            if (!this.checkMethod()) {
                this.setVersion(V1_1);
            } else if (REFERENCEBINDDESCRIPTOR.matcher(this.method.getDescriptor().toString()).matches() || !OLDBINDDESCRIPTOR.matcher(this.method.getDescriptor().toString()).matches()) {
                this.setVersion(V1_1);
            }
        }
    }

    private void setVersion(String v) {
        if (v == null) {
            return;
        }
        if (this.version == null) {
            this.version = v;
        } else if (v.compareTo(this.version) > 0) {
            this.version = v;
        }
    }

    private boolean checkMethod() {
        return Modifier.isPublic(this.method.getAccess()) || Modifier.isProtected(this.method.getAccess());
    }

    private void doProperties(Annotation annotation) {
        Object[] properties = (Object[])annotation.get("properties");
        if (properties != null) {
            for (Object o : properties) {
                String p = (String)o;
                Matcher m = PROPERTY_PATTERN.matcher(p);
                if (!m.matches()) {
                    throw new IllegalArgumentException("Malformed property '" + p + "' on: " + annotation.get("name"));
                }
                this.properties.add(m.group(1) + "=" + m.group(2));
            }
        }
    }

    private boolean isTrue(Object object) {
        if (object == null) {
            return false;
        }
        return (Boolean)object;
    }

    private void setBoolean(String string, Object object, boolean b) {
        Boolean bb;
        if (object == null) {
            object = b;
        }
        if ((bb = (Boolean)object) == b) {
            return;
        }
        this.map.put(string, ((Object)bb).toString());
    }

    private void set(String string, Object object, Object deflt) {
        if (object == null || object.equals(deflt)) {
            return;
        }
        this.map.put(string, object.toString());
    }

    private String descriptorToFQN(String string) {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < string.length() - 1; ++i) {
            char c = string.charAt(i);
            if (c == '/') {
                c = '.';
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public void classBegin(int access, Descriptors.TypeRef name) {
        this.className = name;
    }

    @Override
    public void implementsInterfaces(Descriptors.TypeRef[] interfaces) {
        this.interfaces = interfaces;
    }

    @Override
    public void method(Clazz.MethodDef method) {
        this.method = method;
        this.descriptors.add(method.getName());
    }

    void set(String name, Collection<String> l) {
        if (l.size() == 0) {
            return;
        }
        this.set(name, Processor.join(l), "<>");
    }

    public void finish() {
        this.set("multiple:", this.multiple);
        this.set("dynamic:", this.dynamic);
        this.set("optional:", this.optional);
        this.set("implementation:", this.clazz.getFQN(), "<>");
        this.set("properties:", this.properties);
        if (this.version != null) {
            this.set("version:", this.version, "<>");
            this.reporter.trace("Component %s is v1.1", this.map);
        }
        this.set(".descriptors:", this.descriptors);
    }
}

