/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build;

import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import aQute.lib.io.IO;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ProjectTracker
implements AutoCloseable {
    private final Workspace workspace;
    private final Map<CollationKey, Project> projects;
    private boolean changed = true;
    private final Collator fileCollator = IO.fileCollator();

    ProjectTracker(Workspace workspace) {
        this.workspace = workspace;
        this.projects = new TreeMap<CollationKey, Project>();
    }

    @Override
    public synchronized void close() {
        this.projects.values().forEach(IO::close);
    }

    synchronized void refresh() {
        this.changed = true;
    }

    synchronized List<Project> getAllProjects() {
        this.update();
        return new ArrayList<Project>(this.projects.values());
    }

    synchronized Optional<Project> getProject(String name) {
        this.update();
        CollationKey key = this.fileCollator.getCollationKey(name);
        if (!this.projects.containsKey(key) && this.workspace.getFile(name + "/" + "bnd.bnd").isFile()) {
            this.changed = true;
            this.update();
        }
        return Optional.ofNullable(this.projects.get(key));
    }

    private List<CollationKey> list(Path dir) {
        if (dir != null && Files.isDirectory(dir, new LinkOption[0])) {
            List<CollationKey> list;
            block9: {
                Stream<Path> stream = Files.list(dir);
                try {
                    List<CollationKey> result;
                    list = result = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(path -> this.fileCollator.getCollationKey(path.getFileName().toString())).sorted().collect(Collectors.toList());
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                stream.close();
            }
            return list;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        if (!this.changed) {
            return;
        }
        this.changed = false;
        boolean notify = false;
        try {
            Path base = this.workspace.getBase().toPath();
            ArrayList<CollationKey> older = new ArrayList<CollationKey>(this.projects.keySet());
            for (CollationKey key : this.list(base)) {
                String name = key.getSourceString();
                Path directory = base.resolve(name);
                Project project = this.projects.get(key);
                if (project != null) {
                    older.remove(key);
                    if (directory.equals(project.getBase().toPath()) && project.isValid()) continue;
                    IO.close(project);
                }
                if (Files.isRegularFile(directory.resolve(Project.BNDPATH), new LinkOption[0])) {
                    project = new Project(this.workspace, directory.toFile());
                    if (project.isValid()) {
                        this.projects.put(key, project);
                        notify = true;
                        continue;
                    }
                    IO.close(project);
                }
                this.projects.remove(key);
                notify = true;
            }
            older.stream().map(this.projects::remove).forEach(IO::close);
        }
        finally {
            if (notify) {
                this.workspace.notifier.projects(new ArrayList<Project>(this.projects.values()));
            }
        }
    }

    public String toString() {
        return this.projects.keySet().stream().map(CollationKey::getSourceString).collect(Collectors.joining(",", "[", "]"));
    }

    synchronized void forceRefresh() {
        this.changed = true;
        this.update();
    }
}

