/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.sse;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.servlet.AsyncContext;
import org.apache.http.HttpEntity;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.knox.gateway.sse.SSEvent;

public class SSEEntity
extends AbstractHttpEntity {
    private final BlockingQueue<SSEvent> eventQueue;
    private final StringBuilder eventBuilder = new StringBuilder();
    private final HttpEntity httpEntity;
    private char previousChar = (char)48;

    public SSEEntity(HttpEntity httpEntity) {
        this.httpEntity = httpEntity;
        this.eventQueue = new LinkedBlockingQueue<SSEvent>();
    }

    public boolean readCharBuffer(CharBuffer charBuffer) {
        while (charBuffer.hasRemaining()) {
            this.processChar(charBuffer.get());
        }
        return !this.eventQueue.isEmpty();
    }

    private void processChar(char nextChar) {
        if (this.isNewLineChar(nextChar) && this.isNewLineChar(this.previousChar)) {
            this.processEvent();
            this.eventBuilder.setLength(0);
            this.previousChar = (char)48;
        } else {
            this.eventBuilder.append(nextChar);
            this.previousChar = nextChar;
        }
    }

    private boolean isNewLineChar(char c) {
        return c == '\n' || c == '\r' || c == '\u0085' || c == '\u2028' || c == '\u2029';
    }

    private void processEvent() {
        String unprocessedEvent = this.eventBuilder.toString();
        SSEvent ssEvent = SSEvent.fromString(unprocessedEvent);
        this.eventQueue.add(ssEvent);
    }

    public void sendEvent(AsyncContext asyncContext) throws IOException, InterruptedException {
        while (!this.eventQueue.isEmpty()) {
            SSEvent event = this.eventQueue.take();
            asyncContext.getResponse().getWriter().write(event.toString());
            asyncContext.getResponse().getWriter().println('\n');
            asyncContext.getResponse().flushBuffer();
        }
    }

    public BlockingQueue<SSEvent> getEventQueue() {
        return this.eventQueue;
    }

    public boolean isRepeatable() {
        return this.httpEntity.isRepeatable();
    }

    public long getContentLength() {
        return this.httpEntity.getContentLength();
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        return this.httpEntity.getContent();
    }

    public void writeTo(OutputStream outStream) throws IOException {
        this.httpEntity.writeTo(outStream);
    }

    public boolean isStreaming() {
        return this.httpEntity.isStreaming();
    }
}

