/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter.rewrite.impl;

import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.knox.gateway.filter.rewrite.api.FrontendFunctionDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteEnvironment;
import org.apache.knox.gateway.filter.rewrite.i18n.UrlRewriteResources;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteContext;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteFunctionProcessor;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteResolver;
import org.apache.knox.gateway.i18n.resources.ResourcesFactory;

public class FrontendFunctionProcessor
implements UrlRewriteFunctionProcessor<FrontendFunctionDescriptor> {
    private static UrlRewriteResources RES = (UrlRewriteResources)ResourcesFactory.get(UrlRewriteResources.class);
    private Map<String, UrlRewriteResolver> resolvers;

    @Override
    public String name() {
        return "frontend";
    }

    @Override
    public void initialize(UrlRewriteEnvironment environment, FrontendFunctionDescriptor descriptor) throws Exception {
        if (environment == null) {
            throw new IllegalArgumentException("environment==null");
        }
        URI frontend = (URI)environment.getAttribute("org.apache.knox.gateway.frontend.uri");
        this.resolvers = new HashMap<String, UrlRewriteResolver>();
        if (frontend == null) {
            this.resolvers.put("url", new ParamResolver("gateway.url"));
            this.resolvers.put("addr", new ParamResolver("gateway.addr"));
            this.resolvers.put("scheme", new ParamResolver("gateway.scheme"));
            this.resolvers.put("host", new ParamResolver("gateway.host"));
            this.resolvers.put("port", new ParamResolver("gateway.port"));
            this.resolvers.put("path", new ParamResolver("gateway.path"));
        } else {
            this.resolvers.put("url", new FixedResolver(frontend.toString()));
            this.resolvers.put("addr", new FixedResolver(frontend.getHost() + ":" + frontend.getPort()));
            this.resolvers.put("scheme", new FixedResolver(frontend.getScheme()));
            this.resolvers.put("host", new FixedResolver(frontend.getHost()));
            this.resolvers.put("port", new FixedResolver(Integer.toString(frontend.getPort())));
            this.resolvers.put("path", new FixedResolver(frontend.getPath()));
        }
        this.resolvers.put("topology", new FixedResolver((String)environment.getAttribute("org.apache.knox.gateway.gateway.cluster")));
        this.resolvers.put("gateway.name", new FixedResolver((String)environment.getAttribute("org.apache.knox.gateway.gateway.name")));
        this.resolvers.put("address", this.resolvers.get("addr"));
    }

    @Override
    public void destroy() throws Exception {
        this.resolvers.clear();
    }

    @Override
    public List<String> resolve(UrlRewriteContext context, List<String> parameters) throws Exception {
        UrlRewriteResolver resolver;
        String first;
        String parameter = "url";
        if (parameters != null && !parameters.isEmpty() && (first = parameters.get(0)) != null) {
            parameter = first;
        }
        if ((resolver = this.resolvers.get(parameter = parameter.trim().toLowerCase(Locale.ROOT))) == null) {
            throw new IllegalArgumentException(RES.invalidFrontendFunctionParameter(parameter));
        }
        return resolver.resolve(context, parameters);
    }

    private static class FixedResolver
    implements UrlRewriteResolver {
        private List<String> fixedValues;

        FixedResolver(String ... fixedValues) {
            this.fixedValues = Arrays.asList(fixedValues);
        }

        @Override
        public List<String> resolve(UrlRewriteContext context, List<String> parameter) throws Exception {
            return this.fixedValues;
        }
    }

    private static class ParamResolver
    implements UrlRewriteResolver {
        private String paramName;

        ParamResolver(String paramName) {
            this.paramName = paramName;
        }

        @Override
        public List<String> resolve(UrlRewriteContext context, List<String> parameter) throws Exception {
            return context.getParameters().resolve(this.paramName);
        }
    }
}

