/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Driver;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.KyuubiCommands;
import org.apache.hive.beeline.common.util.HiveStringUtils;
import org.apache.kyuubi.util.reflect.DynConstructors;
import org.apache.kyuubi.util.reflect.DynFields;
import org.apache.kyuubi.util.reflect.DynMethods;

public class KyuubiBeeLine
extends BeeLine {
    public static final String KYUUBI_BEELINE_DEFAULT_JDBC_DRIVER = "org.apache.kyuubi.jdbc.KyuubiHiveDriver";
    private Driver defaultDriver;
    private static final int ERRNO_OK = 0;
    private static final int ERRNO_ARGS = 1;
    private static final int ERRNO_OTHER = 2;
    private static final String PYTHON_MODE_PREFIX = "--python-mode";
    private boolean pythonMode = false;

    public KyuubiBeeLine() {
        this(true);
    }

    public KyuubiBeeLine(boolean isBeeLine) {
        super(isBeeLine);
        this.setCommands(new KyuubiCommands(this));
        try {
            this.defaultDriver = (Driver)DynConstructors.builder().impl(KYUUBI_BEELINE_DEFAULT_JDBC_DRIVER, new Class[0]).buildChecked().newInstance(new Object[0]);
        }
        catch (Throwable t) {
            throw new ExceptionInInitializerError("org.apache.kyuubi.jdbc.KyuubiHiveDriver-missing");
        }
    }

    public boolean isPythonMode() {
        return this.pythonMode;
    }

    public void setPythonMode(boolean pythonMode) {
        this.pythonMode = pythonMode;
    }

    public static void main(String[] args) throws IOException {
        KyuubiBeeLine.mainWithInputRedirection(args, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mainWithInputRedirection(String[] args, InputStream inputStream) throws IOException {
        try (KyuubiBeeLine beeLine = new KyuubiBeeLine();){
            int status = beeLine.begin(args, inputStream);
            if (!Boolean.getBoolean("beeline.system.exit")) {
                System.exit(status);
            }
        }
    }

    protected Driver getDefaultDriver() {
        return this.defaultDriver;
    }

    @Override
    String getApplicationTitle() {
        Package pack = BeeLine.class.getPackage();
        return this.loc("app-introduction", new Object[]{"Beeline", pack.getImplementationVersion() == null ? "???" : pack.getImplementationVersion(), "Apache Kyuubi"});
    }

    @Override
    int initArgs(String[] args) {
        boolean exit;
        DynFields.BoundField exitField;
        boolean connSuccessful;
        CommandLine cl;
        List<Object> commands = Collections.emptyList();
        try {
            Options options = (Options)DynFields.builder().hiddenImpl(BeeLine.class, "options").buildStaticChecked().get();
            BeeLine.BeelineParser beelineParser = new BeeLine.BeelineParser(){

                @Override
                protected void processOption(String arg, ListIterator iter) throws ParseException {
                    if (KyuubiBeeLine.PYTHON_MODE_PREFIX.equals(arg)) {
                        KyuubiBeeLine.this.pythonMode = true;
                    } else {
                        super.processOption(arg, iter);
                    }
                }
            };
            cl = beelineParser.parse(options, args);
            connSuccessful = (Boolean)DynMethods.builder((String)"connectUsingArgs").hiddenImpl(BeeLine.class, new Class[]{BeeLine.BeelineParser.class, CommandLine.class}).buildChecked((Object)this).invoke(new Object[]{beelineParser, cl});
            exitField = DynFields.builder().hiddenImpl(BeeLine.class, "exit").buildChecked((Object)this);
            exit = (Boolean)exitField.get();
        }
        catch (ParseException e1) {
            this.output(e1.getMessage());
            this.usage();
            return -1;
        }
        catch (Exception t) {
            this.error(t.getMessage());
            return 1;
        }
        if (!connSuccessful && !exit) {
            try {
                connSuccessful = (Boolean)DynMethods.builder((String)"defaultBeelineConnect").hiddenImpl(BeeLine.class, new Class[]{CommandLine.class}).buildChecked((Object)this).invoke(new Object[]{cl});
            }
            catch (Exception t) {
                this.error(t.getMessage());
                return 1;
            }
        }
        if (exit) {
            return 1;
        }
        int code = 0;
        if (cl.getOptionValues('e') != null) {
            commands = Arrays.asList(cl.getOptionValues('e'));
            this.getOpts().setAllowMultiLineCommand(false);
        }
        if (!commands.isEmpty() && this.getOpts().getScriptFile() != null) {
            this.error("The '-e' and '-f' options cannot be specified simultaneously");
            return 1;
        }
        if (!commands.isEmpty() && !connSuccessful) {
            this.error("Cannot run commands specified using -e. No current connection");
            return 1;
        }
        if (!commands.isEmpty()) {
            for (String string : commands) {
                this.debug(this.loc("executing-command", string));
                if (this.dispatch(string)) continue;
                ++code;
            }
            try {
                exit = true;
                exitField.set((Object)exit);
            }
            catch (Exception e) {
                this.error(e.getMessage());
                return 1;
            }
        }
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int runInit() {
        String[] initFiles = this.getOpts().getInitFiles();
        int executionResult = 0;
        boolean exitOnError = !this.getOpts().getForce();
        DynFields.BoundField exitField = null;
        if (initFiles != null && initFiles.length != 0) {
            for (String initFile : initFiles) {
                block12: {
                    boolean exit;
                    int t2;
                    this.info("Running init script " + initFile);
                    try {
                        int currentResult;
                        try {
                            currentResult = (Integer)DynMethods.builder((String)"executeFile").hiddenImpl(BeeLine.class, new Class[]{String.class}).buildChecked((Object)this).invoke(new Object[]{initFile});
                            exitField = DynFields.builder().hiddenImpl(BeeLine.class, "exit").buildChecked((Object)this);
                        }
                        catch (Exception t2) {
                            this.error(t2.getMessage());
                            currentResult = 2;
                        }
                        if (currentResult == 0) break block12;
                        executionResult = currentResult;
                        if (!exitOnError) break block12;
                        t2 = executionResult;
                        exit = exitOnError && executionResult != 0;
                    }
                    catch (Throwable throwable) {
                        boolean exit2 = exitOnError && executionResult != 0;
                        try {
                            exitField.set((Object)exit2);
                        }
                        catch (Exception t3) {
                            this.error(t3.getMessage());
                            return 2;
                        }
                        throw throwable;
                    }
                    try {
                        exitField.set((Object)exit);
                    }
                    catch (Exception t4) {
                        this.error(t4.getMessage());
                        return 2;
                    }
                    return t2;
                }
                boolean exit = exitOnError && executionResult != 0;
                try {
                    exitField.set((Object)exit);
                }
                catch (Exception t) {
                    this.error(t.getMessage());
                    return 2;
                }
            }
        }
        return executionResult;
    }

    @Override
    boolean dispatch(String line) {
        return super.dispatch(this.isPythonMode() ? line : HiveStringUtils.removeComments(line));
    }

    @Override
    KyuubiCommands getCommands() {
        return (KyuubiCommands)super.getCommands();
    }

    static {
        try {
            Class<?> bridgeClass = Class.forName("org.slf4j.bridge.SLF4JBridgeHandler");
            bridgeClass.getMethod("removeHandlersForRootLogger", new Class[0]).invoke(null, new Object[0]);
            boolean installed = (Boolean)bridgeClass.getMethod("isInstalled", new Class[0]).invoke(null, new Object[0]);
            if (!installed) {
                bridgeClass.getMethod("install", new Class[0]).invoke(null, new Object[0]);
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }
}

