/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.net.bytebuddy.implementation.bytecode.assign.primitive;

import java.util.Arrays;
import org.apache.kyuubi.shade.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.apache.kyuubi.shade.net.bytebuddy.description.type.TypeDefinition;
import org.apache.kyuubi.shade.net.bytebuddy.implementation.Implementation;
import org.apache.kyuubi.shade.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.apache.kyuubi.shade.net.bytebuddy.implementation.bytecode.StackSize;
import org.apache.kyuubi.shade.net.bytebuddy.jar.asm.MethodVisitor;
import org.apache.kyuubi.shade.net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PrimitiveNarrowingDelegate {
    BOOLEAN(StackManipulation.Trivial.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE),
    BYTE(StackManipulation.Illegal.INSTANCE, StackManipulation.Trivial.INSTANCE, StackManipulation.Illegal.INSTANCE, new NarrowingStackManipulation(new int[]{146}, StackSize.ZERO.toDecreasingSize()), StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE),
    SHORT(StackManipulation.Illegal.INSTANCE, new NarrowingStackManipulation(new int[]{145}, StackSize.ZERO.toDecreasingSize()), StackManipulation.Trivial.INSTANCE, new NarrowingStackManipulation(new int[]{146}, StackSize.ZERO.toDecreasingSize()), StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE),
    CHARACTER(StackManipulation.Illegal.INSTANCE, new NarrowingStackManipulation(new int[]{145}, StackSize.ZERO.toDecreasingSize()), new NarrowingStackManipulation(new int[]{147}, StackSize.ZERO.toDecreasingSize()), StackManipulation.Trivial.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE),
    INTEGER(StackManipulation.Illegal.INSTANCE, new NarrowingStackManipulation(new int[]{145}, StackSize.ZERO.toDecreasingSize()), new NarrowingStackManipulation(new int[]{147}, StackSize.ZERO.toDecreasingSize()), new NarrowingStackManipulation(new int[]{146}, StackSize.ZERO.toDecreasingSize()), StackManipulation.Trivial.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE),
    LONG(StackManipulation.Illegal.INSTANCE, new NarrowingStackManipulation(new int[]{136, 145}, StackSize.SINGLE.toDecreasingSize()), new NarrowingStackManipulation(new int[]{136, 147}, StackSize.SINGLE.toDecreasingSize()), new NarrowingStackManipulation(new int[]{136, 146}, StackSize.SINGLE.toDecreasingSize()), new NarrowingStackManipulation(new int[]{136}, StackSize.SINGLE.toDecreasingSize()), StackManipulation.Trivial.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE),
    FLOAT(StackManipulation.Illegal.INSTANCE, new NarrowingStackManipulation(new int[]{139, 145}, StackSize.ZERO.toDecreasingSize()), new NarrowingStackManipulation(new int[]{139, 147}, StackSize.ZERO.toDecreasingSize()), new NarrowingStackManipulation(new int[]{139, 146}, StackSize.ZERO.toDecreasingSize()), new NarrowingStackManipulation(new int[]{139}, StackSize.ZERO.toDecreasingSize()), new NarrowingStackManipulation(new int[]{140}, StackSize.SINGLE.toIncreasingSize()), StackManipulation.Trivial.INSTANCE, StackManipulation.Illegal.INSTANCE),
    DOUBLE(StackManipulation.Illegal.INSTANCE, new NarrowingStackManipulation(new int[]{142, 145}, StackSize.SINGLE.toDecreasingSize()), new NarrowingStackManipulation(new int[]{142, 147}, StackSize.SINGLE.toDecreasingSize()), new NarrowingStackManipulation(new int[]{142, 146}, StackSize.SINGLE.toDecreasingSize()), new NarrowingStackManipulation(new int[]{142}, StackSize.SINGLE.toDecreasingSize()), new NarrowingStackManipulation(new int[]{143}, StackSize.ZERO.toDecreasingSize()), new NarrowingStackManipulation(new int[]{144}, StackSize.SINGLE.toDecreasingSize()), StackManipulation.Trivial.INSTANCE);

    private final StackManipulation toBooleanStackManipulation;
    private final StackManipulation toByteStackManipulation;
    private final StackManipulation toShortStackManipulation;
    private final StackManipulation toCharacterStackManipulation;
    private final StackManipulation toIntegerStackManipulation;
    private final StackManipulation toLongStackManipulation;
    private final StackManipulation toFloatStackManipulation;
    private final StackManipulation toDoubleStackManipulation;

    private PrimitiveNarrowingDelegate(StackManipulation toBooleanStackManipulation, StackManipulation toByteStackManipulation, StackManipulation toShortStackManipulation, StackManipulation toCharacterStackManipulation, StackManipulation toIntegerStackManipulation, StackManipulation toLongStackManipulation, StackManipulation toFloatStackManipulation, StackManipulation toDoubleStackManipulation) {
        this.toBooleanStackManipulation = toBooleanStackManipulation;
        this.toByteStackManipulation = toByteStackManipulation;
        this.toShortStackManipulation = toShortStackManipulation;
        this.toCharacterStackManipulation = toCharacterStackManipulation;
        this.toIntegerStackManipulation = toIntegerStackManipulation;
        this.toLongStackManipulation = toLongStackManipulation;
        this.toFloatStackManipulation = toFloatStackManipulation;
        this.toDoubleStackManipulation = toDoubleStackManipulation;
    }

    public static PrimitiveNarrowingDelegate forPrimitive(TypeDefinition typeDefinition) {
        if (typeDefinition.represents(Boolean.TYPE)) {
            return BOOLEAN;
        }
        if (typeDefinition.represents(Byte.TYPE)) {
            return BYTE;
        }
        if (typeDefinition.represents(Short.TYPE)) {
            return SHORT;
        }
        if (typeDefinition.represents(Character.TYPE)) {
            return CHARACTER;
        }
        if (typeDefinition.represents(Integer.TYPE)) {
            return INTEGER;
        }
        if (typeDefinition.represents(Long.TYPE)) {
            return LONG;
        }
        if (typeDefinition.represents(Float.TYPE)) {
            return FLOAT;
        }
        if (typeDefinition.represents(Double.TYPE)) {
            return DOUBLE;
        }
        throw new IllegalArgumentException("Not a primitive, non-void type: " + typeDefinition);
    }

    public StackManipulation narrowTo(TypeDefinition typeDefinition) {
        if (typeDefinition.represents(Boolean.TYPE)) {
            return this.toBooleanStackManipulation;
        }
        if (typeDefinition.represents(Byte.TYPE)) {
            return this.toByteStackManipulation;
        }
        if (typeDefinition.represents(Short.TYPE)) {
            return this.toShortStackManipulation;
        }
        if (typeDefinition.represents(Character.TYPE)) {
            return this.toCharacterStackManipulation;
        }
        if (typeDefinition.represents(Integer.TYPE)) {
            return this.toIntegerStackManipulation;
        }
        if (typeDefinition.represents(Long.TYPE)) {
            return this.toLongStackManipulation;
        }
        if (typeDefinition.represents(Float.TYPE)) {
            return this.toFloatStackManipulation;
        }
        if (typeDefinition.represents(Double.TYPE)) {
            return this.toDoubleStackManipulation;
        }
        throw new IllegalArgumentException("Not a primitive non-void type: " + typeDefinition);
    }

    @HashCodeAndEqualsPlugin.Enhance
    protected static class NarrowingStackManipulation
    extends StackManipulation.AbstractBase {
        private final int[] conversionOpcodes;
        private final StackManipulation.Size size;

        protected NarrowingStackManipulation(int[] conversionOpcodes, StackManipulation.Size size) {
            this.conversionOpcodes = conversionOpcodes;
            this.size = size;
        }

        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context context) {
            for (int conversionOpcode : this.conversionOpcodes) {
                methodVisitor.visitInsn(conversionOpcode);
            }
            return this.size;
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (!Arrays.equals(this.conversionOpcodes, ((NarrowingStackManipulation)object).conversionOpcodes)) {
                return false;
            }
            return this.size.equals(((NarrowingStackManipulation)object).size);
        }

        public int hashCode() {
            return (this.getClass().hashCode() * 31 + Arrays.hashCode(this.conversionOpcodes)) * 31 + this.size.hashCode();
        }
    }
}

