/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.analysis;

import java.io.IOException;
import java.io.Reader;
import java.util.Random;
import org.apache.lucene.tests.util.TestUtil;

public class MockReaderWrapper
extends Reader {
    private final Reader in;
    private final Random random;
    private int excAtChar = -1;
    private int readSoFar;
    private boolean throwExcNext;

    public MockReaderWrapper(Random random, Reader in) {
        this.in = in;
        this.random = random;
    }

    public void throwExcAfterChar(int charUpto) {
        this.excAtChar = charUpto;
        assert (this.readSoFar == 0);
    }

    public void throwExcNext() {
        this.throwExcNext = true;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int read;
        if (this.throwExcNext || this.excAtChar != -1 && this.readSoFar >= this.excAtChar) {
            throw new RuntimeException("fake exception now!");
        }
        int realLen = len == 1 ? 1 : TestUtil.nextInt(this.random, 1, len);
        if (this.excAtChar != -1) {
            int left = this.excAtChar - this.readSoFar;
            assert (left != 0);
            read = this.in.read(cbuf, off, Math.min(realLen, left));
            assert (read != -1);
            this.readSoFar += read;
        } else {
            read = this.in.read(cbuf, off, realLen);
        }
        return read;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public boolean ready() {
        return false;
    }

    public static boolean isMyEvilException(Throwable t) {
        return t instanceof RuntimeException && "fake exception now!".equals(t.getMessage());
    }
}

