module org.apache.lucene.test_framework {
    requires org.apache.lucene.core;
    requires org.apache.lucene.codecs;
    /* transitive */ requires junit;
    /* transitive */ requires randomizedtesting.runner;

    exports org.apache.lucene.tests.analysis.standard;
    exports org.apache.lucene.tests.analysis;
    exports org.apache.lucene.tests.codecs.asserting;
    exports org.apache.lucene.tests.codecs.blockterms;
    exports org.apache.lucene.tests.codecs.bloom;
    exports org.apache.lucene.tests.codecs.cheapbastard;
    exports org.apache.lucene.tests.codecs.compressing.dummy;
    exports org.apache.lucene.tests.codecs.compressing;
    exports org.apache.lucene.tests.codecs.cranky;
    exports org.apache.lucene.tests.codecs.mockrandom;
    exports org.apache.lucene.tests.codecs.ramonly;
    exports org.apache.lucene.tests.codecs.uniformsplit.sharedterms;
    exports org.apache.lucene.tests.codecs.uniformsplit;
    exports org.apache.lucene.tests.codecs.vector;
    exports org.apache.lucene.tests.geo;
    exports org.apache.lucene.tests.index;
    exports org.apache.lucene.tests.mockfile;
    exports org.apache.lucene.tests.search.similarities;
    exports org.apache.lucene.tests.search;
    exports org.apache.lucene.tests.store;
    exports org.apache.lucene.tests.util.automaton;
    exports org.apache.lucene.tests.util.fst;
    exports org.apache.lucene.tests.util;

    opens org.apache.lucene.tests.index to junit;

    provides Codec with AssertingCodec, CheapBastardCodec, DeflateWithPresetCompressingCodec, FastCompressingCodec, FastDecompressionCompressingCodec, HighCompressionCompressingCodec, LZ4WithPresetCompressingCodec, DummyCompressingCodec, ConfigurableMCodec;
    provides DocValuesFormat with AssertingDocValuesFormat;
    provides KnnVectorsFormat with AssertingKnnVectorsFormat;
    provides PostingsFormat with MockRandomPostingsFormat, RAMOnlyPostingsFormat, LuceneFixedGap, LuceneVarGapFixedInterval, LuceneVarGapDocFreqInterval, TestBloomFilteredLucenePostings, AssertingPostingsFormat, UniformSplitRot13PostingsFormat, STUniformSplitRot13PostingsFormat;

}

