/*
 * Copyright (C) 2019 Dialog Semiconductor. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * - Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * - Neither the name of Dialog Semiconductor nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @file     /workspaces/kninos/bbtester/development/software_include/D2763AA/D2763x.h
 * @brief    CMSIS HeaderFile
 * @version  1.2
 * @date     23. May 2019
 * @note     Generated by SVDConv V3.3.26 on Thursday, 23.05.2019 09:20:28
 *           from File '/workspaces/kninos/bbtester/development/software_include/D2763AA/datasheet_cmsis_cmac.svd',
 */



/** @addtogroup Dialog
  * @{
  */


/** @addtogroup D2763x
  * @{
  */


#ifndef D2763X_H
#define D2763X_H

#ifdef __cplusplus
extern "C" {
#endif


#ifndef CMSIS_STRIP_HEADER

#include "system_CMAC.h"                      /*!< D2763x System                                                             */
#include "os/os_arch_cmac.h"


/* ========================================  Start of section using anonymous unions  ======================================== */
#if defined (__CC_ARM)
  #pragma push
  #pragma anon_unions
#elif defined (__ICCARM__)
  #pragma language=extended
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic push
  #pragma clang diagnostic ignored "-Wc11-extensions"
  #pragma clang diagnostic ignored "-Wreserved-id-macro"
  #pragma clang diagnostic ignored "-Wgnu-anonymous-struct"
  #pragma clang diagnostic ignored "-Wnested-anon-types"
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning 586
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#else
  #warning Not supported compiler type
#endif


/* =========================================================================================================================== */
/* ================                            Device Specific Peripheral Section                             ================ */
/* =========================================================================================================================== */


#endif /*CMSIS_STRIP_HEADER*/

/** @addtogroup Device_Peripheral_peripherals
  * @{
  */



/* =========================================================================================================================== */
/* ================                                           CMAC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief CMAC registers (CMAC)
  */

typedef struct {                                /*!< (@ 0x40000000) CMAC Structure                                             */
  __IO uint32_t  CM_CTRL_REG;                 /*!< (@ 0x00000000) CM_CTRL_REG                                                */
  __IO uint32_t  CM_STAT_REG;                 /*!< (@ 0x00000004) CM_STAT_REG                                                */
  __IO uint32_t  CM_CLK_COMP_REG;             /*!< (@ 0x00000008) CM_CLK_COMP_REG                                            */
  __I  uint32_t  RESERVED;
  __IO uint32_t  CM_EXC_STAT_REG;             /*!< (@ 0x00000010) CM_EXC_STAT_REG                                            */
  __IO uint32_t  CM_EXC_DIS_REG;              /*!< (@ 0x00000014) CM_EXC_DIS_REG                                             */
  __IO uint32_t  CM_EV_SET_REG;               /*!< (@ 0x00000018) CM_EV_SET_REG                                              */
  __IO uint32_t  CM_EV_LATCHED_REG;           /*!< (@ 0x0000001C) CM_EV_LATCHED_REG                                          */
  __IO uint32_t  CM_EV_LINKUP_REG;            /*!< (@ 0x00000020) CM_EV_LINKUP_REG                                           */
  __I  uint32_t  RESERVED1[23];
  __IO uint32_t  CM_PHY_CTRL_REG;             /*!< (@ 0x00000080) CM_PHY_CTRL_REG                                            */
  __IO uint32_t  CM_PHY_CTRL2_REG;            /*!< (@ 0x00000084) CM_PHY_CTRL2_REG                                           */
  __I  uint32_t  RESERVED2[30];
  __IO uint32_t  CM_CTRL2_REG;                /*!< (@ 0x00000100) CM_CTRL2_REG                                               */
  __I  uint32_t  RESERVED3[3];
  __IO uint32_t  CM_BS_WINDOW_REG;            /*!< (@ 0x00000110) CM_BS_WINDOW_REG                                           */
  __IO uint32_t  CM_BS_WINDOW_CNT_REG;        /*!< (@ 0x00000114) CM_BS_WINDOW_CNT_REG                                       */
  __I  uint32_t  RESERVED4[2];
  __IO uint32_t  CM_BS_SMPL_ST_REG;           /*!< (@ 0x00000120) CM_BS_SMPL_ST_REG                                          */
  __IO uint32_t  CM_BS_SMPL_FST_REG;          /*!< (@ 0x00000124) CM_BS_SMPL_FST_REG                                         */
  __IO uint32_t  CM_BS_SMPL_D_REG;            /*!< (@ 0x00000128) CM_BS_SMPL_D_REG                                           */
  __I  uint32_t  RESERVED5[53];
  __IO uint32_t  CM_DMA_STAT_REG;             /*!< (@ 0x00000200) CM_DMA_STAT_REG                                            */
  __IO uint32_t  CM_TS1_REG;                  /*!< (@ 0x00000204) CM_TS1_REG                                                 */
  __I  uint32_t  RESERVED6[2];
  __IO uint32_t  CM_CRC_REG;                  /*!< (@ 0x00000210) CM_CRC_REG                                                 */
  __I  uint32_t  RESERVED7[3];
  __IO uint32_t  CM_WHITENING_REG;            /*!< (@ 0x00000220) CM_WHITENING_REG                                           */
  __I  uint32_t  RESERVED8[3];
  __IO uint32_t  CM_AOAD_REG;                 /*!< (@ 0x00000230) CM_AOAD_REG                                                */
  __I  uint32_t  RESERVED9[51];
  __IO uint32_t  CM_LL_INT_MSK_SET_REG;       /*!< (@ 0x00000300) CM_LL_INT_MSK_SET_REG                                      */
  __IO uint32_t  CM_LL_INT_MSK_CLR_REG;       /*!< (@ 0x00000304) CM_LL_INT_MSK_CLR_REG                                      */
  __IO uint32_t  CM_LL_INT_STAT_REG;          /*!< (@ 0x00000308) CM_LL_INT_STAT_REG                                         */
  __IO uint32_t  CM_LL_INT_SEL_REG;           /*!< (@ 0x0000030C) CM_LL_INT_SEL_REG                                          */
  __I  uint32_t  RESERVED10[8];
  __IO uint32_t  CM_LL_TIMER1_36_10_REG;      /*!< (@ 0x00000330) CM_LL_TIMER1_36_10_REG                                     */
  __IO uint32_t  CM_LL_TIMER1_9_0_REG;        /*!< (@ 0x00000334) CM_LL_TIMER1_9_0_REG                                       */
  __IO uint32_t  CM_LL_TIMER1_9_0_EQ_X_REG;   /*!< (@ 0x00000338) CM_LL_TIMER1_9_0_EQ_X_REG                                  */
  __IO uint32_t  CM_LL_TIMER1_9_0_EQ_Y_REG;   /*!< (@ 0x0000033C) CM_LL_TIMER1_9_0_EQ_Y_REG                                  */
  __I  uint32_t  RESERVED11[2];
  __IO uint32_t  CM_LL_TIMER1_36_10_EQ_X_REG; /*!< (@ 0x00000348) CM_LL_TIMER1_36_10_EQ_X_REG                                */
  __IO uint32_t  CM_LL_TIMER1_36_10_EQ_Y_REG; /*!< (@ 0x0000034C) CM_LL_TIMER1_36_10_EQ_Y_REG                                */
  __IO uint32_t  CM_LL_TIMER1_36_10_EQ_Z_REG; /*!< (@ 0x00000350) CM_LL_TIMER1_36_10_EQ_Z_REG                                */
  __IO uint32_t  CM_LL_TIMER1_EQ_X_HI_REG;    /*!< (@ 0x00000354) CM_LL_TIMER1_EQ_X_HI_REG                                   */
  __IO uint32_t  CM_LL_TIMER1_EQ_X_LO_REG;    /*!< (@ 0x00000358) CM_LL_TIMER1_EQ_X_LO_REG                                   */
  __IO uint32_t  CM_LL_TIMER1_EQ_Y_HI_REG;    /*!< (@ 0x0000035C) CM_LL_TIMER1_EQ_Y_HI_REG                                   */
  __IO uint32_t  CM_LL_TIMER1_EQ_Y_LO_REG;    /*!< (@ 0x00000360) CM_LL_TIMER1_EQ_Y_LO_REG                                   */
  __IO uint32_t  CM_LL_TIMER1_EQ_Y_CTRL_REG;  /*!< (@ 0x00000364) CM_LL_TIMER1_EQ_Y_CTRL_REG                                 */
  __I  uint32_t  RESERVED12[294];
  __IO uint32_t  CM_DIAG_PORT0_REG;           /*!< (@ 0x00000800) CM_DIAG_PORT0_REG                                          */
  __IO uint32_t  CM_DIAG_PORT1_REG;           /*!< (@ 0x00000804) CM_DIAG_PORT1_REG                                          */
  __IO uint32_t  CM_DIAG_PORT2_REG;           /*!< (@ 0x00000808) CM_DIAG_PORT2_REG                                          */
  __IO uint32_t  CM_DIAG_PORT3_REG;           /*!< (@ 0x0000080C) CM_DIAG_PORT3_REG                                          */
  __IO uint32_t  CM_DIAG_PORT4_REG;           /*!< (@ 0x00000810) CM_DIAG_PORT4_REG                                          */
  __IO uint32_t  CM_DIAG_PORT5_REG;           /*!< (@ 0x00000814) CM_DIAG_PORT5_REG                                          */
  __IO uint32_t  CM_DIAG_PORT6_REG;           /*!< (@ 0x00000818) CM_DIAG_PORT6_REG                                          */
  __IO uint32_t  CM_DIAG_PORT7_REG;           /*!< (@ 0x0000081C) CM_DIAG_PORT7_REG                                          */
  __IO uint32_t  CM_DIAG_PORT8_REG;           /*!< (@ 0x00000820) CM_DIAG_PORT8_REG                                          */
  __IO uint32_t  CM_DIAG_PORT9_REG;           /*!< (@ 0x00000824) CM_DIAG_PORT9_REG                                          */
  __IO uint32_t  CM_DIAG_PORT10_REG;          /*!< (@ 0x00000828) CM_DIAG_PORT10_REG                                         */
  __IO uint32_t  CM_DIAG_PORT11_REG;          /*!< (@ 0x0000082C) CM_DIAG_PORT11_REG                                         */
  __IO uint32_t  CM_DIAG_PORT12_REG;          /*!< (@ 0x00000830) CM_DIAG_PORT12_REG                                         */
  __IO uint32_t  CM_DIAG_PORT13_REG;          /*!< (@ 0x00000834) CM_DIAG_PORT13_REG                                         */
  __IO uint32_t  CM_DIAG_PORT14_REG;          /*!< (@ 0x00000838) CM_DIAG_PORT14_REG                                         */
  __IO uint32_t  CM_DIAG_PORT15_REG;          /*!< (@ 0x0000083C) CM_DIAG_PORT15_REG                                         */
  __I  uint32_t  RESERVED13[16];
  __IO uint32_t  CM_DIAG_WORD0_REG;           /*!< (@ 0x00000880) CM_DIAG_WORD0_REG                                          */
  __IO uint32_t  CM_DIAG_WORD1_REG;           /*!< (@ 0x00000884) CM_DIAG_WORD1_REG                                          */
  __IO uint32_t  CM_DIAG_WORD2_REG;           /*!< (@ 0x00000888) CM_DIAG_WORD2_REG                                          */
  __IO uint32_t  CM_DIAG_WORD3_REG;           /*!< (@ 0x0000088C) CM_DIAG_WORD3_REG                                          */
  __IO uint32_t  CM_DIAG_WORD4_REG;           /*!< (@ 0x00000890) CM_DIAG_WORD4_REG                                          */
  __IO uint32_t  CM_DIAG_WORD5_REG;           /*!< (@ 0x00000894) CM_DIAG_WORD5_REG                                          */
  __IO uint32_t  CM_DIAG_WORD6_REG;           /*!< (@ 0x00000898) CM_DIAG_WORD6_REG                                          */
  __IO uint32_t  CM_DIAG_WORD7_REG;           /*!< (@ 0x0000089C) CM_DIAG_WORD7_REG                                          */
  __IO uint32_t  CM_DIAG_WORD8_REG;           /*!< (@ 0x000008A0) CM_DIAG_WORD8_REG                                          */
  __IO uint32_t  CM_DIAG_WORD9_REG;           /*!< (@ 0x000008A4) CM_DIAG_WORD9_REG                                          */
  __IO uint32_t  CM_DIAG_WORD10_REG;          /*!< (@ 0x000008A8) CM_DIAG_WORD10_REG                                         */
  __I  uint32_t  RESERVED14[17];
  __IO uint32_t  CM_DIAG_DSER_REG;            /*!< (@ 0x000008F0) CM_DIAG_DSER_REG                                           */
  __I  uint32_t  RESERVED15[3];
  __IO uint32_t  CM_ERROR_REG;                /*!< (@ 0x00000900) CM_ERROR_REG                                               */
  __IO uint32_t  CM_ERROR_DIS_REG;            /*!< (@ 0x00000904) CM_ERROR_DIS_REG                                           */
  __I  uint32_t  RESERVED16[446];
  __IO uint32_t  CM_FRAME_1_REG;              /*!< (@ 0x00001000) CM_FRAME_1_REG                                             */
  __IO uint32_t  CM_FRAME_2_REG;              /*!< (@ 0x00001004) CM_FRAME_2_REG                                             */
  __I  uint32_t  RESERVED17[2];
  __IO uint32_t  CM_FIELD_PUSH_DATA_REG;      /*!< (@ 0x00001010) CM_FIELD_PUSH_DATA_REG                                     */
  __IO uint32_t  CM_FIELD_PUSH_CTRL_REG;      /*!< (@ 0x00001014) CM_FIELD_PUSH_CTRL_REG                                     */
  __I  uint32_t  RESERVED18[2];
  __IO uint32_t  CM_FIELD_1_DATA_REG;         /*!< (@ 0x00001020) CM_FIELD_1_DATA_REG                                        */
  __IO uint32_t  CM_FIELD_1_CTRL_REG;         /*!< (@ 0x00001024) CM_FIELD_1_CTRL_REG                                        */
  __IO uint32_t  CM_FIELD_2_DATA_REG;         /*!< (@ 0x00001028) CM_FIELD_2_DATA_REG                                        */
  __IO uint32_t  CM_FIELD_2_CTRL_REG;         /*!< (@ 0x0000102C) CM_FIELD_2_CTRL_REG                                        */
  __IO uint32_t  CM_FIELD_3_DATA_REG;         /*!< (@ 0x00001030) CM_FIELD_3_DATA_REG                                        */
  __IO uint32_t  CM_FIELD_3_CTRL_REG;         /*!< (@ 0x00001034) CM_FIELD_3_CTRL_REG                                        */
  __IO uint32_t  CM_FIELD_4_DATA_REG;         /*!< (@ 0x00001038) CM_FIELD_4_DATA_REG                                        */
  __IO uint32_t  CM_FIELD_4_CTRL_REG;         /*!< (@ 0x0000103C) CM_FIELD_4_CTRL_REG                                        */
  __I  uint32_t  RESERVED19[48];
  __IO uint32_t  CM_CRYPTO_CTRL_REG;          /*!< (@ 0x00001100) CM_CRYPTO_CTRL_REG                                         */
  __IO uint32_t  CM_CRYPTO_STAT_REG;          /*!< (@ 0x00001104) CM_CRYPTO_STAT_REG                                         */
  __IO uint32_t  CM_CRYPTO_KEY_31_0_REG;      /*!< (@ 0x00001108) CM_CRYPTO_KEY_31_0_REG                                     */
  __IO uint32_t  CM_CRYPTO_KEY_63_32_REG;     /*!< (@ 0x0000110C) CM_CRYPTO_KEY_63_32_REG                                    */
  __IO uint32_t  CM_CRYPTO_KEY_95_64_REG;     /*!< (@ 0x00001110) CM_CRYPTO_KEY_95_64_REG                                    */
  __IO uint32_t  CM_CRYPTO_KEY_127_96_REG;    /*!< (@ 0x00001114) CM_CRYPTO_KEY_127_96_REG                                   */
  __IO uint32_t  CM_CRYPTO_IN_ADR0_REG;       /*!< (@ 0x00001118) CM_CRYPTO_IN_ADR0_REG                                      */
  __IO uint32_t  CM_CRYPTO_IN_ADR1_REG;       /*!< (@ 0x0000111C) CM_CRYPTO_IN_ADR1_REG                                      */
  __IO uint32_t  CM_CRYPTO_IN_ADR2_REG;       /*!< (@ 0x00001120) CM_CRYPTO_IN_ADR2_REG                                      */
  __IO uint32_t  CM_CRYPTO_IN_ADR3_REG;       /*!< (@ 0x00001124) CM_CRYPTO_IN_ADR3_REG                                      */
  __IO uint32_t  CM_CRYPTO_OUT_ADR_REG;       /*!< (@ 0x00001128) CM_CRYPTO_OUT_ADR_REG                                      */
  __I  uint32_t  RESERVED20[949];
  __IO uint32_t  CM_CTRL_SYS_REG;             /*!< (@ 0x40002000) CMAC and System Control Register                           */
  __IO uint32_t  CM_WDOG_REG;                 /*!< (@ 0x40002004) CMAC Watch Dog Control Register                            */
  __I  uint32_t  RESERVED21[62];
  __IO uint32_t  CM_DIAG_IRQ1_WORD_REG;       /*!< (@ 0x40002100) Diagnostic IRQ on Word1 - Word1 Register                   */
  __IO uint32_t  CM_DIAG_IRQ1_EDGE_REG;       /*!< (@ 0x40002104) Diagnostic IRQ on Word1 - Edge Register                    */
  __IO uint32_t  CM_DIAG_IRQ1_STAT_REG;       /*!< (@ 0x40002108) Diagnostic IRQ on Word1 - Status Register                  */
  __IO uint32_t  CM_DIAG_IRQ1_MASK_REG;       /*!< (@ 0x4000210C) Diagnostic IRQ on Word1 - Mask Register                    */
} CMAC_Type;                                    /*!< Size = 4396 (0x112c)                                                    */


typedef struct {                                    /*!< (@ 0x50010400) CMAC_TIMER_SLP Structure                               */
  __IO uint32_t  CM_SLP_CTRL_REG;                   /*!< (@ 0x50010400) CMAC Sleep Control 1 (allowed to RMW)                  */
  __IO uint32_t  CM_SLP_CTRL2_REG;                  /*!< (@ 0x50010404) CMAC Sleep Control 2 (no RMW)                          */
  __IO uint32_t  CM_SLP_TIMER_REG;                  /*!< (@ 0x50010408) CMAC Sleep Timer                                       */
} CMAC_TIMER_SLP_Type;


typedef struct {                                /*!< (@ 0x50000200) PDC Structure                                              */
  __IOM uint32_t  PDC_CTRL0_REG;                /*!< (@ 0x00000000) PDC control register                                       */
  __IOM uint32_t  PDC_CTRL1_REG;                /*!< (@ 0x00000004) PDC control register                                       */
  __IOM uint32_t  PDC_CTRL2_REG;                /*!< (@ 0x00000008) PDC control register                                       */
  __IOM uint32_t  PDC_CTRL3_REG;                /*!< (@ 0x0000000C) PDC control register                                       */
  __IOM uint32_t  PDC_CTRL4_REG;                /*!< (@ 0x00000010) PDC control register                                       */
  __IOM uint32_t  PDC_CTRL5_REG;                /*!< (@ 0x00000014) PDC control register                                       */
  __IOM uint32_t  PDC_CTRL6_REG;                /*!< (@ 0x00000018) PDC control register                                       */
  __IOM uint32_t  PDC_CTRL7_REG;                /*!< (@ 0x0000001C) PDC control register                                       */
  __IOM uint32_t  PDC_CTRL8_REG;                /*!< (@ 0x00000020) PDC control register                                       */
  __IOM uint32_t  PDC_CTRL9_REG;                /*!< (@ 0x00000024) PDC control register                                       */
  __IOM uint32_t  PDC_CTRL10_REG;               /*!< (@ 0x00000028) PDC control register                                       */
  __IOM uint32_t  PDC_CTRL11_REG;               /*!< (@ 0x0000002C) PDC control register                                       */
  __IOM uint32_t  PDC_CTRL12_REG;               /*!< (@ 0x00000030) PDC control register                                       */
  __IOM uint32_t  PDC_CTRL13_REG;               /*!< (@ 0x00000034) PDC control register                                       */
  __IOM uint32_t  PDC_CTRL14_REG;               /*!< (@ 0x00000038) PDC control register                                       */
  __IOM uint32_t  PDC_CTRL15_REG;               /*!< (@ 0x0000003C) PDC control register                                       */
  __IM  uint32_t  RESERVED[16];
  __IOM uint32_t  PDC_ACKNOWLEDGE_REG;          /*!< (@ 0x00000080) Clear a pending PDC bit                                    */
  __IOM uint32_t  PDC_PENDING_REG;              /*!< (@ 0x00000084) Shows any pending wakup event                              */
  __IOM uint32_t  PDC_PENDING_SNC_REG;          /*!< (@ 0x00000088) Shows any pending IRQ to SNC                               */
  __IOM uint32_t  PDC_PENDING_CM33_REG;         /*!< (@ 0x0000008C) Shows any pending IRQ to CM33                              */
  __IOM uint32_t  PDC_PENDING_CMAC_REG;         /*!< (@ 0x00000090) Shows any pending IRQ to CM33                              */
  __IOM uint32_t  PDC_SET_PENDING_REG;          /*!< (@ 0x00000094) Set a pending PDC bit                                      */
} PDC_Type;                                     /*!< Size = 152 (0x98)                                                         */


/** @} */ /* End of group Device_Peripheral_peripherals */


/* =========================================================================================================================== */
/* ================                          Device Specific Peripheral Address Map                           ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_peripheralAddr
  * @{
  */

#define CMAC_BASE                   0x40000000UL
#define CMAC_TIMER_SLP_BASE         0x50010400UL
#define PDC_BASE                    0x50000200UL

/** @} */ /* End of group Device_Peripheral_peripheralAddr */


/* =========================================================================================================================== */
/* ================                                  Peripheral declaration                                   ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_declaration
  * @{
  */

#define CMAC                        ((CMAC_Type*)              CMAC_BASE)
#define CMAC_TIMER_SLP              ((CMAC_TIMER_SLP_Type *)   CMAC_TIMER_SLP_BASE)
#define PDC                         ((PDC_Type*)               PDC_BASE)

/** @} */ /* End of group Device_Peripheral_declaration */


/* =========================================  End of section using anonymous unions  ========================================= */
#if defined (__CC_ARM)
  #pragma pop
#elif defined (__ICCARM__)
  /* leave anonymous unions enabled */
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic pop
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning restore
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#endif


/* =========================================================================================================================== */
/* ================                                Pos/Mask Peripheral Section                                ================ */
/* =========================================================================================================================== */


/** @addtogroup PosMask_peripherals
  * @{
  */



/* =========================================================================================================================== */
/* ================                                           CMAC                                            ================ */
/* =========================================================================================================================== */

/* ======================================================  CM_AOAD_REG  ====================================================== */
#define CMAC_CM_AOAD_REG_AOAD_PORT_Pos    (24UL)                    /*!< AOAD_PORT (Bit 24)                                    */
#define CMAC_CM_AOAD_REG_AOAD_PORT_Msk    (0xff000000UL)            /*!< AOAD_PORT (Bitfield-Mask: 0xff)                       */
#define CMAC_CM_AOAD_REG_AOAD_TIME_SHIFT_M1_Pos (20UL)              /*!< AOAD_TIME_SHIFT_M1 (Bit 20)                           */
#define CMAC_CM_AOAD_REG_AOAD_TIME_SHIFT_M1_Msk (0x700000UL)        /*!< AOAD_TIME_SHIFT_M1 (Bitfield-Mask: 0x07)              */
#define CMAC_CM_AOAD_REG_AOAD_BIN_MODE_Pos (17UL)                   /*!< AOAD_BIN_MODE (Bit 17)                                */
#define CMAC_CM_AOAD_REG_AOAD_BIN_MODE_Msk (0x20000UL)              /*!< AOAD_BIN_MODE (Bitfield-Mask: 0x01)                   */
#define CMAC_CM_AOAD_REG_AOAD_USE_ALL_OFF_Pos (16UL)                /*!< AOAD_USE_ALL_OFF (Bit 16)                             */
#define CMAC_CM_AOAD_REG_AOAD_USE_ALL_OFF_Msk (0x10000UL)           /*!< AOAD_USE_ALL_OFF (Bitfield-Mask: 0x01)                */
#define CMAC_CM_AOAD_REG_AOAD_INTERLEAVE_ANT0_Pos (15UL)            /*!< AOAD_INTERLEAVE_ANT0 (Bit 15)                         */
#define CMAC_CM_AOAD_REG_AOAD_INTERLEAVE_ANT0_Msk (0x8000UL)        /*!< AOAD_INTERLEAVE_ANT0 (Bitfield-Mask: 0x01)            */
#define CMAC_CM_AOAD_REG_AOAD_ONEHOT_Pos  (14UL)                    /*!< AOAD_ONEHOT (Bit 14)                                  */
#define CMAC_CM_AOAD_REG_AOAD_ONEHOT_Msk  (0x4000UL)                /*!< AOAD_ONEHOT (Bitfield-Mask: 0x01)                     */
#define CMAC_CM_AOAD_REG_AOAD_PATTERN_Pos (13UL)                    /*!< AOAD_PATTERN (Bit 13)                                 */
#define CMAC_CM_AOAD_REG_AOAD_PATTERN_Msk (0x2000UL)                /*!< AOAD_PATTERN (Bitfield-Mask: 0x01)                    */
#define CMAC_CM_AOAD_REG_AOAD_SYMBOLS_PER_SWING_Pos (11UL)          /*!< AOAD_SYMBOLS_PER_SWING (Bit 11)                       */
#define CMAC_CM_AOAD_REG_AOAD_SYMBOLS_PER_SWING_Msk (0x1800UL)      /*!< AOAD_SYMBOLS_PER_SWING (Bitfield-Mask: 0x03)          */
#define CMAC_CM_AOAD_REG_AOAD_ANTENNAS_M1_Pos (8UL)                 /*!< AOAD_ANTENNAS_M1 (Bit 8)                              */
#define CMAC_CM_AOAD_REG_AOAD_ANTENNAS_M1_Msk (0x700UL)             /*!< AOAD_ANTENNAS_M1 (Bitfield-Mask: 0x07)                */
#define CMAC_CM_AOAD_REG_AOAD_STATE_WR_EN_Pos (5UL)                 /*!< AOAD_STATE_WR_EN (Bit 5)                              */
#define CMAC_CM_AOAD_REG_AOAD_STATE_WR_EN_Msk (0x20UL)              /*!< AOAD_STATE_WR_EN (Bitfield-Mask: 0x01)                */
#define CMAC_CM_AOAD_REG_AOAD_STATE_Pos   (0UL)                     /*!< AOAD_STATE (Bit 0)                                    */
#define CMAC_CM_AOAD_REG_AOAD_STATE_Msk   (0x1fUL)                  /*!< AOAD_STATE (Bitfield-Mask: 0x1f)                      */
/* ===================================================  CM_BS_SMPL_D_REG  ==================================================== */
#define CMAC_CM_BS_SMPL_D_REG_BS_WINDOW_LATCHED_Pos (0UL)           /*!< BS_WINDOW_LATCHED (Bit 0)                             */
#define CMAC_CM_BS_SMPL_D_REG_BS_WINDOW_LATCHED_Msk (0xffffffffUL)  /*!< BS_WINDOW_LATCHED (Bitfield-Mask: 0xffffffff)         */
/* ==================================================  CM_BS_SMPL_FST_REG  =================================================== */
#define CMAC_CM_BS_SMPL_FST_REG_BS_SMPL_VALID_Pos (31UL)            /*!< BS_SMPL_VALID (Bit 31)                                */
#define CMAC_CM_BS_SMPL_FST_REG_BS_SMPL_VALID_Msk (0x80000000UL)    /*!< BS_SMPL_VALID (Bitfield-Mask: 0x01)                   */
#define CMAC_CM_BS_SMPL_FST_REG_BS_SMPL_NO_ERROR_Pos (30UL)         /*!< BS_SMPL_NO_ERROR (Bit 30)                             */
#define CMAC_CM_BS_SMPL_FST_REG_BS_SMPL_NO_ERROR_Msk (0x40000000UL) /*!< BS_SMPL_NO_ERROR (Bitfield-Mask: 0x01)                */
#define CMAC_CM_BS_SMPL_FST_REG_BS_WINDOW_CNT_LATCHED_Pos (16UL)    /*!< BS_WINDOW_CNT_LATCHED (Bit 16)                        */
#define CMAC_CM_BS_SMPL_FST_REG_BS_WINDOW_CNT_LATCHED_Msk (0x1f0000UL) /*!< BS_WINDOW_CNT_LATCHED (Bitfield-Mask: 0x1f)        */
#define CMAC_CM_BS_SMPL_FST_REG_FIELD_CNT_LATCHED_Pos (0UL)         /*!< FIELD_CNT_LATCHED (Bit 0)                             */
#define CMAC_CM_BS_SMPL_FST_REG_FIELD_CNT_LATCHED_Msk (0xfUL)       /*!< FIELD_CNT_LATCHED (Bitfield-Mask: 0x0f)               */
/* ===================================================  CM_BS_SMPL_ST_REG  =================================================== */
#define CMAC_CM_BS_SMPL_ST_REG_BS_SMPL_VALID_Pos (31UL)             /*!< BS_SMPL_VALID (Bit 31)                                */
#define CMAC_CM_BS_SMPL_ST_REG_BS_SMPL_VALID_Msk (0x80000000UL)     /*!< BS_SMPL_VALID (Bitfield-Mask: 0x01)                   */
#define CMAC_CM_BS_SMPL_ST_REG_BS_SMPL_NO_ERROR_Pos (30UL)          /*!< BS_SMPL_NO_ERROR (Bit 30)                             */
#define CMAC_CM_BS_SMPL_ST_REG_BS_SMPL_NO_ERROR_Msk (0x40000000UL)  /*!< BS_SMPL_NO_ERROR (Bitfield-Mask: 0x01)                */
#define CMAC_CM_BS_SMPL_ST_REG_BS_WINDOW_CNT_LATCHED_Pos (16UL)     /*!< BS_WINDOW_CNT_LATCHED (Bit 16)                        */
#define CMAC_CM_BS_SMPL_ST_REG_BS_WINDOW_CNT_LATCHED_Msk (0x1f0000UL) /*!< BS_WINDOW_CNT_LATCHED (Bitfield-Mask: 0x1f)         */
#define CMAC_CM_BS_SMPL_ST_REG_FIELD_CNT_LATCHED_Pos (0UL)          /*!< FIELD_CNT_LATCHED (Bit 0)                             */
#define CMAC_CM_BS_SMPL_ST_REG_FIELD_CNT_LATCHED_Msk (0xfUL)        /*!< FIELD_CNT_LATCHED (Bitfield-Mask: 0x0f)               */
/* =================================================  CM_BS_WINDOW_CNT_REG  ================================================== */
#define CMAC_CM_BS_WINDOW_CNT_REG_CM_BS_WINDOW_CNT_Pos (0UL)        /*!< CM_BS_WINDOW_CNT (Bit 0)                              */
#define CMAC_CM_BS_WINDOW_CNT_REG_CM_BS_WINDOW_CNT_Msk (0x1fUL)     /*!< CM_BS_WINDOW_CNT (Bitfield-Mask: 0x1f)                */
/* ===================================================  CM_BS_WINDOW_REG  ==================================================== */
#define CMAC_CM_BS_WINDOW_REG_CM_BS_WINDOW_Pos (0UL)                /*!< CM_BS_WINDOW (Bit 0)                                  */
#define CMAC_CM_BS_WINDOW_REG_CM_BS_WINDOW_Msk (0xffffffffUL)       /*!< CM_BS_WINDOW (Bitfield-Mask: 0xffffffff)              */
/* ====================================================  CM_CLK_COMP_REG  ==================================================== */
#define CMAC_CM_CLK_COMP_REG_CLK1MHZ_COMP_Pos (6UL)                 /*!< CLK1MHZ_COMP (Bit 6)                                  */
#define CMAC_CM_CLK_COMP_REG_CLK1MHZ_COMP_Msk (0x40UL)              /*!< CLK1MHZ_COMP (Bitfield-Mask: 0x01)                    */
#define CMAC_CM_CLK_COMP_REG_CLK2MHZ_COMP_Pos (0UL)                 /*!< CLK2MHZ_COMP (Bit 0)                                  */
#define CMAC_CM_CLK_COMP_REG_CLK2MHZ_COMP_Msk (0x3fUL)              /*!< CLK2MHZ_COMP (Bitfield-Mask: 0x3f)                    */
/* ======================================================  CM_CRC_REG  ======================================================= */
#define CMAC_CM_CRC_REG_CRC_INIT_VAL_Pos  (0UL)                     /*!< CRC_INIT_VAL (Bit 0)                                  */
#define CMAC_CM_CRC_REG_CRC_INIT_VAL_Msk  (0xffffffUL)              /*!< CRC_INIT_VAL (Bitfield-Mask: 0xffffff)                */
/* ==================================================  CM_CRYPTO_CTRL_REG  =================================================== */
#define CMAC_CM_CRYPTO_CTRL_REG_CM_CRYPTO_CTR_LEN_Pos (16UL)        /*!< CM_CRYPTO_CTR_LEN (Bit 16)                            */
#define CMAC_CM_CRYPTO_CTRL_REG_CM_CRYPTO_CTR_LEN_Msk (0xff0000UL)  /*!< CM_CRYPTO_CTR_LEN (Bitfield-Mask: 0xff)               */
#define CMAC_CM_CRYPTO_CTRL_REG_CM_CRYPTO_KEY_ORDER_Pos (10UL)      /*!< CM_CRYPTO_KEY_ORDER (Bit 10)                          */
#define CMAC_CM_CRYPTO_CTRL_REG_CM_CRYPTO_KEY_ORDER_Msk (0x400UL)   /*!< CM_CRYPTO_KEY_ORDER (Bitfield-Mask: 0x01)             */
#define CMAC_CM_CRYPTO_CTRL_REG_CM_CRYPTO_SW_REQ_PBUF_CLR_Pos (9UL) /*!< CM_CRYPTO_SW_REQ_PBUF_CLR (Bit 9)                     */
#define CMAC_CM_CRYPTO_CTRL_REG_CM_CRYPTO_SW_REQ_PBUF_CLR_Msk (0x200UL) /*!< CM_CRYPTO_SW_REQ_PBUF_CLR (Bitfield-Mask: 0x01)   */
#define CMAC_CM_CRYPTO_CTRL_REG_CM_CRYPTO_SW_REQ_ABORT_Pos (8UL)    /*!< CM_CRYPTO_SW_REQ_ABORT (Bit 8)                        */
#define CMAC_CM_CRYPTO_CTRL_REG_CM_CRYPTO_SW_REQ_ABORT_Msk (0x100UL) /*!< CM_CRYPTO_SW_REQ_ABORT (Bitfield-Mask: 0x01)         */
#define CMAC_CM_CRYPTO_CTRL_REG_CM_CRYPTO_ECB_ENC_EN_Pos (7UL)      /*!< CM_CRYPTO_ECB_ENC_EN (Bit 7)                          */
#define CMAC_CM_CRYPTO_CTRL_REG_CM_CRYPTO_ECB_ENC_EN_Msk (0x80UL)   /*!< CM_CRYPTO_ECB_ENC_EN (Bitfield-Mask: 0x01)            */
#define CMAC_CM_CRYPTO_CTRL_REG_CM_CRYPTO_IN_SEL_Pos (6UL)          /*!< CM_CRYPTO_IN_SEL (Bit 6)                              */
#define CMAC_CM_CRYPTO_CTRL_REG_CM_CRYPTO_IN_SEL_Msk (0x40UL)       /*!< CM_CRYPTO_IN_SEL (Bitfield-Mask: 0x01)                */
#define CMAC_CM_CRYPTO_CTRL_REG_CM_CRYPTO_OUT_SEL_Pos (5UL)         /*!< CM_CRYPTO_OUT_SEL (Bit 5)                             */
#define CMAC_CM_CRYPTO_CTRL_REG_CM_CRYPTO_OUT_SEL_Msk (0x20UL)      /*!< CM_CRYPTO_OUT_SEL (Bitfield-Mask: 0x01)               */
#define CMAC_CM_CRYPTO_CTRL_REG_CM_CRYPTO_UCR_PLD_CP_Pos (4UL)      /*!< CM_CRYPTO_UCR_PLD_CP (Bit 4)                          */
#define CMAC_CM_CRYPTO_CTRL_REG_CM_CRYPTO_UCR_PLD_CP_Msk (0x10UL)   /*!< CM_CRYPTO_UCR_PLD_CP (Bitfield-Mask: 0x01)            */
#define CMAC_CM_CRYPTO_CTRL_REG_CM_CRYPTO_CTR_MAC_EN_Pos (3UL)      /*!< CM_CRYPTO_CTR_MAC_EN (Bit 3)                          */
#define CMAC_CM_CRYPTO_CTRL_REG_CM_CRYPTO_CTR_MAC_EN_Msk (0x8UL)    /*!< CM_CRYPTO_CTR_MAC_EN (Bitfield-Mask: 0x01)            */
#define CMAC_CM_CRYPTO_CTRL_REG_CM_CRYPTO_CTR_PLD_EN_Pos (2UL)      /*!< CM_CRYPTO_CTR_PLD_EN (Bit 2)                          */
#define CMAC_CM_CRYPTO_CTRL_REG_CM_CRYPTO_CTR_PLD_EN_Msk (0x4UL)    /*!< CM_CRYPTO_CTR_PLD_EN (Bitfield-Mask: 0x01)            */
#define CMAC_CM_CRYPTO_CTRL_REG_CM_CRYPTO_AUTH_EN_Pos (1UL)         /*!< CM_CRYPTO_AUTH_EN (Bit 1)                             */
#define CMAC_CM_CRYPTO_CTRL_REG_CM_CRYPTO_AUTH_EN_Msk (0x2UL)       /*!< CM_CRYPTO_AUTH_EN (Bitfield-Mask: 0x01)               */
#define CMAC_CM_CRYPTO_CTRL_REG_CM_CRYPTO_ENC_DECN_Pos (0UL)        /*!< CM_CRYPTO_ENC_DECN (Bit 0)                            */
#define CMAC_CM_CRYPTO_CTRL_REG_CM_CRYPTO_ENC_DECN_Msk (0x1UL)      /*!< CM_CRYPTO_ENC_DECN (Bitfield-Mask: 0x01)              */
/* =================================================  CM_CRYPTO_IN_ADR0_REG  ================================================= */
#define CMAC_CM_CRYPTO_IN_ADR0_REG_CM_CRYPTO_ADATA_ADR_OFST_Pos (0UL) /*!< CM_CRYPTO_ADATA_ADR_OFST (Bit 0)                    */
#define CMAC_CM_CRYPTO_IN_ADR0_REG_CM_CRYPTO_ADATA_ADR_OFST_Msk (0x3ffffUL) /*!< CM_CRYPTO_ADATA_ADR_OFST (Bitfield-Mask: 0x3ffff) */
/* =================================================  CM_CRYPTO_IN_ADR1_REG  ================================================= */
#define CMAC_CM_CRYPTO_IN_ADR1_REG_CM_CRYPTO_AUTH_ADR_OFST_Pos (0UL) /*!< CM_CRYPTO_AUTH_ADR_OFST (Bit 0)                      */
#define CMAC_CM_CRYPTO_IN_ADR1_REG_CM_CRYPTO_AUTH_ADR_OFST_Msk (0x3ffffUL) /*!< CM_CRYPTO_AUTH_ADR_OFST (Bitfield-Mask: 0x3ffff) */
/* =================================================  CM_CRYPTO_IN_ADR2_REG  ================================================= */
#define CMAC_CM_CRYPTO_IN_ADR2_REG_CM_CRYPTO_PLD_ADR_OFST_Pos (0UL) /*!< CM_CRYPTO_PLD_ADR_OFST (Bit 0)                        */
#define CMAC_CM_CRYPTO_IN_ADR2_REG_CM_CRYPTO_PLD_ADR_OFST_Msk (0x3ffffUL) /*!< CM_CRYPTO_PLD_ADR_OFST (Bitfield-Mask: 0x3ffff) */
/* =================================================  CM_CRYPTO_IN_ADR3_REG  ================================================= */
#define CMAC_CM_CRYPTO_IN_ADR3_REG_CM_CRYPTO_CTRBLK_ADR_OFST_Pos (0UL) /*!< CM_CRYPTO_CTRBLK_ADR_OFST (Bit 0)                  */
#define CMAC_CM_CRYPTO_IN_ADR3_REG_CM_CRYPTO_CTRBLK_ADR_OFST_Msk (0x3ffffUL) /*!< CM_CRYPTO_CTRBLK_ADR_OFST (Bitfield-Mask: 0x3ffff) */
/* ===============================================  CM_CRYPTO_KEY_127_96_REG  ================================================ */
#define CMAC_CM_CRYPTO_KEY_127_96_REG_CM_CRYPTO_KEY_127_96_Pos (0UL) /*!< CM_CRYPTO_KEY_127_96 (Bit 0)                         */
#define CMAC_CM_CRYPTO_KEY_127_96_REG_CM_CRYPTO_KEY_127_96_Msk (0xffffffffUL) /*!< CM_CRYPTO_KEY_127_96 (Bitfield-Mask: 0xffffffff) */
/* ================================================  CM_CRYPTO_KEY_31_0_REG  ================================================= */
#define CMAC_CM_CRYPTO_KEY_31_0_REG_CM_CRYPTO_KEY_31_0_Pos (0UL)    /*!< CM_CRYPTO_KEY_31_0 (Bit 0)                            */
#define CMAC_CM_CRYPTO_KEY_31_0_REG_CM_CRYPTO_KEY_31_0_Msk (0xffffffffUL) /*!< CM_CRYPTO_KEY_31_0 (Bitfield-Mask: 0xffffffff)  */
/* ================================================  CM_CRYPTO_KEY_63_32_REG  ================================================ */
#define CMAC_CM_CRYPTO_KEY_63_32_REG_CM_CRYPTO_KEY_63_32_Pos (0UL)  /*!< CM_CRYPTO_KEY_63_32 (Bit 0)                           */
#define CMAC_CM_CRYPTO_KEY_63_32_REG_CM_CRYPTO_KEY_63_32_Msk (0xffffffffUL) /*!< CM_CRYPTO_KEY_63_32 (Bitfield-Mask: 0xffffffff) */
/* ================================================  CM_CRYPTO_KEY_95_64_REG  ================================================ */
#define CMAC_CM_CRYPTO_KEY_95_64_REG_CM_CRYPTO_KEY_95_64_Pos (0UL)  /*!< CM_CRYPTO_KEY_95_64 (Bit 0)                           */
#define CMAC_CM_CRYPTO_KEY_95_64_REG_CM_CRYPTO_KEY_95_64_Msk (0xffffffffUL) /*!< CM_CRYPTO_KEY_95_64 (Bitfield-Mask: 0xffffffff) */
/* =================================================  CM_CRYPTO_OUT_ADR_REG  ================================================= */
#define CMAC_CM_CRYPTO_OUT_ADR_REG_CM_CRYPTO_OUT_ADR_OFST_Pos (0UL) /*!< CM_CRYPTO_OUT_ADR_OFST (Bit 0)                        */
#define CMAC_CM_CRYPTO_OUT_ADR_REG_CM_CRYPTO_OUT_ADR_OFST_Msk (0x3ffffUL) /*!< CM_CRYPTO_OUT_ADR_OFST (Bitfield-Mask: 0x3ffff) */
/* ==================================================  CM_CRYPTO_STAT_REG  =================================================== */
#define CMAC_CM_CRYPTO_STAT_REG_CM_CRYPTO_OUT_UNDERFLOW_Pos (6UL)   /*!< CM_CRYPTO_OUT_UNDERFLOW (Bit 6)                       */
#define CMAC_CM_CRYPTO_STAT_REG_CM_CRYPTO_OUT_UNDERFLOW_Msk (0x40UL) /*!< CM_CRYPTO_OUT_UNDERFLOW (Bitfield-Mask: 0x01)        */
#define CMAC_CM_CRYPTO_STAT_REG_CM_CRYPTO_IN_OVERFLOW_Pos (5UL)     /*!< CM_CRYPTO_IN_OVERFLOW (Bit 5)                         */
#define CMAC_CM_CRYPTO_STAT_REG_CM_CRYPTO_IN_OVERFLOW_Msk (0x20UL)  /*!< CM_CRYPTO_IN_OVERFLOW (Bitfield-Mask: 0x01)           */
#define CMAC_CM_CRYPTO_STAT_REG_CM_CRYPTO_PARAM_ERROR_Pos (2UL)     /*!< CM_CRYPTO_PARAM_ERROR (Bit 2)                         */
#define CMAC_CM_CRYPTO_STAT_REG_CM_CRYPTO_PARAM_ERROR_Msk (0x1cUL)  /*!< CM_CRYPTO_PARAM_ERROR (Bitfield-Mask: 0x07)           */
#define CMAC_CM_CRYPTO_STAT_REG_CM_CRYPTO_MIC_MISMACH_Pos (1UL)     /*!< CM_CRYPTO_MIC_MISMACH (Bit 1)                         */
#define CMAC_CM_CRYPTO_STAT_REG_CM_CRYPTO_MIC_MISMACH_Msk (0x2UL)   /*!< CM_CRYPTO_MIC_MISMACH (Bitfield-Mask: 0x01)           */
#define CMAC_CM_CRYPTO_STAT_REG_CM_CRYPTO_BUSY_Pos (0UL)            /*!< CM_CRYPTO_BUSY (Bit 0)                                */
#define CMAC_CM_CRYPTO_STAT_REG_CM_CRYPTO_BUSY_Msk (0x1UL)          /*!< CM_CRYPTO_BUSY (Bitfield-Mask: 0x01)                  */
/* =====================================================  CM_CTRL2_REG  ====================================================== */
#define CMAC_CM_CTRL2_REG_COEX_CANCELS_RX_Pos (14UL)                /*!< COEX_CANCELS_RX (Bit 14)                              */
#define CMAC_CM_CTRL2_REG_COEX_CANCELS_RX_Msk (0x4000UL)            /*!< COEX_CANCELS_RX (Bitfield-Mask: 0x01)                 */
#define CMAC_CM_CTRL2_REG_COEX_SMART_ACT_MANUAL_Pos (13UL)          /*!< COEX_SMART_ACT_MANUAL (Bit 13)                        */
#define CMAC_CM_CTRL2_REG_COEX_SMART_ACT_MANUAL_Msk (0x2000UL)      /*!< COEX_SMART_ACT_MANUAL (Bitfield-Mask: 0x01)           */
#define CMAC_CM_CTRL2_REG_COEX_SMART_PRI_MANUAL_Pos (12UL)          /*!< COEX_SMART_PRI_MANUAL (Bit 12)                        */
#define CMAC_CM_CTRL2_REG_COEX_SMART_PRI_MANUAL_Msk (0x1000UL)      /*!< COEX_SMART_PRI_MANUAL (Bitfield-Mask: 0x01)           */
#define CMAC_CM_CTRL2_REG_COEX_PTI_FORCE_1_Pos (11UL)               /*!< COEX_PTI_FORCE_1 (Bit 11)                             */
#define CMAC_CM_CTRL2_REG_COEX_PTI_FORCE_1_Msk (0x800UL)            /*!< COEX_PTI_FORCE_1 (Bitfield-Mask: 0x01)                */
#define CMAC_CM_CTRL2_REG_COEX_PTI_FORCE_0_Pos (10UL)               /*!< COEX_PTI_FORCE_0 (Bit 10)                             */
#define CMAC_CM_CTRL2_REG_COEX_PTI_FORCE_0_Msk (0x400UL)            /*!< COEX_PTI_FORCE_0 (Bitfield-Mask: 0x01)                */
#define CMAC_CM_CTRL2_REG_COEX_IMPL_Pos   (9UL)                     /*!< COEX_IMPL (Bit 9)                                     */
#define CMAC_CM_CTRL2_REG_COEX_IMPL_Msk   (0x200UL)                 /*!< COEX_IMPL (Bitfield-Mask: 0x01)                       */
#define CMAC_CM_CTRL2_REG_COEX_AUTO_Pos   (8UL)                     /*!< COEX_AUTO (Bit 8)                                     */
#define CMAC_CM_CTRL2_REG_COEX_AUTO_Msk   (0x100UL)                 /*!< COEX_AUTO (Bitfield-Mask: 0x01)                       */
#define CMAC_CM_CTRL2_REG_LL_TIMER1_9_0_LIMITED_N_Pos (7UL)         /*!< LL_TIMER1_9_0_LIMITED_N (Bit 7)                       */
#define CMAC_CM_CTRL2_REG_LL_TIMER1_9_0_LIMITED_N_Msk (0x80UL)      /*!< LL_TIMER1_9_0_LIMITED_N (Bitfield-Mask: 0x01)         */
#define CMAC_CM_CTRL2_REG_WHITENING_MODE_Pos (5UL)                  /*!< WHITENING_MODE (Bit 5)                                */
#define CMAC_CM_CTRL2_REG_WHITENING_MODE_Msk (0x60UL)               /*!< WHITENING_MODE (Bitfield-Mask: 0x03)                  */
#define CMAC_CM_CTRL2_REG_CRC_MODE_Pos    (3UL)                     /*!< CRC_MODE (Bit 3)                                      */
#define CMAC_CM_CTRL2_REG_CRC_MODE_Msk    (0x18UL)                  /*!< CRC_MODE (Bitfield-Mask: 0x03)                        */
#define CMAC_CM_CTRL2_REG_RXEV_ON_LPCLK_NEGEDGE_Pos (2UL)           /*!< RXEV_ON_LPCLK_NEGEDGE (Bit 2)                         */
#define CMAC_CM_CTRL2_REG_RXEV_ON_LPCLK_NEGEDGE_Msk (0x4UL)         /*!< RXEV_ON_LPCLK_NEGEDGE (Bitfield-Mask: 0x01)           */
#define CMAC_CM_CTRL2_REG_RXEV_ON_LPCLK_POSEDGE_Pos (1UL)           /*!< RXEV_ON_LPCLK_POSEDGE (Bit 1)                         */
#define CMAC_CM_CTRL2_REG_RXEV_ON_LPCLK_POSEDGE_Msk (0x2UL)         /*!< RXEV_ON_LPCLK_POSEDGE (Bitfield-Mask: 0x01)           */
#define CMAC_CM_CTRL2_REG_RXEV_ON_1MHZ_Pos (0UL)                    /*!< RXEV_ON_1MHZ (Bit 0)                                  */
#define CMAC_CM_CTRL2_REG_RXEV_ON_1MHZ_Msk (0x1UL)                  /*!< RXEV_ON_1MHZ (Bitfield-Mask: 0x01)                    */
/* ======================================================  CM_CTRL_REG  ====================================================== */
#define CMAC_CM_CTRL_REG_CM_CLK_FREQ_MHZ_D2M1_Pos (24UL)            /*!< CM_CLK_FREQ_MHZ_D2M1 (Bit 24)                         */
#define CMAC_CM_CTRL_REG_CM_CLK_FREQ_MHZ_D2M1_Msk (0x3f000000UL)    /*!< CM_CLK_FREQ_MHZ_D2M1 (Bitfield-Mask: 0x3f)            */
#define CMAC_CM_CTRL_REG_CM_SPR_Pos       (5UL)                     /*!< CM_SPR (Bit 5)                                        */
#define CMAC_CM_CTRL_REG_CM_SPR_Msk       (0x1e0UL)                 /*!< CM_SPR (Bitfield-Mask: 0x0f)                          */
#define CMAC_CM_CTRL_REG_TIMERS_HALT_ON_HALT_N_Pos (4UL)            /*!< TIMERS_HALT_ON_HALT_N (Bit 4)                         */
#define CMAC_CM_CTRL_REG_TIMERS_HALT_ON_HALT_N_Msk (0x10UL)         /*!< TIMERS_HALT_ON_HALT_N (Bitfield-Mask: 0x01)           */
#define CMAC_CM_CTRL_REG_MCPU_STATE_RETAINED_Pos (3UL)              /*!< MCPU_STATE_RETAINED (Bit 3)                           */
#define CMAC_CM_CTRL_REG_MCPU_STATE_RETAINED_Msk (0x8UL)            /*!< MCPU_STATE_RETAINED (Bitfield-Mask: 0x01)             */
#define CMAC_CM_CTRL_REG_MCPU_SWD_EN_Pos  (2UL)                     /*!< MCPU_SWD_EN (Bit 2)                                   */
#define CMAC_CM_CTRL_REG_MCPU_SWD_EN_Msk  (0x4UL)                   /*!< MCPU_SWD_EN (Bitfield-Mask: 0x01)                     */
#define CMAC_CM_CTRL_REG_CM_BS_ENABLE_Pos (1UL)                     /*!< CM_BS_ENABLE (Bit 1)                                  */
#define CMAC_CM_CTRL_REG_CM_BS_ENABLE_Msk (0x2UL)                   /*!< CM_BS_ENABLE (Bitfield-Mask: 0x01)                    */
#define CMAC_CM_CTRL_REG_CM_BS_RESET_N_Pos (0UL)                    /*!< CM_BS_RESET_N (Bit 0)                                 */
#define CMAC_CM_CTRL_REG_CM_BS_RESET_N_Msk (0x1UL)                  /*!< CM_BS_RESET_N (Bitfield-Mask: 0x01)                   */
/* ===================================================  CM_DIAG_DSER_REG  ==================================================== */
#define CMAC_CM_DIAG_DSER_REG_DIAG_DSER_Pos (0UL)                   /*!< DIAG_DSER (Bit 0)                                     */
#define CMAC_CM_DIAG_DSER_REG_DIAG_DSER_Msk (0xffUL)                /*!< DIAG_DSER (Bitfield-Mask: 0xff)                       */
/* ===================================================  CM_DIAG_PORT0_REG  =================================================== */
#define CMAC_CM_DIAG_PORT0_REG_DIAG_INV_Pos (16UL)                  /*!< DIAG_INV (Bit 16)                                     */
#define CMAC_CM_DIAG_PORT0_REG_DIAG_INV_Msk (0x10000UL)             /*!< DIAG_INV (Bitfield-Mask: 0x01)                        */
#define CMAC_CM_DIAG_PORT0_REG_DIAG_BIT_Pos (8UL)                   /*!< DIAG_BIT (Bit 8)                                      */
#define CMAC_CM_DIAG_PORT0_REG_DIAG_BIT_Msk (0x1f00UL)              /*!< DIAG_BIT (Bitfield-Mask: 0x1f)                        */
#define CMAC_CM_DIAG_PORT0_REG_DIAG_WORD_Pos (0UL)                  /*!< DIAG_WORD (Bit 0)                                     */
#define CMAC_CM_DIAG_PORT0_REG_DIAG_WORD_Msk (0xfUL)                /*!< DIAG_WORD (Bitfield-Mask: 0x0f)                       */
/* ==================================================  CM_DIAG_PORT10_REG  =================================================== */
#define CMAC_CM_DIAG_PORT10_REG_DIAG_INV_Pos (16UL)                 /*!< DIAG_INV (Bit 16)                                     */
#define CMAC_CM_DIAG_PORT10_REG_DIAG_INV_Msk (0x10000UL)            /*!< DIAG_INV (Bitfield-Mask: 0x01)                        */
#define CMAC_CM_DIAG_PORT10_REG_DIAG_BIT_Pos (8UL)                  /*!< DIAG_BIT (Bit 8)                                      */
#define CMAC_CM_DIAG_PORT10_REG_DIAG_BIT_Msk (0x1f00UL)             /*!< DIAG_BIT (Bitfield-Mask: 0x1f)                        */
#define CMAC_CM_DIAG_PORT10_REG_DIAG_WORD_Pos (0UL)                 /*!< DIAG_WORD (Bit 0)                                     */
#define CMAC_CM_DIAG_PORT10_REG_DIAG_WORD_Msk (0xfUL)               /*!< DIAG_WORD (Bitfield-Mask: 0x0f)                       */
/* ==================================================  CM_DIAG_PORT11_REG  =================================================== */
#define CMAC_CM_DIAG_PORT11_REG_DIAG_INV_Pos (16UL)                 /*!< DIAG_INV (Bit 16)                                     */
#define CMAC_CM_DIAG_PORT11_REG_DIAG_INV_Msk (0x10000UL)            /*!< DIAG_INV (Bitfield-Mask: 0x01)                        */
#define CMAC_CM_DIAG_PORT11_REG_DIAG_BIT_Pos (8UL)                  /*!< DIAG_BIT (Bit 8)                                      */
#define CMAC_CM_DIAG_PORT11_REG_DIAG_BIT_Msk (0x1f00UL)             /*!< DIAG_BIT (Bitfield-Mask: 0x1f)                        */
#define CMAC_CM_DIAG_PORT11_REG_DIAG_WORD_Pos (0UL)                 /*!< DIAG_WORD (Bit 0)                                     */
#define CMAC_CM_DIAG_PORT11_REG_DIAG_WORD_Msk (0xfUL)               /*!< DIAG_WORD (Bitfield-Mask: 0x0f)                       */
/* ==================================================  CM_DIAG_PORT12_REG  =================================================== */
#define CMAC_CM_DIAG_PORT12_REG_DIAG_INV_Pos (16UL)                 /*!< DIAG_INV (Bit 16)                                     */
#define CMAC_CM_DIAG_PORT12_REG_DIAG_INV_Msk (0x10000UL)            /*!< DIAG_INV (Bitfield-Mask: 0x01)                        */
#define CMAC_CM_DIAG_PORT12_REG_DIAG_BIT_Pos (8UL)                  /*!< DIAG_BIT (Bit 8)                                      */
#define CMAC_CM_DIAG_PORT12_REG_DIAG_BIT_Msk (0x1f00UL)             /*!< DIAG_BIT (Bitfield-Mask: 0x1f)                        */
#define CMAC_CM_DIAG_PORT12_REG_DIAG_WORD_Pos (0UL)                 /*!< DIAG_WORD (Bit 0)                                     */
#define CMAC_CM_DIAG_PORT12_REG_DIAG_WORD_Msk (0xfUL)               /*!< DIAG_WORD (Bitfield-Mask: 0x0f)                       */
/* ==================================================  CM_DIAG_PORT13_REG  =================================================== */
#define CMAC_CM_DIAG_PORT13_REG_DIAG_INV_Pos (16UL)                 /*!< DIAG_INV (Bit 16)                                     */
#define CMAC_CM_DIAG_PORT13_REG_DIAG_INV_Msk (0x10000UL)            /*!< DIAG_INV (Bitfield-Mask: 0x01)                        */
#define CMAC_CM_DIAG_PORT13_REG_DIAG_BIT_Pos (8UL)                  /*!< DIAG_BIT (Bit 8)                                      */
#define CMAC_CM_DIAG_PORT13_REG_DIAG_BIT_Msk (0x1f00UL)             /*!< DIAG_BIT (Bitfield-Mask: 0x1f)                        */
#define CMAC_CM_DIAG_PORT13_REG_DIAG_WORD_Pos (0UL)                 /*!< DIAG_WORD (Bit 0)                                     */
#define CMAC_CM_DIAG_PORT13_REG_DIAG_WORD_Msk (0xfUL)               /*!< DIAG_WORD (Bitfield-Mask: 0x0f)                       */
/* ==================================================  CM_DIAG_PORT14_REG  =================================================== */
#define CMAC_CM_DIAG_PORT14_REG_DIAG_INV_Pos (16UL)                 /*!< DIAG_INV (Bit 16)                                     */
#define CMAC_CM_DIAG_PORT14_REG_DIAG_INV_Msk (0x10000UL)            /*!< DIAG_INV (Bitfield-Mask: 0x01)                        */
#define CMAC_CM_DIAG_PORT14_REG_DIAG_BIT_Pos (8UL)                  /*!< DIAG_BIT (Bit 8)                                      */
#define CMAC_CM_DIAG_PORT14_REG_DIAG_BIT_Msk (0x1f00UL)             /*!< DIAG_BIT (Bitfield-Mask: 0x1f)                        */
#define CMAC_CM_DIAG_PORT14_REG_DIAG_WORD_Pos (0UL)                 /*!< DIAG_WORD (Bit 0)                                     */
#define CMAC_CM_DIAG_PORT14_REG_DIAG_WORD_Msk (0xfUL)               /*!< DIAG_WORD (Bitfield-Mask: 0x0f)                       */
/* ==================================================  CM_DIAG_PORT15_REG  =================================================== */
#define CMAC_CM_DIAG_PORT15_REG_DIAG_INV_Pos (16UL)                 /*!< DIAG_INV (Bit 16)                                     */
#define CMAC_CM_DIAG_PORT15_REG_DIAG_INV_Msk (0x10000UL)            /*!< DIAG_INV (Bitfield-Mask: 0x01)                        */
#define CMAC_CM_DIAG_PORT15_REG_DIAG_BIT_Pos (8UL)                  /*!< DIAG_BIT (Bit 8)                                      */
#define CMAC_CM_DIAG_PORT15_REG_DIAG_BIT_Msk (0x1f00UL)             /*!< DIAG_BIT (Bitfield-Mask: 0x1f)                        */
#define CMAC_CM_DIAG_PORT15_REG_DIAG_WORD_Pos (0UL)                 /*!< DIAG_WORD (Bit 0)                                     */
#define CMAC_CM_DIAG_PORT15_REG_DIAG_WORD_Msk (0xfUL)               /*!< DIAG_WORD (Bitfield-Mask: 0x0f)                       */
/* ===================================================  CM_DIAG_PORT1_REG  =================================================== */
#define CMAC_CM_DIAG_PORT1_REG_DIAG_INV_Pos (16UL)                  /*!< DIAG_INV (Bit 16)                                     */
#define CMAC_CM_DIAG_PORT1_REG_DIAG_INV_Msk (0x10000UL)             /*!< DIAG_INV (Bitfield-Mask: 0x01)                        */
#define CMAC_CM_DIAG_PORT1_REG_DIAG_BIT_Pos (8UL)                   /*!< DIAG_BIT (Bit 8)                                      */
#define CMAC_CM_DIAG_PORT1_REG_DIAG_BIT_Msk (0x1f00UL)              /*!< DIAG_BIT (Bitfield-Mask: 0x1f)                        */
#define CMAC_CM_DIAG_PORT1_REG_DIAG_WORD_Pos (0UL)                  /*!< DIAG_WORD (Bit 0)                                     */
#define CMAC_CM_DIAG_PORT1_REG_DIAG_WORD_Msk (0xfUL)                /*!< DIAG_WORD (Bitfield-Mask: 0x0f)                       */
/* ===================================================  CM_DIAG_PORT2_REG  =================================================== */
#define CMAC_CM_DIAG_PORT2_REG_DIAG_INV_Pos (16UL)                  /*!< DIAG_INV (Bit 16)                                     */
#define CMAC_CM_DIAG_PORT2_REG_DIAG_INV_Msk (0x10000UL)             /*!< DIAG_INV (Bitfield-Mask: 0x01)                        */
#define CMAC_CM_DIAG_PORT2_REG_DIAG_BIT_Pos (8UL)                   /*!< DIAG_BIT (Bit 8)                                      */
#define CMAC_CM_DIAG_PORT2_REG_DIAG_BIT_Msk (0x1f00UL)              /*!< DIAG_BIT (Bitfield-Mask: 0x1f)                        */
#define CMAC_CM_DIAG_PORT2_REG_DIAG_WORD_Pos (0UL)                  /*!< DIAG_WORD (Bit 0)                                     */
#define CMAC_CM_DIAG_PORT2_REG_DIAG_WORD_Msk (0xfUL)                /*!< DIAG_WORD (Bitfield-Mask: 0x0f)                       */
/* ===================================================  CM_DIAG_PORT3_REG  =================================================== */
#define CMAC_CM_DIAG_PORT3_REG_DIAG_INV_Pos (16UL)                  /*!< DIAG_INV (Bit 16)                                     */
#define CMAC_CM_DIAG_PORT3_REG_DIAG_INV_Msk (0x10000UL)             /*!< DIAG_INV (Bitfield-Mask: 0x01)                        */
#define CMAC_CM_DIAG_PORT3_REG_DIAG_BIT_Pos (8UL)                   /*!< DIAG_BIT (Bit 8)                                      */
#define CMAC_CM_DIAG_PORT3_REG_DIAG_BIT_Msk (0x1f00UL)              /*!< DIAG_BIT (Bitfield-Mask: 0x1f)                        */
#define CMAC_CM_DIAG_PORT3_REG_DIAG_WORD_Pos (0UL)                  /*!< DIAG_WORD (Bit 0)                                     */
#define CMAC_CM_DIAG_PORT3_REG_DIAG_WORD_Msk (0xfUL)                /*!< DIAG_WORD (Bitfield-Mask: 0x0f)                       */
/* ===================================================  CM_DIAG_PORT4_REG  =================================================== */
#define CMAC_CM_DIAG_PORT4_REG_DIAG_INV_Pos (16UL)                  /*!< DIAG_INV (Bit 16)                                     */
#define CMAC_CM_DIAG_PORT4_REG_DIAG_INV_Msk (0x10000UL)             /*!< DIAG_INV (Bitfield-Mask: 0x01)                        */
#define CMAC_CM_DIAG_PORT4_REG_DIAG_BIT_Pos (8UL)                   /*!< DIAG_BIT (Bit 8)                                      */
#define CMAC_CM_DIAG_PORT4_REG_DIAG_BIT_Msk (0x1f00UL)              /*!< DIAG_BIT (Bitfield-Mask: 0x1f)                        */
#define CMAC_CM_DIAG_PORT4_REG_DIAG_WORD_Pos (0UL)                  /*!< DIAG_WORD (Bit 0)                                     */
#define CMAC_CM_DIAG_PORT4_REG_DIAG_WORD_Msk (0xfUL)                /*!< DIAG_WORD (Bitfield-Mask: 0x0f)                       */
/* ===================================================  CM_DIAG_PORT5_REG  =================================================== */
#define CMAC_CM_DIAG_PORT5_REG_DIAG_INV_Pos (16UL)                  /*!< DIAG_INV (Bit 16)                                     */
#define CMAC_CM_DIAG_PORT5_REG_DIAG_INV_Msk (0x10000UL)             /*!< DIAG_INV (Bitfield-Mask: 0x01)                        */
#define CMAC_CM_DIAG_PORT5_REG_DIAG_BIT_Pos (8UL)                   /*!< DIAG_BIT (Bit 8)                                      */
#define CMAC_CM_DIAG_PORT5_REG_DIAG_BIT_Msk (0x1f00UL)              /*!< DIAG_BIT (Bitfield-Mask: 0x1f)                        */
#define CMAC_CM_DIAG_PORT5_REG_DIAG_WORD_Pos (0UL)                  /*!< DIAG_WORD (Bit 0)                                     */
#define CMAC_CM_DIAG_PORT5_REG_DIAG_WORD_Msk (0xfUL)                /*!< DIAG_WORD (Bitfield-Mask: 0x0f)                       */
/* ===================================================  CM_DIAG_PORT6_REG  =================================================== */
#define CMAC_CM_DIAG_PORT6_REG_DIAG_INV_Pos (16UL)                  /*!< DIAG_INV (Bit 16)                                     */
#define CMAC_CM_DIAG_PORT6_REG_DIAG_INV_Msk (0x10000UL)             /*!< DIAG_INV (Bitfield-Mask: 0x01)                        */
#define CMAC_CM_DIAG_PORT6_REG_DIAG_BIT_Pos (8UL)                   /*!< DIAG_BIT (Bit 8)                                      */
#define CMAC_CM_DIAG_PORT6_REG_DIAG_BIT_Msk (0x1f00UL)              /*!< DIAG_BIT (Bitfield-Mask: 0x1f)                        */
#define CMAC_CM_DIAG_PORT6_REG_DIAG_WORD_Pos (0UL)                  /*!< DIAG_WORD (Bit 0)                                     */
#define CMAC_CM_DIAG_PORT6_REG_DIAG_WORD_Msk (0xfUL)                /*!< DIAG_WORD (Bitfield-Mask: 0x0f)                       */
/* ===================================================  CM_DIAG_PORT7_REG  =================================================== */
#define CMAC_CM_DIAG_PORT7_REG_DIAG_INV_Pos (16UL)                  /*!< DIAG_INV (Bit 16)                                     */
#define CMAC_CM_DIAG_PORT7_REG_DIAG_INV_Msk (0x10000UL)             /*!< DIAG_INV (Bitfield-Mask: 0x01)                        */
#define CMAC_CM_DIAG_PORT7_REG_DIAG_BIT_Pos (8UL)                   /*!< DIAG_BIT (Bit 8)                                      */
#define CMAC_CM_DIAG_PORT7_REG_DIAG_BIT_Msk (0x1f00UL)              /*!< DIAG_BIT (Bitfield-Mask: 0x1f)                        */
#define CMAC_CM_DIAG_PORT7_REG_DIAG_WORD_Pos (0UL)                  /*!< DIAG_WORD (Bit 0)                                     */
#define CMAC_CM_DIAG_PORT7_REG_DIAG_WORD_Msk (0xfUL)                /*!< DIAG_WORD (Bitfield-Mask: 0x0f)                       */
/* ===================================================  CM_DIAG_PORT8_REG  =================================================== */
#define CMAC_CM_DIAG_PORT8_REG_DIAG_INV_Pos (16UL)                  /*!< DIAG_INV (Bit 16)                                     */
#define CMAC_CM_DIAG_PORT8_REG_DIAG_INV_Msk (0x10000UL)             /*!< DIAG_INV (Bitfield-Mask: 0x01)                        */
#define CMAC_CM_DIAG_PORT8_REG_DIAG_BIT_Pos (8UL)                   /*!< DIAG_BIT (Bit 8)                                      */
#define CMAC_CM_DIAG_PORT8_REG_DIAG_BIT_Msk (0x1f00UL)              /*!< DIAG_BIT (Bitfield-Mask: 0x1f)                        */
#define CMAC_CM_DIAG_PORT8_REG_DIAG_WORD_Pos (0UL)                  /*!< DIAG_WORD (Bit 0)                                     */
#define CMAC_CM_DIAG_PORT8_REG_DIAG_WORD_Msk (0xfUL)                /*!< DIAG_WORD (Bitfield-Mask: 0x0f)                       */
/* ===================================================  CM_DIAG_PORT9_REG  =================================================== */
#define CMAC_CM_DIAG_PORT9_REG_DIAG_INV_Pos (16UL)                  /*!< DIAG_INV (Bit 16)                                     */
#define CMAC_CM_DIAG_PORT9_REG_DIAG_INV_Msk (0x10000UL)             /*!< DIAG_INV (Bitfield-Mask: 0x01)                        */
#define CMAC_CM_DIAG_PORT9_REG_DIAG_BIT_Pos (8UL)                   /*!< DIAG_BIT (Bit 8)                                      */
#define CMAC_CM_DIAG_PORT9_REG_DIAG_BIT_Msk (0x1f00UL)              /*!< DIAG_BIT (Bitfield-Mask: 0x1f)                        */
#define CMAC_CM_DIAG_PORT9_REG_DIAG_WORD_Pos (0UL)                  /*!< DIAG_WORD (Bit 0)                                     */
#define CMAC_CM_DIAG_PORT9_REG_DIAG_WORD_Msk (0xfUL)                /*!< DIAG_WORD (Bitfield-Mask: 0x0f)                       */
/* ===================================================  CM_DIAG_WORD0_REG  =================================================== */
#define CMAC_CM_DIAG_WORD0_REG_DIAG0_NULL_Pos (0UL)                 /*!< DIAG0_NULL (Bit 0)                                    */
#define CMAC_CM_DIAG_WORD0_REG_DIAG0_NULL_Msk (0x1UL)               /*!< DIAG0_NULL (Bitfield-Mask: 0x01)                      */
/* ==================================================  CM_DIAG_WORD10_REG  =================================================== */
#define CMAC_CM_DIAG_WORD10_REG_DIAG10_EV1C_DMA2CRYPTO_REQ_Pos (22UL) /*!< DIAG10_EV1C_DMA2CRYPTO_REQ (Bit 22)                 */
#define CMAC_CM_DIAG_WORD10_REG_DIAG10_EV1C_DMA2CRYPTO_REQ_Msk (0x400000UL) /*!< DIAG10_EV1C_DMA2CRYPTO_REQ (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_WORD10_REG_DIAG10_EV_CRYPTO_START_Pos (21UL)   /*!< DIAG10_EV_CRYPTO_START (Bit 21)                       */
#define CMAC_CM_DIAG_WORD10_REG_DIAG10_EV_CRYPTO_START_Msk (0x200000UL) /*!< DIAG10_EV_CRYPTO_START (Bitfield-Mask: 0x01)      */
#define CMAC_CM_DIAG_WORD10_REG_DIAG10_CRYPTO_BUSY_Pos (20UL)       /*!< DIAG10_CRYPTO_BUSY (Bit 20)                           */
#define CMAC_CM_DIAG_WORD10_REG_DIAG10_CRYPTO_BUSY_Msk (0x100000UL) /*!< DIAG10_CRYPTO_BUSY (Bitfield-Mask: 0x01)              */
#define CMAC_CM_DIAG_WORD10_REG_DIAG10_CRYPTO_MIC_ERROR_Pos (19UL)  /*!< DIAG10_CRYPTO_MIC_ERROR (Bit 19)                      */
#define CMAC_CM_DIAG_WORD10_REG_DIAG10_CRYPTO_MIC_ERROR_Msk (0x80000UL) /*!< DIAG10_CRYPTO_MIC_ERROR (Bitfield-Mask: 0x01)     */
#define CMAC_CM_DIAG_WORD10_REG_DIAG10_CRYPTO_SER_IN_REQ_Pos (18UL) /*!< DIAG10_CRYPTO_SER_IN_REQ (Bit 18)                     */
#define CMAC_CM_DIAG_WORD10_REG_DIAG10_CRYPTO_SER_IN_REQ_Msk (0x40000UL) /*!< DIAG10_CRYPTO_SER_IN_REQ (Bitfield-Mask: 0x01)   */
#define CMAC_CM_DIAG_WORD10_REG_DIAG10_CRYPTO_SER_OUT_REQ_Pos (17UL) /*!< DIAG10_CRYPTO_SER_OUT_REQ (Bit 17)                   */
#define CMAC_CM_DIAG_WORD10_REG_DIAG10_CRYPTO_SER_OUT_REQ_Msk (0x20000UL) /*!< DIAG10_CRYPTO_SER_OUT_REQ (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_WORD10_REG_DIAG10_CRYPTO_DMA_IN_CS_Pos (16UL)  /*!< DIAG10_CRYPTO_DMA_IN_CS (Bit 16)                      */
#define CMAC_CM_DIAG_WORD10_REG_DIAG10_CRYPTO_DMA_IN_CS_Msk (0x10000UL) /*!< DIAG10_CRYPTO_DMA_IN_CS (Bitfield-Mask: 0x01)     */
#define CMAC_CM_DIAG_WORD10_REG_DIAG10_CRYPTO_DMA_OUT_CS_Pos (14UL) /*!< DIAG10_CRYPTO_DMA_OUT_CS (Bit 14)                     */
#define CMAC_CM_DIAG_WORD10_REG_DIAG10_CRYPTO_DMA_OUT_CS_Msk (0x4000UL) /*!< DIAG10_CRYPTO_DMA_OUT_CS (Bitfield-Mask: 0x01)    */
#define CMAC_CM_DIAG_WORD10_REG_DIAG10_CRYPTO_RD_AUTH_Pos (12UL)    /*!< DIAG10_CRYPTO_RD_AUTH (Bit 12)                        */
#define CMAC_CM_DIAG_WORD10_REG_DIAG10_CRYPTO_RD_AUTH_Msk (0x1000UL) /*!< DIAG10_CRYPTO_RD_AUTH (Bitfield-Mask: 0x01)          */
#define CMAC_CM_DIAG_WORD10_REG_DIAG10_CRYPTO_RD_ADATA_Pos (11UL)   /*!< DIAG10_CRYPTO_RD_ADATA (Bit 11)                       */
#define CMAC_CM_DIAG_WORD10_REG_DIAG10_CRYPTO_RD_ADATA_Msk (0x800UL) /*!< DIAG10_CRYPTO_RD_ADATA (Bitfield-Mask: 0x01)         */
#define CMAC_CM_DIAG_WORD10_REG_DIAG10_CRYPTO_RD_ENCR_Pos (10UL)    /*!< DIAG10_CRYPTO_RD_ENCR (Bit 10)                        */
#define CMAC_CM_DIAG_WORD10_REG_DIAG10_CRYPTO_RD_ENCR_Msk (0x400UL) /*!< DIAG10_CRYPTO_RD_ENCR (Bitfield-Mask: 0x01)           */
#define CMAC_CM_DIAG_WORD10_REG_DIAG10_CRYPTO_RD_PLD_Pos (9UL)      /*!< DIAG10_CRYPTO_RD_PLD (Bit 9)                          */
#define CMAC_CM_DIAG_WORD10_REG_DIAG10_CRYPTO_RD_PLD_Msk (0x200UL)  /*!< DIAG10_CRYPTO_RD_PLD (Bitfield-Mask: 0x01)            */
#define CMAC_CM_DIAG_WORD10_REG_DIAG10_CRYPTO_RD_CNT_Pos (0UL)      /*!< DIAG10_CRYPTO_RD_CNT (Bit 0)                          */
#define CMAC_CM_DIAG_WORD10_REG_DIAG10_CRYPTO_RD_CNT_Msk (0x1ffUL)  /*!< DIAG10_CRYPTO_RD_CNT (Bitfield-Mask: 0x1ff)           */
/* ===================================================  CM_DIAG_WORD1_REG  =================================================== */
#define CMAC_CM_DIAG_WORD1_REG_DIAG1_SIGNAL_DETECTED_Pos (10UL)     /*!< DIAG1_SIGNAL_DETECTED (Bit 10)                        */
#define CMAC_CM_DIAG_WORD1_REG_DIAG1_SIGNAL_DETECTED_Msk (0x400UL)  /*!< DIAG1_SIGNAL_DETECTED (Bitfield-Mask: 0x01)           */
#define CMAC_CM_DIAG_WORD1_REG_DIAG1_MATCH0101_Pos (9UL)            /*!< DIAG1_MATCH0101 (Bit 9)                               */
#define CMAC_CM_DIAG_WORD1_REG_DIAG1_MATCH0101_Msk (0x200UL)        /*!< DIAG1_MATCH0101 (Bitfield-Mask: 0x01)                 */
#define CMAC_CM_DIAG_WORD1_REG_DIAG1_SYNC_FOUND_Pos (8UL)           /*!< DIAG1_SYNC_FOUND (Bit 8)                              */
#define CMAC_CM_DIAG_WORD1_REG_DIAG1_SYNC_FOUND_Msk (0x100UL)       /*!< DIAG1_SYNC_FOUND (Bitfield-Mask: 0x01)                */
#define CMAC_CM_DIAG_WORD1_REG_DIAG1_PHY_TX_EN_RFCU_Pos (7UL)       /*!< DIAG1_PHY_TX_EN_RFCU (Bit 7)                          */
#define CMAC_CM_DIAG_WORD1_REG_DIAG1_PHY_TX_EN_RFCU_Msk (0x80UL)    /*!< DIAG1_PHY_TX_EN_RFCU (Bitfield-Mask: 0x01)            */
#define CMAC_CM_DIAG_WORD1_REG_DIAG1_PHY_RX_EN_RFCU_Pos (6UL)       /*!< DIAG1_PHY_RX_EN_RFCU (Bit 6)                          */
#define CMAC_CM_DIAG_WORD1_REG_DIAG1_PHY_RX_EN_RFCU_Msk (0x40UL)    /*!< DIAG1_PHY_RX_EN_RFCU (Bitfield-Mask: 0x01)            */
#define CMAC_CM_DIAG_WORD1_REG_DIAG1_DCF_26_Pos (5UL)               /*!< DIAG1_DCF_26 (Bit 5)                                  */
#define CMAC_CM_DIAG_WORD1_REG_DIAG1_DCF_26_Msk (0x20UL)            /*!< DIAG1_DCF_26 (Bitfield-Mask: 0x01)                    */
#define CMAC_CM_DIAG_WORD1_REG_DIAG1_DCF_25_Pos (4UL)               /*!< DIAG1_DCF_25 (Bit 4)                                  */
#define CMAC_CM_DIAG_WORD1_REG_DIAG1_DCF_25_Msk (0x10UL)            /*!< DIAG1_DCF_25 (Bitfield-Mask: 0x01)                    */
#define CMAC_CM_DIAG_WORD1_REG_DIAG1_DCF_24_Pos (3UL)               /*!< DIAG1_DCF_24 (Bit 3)                                  */
#define CMAC_CM_DIAG_WORD1_REG_DIAG1_DCF_24_Msk (0x8UL)             /*!< DIAG1_DCF_24 (Bitfield-Mask: 0x01)                    */
#define CMAC_CM_DIAG_WORD1_REG_DIAG1_DCF_23_Pos (2UL)               /*!< DIAG1_DCF_23 (Bit 2)                                  */
#define CMAC_CM_DIAG_WORD1_REG_DIAG1_DCF_23_Msk (0x4UL)             /*!< DIAG1_DCF_23 (Bitfield-Mask: 0x01)                    */
#define CMAC_CM_DIAG_WORD1_REG_DIAG1_DCF_22_Pos (1UL)               /*!< DIAG1_DCF_22 (Bit 1)                                  */
#define CMAC_CM_DIAG_WORD1_REG_DIAG1_DCF_22_Msk (0x2UL)             /*!< DIAG1_DCF_22 (Bitfield-Mask: 0x01)                    */
#define CMAC_CM_DIAG_WORD1_REG_DIAG1_DCF_21_Pos (0UL)               /*!< DIAG1_DCF_21 (Bit 0)                                  */
#define CMAC_CM_DIAG_WORD1_REG_DIAG1_DCF_21_Msk (0x1UL)             /*!< DIAG1_DCF_21 (Bitfield-Mask: 0x01)                    */
/* ===================================================  CM_DIAG_WORD2_REG  =================================================== */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_TX_DATA_ENVELOP_Pos (18UL) /*!< DIAG2_PHY_TX_DATA_ENVELOP (Bit 18)                    */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_TX_DATA_ENVELOP_Msk (0x40000UL) /*!< DIAG2_PHY_TX_DATA_ENVELOP (Bitfield-Mask: 0x01)  */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_RX_EN_TMP_Pos (17UL)       /*!< DIAG2_PHY_RX_EN_TMP (Bit 17)                          */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_RX_EN_TMP_Msk (0x20000UL)  /*!< DIAG2_PHY_RX_EN_TMP (Bitfield-Mask: 0x01)             */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_TX_EN_TMP_Pos (16UL)       /*!< DIAG2_PHY_TX_EN_TMP (Bit 16)                          */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_TX_EN_TMP_Msk (0x10000UL)  /*!< DIAG2_PHY_TX_EN_TMP (Bitfield-Mask: 0x01)             */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_RX_EN_Pos (15UL)           /*!< DIAG2_PHY_RX_EN (Bit 15)                              */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_RX_EN_Msk (0x8000UL)       /*!< DIAG2_PHY_RX_EN (Bitfield-Mask: 0x01)                 */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_TX_EN_Pos (14UL)           /*!< DIAG2_PHY_TX_EN (Bit 14)                              */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_TX_EN_Msk (0x4000UL)       /*!< DIAG2_PHY_TX_EN (Bitfield-Mask: 0x01)                 */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_RX_DATA_EN_Pos (13UL)      /*!< DIAG2_PHY_RX_DATA_EN (Bit 13)                         */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_RX_DATA_EN_Msk (0x2000UL)  /*!< DIAG2_PHY_RX_DATA_EN (Bitfield-Mask: 0x01)            */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_RX_DATA_SAMPLED_Pos (12UL) /*!< DIAG2_PHY_RX_DATA_SAMPLED (Bit 12)                    */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_RX_DATA_SAMPLED_Msk (0x1000UL) /*!< DIAG2_PHY_RX_DATA_SAMPLED (Bitfield-Mask: 0x01)   */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_RX_DATA_CORR_Pos (11UL)    /*!< DIAG2_PHY_RX_DATA_CORR (Bit 11)                       */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_RX_DATA_CORR_Msk (0x800UL) /*!< DIAG2_PHY_RX_DATA_CORR (Bitfield-Mask: 0x01)          */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_RX_DATA_Pos (10UL)         /*!< DIAG2_PHY_RX_DATA (Bit 10)                            */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_RX_DATA_Msk (0x400UL)      /*!< DIAG2_PHY_RX_DATA (Bitfield-Mask: 0x01)               */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_TX_DATA_EN_Pos (9UL)       /*!< DIAG2_PHY_TX_DATA_EN (Bit 9)                          */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_TX_DATA_EN_Msk (0x200UL)   /*!< DIAG2_PHY_TX_DATA_EN (Bitfield-Mask: 0x01)            */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_TX_DATA_Pos (8UL)          /*!< DIAG2_PHY_TX_DATA (Bit 8)                             */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_TX_DATA_Msk (0x100UL)      /*!< DIAG2_PHY_TX_DATA (Bitfield-Mask: 0x01)               */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_TXRX_DATA_B4WHITE_Pos (7UL) /*!< DIAG2_PHY_TXRX_DATA_B4WHITE (Bit 7)                  */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_TXRX_DATA_B4WHITE_Msk (0x80UL) /*!< DIAG2_PHY_TXRX_DATA_B4WHITE (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_TXRX_DATA_Pos (6UL)        /*!< DIAG2_PHY_TXRX_DATA (Bit 6)                           */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_TXRX_DATA_Msk (0x40UL)     /*!< DIAG2_PHY_TXRX_DATA (Bitfield-Mask: 0x01)             */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_RDY4BS_INT_Pos (5UL)       /*!< DIAG2_PHY_RDY4BS_INT (Bit 5)                          */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_RDY4BS_INT_Msk (0x20UL)    /*!< DIAG2_PHY_RDY4BS_INT (Bitfield-Mask: 0x01)            */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_BUSY_BUF_Pos (4UL)         /*!< DIAG2_PHY_BUSY_BUF (Bit 4)                            */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_BUSY_BUF_Msk (0x10UL)      /*!< DIAG2_PHY_BUSY_BUF (Bitfield-Mask: 0x01)              */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_CORR_SHIFT_EN_Pos (3UL)        /*!< DIAG2_CORR_SHIFT_EN (Bit 3)                           */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_CORR_SHIFT_EN_Msk (0x8UL)      /*!< DIAG2_CORR_SHIFT_EN (Bitfield-Mask: 0x01)             */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_CORR_COMB_Pos (2UL)            /*!< DIAG2_CORR_COMB (Bit 2)                               */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_CORR_COMB_Msk (0x4UL)          /*!< DIAG2_CORR_COMB (Bitfield-Mask: 0x01)                 */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_TXRX_DATA_EN_COMB_Pos (1UL) /*!< DIAG2_PHY_TXRX_DATA_EN_COMB (Bit 1)                  */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_TXRX_DATA_EN_COMB_Msk (0x2UL) /*!< DIAG2_PHY_TXRX_DATA_EN_COMB (Bitfield-Mask: 0x01)  */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_TXRX_DATA_COMB_Pos (0UL)   /*!< DIAG2_PHY_TXRX_DATA_COMB (Bit 0)                      */
#define CMAC_CM_DIAG_WORD2_REG_DIAG2_PHY_TXRX_DATA_COMB_Msk (0x1UL) /*!< DIAG2_PHY_TXRX_DATA_COMB (Bitfield-Mask: 0x01)        */
/* ===================================================  CM_DIAG_WORD3_REG  =================================================== */
#define CMAC_CM_DIAG_WORD3_REG_DIAG3_AOAD_PORT_Pos (24UL)           /*!< DIAG3_AOAD_PORT (Bit 24)                              */
#define CMAC_CM_DIAG_WORD3_REG_DIAG3_AOAD_PORT_Msk (0xff000000UL)   /*!< DIAG3_AOAD_PORT (Bitfield-Mask: 0xff)                 */
#define CMAC_CM_DIAG_WORD3_REG_DIAG3_FRAME_COEX_PTI_Pos (23UL)      /*!< DIAG3_FRAME_COEX_PTI (Bit 23)                         */
#define CMAC_CM_DIAG_WORD3_REG_DIAG3_FRAME_COEX_PTI_Msk (0x800000UL) /*!< DIAG3_FRAME_COEX_PTI (Bitfield-Mask: 0x01)           */
#define CMAC_CM_DIAG_WORD3_REG_DIAG3_COEX_MASKS_TXRX_EN_Pos (22UL)  /*!< DIAG3_COEX_MASKS_TXRX_EN (Bit 22)                     */
#define CMAC_CM_DIAG_WORD3_REG_DIAG3_COEX_MASKS_TXRX_EN_Msk (0x400000UL) /*!< DIAG3_COEX_MASKS_TXRX_EN (Bitfield-Mask: 0x01)   */
#define CMAC_CM_DIAG_WORD3_REG_DIAG3_COEX_EXT_ACT_BUF_Pos (21UL)    /*!< DIAG3_COEX_EXT_ACT_BUF (Bit 21)                       */
#define CMAC_CM_DIAG_WORD3_REG_DIAG3_COEX_EXT_ACT_BUF_Msk (0x200000UL) /*!< DIAG3_COEX_EXT_ACT_BUF (Bitfield-Mask: 0x01)       */
#define CMAC_CM_DIAG_WORD3_REG_DIAG3_TCLK_FROM_PCLK_Pos (20UL)      /*!< DIAG3_TCLK_FROM_PCLK (Bit 20)                         */
#define CMAC_CM_DIAG_WORD3_REG_DIAG3_TCLK_FROM_PCLK_Msk (0x100000UL) /*!< DIAG3_TCLK_FROM_PCLK (Bitfield-Mask: 0x01)           */
#define CMAC_CM_DIAG_WORD3_REG_DIAG3_SLP_TIMER_ACTIVE_Pos (19UL)    /*!< DIAG3_SLP_TIMER_ACTIVE (Bit 19)                       */
#define CMAC_CM_DIAG_WORD3_REG_DIAG3_SLP_TIMER_ACTIVE_Msk (0x80000UL) /*!< DIAG3_SLP_TIMER_ACTIVE (Bitfield-Mask: 0x01)        */
#define CMAC_CM_DIAG_WORD3_REG_DIAG3_TS1_DIRTY_Pos (18UL)           /*!< DIAG3_TS1_DIRTY (Bit 18)                              */
#define CMAC_CM_DIAG_WORD3_REG_DIAG3_TS1_DIRTY_Msk (0x40000UL)      /*!< DIAG3_TS1_DIRTY (Bitfield-Mask: 0x01)                 */
#define CMAC_CM_DIAG_WORD3_REG_DIAG3_CALLBACK_IRQ_VALID_Pos (17UL)  /*!< DIAG3_CALLBACK_IRQ_VALID (Bit 17)                     */
#define CMAC_CM_DIAG_WORD3_REG_DIAG3_CALLBACK_IRQ_VALID_Msk (0x20000UL) /*!< DIAG3_CALLBACK_IRQ_VALID (Bitfield-Mask: 0x01)    */
#define CMAC_CM_DIAG_WORD3_REG_DIAG3_CM_EV_LINKUP_REG_WR_P_Pos (16UL) /*!< DIAG3_CM_EV_LINKUP_REG_WR_P (Bit 16)                */
#define CMAC_CM_DIAG_WORD3_REG_DIAG3_CM_EV_LINKUP_REG_WR_P_Msk (0x10000UL) /*!< DIAG3_CM_EV_LINKUP_REG_WR_P (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_WORD3_REG_DIAG3_CM_WHITENING_REG_WR_P_Pos (15UL) /*!< DIAG3_CM_WHITENING_REG_WR_P (Bit 15)                */
#define CMAC_CM_DIAG_WORD3_REG_DIAG3_CM_WHITENING_REG_WR_P_Msk (0x8000UL) /*!< DIAG3_CM_WHITENING_REG_WR_P (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_WORD3_REG_DIAG3_CM_CRC_REG_WR_P_Pos (14UL)     /*!< DIAG3_CM_CRC_REG_WR_P (Bit 14)                        */
#define CMAC_CM_DIAG_WORD3_REG_DIAG3_CM_CRC_REG_WR_P_Msk (0x4000UL) /*!< DIAG3_CM_CRC_REG_WR_P (Bitfield-Mask: 0x01)           */
#define CMAC_CM_DIAG_WORD3_REG_DIAG3_CRC_ZERO_Pos (13UL)            /*!< DIAG3_CRC_ZERO (Bit 13)                               */
#define CMAC_CM_DIAG_WORD3_REG_DIAG3_CRC_ZERO_Msk (0x2000UL)        /*!< DIAG3_CRC_ZERO (Bitfield-Mask: 0x01)                  */
#define CMAC_CM_DIAG_WORD3_REG_DIAG3_DMA2BS_RDY_Pos (12UL)          /*!< DIAG3_DMA2BS_RDY (Bit 12)                             */
#define CMAC_CM_DIAG_WORD3_REG_DIAG3_DMA2BS_RDY_Msk (0x1000UL)      /*!< DIAG3_DMA2BS_RDY (Bitfield-Mask: 0x01)                */
#define CMAC_CM_DIAG_WORD3_REG_DIAG3_BS_SMPL_VALID_Pos (11UL)       /*!< DIAG3_BS_SMPL_VALID (Bit 11)                          */
#define CMAC_CM_DIAG_WORD3_REG_DIAG3_BS_SMPL_VALID_Msk (0x800UL)    /*!< DIAG3_BS_SMPL_VALID (Bitfield-Mask: 0x01)             */
#define CMAC_CM_DIAG_WORD3_REG_DIAG3_CLK_EV_OFFSET_CHANGE_Pos (10UL) /*!< DIAG3_CLK_EV_OFFSET_CHANGE (Bit 10)                  */
#define CMAC_CM_DIAG_WORD3_REG_DIAG3_CLK_EV_OFFSET_CHANGE_Msk (0x400UL) /*!< DIAG3_CLK_EV_OFFSET_CHANGE (Bitfield-Mask: 0x01)  */
#define CMAC_CM_DIAG_WORD3_REG_DIAG3_CLK_EV_OFFSET_Pos (4UL)        /*!< DIAG3_CLK_EV_OFFSET (Bit 4)                           */
#define CMAC_CM_DIAG_WORD3_REG_DIAG3_CLK_EV_OFFSET_Msk (0x3f0UL)    /*!< DIAG3_CLK_EV_OFFSET (Bitfield-Mask: 0x3f)             */
/* ===================================================  CM_DIAG_WORD4_REG  =================================================== */
#define CMAC_CM_DIAG_WORD4_REG_DIAG4_SWD_ATTACHED_Pos (31UL)        /*!< DIAG4_SWD_ATTACHED (Bit 31)                           */
#define CMAC_CM_DIAG_WORD4_REG_DIAG4_SWD_ATTACHED_Msk (0x80000000UL) /*!< DIAG4_SWD_ATTACHED (Bitfield-Mask: 0x01)             */
#define CMAC_CM_DIAG_WORD4_REG_DIAG4_MCPU_HMASTER_Pos (30UL)        /*!< DIAG4_MCPU_HMASTER (Bit 30)                           */
#define CMAC_CM_DIAG_WORD4_REG_DIAG4_MCPU_HMASTER_Msk (0x40000000UL) /*!< DIAG4_MCPU_HMASTER (Bitfield-Mask: 0x01)             */
#define CMAC_CM_DIAG_WORD4_REG_DIAG4_MCPU_SYS_RST_REQ_Pos (29UL)    /*!< DIAG4_MCPU_SYS_RST_REQ (Bit 29)                       */
#define CMAC_CM_DIAG_WORD4_REG_DIAG4_MCPU_SYS_RST_REQ_Msk (0x20000000UL) /*!< DIAG4_MCPU_SYS_RST_REQ (Bitfield-Mask: 0x01)     */
#define CMAC_CM_DIAG_WORD4_REG_DIAG4_MCPU_HALTED_BUF_Pos (28UL)     /*!< DIAG4_MCPU_HALTED_BUF (Bit 28)                        */
#define CMAC_CM_DIAG_WORD4_REG_DIAG4_MCPU_HALTED_BUF_Msk (0x10000000UL) /*!< DIAG4_MCPU_HALTED_BUF (Bitfield-Mask: 0x01)       */
#define CMAC_CM_DIAG_WORD4_REG_DIAG4_SLEEPING_Pos (27UL)            /*!< DIAG4_SLEEPING (Bit 27)                               */
#define CMAC_CM_DIAG_WORD4_REG_DIAG4_SLEEPING_Msk (0x8000000UL)     /*!< DIAG4_SLEEPING (Bitfield-Mask: 0x01)                  */
#define CMAC_CM_DIAG_WORD4_REG_DIAG4_TIMERS_HALT_Pos (25UL)         /*!< DIAG4_TIMERS_HALT (Bit 25)                            */
#define CMAC_CM_DIAG_WORD4_REG_DIAG4_TIMERS_HALT_Msk (0x2000000UL)  /*!< DIAG4_TIMERS_HALT (Bitfield-Mask: 0x01)               */
#define CMAC_CM_DIAG_WORD4_REG_DIAG4_MCPU_LOCKUP_Pos (23UL)         /*!< DIAG4_MCPU_LOCKUP (Bit 23)                            */
#define CMAC_CM_DIAG_WORD4_REG_DIAG4_MCPU_LOCKUP_Msk (0x800000UL)   /*!< DIAG4_MCPU_LOCKUP (Bitfield-Mask: 0x01)               */
#define CMAC_CM_DIAG_WORD4_REG_DIAG4_MCPU_NMI_Pos (22UL)            /*!< DIAG4_MCPU_NMI (Bit 22)                               */
#define CMAC_CM_DIAG_WORD4_REG_DIAG4_MCPU_NMI_Msk (0x400000UL)      /*!< DIAG4_MCPU_NMI (Bitfield-Mask: 0x01)                  */
#define CMAC_CM_DIAG_WORD4_REG_DIAG4_MCPU_RXEV_Pos (21UL)           /*!< DIAG4_MCPU_RXEV (Bit 21)                              */
#define CMAC_CM_DIAG_WORD4_REG_DIAG4_MCPU_RXEV_Msk (0x200000UL)     /*!< DIAG4_MCPU_RXEV (Bitfield-Mask: 0x01)                 */
#define CMAC_CM_DIAG_WORD4_REG_DIAG4_MCPU_TXEV_Pos (20UL)           /*!< DIAG4_MCPU_TXEV (Bit 20)                              */
#define CMAC_CM_DIAG_WORD4_REG_DIAG4_MCPU_TXEV_Msk (0x100000UL)     /*!< DIAG4_MCPU_TXEV (Bitfield-Mask: 0x01)                 */
#define CMAC_CM_DIAG_WORD4_REG_DIAG4_MCPU_HREADY_Pos (17UL)         /*!< DIAG4_MCPU_HREADY (Bit 17)                            */
#define CMAC_CM_DIAG_WORD4_REG_DIAG4_MCPU_HREADY_Msk (0x20000UL)    /*!< DIAG4_MCPU_HREADY (Bitfield-Mask: 0x01)               */
#define CMAC_CM_DIAG_WORD4_REG_DIAG4_DSER_Pos (0UL)                 /*!< DIAG4_DSER (Bit 0)                                    */
#define CMAC_CM_DIAG_WORD4_REG_DIAG4_DSER_Msk (0x1UL)               /*!< DIAG4_DSER (Bitfield-Mask: 0x01)                      */
/* ===================================================  CM_DIAG_WORD5_REG  =================================================== */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV1C_LP_CLK_TOGGLE_Pos (16UL)  /*!< DIAG5_EV1C_LP_CLK_TOGGLE (Bit 16)                     */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV1C_LP_CLK_TOGGLE_Msk (0x10000UL) /*!< DIAG5_EV1C_LP_CLK_TOGGLE (Bitfield-Mask: 0x01)    */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV1C_TS1_TRIGGER_Pos (15UL)    /*!< DIAG5_EV1C_TS1_TRIGGER (Bit 15)                       */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV1C_TS1_TRIGGER_Msk (0x8000UL) /*!< DIAG5_EV1C_TS1_TRIGGER (Bitfield-Mask: 0x01)         */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV1C_BS2MC_DMA_CRITICAL_Pos (14UL) /*!< DIAG5_EV1C_BS2MC_DMA_CRITICAL (Bit 14)            */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV1C_BS2MC_DMA_CRITICAL_Msk (0x4000UL) /*!< DIAG5_EV1C_BS2MC_DMA_CRITICAL (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV1C_BS2DMA_REQ_Pos (13UL)     /*!< DIAG5_EV1C_BS2DMA_REQ (Bit 13)                        */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV1C_BS2DMA_REQ_Msk (0x2000UL) /*!< DIAG5_EV1C_BS2DMA_REQ (Bitfield-Mask: 0x01)           */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV1US_PHY_TO_IDLE_Pos (12UL)   /*!< DIAG5_EV1US_PHY_TO_IDLE (Bit 12)                      */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV1US_PHY_TO_IDLE_Msk (0x1000UL) /*!< DIAG5_EV1US_PHY_TO_IDLE (Bitfield-Mask: 0x01)       */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV1C_FRAME_REG_POP_Pos (11UL)  /*!< DIAG5_EV1C_FRAME_REG_POP (Bit 11)                     */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV1C_FRAME_REG_POP_Msk (0x800UL) /*!< DIAG5_EV1C_FRAME_REG_POP (Bitfield-Mask: 0x01)      */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV_FIELD_REG_POP_Pos (10UL)    /*!< DIAG5_EV_FIELD_REG_POP (Bit 10)                       */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV_FIELD_REG_POP_Msk (0x400UL) /*!< DIAG5_EV_FIELD_REG_POP (Bitfield-Mask: 0x01)          */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV1US_CORR_TIMEOUT_Pos (9UL)   /*!< DIAG5_EV1US_CORR_TIMEOUT (Bit 9)                      */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV1US_CORR_TIMEOUT_Msk (0x200UL) /*!< DIAG5_EV1US_CORR_TIMEOUT (Bitfield-Mask: 0x01)      */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV1C_FIELD_ON_THR_EXP_Pos (8UL) /*!< DIAG5_EV1C_FIELD_ON_THR_EXP (Bit 8)                  */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV1C_FIELD_ON_THR_EXP_Msk (0x100UL) /*!< DIAG5_EV1C_FIELD_ON_THR_EXP (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV1C_BS_SMPL_BUF_Pos (7UL)     /*!< DIAG5_EV1C_BS_SMPL_BUF (Bit 7)                        */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV1C_BS_SMPL_BUF_Msk (0x80UL)  /*!< DIAG5_EV1C_BS_SMPL_BUF (Bitfield-Mask: 0x01)          */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV_WINDOW_CNT_THR_EXP_Pos (6UL) /*!< DIAG5_EV_WINDOW_CNT_THR_EXP (Bit 6)                  */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV_WINDOW_CNT_THR_EXP_Msk (0x40UL) /*!< DIAG5_EV_WINDOW_CNT_THR_EXP (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV1C_BS_STOP_Pos (5UL)         /*!< DIAG5_EV1C_BS_STOP (Bit 5)                            */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV1C_BS_STOP_Msk (0x20UL)      /*!< DIAG5_EV1C_BS_STOP (Bitfield-Mask: 0x01)              */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV_BS_START_Pos (4UL)          /*!< DIAG5_EV_BS_START (Bit 4)                             */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV_BS_START_Msk (0x10UL)       /*!< DIAG5_EV_BS_START (Bitfield-Mask: 0x01)               */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV1US_FRAME_START_Pos (3UL)    /*!< DIAG5_EV1US_FRAME_START (Bit 3)                       */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV1US_FRAME_START_Msk (0x8UL)  /*!< DIAG5_EV1US_FRAME_START (Bitfield-Mask: 0x01)         */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV_SYMBOL_Pos (2UL)            /*!< DIAG5_EV_SYMBOL (Bit 2)                               */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV_SYMBOL_Msk (0x4UL)          /*!< DIAG5_EV_SYMBOL (Bitfield-Mask: 0x01)                 */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV1C_CLK_EV_Pos (1UL)          /*!< DIAG5_EV1C_CLK_EV (Bit 1)                             */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV1C_CLK_EV_Msk (0x2UL)        /*!< DIAG5_EV1C_CLK_EV (Bitfield-Mask: 0x01)               */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV1C_CLK_1MHZ_Pos (0UL)        /*!< DIAG5_EV1C_CLK_1MHZ (Bit 0)                           */
#define CMAC_CM_DIAG_WORD5_REG_DIAG5_EV1C_CLK_1MHZ_Msk (0x1UL)      /*!< DIAG5_EV1C_CLK_1MHZ (Bitfield-Mask: 0x01)             */
/* ===================================================  CM_DIAG_WORD6_REG  =================================================== */
#define CMAC_CM_DIAG_WORD6_REG_DIAG6_CMAC_ON_ERROR_Pos (31UL)       /*!< DIAG6_CMAC_ON_ERROR (Bit 31)                          */
#define CMAC_CM_DIAG_WORD6_REG_DIAG6_CMAC_ON_ERROR_Msk (0x80000000UL) /*!< DIAG6_CMAC_ON_ERROR (Bitfield-Mask: 0x01)           */
#define CMAC_CM_DIAG_WORD6_REG_DIAG6_CM_BS_WINDOW_CNT_REG_Pos (26UL) /*!< DIAG6_CM_BS_WINDOW_CNT_REG (Bit 26)                  */
#define CMAC_CM_DIAG_WORD6_REG_DIAG6_CM_BS_WINDOW_CNT_REG_Msk (0x7c000000UL) /*!< DIAG6_CM_BS_WINDOW_CNT_REG (Bitfield-Mask: 0x1f) */
#define CMAC_CM_DIAG_WORD6_REG_DIAG6_FRAME_TIMER_Pos (12UL)         /*!< DIAG6_FRAME_TIMER (Bit 12)                            */
#define CMAC_CM_DIAG_WORD6_REG_DIAG6_FRAME_TIMER_Msk (0x3fff000UL)  /*!< DIAG6_FRAME_TIMER (Bitfield-Mask: 0x3fff)             */
#define CMAC_CM_DIAG_WORD6_REG_DIAG6_FIELD_CNT_Pos (8UL)            /*!< DIAG6_FIELD_CNT (Bit 8)                               */
#define CMAC_CM_DIAG_WORD6_REG_DIAG6_FIELD_CNT_Msk (0xf00UL)        /*!< DIAG6_FIELD_CNT (Bitfield-Mask: 0x0f)                 */
#define CMAC_CM_DIAG_WORD6_REG_DIAG6_BS_FSM_Pos (4UL)               /*!< DIAG6_BS_FSM (Bit 4)                                  */
#define CMAC_CM_DIAG_WORD6_REG_DIAG6_BS_FSM_Msk (0x70UL)            /*!< DIAG6_BS_FSM (Bitfield-Mask: 0x07)                    */
#define CMAC_CM_DIAG_WORD6_REG_DIAG6_FRAME_FSM_Pos (0UL)            /*!< DIAG6_FRAME_FSM (Bit 0)                               */
#define CMAC_CM_DIAG_WORD6_REG_DIAG6_FRAME_FSM_Msk (0x7UL)          /*!< DIAG6_FRAME_FSM (Bitfield-Mask: 0x07)                 */
/* ===================================================  CM_DIAG_WORD7_REG  =================================================== */
#define CMAC_CM_DIAG_WORD7_REG_DIAG7_CM_FIELD_4_VALID_Pos (31UL)    /*!< DIAG7_CM_FIELD_4_VALID (Bit 31)                       */
#define CMAC_CM_DIAG_WORD7_REG_DIAG7_CM_FIELD_4_VALID_Msk (0x80000000UL) /*!< DIAG7_CM_FIELD_4_VALID (Bitfield-Mask: 0x01)     */
#define CMAC_CM_DIAG_WORD7_REG_DIAG7_CM_FIELD_2_VALID_Pos (30UL)    /*!< DIAG7_CM_FIELD_2_VALID (Bit 30)                       */
#define CMAC_CM_DIAG_WORD7_REG_DIAG7_CM_FIELD_2_VALID_Msk (0x40000000UL) /*!< DIAG7_CM_FIELD_2_VALID (Bitfield-Mask: 0x01)     */
#define CMAC_CM_DIAG_WORD7_REG_DIAG7_CM_FIELD_1_VALID_Pos (29UL)    /*!< DIAG7_CM_FIELD_1_VALID (Bit 29)                       */
#define CMAC_CM_DIAG_WORD7_REG_DIAG7_CM_FIELD_1_VALID_Msk (0x20000000UL) /*!< DIAG7_CM_FIELD_1_VALID (Bitfield-Mask: 0x01)     */
#define CMAC_CM_DIAG_WORD7_REG_DIAG7_REGF_WR_P_Pos (28UL)           /*!< DIAG7_REGF_WR_P (Bit 28)                              */
#define CMAC_CM_DIAG_WORD7_REG_DIAG7_REGF_WR_P_Msk (0x10000000UL)   /*!< DIAG7_REGF_WR_P (Bitfield-Mask: 0x01)                 */
#define CMAC_CM_DIAG_WORD7_REG_DIAG7_REGF_RD_P_Pos (27UL)           /*!< DIAG7_REGF_RD_P (Bit 27)                              */
#define CMAC_CM_DIAG_WORD7_REG_DIAG7_REGF_RD_P_Msk (0x8000000UL)    /*!< DIAG7_REGF_RD_P (Bitfield-Mask: 0x01)                 */
#define CMAC_CM_DIAG_WORD7_REG_DIAG7_CM_BS_SMPL_ST_FST_RD_P_Pos (26UL) /*!< DIAG7_CM_BS_SMPL_ST_FST_RD_P (Bit 26)              */
#define CMAC_CM_DIAG_WORD7_REG_DIAG7_CM_BS_SMPL_ST_FST_RD_P_Msk (0x4000000UL) /*!< DIAG7_CM_BS_SMPL_ST_FST_RD_P (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_WORD7_REG_DIAG7_MEMCTRL_MCPU_IDLE_REQ_Pos (10UL) /*!< DIAG7_MEMCTRL_MCPU_IDLE_REQ (Bit 10)                */
#define CMAC_CM_DIAG_WORD7_REG_DIAG7_MEMCTRL_MCPU_IDLE_REQ_Msk (0x400UL) /*!< DIAG7_MEMCTRL_MCPU_IDLE_REQ (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_WORD7_REG_DIAG7_CRYPTO2MC_CS_Pos (6UL)         /*!< DIAG7_CRYPTO2MC_CS (Bit 6)                            */
#define CMAC_CM_DIAG_WORD7_REG_DIAG7_CRYPTO2MC_CS_Msk (0x40UL)      /*!< DIAG7_CRYPTO2MC_CS (Bitfield-Mask: 0x01)              */
#define CMAC_CM_DIAG_WORD7_REG_DIAG7_MC2DMA_RDY_Pos (5UL)           /*!< DIAG7_MC2DMA_RDY (Bit 5)                              */
#define CMAC_CM_DIAG_WORD7_REG_DIAG7_MC2DMA_RDY_Msk (0x20UL)        /*!< DIAG7_MC2DMA_RDY (Bitfield-Mask: 0x01)                */
#define CMAC_CM_DIAG_WORD7_REG_DIAG7_DMA2MC_CS_Pos (4UL)            /*!< DIAG7_DMA2MC_CS (Bit 4)                               */
#define CMAC_CM_DIAG_WORD7_REG_DIAG7_DMA2MC_CS_Msk (0x10UL)         /*!< DIAG7_DMA2MC_CS (Bitfield-Mask: 0x01)                 */
#define CMAC_CM_DIAG_WORD7_REG_DIAG7_ADDR_CYCLE_FOR_2_Pos (2UL)     /*!< DIAG7_ADDR_CYCLE_FOR_2 (Bit 2)                        */
#define CMAC_CM_DIAG_WORD7_REG_DIAG7_ADDR_CYCLE_FOR_2_Msk (0x4UL)   /*!< DIAG7_ADDR_CYCLE_FOR_2 (Bitfield-Mask: 0x01)          */
#define CMAC_CM_DIAG_WORD7_REG_DIAG7_ADDR_CYCLE_FOR_1_Pos (1UL)     /*!< DIAG7_ADDR_CYCLE_FOR_1 (Bit 1)                        */
#define CMAC_CM_DIAG_WORD7_REG_DIAG7_ADDR_CYCLE_FOR_1_Msk (0x2UL)   /*!< DIAG7_ADDR_CYCLE_FOR_1 (Bitfield-Mask: 0x01)          */
#define CMAC_CM_DIAG_WORD7_REG_DIAG7_ADDR_CYCLE_FOR_0_Pos (0UL)     /*!< DIAG7_ADDR_CYCLE_FOR_0 (Bit 0)                        */
#define CMAC_CM_DIAG_WORD7_REG_DIAG7_ADDR_CYCLE_FOR_0_Msk (0x1UL)   /*!< DIAG7_ADDR_CYCLE_FOR_0 (Bitfield-Mask: 0x01)          */
/* ===================================================  CM_DIAG_WORD8_REG  =================================================== */
#define CMAC_CM_DIAG_WORD8_REG_DIAG8_EV1US_LL_TIMER1_EQ_Y_Pos (31UL) /*!< DIAG8_EV1US_LL_TIMER1_EQ_Y (Bit 31)                  */
#define CMAC_CM_DIAG_WORD8_REG_DIAG8_EV1US_LL_TIMER1_EQ_Y_Msk (0x80000000UL) /*!< DIAG8_EV1US_LL_TIMER1_EQ_Y (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_WORD8_REG_DIAG8_EV1US_LL_TIMER1_EQ_X_Pos (30UL) /*!< DIAG8_EV1US_LL_TIMER1_EQ_X (Bit 30)                  */
#define CMAC_CM_DIAG_WORD8_REG_DIAG8_EV1US_LL_TIMER1_EQ_X_Msk (0x40000000UL) /*!< DIAG8_EV1US_LL_TIMER1_EQ_X (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_WORD8_REG_DIAG8_EV1US_LL_TIMER1_36_10_EQ_Z_Pos (29UL) /*!< DIAG8_EV1US_LL_TIMER1_36_10_EQ_Z (Bit 29)      */
#define CMAC_CM_DIAG_WORD8_REG_DIAG8_EV1US_LL_TIMER1_36_10_EQ_Z_Msk (0x20000000UL) /*!< DIAG8_EV1US_LL_TIMER1_36_10_EQ_Z (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_WORD8_REG_DIAG8_EV1US_LL_TIMER1_36_10_EQ_Y_Pos (28UL) /*!< DIAG8_EV1US_LL_TIMER1_36_10_EQ_Y (Bit 28)      */
#define CMAC_CM_DIAG_WORD8_REG_DIAG8_EV1US_LL_TIMER1_36_10_EQ_Y_Msk (0x10000000UL) /*!< DIAG8_EV1US_LL_TIMER1_36_10_EQ_Y (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_WORD8_REG_DIAG8_EV1US_LL_TIMER1_36_10_EQ_X_Pos (27UL) /*!< DIAG8_EV1US_LL_TIMER1_36_10_EQ_X (Bit 27)      */
#define CMAC_CM_DIAG_WORD8_REG_DIAG8_EV1US_LL_TIMER1_36_10_EQ_X_Msk (0x8000000UL) /*!< DIAG8_EV1US_LL_TIMER1_36_10_EQ_X (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_WORD8_REG_DIAG8_EV1US_LL_TIMER1_36_10_EQ_0_Pos (26UL) /*!< DIAG8_EV1US_LL_TIMER1_36_10_EQ_0 (Bit 26)      */
#define CMAC_CM_DIAG_WORD8_REG_DIAG8_EV1US_LL_TIMER1_36_10_EQ_0_Msk (0x4000000UL) /*!< DIAG8_EV1US_LL_TIMER1_36_10_EQ_0 (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_WORD8_REG_DIAG8_EV1US_LL_TIMER1_9_0_EQ_Y_Pos (25UL) /*!< DIAG8_EV1US_LL_TIMER1_9_0_EQ_Y (Bit 25)          */
#define CMAC_CM_DIAG_WORD8_REG_DIAG8_EV1US_LL_TIMER1_9_0_EQ_Y_Msk (0x2000000UL) /*!< DIAG8_EV1US_LL_TIMER1_9_0_EQ_Y (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_WORD8_REG_DIAG8_EV1US_LL_TIMER1_9_0_EQ_X_Pos (24UL) /*!< DIAG8_EV1US_LL_TIMER1_9_0_EQ_X (Bit 24)          */
#define CMAC_CM_DIAG_WORD8_REG_DIAG8_EV1US_LL_TIMER1_9_0_EQ_X_Msk (0x1000000UL) /*!< DIAG8_EV1US_LL_TIMER1_9_0_EQ_X (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_WORD8_REG_DIAG8_EV1US_LL_TIMER1_9_0_EQ_0_Pos (23UL) /*!< DIAG8_EV1US_LL_TIMER1_9_0_EQ_0 (Bit 23)          */
#define CMAC_CM_DIAG_WORD8_REG_DIAG8_EV1US_LL_TIMER1_9_0_EQ_0_Msk (0x800000UL) /*!< DIAG8_EV1US_LL_TIMER1_9_0_EQ_0 (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_WORD8_REG_DIAG8_LL_TIMER1_00_Pos (0UL)         /*!< DIAG8_LL_TIMER1_00 (Bit 0)                            */
#define CMAC_CM_DIAG_WORD8_REG_DIAG8_LL_TIMER1_00_Msk (0x1UL)       /*!< DIAG8_LL_TIMER1_00 (Bitfield-Mask: 0x01)              */
/* ===================================================  CM_DIAG_WORD9_REG  =================================================== */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_PDC2CMAC_IRQ_Pos (30UL)        /*!< DIAG9_PDC2CMAC_IRQ (Bit 30)                           */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_PDC2CMAC_IRQ_Msk (0x40000000UL) /*!< DIAG9_PDC2CMAC_IRQ (Bitfield-Mask: 0x01)             */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_XTAL32M_RDY_Pos (29UL)         /*!< DIAG9_XTAL32M_RDY (Bit 29)                            */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_XTAL32M_RDY_Msk (0x20000000UL) /*!< DIAG9_XTAL32M_RDY (Bitfield-Mask: 0x01)               */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_CMAC_SLP_TIMER_IRQ_Pos (28UL)  /*!< DIAG9_CMAC_SLP_TIMER_IRQ (Bit 28)                     */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_CMAC_SLP_TIMER_IRQ_Msk (0x10000000UL) /*!< DIAG9_CMAC_SLP_TIMER_IRQ (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_GEN_HW_IRQ_Pos (27UL)          /*!< DIAG9_GEN_HW_IRQ (Bit 27)                             */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_GEN_HW_IRQ_Msk (0x8000000UL)   /*!< DIAG9_GEN_HW_IRQ (Bitfield-Mask: 0x01)                */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_FRAME_IRQ_Pos (26UL)           /*!< DIAG9_FRAME_IRQ (Bit 26)                              */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_FRAME_IRQ_Msk (0x4000000UL)    /*!< DIAG9_FRAME_IRQ (Bitfield-Mask: 0x01)                 */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_CALLBACK_IRQ_Pos (25UL)        /*!< DIAG9_CALLBACK_IRQ (Bit 25)                           */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_CALLBACK_IRQ_Msk (0x2000000UL) /*!< DIAG9_CALLBACK_IRQ (Bitfield-Mask: 0x01)              */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_FIELD_IRQ_Pos (24UL)           /*!< DIAG9_FIELD_IRQ (Bit 24)                              */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_FIELD_IRQ_Msk (0x1000000UL)    /*!< DIAG9_FIELD_IRQ (Bitfield-Mask: 0x01)                 */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_CMAC2SYS_IRQ_Pos (23UL)        /*!< DIAG9_CMAC2SYS_IRQ (Bit 23)                           */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_CMAC2SYS_IRQ_Msk (0x800000UL)  /*!< DIAG9_CMAC2SYS_IRQ (Bitfield-Mask: 0x01)              */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_22_Pos (22UL)        /*!< DIAG9_EXCEPTION_22 (Bit 22)                           */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_22_Msk (0x400000UL)  /*!< DIAG9_EXCEPTION_22 (Bitfield-Mask: 0x01)              */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_21_Pos (21UL)        /*!< DIAG9_EXCEPTION_21 (Bit 21)                           */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_21_Msk (0x200000UL)  /*!< DIAG9_EXCEPTION_21 (Bitfield-Mask: 0x01)              */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_20_Pos (20UL)        /*!< DIAG9_EXCEPTION_20 (Bit 20)                           */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_20_Msk (0x100000UL)  /*!< DIAG9_EXCEPTION_20 (Bitfield-Mask: 0x01)              */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_19_Pos (19UL)        /*!< DIAG9_EXCEPTION_19 (Bit 19)                           */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_19_Msk (0x80000UL)   /*!< DIAG9_EXCEPTION_19 (Bitfield-Mask: 0x01)              */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_18_Pos (18UL)        /*!< DIAG9_EXCEPTION_18 (Bit 18)                           */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_18_Msk (0x40000UL)   /*!< DIAG9_EXCEPTION_18 (Bitfield-Mask: 0x01)              */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_17_Pos (17UL)        /*!< DIAG9_EXCEPTION_17 (Bit 17)                           */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_17_Msk (0x20000UL)   /*!< DIAG9_EXCEPTION_17 (Bitfield-Mask: 0x01)              */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_16_Pos (16UL)        /*!< DIAG9_EXCEPTION_16 (Bit 16)                           */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_16_Msk (0x10000UL)   /*!< DIAG9_EXCEPTION_16 (Bitfield-Mask: 0x01)              */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_15_Pos (15UL)        /*!< DIAG9_EXCEPTION_15 (Bit 15)                           */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_15_Msk (0x8000UL)    /*!< DIAG9_EXCEPTION_15 (Bitfield-Mask: 0x01)              */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_14_Pos (14UL)        /*!< DIAG9_EXCEPTION_14 (Bit 14)                           */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_14_Msk (0x4000UL)    /*!< DIAG9_EXCEPTION_14 (Bitfield-Mask: 0x01)              */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_13_Pos (13UL)        /*!< DIAG9_EXCEPTION_13 (Bit 13)                           */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_13_Msk (0x2000UL)    /*!< DIAG9_EXCEPTION_13 (Bitfield-Mask: 0x01)              */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_12_Pos (12UL)        /*!< DIAG9_EXCEPTION_12 (Bit 12)                           */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_12_Msk (0x1000UL)    /*!< DIAG9_EXCEPTION_12 (Bitfield-Mask: 0x01)              */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_11_Pos (11UL)        /*!< DIAG9_EXCEPTION_11 (Bit 11)                           */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_11_Msk (0x800UL)     /*!< DIAG9_EXCEPTION_11 (Bitfield-Mask: 0x01)              */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_10_Pos (10UL)        /*!< DIAG9_EXCEPTION_10 (Bit 10)                           */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_10_Msk (0x400UL)     /*!< DIAG9_EXCEPTION_10 (Bitfield-Mask: 0x01)              */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_9_Pos (9UL)          /*!< DIAG9_EXCEPTION_9 (Bit 9)                             */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_9_Msk (0x200UL)      /*!< DIAG9_EXCEPTION_9 (Bitfield-Mask: 0x01)               */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_8_Pos (8UL)          /*!< DIAG9_EXCEPTION_8 (Bit 8)                             */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_8_Msk (0x100UL)      /*!< DIAG9_EXCEPTION_8 (Bitfield-Mask: 0x01)               */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_7_Pos (7UL)          /*!< DIAG9_EXCEPTION_7 (Bit 7)                             */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_7_Msk (0x80UL)       /*!< DIAG9_EXCEPTION_7 (Bitfield-Mask: 0x01)               */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_6_Pos (6UL)          /*!< DIAG9_EXCEPTION_6 (Bit 6)                             */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_6_Msk (0x40UL)       /*!< DIAG9_EXCEPTION_6 (Bitfield-Mask: 0x01)               */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_5_Pos (5UL)          /*!< DIAG9_EXCEPTION_5 (Bit 5)                             */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_5_Msk (0x20UL)       /*!< DIAG9_EXCEPTION_5 (Bitfield-Mask: 0x01)               */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_4_Pos (4UL)          /*!< DIAG9_EXCEPTION_4 (Bit 4)                             */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_4_Msk (0x10UL)       /*!< DIAG9_EXCEPTION_4 (Bitfield-Mask: 0x01)               */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_3_Pos (3UL)          /*!< DIAG9_EXCEPTION_3 (Bit 3)                             */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_3_Msk (0x8UL)        /*!< DIAG9_EXCEPTION_3 (Bitfield-Mask: 0x01)               */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_2_Pos (2UL)          /*!< DIAG9_EXCEPTION_2 (Bit 2)                             */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_2_Msk (0x4UL)        /*!< DIAG9_EXCEPTION_2 (Bitfield-Mask: 0x01)               */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_1_Pos (1UL)          /*!< DIAG9_EXCEPTION_1 (Bit 1)                             */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_1_Msk (0x2UL)        /*!< DIAG9_EXCEPTION_1 (Bitfield-Mask: 0x01)               */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_0_Pos (0UL)          /*!< DIAG9_EXCEPTION_0 (Bit 0)                             */
#define CMAC_CM_DIAG_WORD9_REG_DIAG9_EXCEPTION_0_Msk (0x1UL)        /*!< DIAG9_EXCEPTION_0 (Bitfield-Mask: 0x01)               */
/* ====================================================  CM_DMA_STAT_REG  ==================================================== */
#define CMAC_CM_DMA_STAT_REG_DMA_BYTES_Pos (20UL)                   /*!< DMA_BYTES (Bit 20)                                    */
#define CMAC_CM_DMA_STAT_REG_DMA_BYTES_Msk (0x1ff00000UL)           /*!< DMA_BYTES (Bitfield-Mask: 0x1ff)                      */
#define CMAC_CM_DMA_STAT_REG_DMA_BUFFER_PTR_Pos (0UL)               /*!< DMA_BUFFER_PTR (Bit 0)                                */
#define CMAC_CM_DMA_STAT_REG_DMA_BUFFER_PTR_Msk (0x3ffffUL)         /*!< DMA_BUFFER_PTR (Bitfield-Mask: 0x3ffff)               */
/* ===================================================  CM_ERROR_DIS_REG  ==================================================== */
#define CMAC_CM_ERROR_DIS_REG_CM_MCPU_LOCKUP_Pos (31UL)             /*!< CM_MCPU_LOCKUP (Bit 31)                               */
#define CMAC_CM_ERROR_DIS_REG_CM_MCPU_LOCKUP_Msk (0x80000000UL)     /*!< CM_MCPU_LOCKUP (Bitfield-Mask: 0x01)                  */
#define CMAC_CM_ERROR_DIS_REG_CM_REGFILE_ERR_Pos (30UL)             /*!< CM_REGFILE_ERR (Bit 30)                               */
#define CMAC_CM_ERROR_DIS_REG_CM_REGFILE_ERR_Msk (0x40000000UL)     /*!< CM_REGFILE_ERR (Bitfield-Mask: 0x01)                  */
#define CMAC_CM_ERROR_DIS_REG_CM_CRYPTO_ERR_Pos (29UL)              /*!< CM_CRYPTO_ERR (Bit 29)                                */
#define CMAC_CM_ERROR_DIS_REG_CM_CRYPTO_ERR_Msk (0x20000000UL)      /*!< CM_CRYPTO_ERR (Bitfield-Mask: 0x01)                   */
#define CMAC_CM_ERROR_DIS_REG_CM_SYSMEMCTRL_ERR_Pos (28UL)          /*!< CM_SYSMEMCTRL_ERR (Bit 28)                            */
#define CMAC_CM_ERROR_DIS_REG_CM_SYSMEMCTRL_ERR_Msk (0x10000000UL)  /*!< CM_SYSMEMCTRL_ERR (Bitfield-Mask: 0x01)               */
#define CMAC_CM_ERROR_DIS_REG_CM_PHY_ERR_Pos (27UL)                 /*!< CM_PHY_ERR (Bit 27)                                   */
#define CMAC_CM_ERROR_DIS_REG_CM_PHY_ERR_Msk (0x8000000UL)          /*!< CM_PHY_ERR (Bitfield-Mask: 0x01)                      */
#define CMAC_CM_ERROR_DIS_REG_CM_FPGA_ERR_Pos (25UL)                /*!< CM_FPGA_ERR (Bit 25)                                  */
#define CMAC_CM_ERROR_DIS_REG_CM_FPGA_ERR_Msk (0x2000000UL)         /*!< CM_FPGA_ERR (Bitfield-Mask: 0x01)                     */
#define CMAC_CM_ERROR_DIS_REG_CM_MONITOR_ERR_Pos (11UL)             /*!< CM_MONITOR_ERR (Bit 11)                               */
#define CMAC_CM_ERROR_DIS_REG_CM_MONITOR_ERR_Msk (0x800UL)          /*!< CM_MONITOR_ERR (Bitfield-Mask: 0x01)                  */
#define CMAC_CM_ERROR_DIS_REG_CM_CORR_ERR_Pos (10UL)                /*!< CM_CORR_ERR (Bit 10)                                  */
#define CMAC_CM_ERROR_DIS_REG_CM_CORR_ERR_Msk (0x400UL)             /*!< CM_CORR_ERR (Bitfield-Mask: 0x01)                     */
#define CMAC_CM_ERROR_DIS_REG_CM_TS_ERR_Pos (9UL)                   /*!< CM_TS_ERR (Bit 9)                                     */
#define CMAC_CM_ERROR_DIS_REG_CM_TS_ERR_Msk (0x200UL)               /*!< CM_TS_ERR (Bitfield-Mask: 0x01)                       */
#define CMAC_CM_ERROR_DIS_REG_CM_DMA_BUF_ERR_Pos (8UL)              /*!< CM_DMA_BUF_ERR (Bit 8)                                */
#define CMAC_CM_ERROR_DIS_REG_CM_DMA_BUF_ERR_Msk (0x100UL)          /*!< CM_DMA_BUF_ERR (Bitfield-Mask: 0x01)                  */
#define CMAC_CM_ERROR_DIS_REG_CM_DMA_ERR_Pos (7UL)                  /*!< CM_DMA_ERR (Bit 7)                                    */
#define CMAC_CM_ERROR_DIS_REG_CM_DMA_ERR_Msk (0x80UL)               /*!< CM_DMA_ERR (Bitfield-Mask: 0x01)                      */
#define CMAC_CM_ERROR_DIS_REG_CM_PHY_BUSY_RDY_ERR_Pos (6UL)         /*!< CM_PHY_BUSY_RDY_ERR (Bit 6)                           */
#define CMAC_CM_ERROR_DIS_REG_CM_PHY_BUSY_RDY_ERR_Msk (0x40UL)      /*!< CM_PHY_BUSY_RDY_ERR (Bitfield-Mask: 0x01)             */
#define CMAC_CM_ERROR_DIS_REG_CM_BS_SMPL_ERR_Pos (5UL)              /*!< CM_BS_SMPL_ERR (Bit 5)                                */
#define CMAC_CM_ERROR_DIS_REG_CM_BS_SMPL_ERR_Msk (0x20UL)           /*!< CM_BS_SMPL_ERR (Bitfield-Mask: 0x01)                  */
#define CMAC_CM_ERROR_DIS_REG_CM_CALLBACK_ERR_Pos (4UL)             /*!< CM_CALLBACK_ERR (Bit 4)                               */
#define CMAC_CM_ERROR_DIS_REG_CM_CALLBACK_ERR_Msk (0x10UL)          /*!< CM_CALLBACK_ERR (Bitfield-Mask: 0x01)                 */
#define CMAC_CM_ERROR_DIS_REG_CM_FRAME_ERR_Pos (3UL)                /*!< CM_FRAME_ERR (Bit 3)                                  */
#define CMAC_CM_ERROR_DIS_REG_CM_FRAME_ERR_Msk (0x8UL)              /*!< CM_FRAME_ERR (Bitfield-Mask: 0x01)                    */
#define CMAC_CM_ERROR_DIS_REG_CM_FIELD2_ERR_Pos (2UL)               /*!< CM_FIELD2_ERR (Bit 2)                                 */
#define CMAC_CM_ERROR_DIS_REG_CM_FIELD2_ERR_Msk (0x4UL)             /*!< CM_FIELD2_ERR (Bitfield-Mask: 0x01)                   */
#define CMAC_CM_ERROR_DIS_REG_CM_FIELD1_ERR_Pos (1UL)               /*!< CM_FIELD1_ERR (Bit 1)                                 */
#define CMAC_CM_ERROR_DIS_REG_CM_FIELD1_ERR_Msk (0x2UL)             /*!< CM_FIELD1_ERR (Bitfield-Mask: 0x01)                   */
#define CMAC_CM_ERROR_DIS_REG_CM_CLK_EV_ERR_Pos (0UL)               /*!< CM_CLK_EV_ERR (Bit 0)                                 */
#define CMAC_CM_ERROR_DIS_REG_CM_CLK_EV_ERR_Msk (0x1UL)             /*!< CM_CLK_EV_ERR (Bitfield-Mask: 0x01)                   */
/* =====================================================  CM_ERROR_REG  ====================================================== */
#define CMAC_CM_ERROR_REG_CM_MCPU_LOCKUP_Pos (31UL)                 /*!< CM_MCPU_LOCKUP (Bit 31)                               */
#define CMAC_CM_ERROR_REG_CM_MCPU_LOCKUP_Msk (0x80000000UL)         /*!< CM_MCPU_LOCKUP (Bitfield-Mask: 0x01)                  */
#define CMAC_CM_ERROR_REG_CM_REGFILE_ERR_Pos (30UL)                 /*!< CM_REGFILE_ERR (Bit 30)                               */
#define CMAC_CM_ERROR_REG_CM_REGFILE_ERR_Msk (0x40000000UL)         /*!< CM_REGFILE_ERR (Bitfield-Mask: 0x01)                  */
#define CMAC_CM_ERROR_REG_CM_CRYPTO_ERR_Pos (29UL)                  /*!< CM_CRYPTO_ERR (Bit 29)                                */
#define CMAC_CM_ERROR_REG_CM_CRYPTO_ERR_Msk (0x20000000UL)          /*!< CM_CRYPTO_ERR (Bitfield-Mask: 0x01)                   */
#define CMAC_CM_ERROR_REG_CM_SYSMEMCTRL_ERR_Pos (28UL)              /*!< CM_SYSMEMCTRL_ERR (Bit 28)                            */
#define CMAC_CM_ERROR_REG_CM_SYSMEMCTRL_ERR_Msk (0x10000000UL)      /*!< CM_SYSMEMCTRL_ERR (Bitfield-Mask: 0x01)               */
#define CMAC_CM_ERROR_REG_CM_PHY_ERR_Pos  (27UL)                    /*!< CM_PHY_ERR (Bit 27)                                   */
#define CMAC_CM_ERROR_REG_CM_PHY_ERR_Msk  (0x8000000UL)             /*!< CM_PHY_ERR (Bitfield-Mask: 0x01)                      */
#define CMAC_CM_ERROR_REG_CM_WDOG_EXPIRE_ERR_Pos (26UL)             /*!< CM_WDOG_EXPIRE_ERR (Bit 26)                           */
#define CMAC_CM_ERROR_REG_CM_WDOG_EXPIRE_ERR_Msk (0x4000000UL)      /*!< CM_WDOG_EXPIRE_ERR (Bitfield-Mask: 0x01)              */
#define CMAC_CM_ERROR_REG_CM_FPGA_ERR_Pos (25UL)                    /*!< CM_FPGA_ERR (Bit 25)                                  */
#define CMAC_CM_ERROR_REG_CM_FPGA_ERR_Msk (0x2000000UL)             /*!< CM_FPGA_ERR (Bitfield-Mask: 0x01)                     */
#define CMAC_CM_ERROR_REG_CM_MONITOR_ERR_Pos (11UL)                 /*!< CM_MONITOR_ERR (Bit 11)                               */
#define CMAC_CM_ERROR_REG_CM_MONITOR_ERR_Msk (0x800UL)              /*!< CM_MONITOR_ERR (Bitfield-Mask: 0x01)                  */
#define CMAC_CM_ERROR_REG_CM_CORR_ERR_Pos (10UL)                    /*!< CM_CORR_ERR (Bit 10)                                  */
#define CMAC_CM_ERROR_REG_CM_CORR_ERR_Msk (0x400UL)                 /*!< CM_CORR_ERR (Bitfield-Mask: 0x01)                     */
#define CMAC_CM_ERROR_REG_CM_TS_ERR_Pos   (9UL)                     /*!< CM_TS_ERR (Bit 9)                                     */
#define CMAC_CM_ERROR_REG_CM_TS_ERR_Msk   (0x200UL)                 /*!< CM_TS_ERR (Bitfield-Mask: 0x01)                       */
#define CMAC_CM_ERROR_REG_CM_DMA_BUF_ERR_Pos (8UL)                  /*!< CM_DMA_BUF_ERR (Bit 8)                                */
#define CMAC_CM_ERROR_REG_CM_DMA_BUF_ERR_Msk (0x100UL)              /*!< CM_DMA_BUF_ERR (Bitfield-Mask: 0x01)                  */
#define CMAC_CM_ERROR_REG_CM_DMA_ERR_Pos  (7UL)                     /*!< CM_DMA_ERR (Bit 7)                                    */
#define CMAC_CM_ERROR_REG_CM_DMA_ERR_Msk  (0x80UL)                  /*!< CM_DMA_ERR (Bitfield-Mask: 0x01)                      */
#define CMAC_CM_ERROR_REG_CM_PHY_BUSY_RDY_ERR_Pos (6UL)             /*!< CM_PHY_BUSY_RDY_ERR (Bit 6)                           */
#define CMAC_CM_ERROR_REG_CM_PHY_BUSY_RDY_ERR_Msk (0x40UL)          /*!< CM_PHY_BUSY_RDY_ERR (Bitfield-Mask: 0x01)             */
#define CMAC_CM_ERROR_REG_CM_BS_SMPL_ERR_Pos (5UL)                  /*!< CM_BS_SMPL_ERR (Bit 5)                                */
#define CMAC_CM_ERROR_REG_CM_BS_SMPL_ERR_Msk (0x20UL)               /*!< CM_BS_SMPL_ERR (Bitfield-Mask: 0x01)                  */
#define CMAC_CM_ERROR_REG_CM_CALLBACK_ERR_Pos (4UL)                 /*!< CM_CALLBACK_ERR (Bit 4)                               */
#define CMAC_CM_ERROR_REG_CM_CALLBACK_ERR_Msk (0x10UL)              /*!< CM_CALLBACK_ERR (Bitfield-Mask: 0x01)                 */
#define CMAC_CM_ERROR_REG_CM_FRAME_ERR_Pos (3UL)                    /*!< CM_FRAME_ERR (Bit 3)                                  */
#define CMAC_CM_ERROR_REG_CM_FRAME_ERR_Msk (0x8UL)                  /*!< CM_FRAME_ERR (Bitfield-Mask: 0x01)                    */
#define CMAC_CM_ERROR_REG_CM_FIELD2_ERR_Pos (2UL)                   /*!< CM_FIELD2_ERR (Bit 2)                                 */
#define CMAC_CM_ERROR_REG_CM_FIELD2_ERR_Msk (0x4UL)                 /*!< CM_FIELD2_ERR (Bitfield-Mask: 0x01)                   */
#define CMAC_CM_ERROR_REG_CM_FIELD1_ERR_Pos (1UL)                   /*!< CM_FIELD1_ERR (Bit 1)                                 */
#define CMAC_CM_ERROR_REG_CM_FIELD1_ERR_Msk (0x2UL)                 /*!< CM_FIELD1_ERR (Bitfield-Mask: 0x01)                   */
#define CMAC_CM_ERROR_REG_CM_CLK_EV_ERR_Pos (0UL)                   /*!< CM_CLK_EV_ERR (Bit 0)                                 */
#define CMAC_CM_ERROR_REG_CM_CLK_EV_ERR_Msk (0x1UL)                 /*!< CM_CLK_EV_ERR (Bitfield-Mask: 0x01)                   */
/* ===================================================  CM_EV_LATCHED_REG  =================================================== */
#define CMAC_CM_EV_LATCHED_REG_EV1C_LP_CLK_NEGEDGE_Pos (10UL)       /*!< EV1C_LP_CLK_NEGEDGE (Bit 10)                          */
#define CMAC_CM_EV_LATCHED_REG_EV1C_LP_CLK_NEGEDGE_Msk (0x400UL)    /*!< EV1C_LP_CLK_NEGEDGE (Bitfield-Mask: 0x01)             */
#define CMAC_CM_EV_LATCHED_REG_EV1C_LP_CLK_POSEDGE_Pos (9UL)        /*!< EV1C_LP_CLK_POSEDGE (Bit 9)                           */
#define CMAC_CM_EV_LATCHED_REG_EV1C_LP_CLK_POSEDGE_Msk (0x200UL)    /*!< EV1C_LP_CLK_POSEDGE (Bitfield-Mask: 0x01)             */
#define CMAC_CM_EV_LATCHED_REG_EV_WINDOW_CNT_THR_Pos (8UL)          /*!< EV_WINDOW_CNT_THR (Bit 8)                             */
#define CMAC_CM_EV_LATCHED_REG_EV_WINDOW_CNT_THR_Msk (0x100UL)      /*!< EV_WINDOW_CNT_THR (Bitfield-Mask: 0x01)               */
#define CMAC_CM_EV_LATCHED_REG_EV1C_CLK_EV_Pos (7UL)                /*!< EV1C_CLK_EV (Bit 7)                                   */
#define CMAC_CM_EV_LATCHED_REG_EV1C_CLK_EV_Msk (0x80UL)             /*!< EV1C_CLK_EV (Bitfield-Mask: 0x01)                     */
#define CMAC_CM_EV_LATCHED_REG_EV1C_CLK_1US_X7_Pos (6UL)            /*!< EV1C_CLK_1US_X7 (Bit 6)                               */
#define CMAC_CM_EV_LATCHED_REG_EV1C_CLK_1US_X7_Msk (0x40UL)         /*!< EV1C_CLK_1US_X7 (Bitfield-Mask: 0x01)                 */
#define CMAC_CM_EV_LATCHED_REG_EV1C_CLK_1US_X6_Pos (5UL)            /*!< EV1C_CLK_1US_X6 (Bit 5)                               */
#define CMAC_CM_EV_LATCHED_REG_EV1C_CLK_1US_X6_Msk (0x20UL)         /*!< EV1C_CLK_1US_X6 (Bitfield-Mask: 0x01)                 */
#define CMAC_CM_EV_LATCHED_REG_EV1C_CLK_1US_X5_Pos (4UL)            /*!< EV1C_CLK_1US_X5 (Bit 4)                               */
#define CMAC_CM_EV_LATCHED_REG_EV1C_CLK_1US_X5_Msk (0x10UL)         /*!< EV1C_CLK_1US_X5 (Bitfield-Mask: 0x01)                 */
#define CMAC_CM_EV_LATCHED_REG_EV1C_CLK_1US_X4_Pos (3UL)            /*!< EV1C_CLK_1US_X4 (Bit 3)                               */
#define CMAC_CM_EV_LATCHED_REG_EV1C_CLK_1US_X4_Msk (0x8UL)          /*!< EV1C_CLK_1US_X4 (Bitfield-Mask: 0x01)                 */
#define CMAC_CM_EV_LATCHED_REG_EV1C_CLK_1US_X3_Pos (2UL)            /*!< EV1C_CLK_1US_X3 (Bit 2)                               */
#define CMAC_CM_EV_LATCHED_REG_EV1C_CLK_1US_X3_Msk (0x4UL)          /*!< EV1C_CLK_1US_X3 (Bitfield-Mask: 0x01)                 */
#define CMAC_CM_EV_LATCHED_REG_EV1C_CLK_1US_X2_Pos (1UL)            /*!< EV1C_CLK_1US_X2 (Bit 1)                               */
#define CMAC_CM_EV_LATCHED_REG_EV1C_CLK_1US_X2_Msk (0x2UL)          /*!< EV1C_CLK_1US_X2 (Bitfield-Mask: 0x01)                 */
#define CMAC_CM_EV_LATCHED_REG_EV1C_CLK_1US_X1_Pos (0UL)            /*!< EV1C_CLK_1US_X1 (Bit 0)                               */
#define CMAC_CM_EV_LATCHED_REG_EV1C_CLK_1US_X1_Msk (0x1UL)          /*!< EV1C_CLK_1US_X1 (Bitfield-Mask: 0x01)                 */
/* ===================================================  CM_EV_LINKUP_REG  ==================================================== */
#define CMAC_CM_EV_LINKUP_REG_LU_PHY_TO_IDLE_2_EXC_Pos (8UL)        /*!< LU_PHY_TO_IDLE_2_EXC (Bit 8)                          */
#define CMAC_CM_EV_LINKUP_REG_LU_PHY_TO_IDLE_2_EXC_Msk (0x100UL)    /*!< LU_PHY_TO_IDLE_2_EXC (Bitfield-Mask: 0x01)            */
#define CMAC_CM_EV_LINKUP_REG_LU_PHY_TO_IDLE_2_NONE_Pos (7UL)       /*!< LU_PHY_TO_IDLE_2_NONE (Bit 7)                         */
#define CMAC_CM_EV_LINKUP_REG_LU_PHY_TO_IDLE_2_NONE_Msk (0x80UL)    /*!< LU_PHY_TO_IDLE_2_NONE (Bitfield-Mask: 0x01)           */
#define CMAC_CM_EV_LINKUP_REG_LU_CORR_TMR_LD_2_TMR1_36_10_EQ_Z_Pos (6UL) /*!< LU_CORR_TMR_LD_2_TMR1_36_10_EQ_Z (Bit 6)         */
#define CMAC_CM_EV_LINKUP_REG_LU_CORR_TMR_LD_2_TMR1_36_10_EQ_Z_Msk (0x40UL) /*!< LU_CORR_TMR_LD_2_TMR1_36_10_EQ_Z (Bitfield-Mask: 0x01) */
#define CMAC_CM_EV_LINKUP_REG_LU_CORR_TMR_LD_2_CORR_START_Pos (5UL) /*!< LU_CORR_TMR_LD_2_CORR_START (Bit 5)                   */
#define CMAC_CM_EV_LINKUP_REG_LU_CORR_TMR_LD_2_CORR_START_Msk (0x20UL) /*!< LU_CORR_TMR_LD_2_CORR_START (Bitfield-Mask: 0x01)  */
#define CMAC_CM_EV_LINKUP_REG_LU_FRAME_START_2_TMR1_9_0_EQ_X_Pos (4UL) /*!< LU_FRAME_START_2_TMR1_9_0_EQ_X (Bit 4)             */
#define CMAC_CM_EV_LINKUP_REG_LU_FRAME_START_2_TMR1_9_0_EQ_X_Msk (0x10UL) /*!< LU_FRAME_START_2_TMR1_9_0_EQ_X (Bitfield-Mask: 0x01) */
#define CMAC_CM_EV_LINKUP_REG_LU_FRAME_START_2_TMR1_9_0_EQ_0_Pos (3UL) /*!< LU_FRAME_START_2_TMR1_9_0_EQ_0 (Bit 3)             */
#define CMAC_CM_EV_LINKUP_REG_LU_FRAME_START_2_TMR1_9_0_EQ_0_Msk (0x8UL) /*!< LU_FRAME_START_2_TMR1_9_0_EQ_0 (Bitfield-Mask: 0x01) */
#define CMAC_CM_EV_LINKUP_REG_LU_FRAME_START_2_PHY_TO_IDLE_Pos (2UL) /*!< LU_FRAME_START_2_PHY_TO_IDLE (Bit 2)                 */
#define CMAC_CM_EV_LINKUP_REG_LU_FRAME_START_2_PHY_TO_IDLE_Msk (0x4UL) /*!< LU_FRAME_START_2_PHY_TO_IDLE (Bitfield-Mask: 0x01) */
#define CMAC_CM_EV_LINKUP_REG_LU_FRAME_START_2_ASAP_Pos (1UL)       /*!< LU_FRAME_START_2_ASAP (Bit 1)                         */
#define CMAC_CM_EV_LINKUP_REG_LU_FRAME_START_2_ASAP_Msk (0x2UL)     /*!< LU_FRAME_START_2_ASAP (Bitfield-Mask: 0x01)           */
#define CMAC_CM_EV_LINKUP_REG_LU_FRAME_START_2_NONE_Pos (0UL)       /*!< LU_FRAME_START_2_NONE (Bit 0)                         */
#define CMAC_CM_EV_LINKUP_REG_LU_FRAME_START_2_NONE_Msk (0x1UL)     /*!< LU_FRAME_START_2_NONE (Bitfield-Mask: 0x01)           */
/* =====================================================  CM_EV_SET_REG  ===================================================== */
#define CMAC_CM_EV_SET_REG_EV1C_CMAC2SYS_IRQ_CLR_Pos (16UL)         /*!< EV1C_CMAC2SYS_IRQ_CLR (Bit 16)                        */
#define CMAC_CM_EV_SET_REG_EV1C_CMAC2SYS_IRQ_CLR_Msk (0x10000UL)    /*!< EV1C_CMAC2SYS_IRQ_CLR (Bitfield-Mask: 0x01)           */
#define CMAC_CM_EV_SET_REG_EV1C_RDY4BS_FORCE_0_CLR_Pos (15UL)       /*!< EV1C_RDY4BS_FORCE_0_CLR (Bit 15)                      */
#define CMAC_CM_EV_SET_REG_EV1C_RDY4BS_FORCE_0_CLR_Msk (0x8000UL)   /*!< EV1C_RDY4BS_FORCE_0_CLR (Bitfield-Mask: 0x01)         */
#define CMAC_CM_EV_SET_REG_EV1C_RDY4BS_FORCE_0_SET_Pos (14UL)       /*!< EV1C_RDY4BS_FORCE_0_SET (Bit 14)                      */
#define CMAC_CM_EV_SET_REG_EV1C_RDY4BS_FORCE_0_SET_Msk (0x4000UL)   /*!< EV1C_RDY4BS_FORCE_0_SET (Bitfield-Mask: 0x01)         */
#define CMAC_CM_EV_SET_REG_EV1C_CALLBACK_VALID_CLR_Pos (13UL)       /*!< EV1C_CALLBACK_VALID_CLR (Bit 13)                      */
#define CMAC_CM_EV_SET_REG_EV1C_CALLBACK_VALID_CLR_Msk (0x2000UL)   /*!< EV1C_CALLBACK_VALID_CLR (Bitfield-Mask: 0x01)         */
#define CMAC_CM_EV_SET_REG_EV1C_CALLBACK_VALID_SET_Pos (12UL)       /*!< EV1C_CALLBACK_VALID_SET (Bit 12)                      */
#define CMAC_CM_EV_SET_REG_EV1C_CALLBACK_VALID_SET_Msk (0x1000UL)   /*!< EV1C_CALLBACK_VALID_SET (Bitfield-Mask: 0x01)         */
#define CMAC_CM_EV_SET_REG_EV1C_FIELD_TOP_LAST_SET_Pos (11UL)       /*!< EV1C_FIELD_TOP_LAST_SET (Bit 11)                      */
#define CMAC_CM_EV_SET_REG_EV1C_FIELD_TOP_LAST_SET_Msk (0x800UL)    /*!< EV1C_FIELD_TOP_LAST_SET (Bitfield-Mask: 0x01)         */
#define CMAC_CM_EV_SET_REG_EV1C_SW_LLC_3_Pos (10UL)                 /*!< EV1C_SW_LLC_3 (Bit 10)                                */
#define CMAC_CM_EV_SET_REG_EV1C_SW_LLC_3_Msk (0x400UL)              /*!< EV1C_SW_LLC_3 (Bitfield-Mask: 0x01)                   */
#define CMAC_CM_EV_SET_REG_EV1C_SW_LLC_2_Pos (9UL)                  /*!< EV1C_SW_LLC_2 (Bit 9)                                 */
#define CMAC_CM_EV_SET_REG_EV1C_SW_LLC_2_Msk (0x200UL)              /*!< EV1C_SW_LLC_2 (Bitfield-Mask: 0x01)                   */
#define CMAC_CM_EV_SET_REG_EV1C_SW_LLC_1_Pos (8UL)                  /*!< EV1C_SW_LLC_1 (Bit 8)                                 */
#define CMAC_CM_EV_SET_REG_EV1C_SW_LLC_1_Msk (0x100UL)              /*!< EV1C_SW_LLC_1 (Bitfield-Mask: 0x01)                   */
#define CMAC_CM_EV_SET_REG_EV1C_SW_MAC_Pos (7UL)                    /*!< EV1C_SW_MAC (Bit 7)                                   */
#define CMAC_CM_EV_SET_REG_EV1C_SW_MAC_Msk (0x80UL)                 /*!< EV1C_SW_MAC (Bitfield-Mask: 0x01)                     */
#define CMAC_CM_EV_SET_REG_EV_TS1_TRIGGER_Pos (6UL)                 /*!< EV_TS1_TRIGGER (Bit 6)                                */
#define CMAC_CM_EV_SET_REG_EV_TS1_TRIGGER_Msk (0x40UL)              /*!< EV_TS1_TRIGGER (Bitfield-Mask: 0x01)                  */
#define CMAC_CM_EV_SET_REG_EV1C_TS1_TRIGGER_Pos (5UL)               /*!< EV1C_TS1_TRIGGER (Bit 5)                              */
#define CMAC_CM_EV_SET_REG_EV1C_TS1_TRIGGER_Msk (0x20UL)            /*!< EV1C_TS1_TRIGGER (Bitfield-Mask: 0x01)                */
#define CMAC_CM_EV_SET_REG_EV_CRYPTO_START_Pos (4UL)                /*!< EV_CRYPTO_START (Bit 4)                               */
#define CMAC_CM_EV_SET_REG_EV_CRYPTO_START_Msk (0x10UL)             /*!< EV_CRYPTO_START (Bitfield-Mask: 0x01)                 */
#define CMAC_CM_EV_SET_REG_EV1C_BS_CLEAR_Pos (3UL)                  /*!< EV1C_BS_CLEAR (Bit 3)                                 */
#define CMAC_CM_EV_SET_REG_EV1C_BS_CLEAR_Msk (0x8UL)                /*!< EV1C_BS_CLEAR (Bitfield-Mask: 0x01)                   */
#define CMAC_CM_EV_SET_REG_EV1C_BS_STOP_Pos (2UL)                   /*!< EV1C_BS_STOP (Bit 2)                                  */
#define CMAC_CM_EV_SET_REG_EV1C_BS_STOP_Msk (0x4UL)                 /*!< EV1C_BS_STOP (Bitfield-Mask: 0x01)                    */
#define CMAC_CM_EV_SET_REG_EV1US_FRAME_START_Pos (1UL)              /*!< EV1US_FRAME_START (Bit 1)                             */
#define CMAC_CM_EV_SET_REG_EV1US_FRAME_START_Msk (0x2UL)            /*!< EV1US_FRAME_START (Bitfield-Mask: 0x01)               */
#define CMAC_CM_EV_SET_REG_EV1C_CMAC2SYS_IRQ_SET_Pos (0UL)          /*!< EV1C_CMAC2SYS_IRQ_SET (Bit 0)                         */
#define CMAC_CM_EV_SET_REG_EV1C_CMAC2SYS_IRQ_SET_Msk (0x1UL)        /*!< EV1C_CMAC2SYS_IRQ_SET (Bitfield-Mask: 0x01)           */
/* ====================================================  CM_EXC_DIS_REG  ===================================================== */
#define CMAC_CM_EXC_DIS_REG_EXC_SWD_DETACH_Pos (13UL)               /*!< EXC_SWD_DETACH (Bit 13)                               */
#define CMAC_CM_EXC_DIS_REG_EXC_SWD_DETACH_Msk (0x2000UL)           /*!< EXC_SWD_DETACH (Bitfield-Mask: 0x01)                  */
#define CMAC_CM_EXC_DIS_REG_EXC_COEX_Pos  (12UL)                    /*!< EXC_COEX (Bit 12)                                     */
#define CMAC_CM_EXC_DIS_REG_EXC_COEX_Msk  (0x1000UL)                /*!< EXC_COEX (Bitfield-Mask: 0x01)                        */
#define CMAC_CM_EXC_DIS_REG_EXC_PHY_Pos   (11UL)                    /*!< EXC_PHY (Bit 11)                                      */
#define CMAC_CM_EXC_DIS_REG_EXC_PHY_Msk   (0x800UL)                 /*!< EXC_PHY (Bitfield-Mask: 0x01)                         */
#define CMAC_CM_EXC_DIS_REG_EXC_XTAL_RDY_Pos (10UL)                 /*!< EXC_XTAL_RDY (Bit 10)                                 */
#define CMAC_CM_EXC_DIS_REG_EXC_XTAL_RDY_Msk (0x400UL)              /*!< EXC_XTAL_RDY (Bitfield-Mask: 0x01)                    */
#define CMAC_CM_EXC_DIS_REG_EXC_BS_STOP_Pos (7UL)                   /*!< EXC_BS_STOP (Bit 7)                                   */
#define CMAC_CM_EXC_DIS_REG_EXC_BS_STOP_Msk (0x80UL)                /*!< EXC_BS_STOP (Bitfield-Mask: 0x01)                     */
#define CMAC_CM_EXC_DIS_REG_EXC_FRAME_START_Pos (6UL)               /*!< EXC_FRAME_START (Bit 6)                               */
#define CMAC_CM_EXC_DIS_REG_EXC_FRAME_START_Msk (0x40UL)            /*!< EXC_FRAME_START (Bitfield-Mask: 0x01)                 */
#define CMAC_CM_EXC_DIS_REG_EXC_CPU_ERROR_Pos (2UL)                 /*!< EXC_CPU_ERROR (Bit 2)                                 */
#define CMAC_CM_EXC_DIS_REG_EXC_CPU_ERROR_Msk (0x4UL)               /*!< EXC_CPU_ERROR (Bitfield-Mask: 0x01)                   */
/* ====================================================  CM_EXC_STAT_REG  ==================================================== */
#define CMAC_CM_EXC_STAT_REG_EXC_SYS2CMAC_Pos (22UL)                /*!< EXC_SYS2CMAC (Bit 22)                                 */
#define CMAC_CM_EXC_STAT_REG_EXC_SYS2CMAC_Msk (0x400000UL)          /*!< EXC_SYS2CMAC (Bitfield-Mask: 0x01)                    */
#define CMAC_CM_EXC_STAT_REG_EXC_SW_LLC_3_Pos (21UL)                /*!< EXC_SW_LLC_3 (Bit 21)                                 */
#define CMAC_CM_EXC_STAT_REG_EXC_SW_LLC_3_Msk (0x200000UL)          /*!< EXC_SW_LLC_3 (Bitfield-Mask: 0x01)                    */
#define CMAC_CM_EXC_STAT_REG_EXC_SW_LLC_2_Pos (20UL)                /*!< EXC_SW_LLC_2 (Bit 20)                                 */
#define CMAC_CM_EXC_STAT_REG_EXC_SW_LLC_2_Msk (0x100000UL)          /*!< EXC_SW_LLC_2 (Bitfield-Mask: 0x01)                    */
#define CMAC_CM_EXC_STAT_REG_EXC_SW_LLC_1_Pos (19UL)                /*!< EXC_SW_LLC_1 (Bit 19)                                 */
#define CMAC_CM_EXC_STAT_REG_EXC_SW_LLC_1_Msk (0x80000UL)           /*!< EXC_SW_LLC_1 (Bitfield-Mask: 0x01)                    */
#define CMAC_CM_EXC_STAT_REG_EXC_CRYPTO_Pos (18UL)                  /*!< EXC_CRYPTO (Bit 18)                                   */
#define CMAC_CM_EXC_STAT_REG_EXC_CRYPTO_Msk (0x40000UL)             /*!< EXC_CRYPTO (Bitfield-Mask: 0x01)                      */
#define CMAC_CM_EXC_STAT_REG_EXC_LL_TIMER2LLC_Pos (17UL)            /*!< EXC_LL_TIMER2LLC (Bit 17)                             */
#define CMAC_CM_EXC_STAT_REG_EXC_LL_TIMER2LLC_Msk (0x20000UL)       /*!< EXC_LL_TIMER2LLC (Bitfield-Mask: 0x01)                */
#define CMAC_CM_EXC_STAT_REG_EXC_LL_TIMER2PRMTV_Pos (16UL)          /*!< EXC_LL_TIMER2PRMTV (Bit 16)                           */
#define CMAC_CM_EXC_STAT_REG_EXC_LL_TIMER2PRMTV_Msk (0x10000UL)     /*!< EXC_LL_TIMER2PRMTV (Bitfield-Mask: 0x01)              */
#define CMAC_CM_EXC_STAT_REG_EXC_SW_MAC_Pos (15UL)                  /*!< EXC_SW_MAC (Bit 15)                                   */
#define CMAC_CM_EXC_STAT_REG_EXC_SW_MAC_Msk (0x8000UL)              /*!< EXC_SW_MAC (Bitfield-Mask: 0x01)                      */
#define CMAC_CM_EXC_STAT_REG_EXC_WDOG_EARLY_Pos (14UL)              /*!< EXC_WDOG_EARLY (Bit 14)                               */
#define CMAC_CM_EXC_STAT_REG_EXC_WDOG_EARLY_Msk (0x4000UL)          /*!< EXC_WDOG_EARLY (Bitfield-Mask: 0x01)                  */
#define CMAC_CM_EXC_STAT_REG_EXC_SWD_DETACH_Pos (13UL)              /*!< EXC_SWD_DETACH (Bit 13)                               */
#define CMAC_CM_EXC_STAT_REG_EXC_SWD_DETACH_Msk (0x2000UL)          /*!< EXC_SWD_DETACH (Bitfield-Mask: 0x01)                  */
#define CMAC_CM_EXC_STAT_REG_EXC_COEX_Pos (12UL)                    /*!< EXC_COEX (Bit 12)                                     */
#define CMAC_CM_EXC_STAT_REG_EXC_COEX_Msk (0x1000UL)                /*!< EXC_COEX (Bitfield-Mask: 0x01)                        */
#define CMAC_CM_EXC_STAT_REG_EXC_PHY_Pos  (11UL)                    /*!< EXC_PHY (Bit 11)                                      */
#define CMAC_CM_EXC_STAT_REG_EXC_PHY_Msk  (0x800UL)                 /*!< EXC_PHY (Bitfield-Mask: 0x01)                         */
#define CMAC_CM_EXC_STAT_REG_EXC_XTAL_RDY_Pos (10UL)                /*!< EXC_XTAL_RDY (Bit 10)                                 */
#define CMAC_CM_EXC_STAT_REG_EXC_XTAL_RDY_Msk (0x400UL)             /*!< EXC_XTAL_RDY (Bitfield-Mask: 0x01)                    */
#define CMAC_CM_EXC_STAT_REG_EXC_DIAG_Pos (9UL)                     /*!< EXC_DIAG (Bit 9)                                      */
#define CMAC_CM_EXC_STAT_REG_EXC_DIAG_Msk (0x200UL)                 /*!< EXC_DIAG (Bitfield-Mask: 0x01)                        */
#define CMAC_CM_EXC_STAT_REG_EXC_PHY_TO_IDLE_4THIS_Pos (8UL)        /*!< EXC_PHY_TO_IDLE_4THIS (Bit 8)                         */
#define CMAC_CM_EXC_STAT_REG_EXC_PHY_TO_IDLE_4THIS_Msk (0x100UL)    /*!< EXC_PHY_TO_IDLE_4THIS (Bitfield-Mask: 0x01)           */
#define CMAC_CM_EXC_STAT_REG_EXC_BS_STOP_Pos (7UL)                  /*!< EXC_BS_STOP (Bit 7)                                   */
#define CMAC_CM_EXC_STAT_REG_EXC_BS_STOP_Msk (0x80UL)               /*!< EXC_BS_STOP (Bitfield-Mask: 0x01)                     */
#define CMAC_CM_EXC_STAT_REG_EXC_FRAME_START_Pos (6UL)              /*!< EXC_FRAME_START (Bit 6)                               */
#define CMAC_CM_EXC_STAT_REG_EXC_FRAME_START_Msk (0x40UL)           /*!< EXC_FRAME_START (Bitfield-Mask: 0x01)                 */
#define CMAC_CM_EXC_STAT_REG_EXC_CORR_TIMEOUT_Pos (5UL)             /*!< EXC_CORR_TIMEOUT (Bit 5)                              */
#define CMAC_CM_EXC_STAT_REG_EXC_CORR_TIMEOUT_Msk (0x20UL)          /*!< EXC_CORR_TIMEOUT (Bitfield-Mask: 0x01)                */
#define CMAC_CM_EXC_STAT_REG_EXC_BS_START_4THIS_Pos (4UL)           /*!< EXC_BS_START_4THIS (Bit 4)                            */
#define CMAC_CM_EXC_STAT_REG_EXC_BS_START_4THIS_Msk (0x10UL)        /*!< EXC_BS_START_4THIS (Bitfield-Mask: 0x01)              */
#define CMAC_CM_EXC_STAT_REG_EXC_FIELD_ON_THR_EXP_Pos (3UL)         /*!< EXC_FIELD_ON_THR_EXP (Bit 3)                          */
#define CMAC_CM_EXC_STAT_REG_EXC_FIELD_ON_THR_EXP_Msk (0x8UL)       /*!< EXC_FIELD_ON_THR_EXP (Bitfield-Mask: 0x01)            */
#define CMAC_CM_EXC_STAT_REG_EXC_CPU_ERROR_Pos (2UL)                /*!< EXC_CPU_ERROR (Bit 2)                                 */
#define CMAC_CM_EXC_STAT_REG_EXC_CPU_ERROR_Msk (0x4UL)              /*!< EXC_CPU_ERROR (Bitfield-Mask: 0x01)                   */
#define CMAC_CM_EXC_STAT_REG_EXC_BS_ERROR_Pos (1UL)                 /*!< EXC_BS_ERROR (Bit 1)                                  */
#define CMAC_CM_EXC_STAT_REG_EXC_BS_ERROR_Msk (0x2UL)               /*!< EXC_BS_ERROR (Bitfield-Mask: 0x01)                    */
#define CMAC_CM_EXC_STAT_REG_EXC_FW_ERROR_Pos (0UL)                 /*!< EXC_FW_ERROR (Bit 0)                                  */
#define CMAC_CM_EXC_STAT_REG_EXC_FW_ERROR_Msk (0x1UL)               /*!< EXC_FW_ERROR (Bitfield-Mask: 0x01)                    */
/* ==================================================  CM_FIELD_1_CTRL_REG  ================================================== */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_PHY_ATTR_SEL_Pos (31UL)      /*!< FIELD_PHY_ATTR_SEL (Bit 31)                           */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_PHY_ATTR_SEL_Msk (0x80000000UL) /*!< FIELD_PHY_ATTR_SEL (Bitfield-Mask: 0x01)           */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_SPR_Pos (28UL)               /*!< FIELD_SPR (Bit 28)                                    */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_SPR_Msk (0x10000000UL)       /*!< FIELD_SPR (Bitfield-Mask: 0x01)                       */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_EXC_ON_EXP_Pos (27UL)        /*!< FIELD_EXC_ON_EXP (Bit 27)                             */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_EXC_ON_EXP_Msk (0x8000000UL) /*!< FIELD_EXC_ON_EXP (Bitfield-Mask: 0x01)                */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_XL_AOAD_Pos (26UL)           /*!< FIELD_XL_AOAD (Bit 26)                                */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_XL_AOAD_Msk (0x4000000UL)    /*!< FIELD_XL_AOAD (Bitfield-Mask: 0x01)                   */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_XL_CORR_Pos (25UL)           /*!< FIELD_XL_CORR (Bit 25)                                */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_XL_CORR_Msk (0x2000000UL)    /*!< FIELD_XL_CORR (Bitfield-Mask: 0x01)                   */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_XL_CRC_Pos (24UL)            /*!< FIELD_XL_CRC (Bit 24)                                 */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_XL_CRC_Msk (0x1000000UL)     /*!< FIELD_XL_CRC (Bitfield-Mask: 0x01)                    */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_XL_DMA_CRYPTO_Pos (23UL)     /*!< FIELD_XL_DMA_CRYPTO (Bit 23)                          */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_XL_DMA_CRYPTO_Msk (0x800000UL) /*!< FIELD_XL_DMA_CRYPTO (Bitfield-Mask: 0x01)           */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_XL_DMA_MEM_Pos (22UL)        /*!< FIELD_XL_DMA_MEM (Bit 22)                             */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_XL_DMA_MEM_Msk (0x400000UL)  /*!< FIELD_XL_DMA_MEM (Bitfield-Mask: 0x01)                */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_XL_WHITENING_Pos (21UL)      /*!< FIELD_XL_WHITENING (Bit 21)                           */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_XL_WHITENING_Msk (0x200000UL) /*!< FIELD_XL_WHITENING (Bitfield-Mask: 0x01)             */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_TX_DATA_SRC_Pos (19UL)       /*!< FIELD_TX_DATA_SRC (Bit 19)                            */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_TX_DATA_SRC_Msk (0x180000UL) /*!< FIELD_TX_DATA_SRC (Bitfield-Mask: 0x03)               */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_EVPSYMBOL_LUT_Pos (17UL)     /*!< FIELD_EVPSYMBOL_LUT (Bit 17)                          */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_EVPSYMBOL_LUT_Msk (0x60000UL) /*!< FIELD_EVPSYMBOL_LUT (Bitfield-Mask: 0x03)            */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_BPSYMBOL_LUT_Pos (15UL)      /*!< FIELD_BPSYMBOL_LUT (Bit 15)                           */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_BPSYMBOL_LUT_Msk (0x18000UL) /*!< FIELD_BPSYMBOL_LUT (Bitfield-Mask: 0x03)              */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_BS_SMPL_NO_ERROR_Pos (14UL)  /*!< FIELD_BS_SMPL_NO_ERROR (Bit 14)                       */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_BS_SMPL_NO_ERROR_Msk (0x4000UL) /*!< FIELD_BS_SMPL_NO_ERROR (Bitfield-Mask: 0x01)       */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_EXC_ON_THR_Pos (13UL)        /*!< FIELD_EXC_ON_THR (Bit 13)                             */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_EXC_ON_THR_Msk (0x2000UL)    /*!< FIELD_EXC_ON_THR (Bitfield-Mask: 0x01)                */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_WINDOW_CNT_THR_Pos (8UL)     /*!< FIELD_WINDOW_CNT_THR (Bit 8)                          */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_WINDOW_CNT_THR_Msk (0x1f00UL) /*!< FIELD_WINDOW_CNT_THR (Bitfield-Mask: 0x1f)           */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_MSB_FIRST_Pos (7UL)          /*!< FIELD_MSB_FIRST (Bit 7)                               */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_MSB_FIRST_Msk (0x80UL)       /*!< FIELD_MSB_FIRST (Bitfield-Mask: 0x01)                 */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_LAST_Pos (6UL)               /*!< FIELD_LAST (Bit 6)                                    */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_LAST_Msk (0x40UL)            /*!< FIELD_LAST (Bitfield-Mask: 0x01)                      */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_VALID_Pos (5UL)              /*!< FIELD_VALID (Bit 5)                                   */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_VALID_Msk (0x20UL)           /*!< FIELD_VALID (Bitfield-Mask: 0x01)                     */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_SIZE_M1_Pos (0UL)            /*!< FIELD_SIZE_M1 (Bit 0)                                 */
#define CMAC_CM_FIELD_1_CTRL_REG_FIELD_SIZE_M1_Msk (0x1fUL)         /*!< FIELD_SIZE_M1 (Bitfield-Mask: 0x1f)                   */
/* ==================================================  CM_FIELD_1_DATA_REG  ================================================== */
#define CMAC_CM_FIELD_1_DATA_REG_FIELD_DATA_Pos (0UL)               /*!< FIELD_DATA (Bit 0)                                    */
#define CMAC_CM_FIELD_1_DATA_REG_FIELD_DATA_Msk (0xffffffffUL)      /*!< FIELD_DATA (Bitfield-Mask: 0xffffffff)                */
/* ==================================================  CM_FIELD_2_CTRL_REG  ================================================== */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_PHY_ATTR_SEL_Pos (31UL)      /*!< FIELD_PHY_ATTR_SEL (Bit 31)                           */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_PHY_ATTR_SEL_Msk (0x80000000UL) /*!< FIELD_PHY_ATTR_SEL (Bitfield-Mask: 0x01)           */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_SPR_Pos (28UL)               /*!< FIELD_SPR (Bit 28)                                    */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_SPR_Msk (0x10000000UL)       /*!< FIELD_SPR (Bitfield-Mask: 0x01)                       */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_EXC_ON_EXP_Pos (27UL)        /*!< FIELD_EXC_ON_EXP (Bit 27)                             */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_EXC_ON_EXP_Msk (0x8000000UL) /*!< FIELD_EXC_ON_EXP (Bitfield-Mask: 0x01)                */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_XL_AOAD_Pos (26UL)           /*!< FIELD_XL_AOAD (Bit 26)                                */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_XL_AOAD_Msk (0x4000000UL)    /*!< FIELD_XL_AOAD (Bitfield-Mask: 0x01)                   */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_XL_CORR_Pos (25UL)           /*!< FIELD_XL_CORR (Bit 25)                                */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_XL_CORR_Msk (0x2000000UL)    /*!< FIELD_XL_CORR (Bitfield-Mask: 0x01)                   */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_XL_CRC_Pos (24UL)            /*!< FIELD_XL_CRC (Bit 24)                                 */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_XL_CRC_Msk (0x1000000UL)     /*!< FIELD_XL_CRC (Bitfield-Mask: 0x01)                    */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_XL_DMA_CRYPTO_Pos (23UL)     /*!< FIELD_XL_DMA_CRYPTO (Bit 23)                          */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_XL_DMA_CRYPTO_Msk (0x800000UL) /*!< FIELD_XL_DMA_CRYPTO (Bitfield-Mask: 0x01)           */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_XL_DMA_MEM_Pos (22UL)        /*!< FIELD_XL_DMA_MEM (Bit 22)                             */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_XL_DMA_MEM_Msk (0x400000UL)  /*!< FIELD_XL_DMA_MEM (Bitfield-Mask: 0x01)                */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_XL_WHITENING_Pos (21UL)      /*!< FIELD_XL_WHITENING (Bit 21)                           */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_XL_WHITENING_Msk (0x200000UL) /*!< FIELD_XL_WHITENING (Bitfield-Mask: 0x01)             */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_TX_DATA_SRC_Pos (19UL)       /*!< FIELD_TX_DATA_SRC (Bit 19)                            */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_TX_DATA_SRC_Msk (0x180000UL) /*!< FIELD_TX_DATA_SRC (Bitfield-Mask: 0x03)               */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_EVPSYMBOL_LUT_Pos (17UL)     /*!< FIELD_EVPSYMBOL_LUT (Bit 17)                          */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_EVPSYMBOL_LUT_Msk (0x60000UL) /*!< FIELD_EVPSYMBOL_LUT (Bitfield-Mask: 0x03)            */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_BPSYMBOL_LUT_Pos (15UL)      /*!< FIELD_BPSYMBOL_LUT (Bit 15)                           */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_BPSYMBOL_LUT_Msk (0x18000UL) /*!< FIELD_BPSYMBOL_LUT (Bitfield-Mask: 0x03)              */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_BS_SMPL_NO_ERROR_Pos (14UL)  /*!< FIELD_BS_SMPL_NO_ERROR (Bit 14)                       */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_BS_SMPL_NO_ERROR_Msk (0x4000UL) /*!< FIELD_BS_SMPL_NO_ERROR (Bitfield-Mask: 0x01)       */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_EXC_ON_THR_Pos (13UL)        /*!< FIELD_EXC_ON_THR (Bit 13)                             */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_EXC_ON_THR_Msk (0x2000UL)    /*!< FIELD_EXC_ON_THR (Bitfield-Mask: 0x01)                */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_WINDOW_CNT_THR_Pos (8UL)     /*!< FIELD_WINDOW_CNT_THR (Bit 8)                          */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_WINDOW_CNT_THR_Msk (0x1f00UL) /*!< FIELD_WINDOW_CNT_THR (Bitfield-Mask: 0x1f)           */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_MSB_FIRST_Pos (7UL)          /*!< FIELD_MSB_FIRST (Bit 7)                               */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_MSB_FIRST_Msk (0x80UL)       /*!< FIELD_MSB_FIRST (Bitfield-Mask: 0x01)                 */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_LAST_Pos (6UL)               /*!< FIELD_LAST (Bit 6)                                    */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_LAST_Msk (0x40UL)            /*!< FIELD_LAST (Bitfield-Mask: 0x01)                      */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_VALID_Pos (5UL)              /*!< FIELD_VALID (Bit 5)                                   */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_VALID_Msk (0x20UL)           /*!< FIELD_VALID (Bitfield-Mask: 0x01)                     */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_SIZE_M1_Pos (0UL)            /*!< FIELD_SIZE_M1 (Bit 0)                                 */
#define CMAC_CM_FIELD_2_CTRL_REG_FIELD_SIZE_M1_Msk (0x1fUL)         /*!< FIELD_SIZE_M1 (Bitfield-Mask: 0x1f)                   */
/* ==================================================  CM_FIELD_2_DATA_REG  ================================================== */
#define CMAC_CM_FIELD_2_DATA_REG_FIELD_DATA_Pos (0UL)               /*!< FIELD_DATA (Bit 0)                                    */
#define CMAC_CM_FIELD_2_DATA_REG_FIELD_DATA_Msk (0xffffffffUL)      /*!< FIELD_DATA (Bitfield-Mask: 0xffffffff)                */
/* ==================================================  CM_FIELD_3_CTRL_REG  ================================================== */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_PHY_ATTR_SEL_Pos (31UL)      /*!< FIELD_PHY_ATTR_SEL (Bit 31)                           */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_PHY_ATTR_SEL_Msk (0x80000000UL) /*!< FIELD_PHY_ATTR_SEL (Bitfield-Mask: 0x01)           */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_SPR_Pos (28UL)               /*!< FIELD_SPR (Bit 28)                                    */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_SPR_Msk (0x10000000UL)       /*!< FIELD_SPR (Bitfield-Mask: 0x01)                       */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_EXC_ON_EXP_Pos (27UL)        /*!< FIELD_EXC_ON_EXP (Bit 27)                             */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_EXC_ON_EXP_Msk (0x8000000UL) /*!< FIELD_EXC_ON_EXP (Bitfield-Mask: 0x01)                */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_XL_AOAD_Pos (26UL)           /*!< FIELD_XL_AOAD (Bit 26)                                */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_XL_AOAD_Msk (0x4000000UL)    /*!< FIELD_XL_AOAD (Bitfield-Mask: 0x01)                   */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_XL_CORR_Pos (25UL)           /*!< FIELD_XL_CORR (Bit 25)                                */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_XL_CORR_Msk (0x2000000UL)    /*!< FIELD_XL_CORR (Bitfield-Mask: 0x01)                   */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_XL_CRC_Pos (24UL)            /*!< FIELD_XL_CRC (Bit 24)                                 */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_XL_CRC_Msk (0x1000000UL)     /*!< FIELD_XL_CRC (Bitfield-Mask: 0x01)                    */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_XL_DMA_CRYPTO_Pos (23UL)     /*!< FIELD_XL_DMA_CRYPTO (Bit 23)                          */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_XL_DMA_CRYPTO_Msk (0x800000UL) /*!< FIELD_XL_DMA_CRYPTO (Bitfield-Mask: 0x01)           */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_XL_DMA_MEM_Pos (22UL)        /*!< FIELD_XL_DMA_MEM (Bit 22)                             */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_XL_DMA_MEM_Msk (0x400000UL)  /*!< FIELD_XL_DMA_MEM (Bitfield-Mask: 0x01)                */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_XL_WHITENING_Pos (21UL)      /*!< FIELD_XL_WHITENING (Bit 21)                           */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_XL_WHITENING_Msk (0x200000UL) /*!< FIELD_XL_WHITENING (Bitfield-Mask: 0x01)             */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_TX_DATA_SRC_Pos (19UL)       /*!< FIELD_TX_DATA_SRC (Bit 19)                            */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_TX_DATA_SRC_Msk (0x180000UL) /*!< FIELD_TX_DATA_SRC (Bitfield-Mask: 0x03)               */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_EVPSYMBOL_LUT_Pos (17UL)     /*!< FIELD_EVPSYMBOL_LUT (Bit 17)                          */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_EVPSYMBOL_LUT_Msk (0x60000UL) /*!< FIELD_EVPSYMBOL_LUT (Bitfield-Mask: 0x03)            */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_BPSYMBOL_LUT_Pos (15UL)      /*!< FIELD_BPSYMBOL_LUT (Bit 15)                           */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_BPSYMBOL_LUT_Msk (0x18000UL) /*!< FIELD_BPSYMBOL_LUT (Bitfield-Mask: 0x03)              */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_BS_SMPL_NO_ERROR_Pos (14UL)  /*!< FIELD_BS_SMPL_NO_ERROR (Bit 14)                       */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_BS_SMPL_NO_ERROR_Msk (0x4000UL) /*!< FIELD_BS_SMPL_NO_ERROR (Bitfield-Mask: 0x01)       */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_EXC_ON_THR_Pos (13UL)        /*!< FIELD_EXC_ON_THR (Bit 13)                             */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_EXC_ON_THR_Msk (0x2000UL)    /*!< FIELD_EXC_ON_THR (Bitfield-Mask: 0x01)                */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_WINDOW_CNT_THR_Pos (8UL)     /*!< FIELD_WINDOW_CNT_THR (Bit 8)                          */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_WINDOW_CNT_THR_Msk (0x1f00UL) /*!< FIELD_WINDOW_CNT_THR (Bitfield-Mask: 0x1f)           */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_MSB_FIRST_Pos (7UL)          /*!< FIELD_MSB_FIRST (Bit 7)                               */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_MSB_FIRST_Msk (0x80UL)       /*!< FIELD_MSB_FIRST (Bitfield-Mask: 0x01)                 */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_LAST_Pos (6UL)               /*!< FIELD_LAST (Bit 6)                                    */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_LAST_Msk (0x40UL)            /*!< FIELD_LAST (Bitfield-Mask: 0x01)                      */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_VALID_Pos (5UL)              /*!< FIELD_VALID (Bit 5)                                   */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_VALID_Msk (0x20UL)           /*!< FIELD_VALID (Bitfield-Mask: 0x01)                     */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_SIZE_M1_Pos (0UL)            /*!< FIELD_SIZE_M1 (Bit 0)                                 */
#define CMAC_CM_FIELD_3_CTRL_REG_FIELD_SIZE_M1_Msk (0x1fUL)         /*!< FIELD_SIZE_M1 (Bitfield-Mask: 0x1f)                   */
/* ==================================================  CM_FIELD_3_DATA_REG  ================================================== */
#define CMAC_CM_FIELD_3_DATA_REG_FIELD_DATA_Pos (0UL)               /*!< FIELD_DATA (Bit 0)                                    */
#define CMAC_CM_FIELD_3_DATA_REG_FIELD_DATA_Msk (0xffffffffUL)      /*!< FIELD_DATA (Bitfield-Mask: 0xffffffff)                */
/* ==================================================  CM_FIELD_4_CTRL_REG  ================================================== */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_PHY_ATTR_SEL_Pos (31UL)      /*!< FIELD_PHY_ATTR_SEL (Bit 31)                           */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_PHY_ATTR_SEL_Msk (0x80000000UL) /*!< FIELD_PHY_ATTR_SEL (Bitfield-Mask: 0x01)           */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_SPR_Pos (28UL)               /*!< FIELD_SPR (Bit 28)                                    */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_SPR_Msk (0x10000000UL)       /*!< FIELD_SPR (Bitfield-Mask: 0x01)                       */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_EXC_ON_EXP_Pos (27UL)        /*!< FIELD_EXC_ON_EXP (Bit 27)                             */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_EXC_ON_EXP_Msk (0x8000000UL) /*!< FIELD_EXC_ON_EXP (Bitfield-Mask: 0x01)                */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_XL_AOAD_Pos (26UL)           /*!< FIELD_XL_AOAD (Bit 26)                                */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_XL_AOAD_Msk (0x4000000UL)    /*!< FIELD_XL_AOAD (Bitfield-Mask: 0x01)                   */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_XL_CORR_Pos (25UL)           /*!< FIELD_XL_CORR (Bit 25)                                */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_XL_CORR_Msk (0x2000000UL)    /*!< FIELD_XL_CORR (Bitfield-Mask: 0x01)                   */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_XL_CRC_Pos (24UL)            /*!< FIELD_XL_CRC (Bit 24)                                 */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_XL_CRC_Msk (0x1000000UL)     /*!< FIELD_XL_CRC (Bitfield-Mask: 0x01)                    */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_XL_DMA_CRYPTO_Pos (23UL)     /*!< FIELD_XL_DMA_CRYPTO (Bit 23)                          */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_XL_DMA_CRYPTO_Msk (0x800000UL) /*!< FIELD_XL_DMA_CRYPTO (Bitfield-Mask: 0x01)           */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_XL_DMA_MEM_Pos (22UL)        /*!< FIELD_XL_DMA_MEM (Bit 22)                             */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_XL_DMA_MEM_Msk (0x400000UL)  /*!< FIELD_XL_DMA_MEM (Bitfield-Mask: 0x01)                */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_XL_WHITENING_Pos (21UL)      /*!< FIELD_XL_WHITENING (Bit 21)                           */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_XL_WHITENING_Msk (0x200000UL) /*!< FIELD_XL_WHITENING (Bitfield-Mask: 0x01)             */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_TX_DATA_SRC_Pos (19UL)       /*!< FIELD_TX_DATA_SRC (Bit 19)                            */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_TX_DATA_SRC_Msk (0x180000UL) /*!< FIELD_TX_DATA_SRC (Bitfield-Mask: 0x03)               */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_EVPSYMBOL_LUT_Pos (17UL)     /*!< FIELD_EVPSYMBOL_LUT (Bit 17)                          */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_EVPSYMBOL_LUT_Msk (0x60000UL) /*!< FIELD_EVPSYMBOL_LUT (Bitfield-Mask: 0x03)            */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_BPSYMBOL_LUT_Pos (15UL)      /*!< FIELD_BPSYMBOL_LUT (Bit 15)                           */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_BPSYMBOL_LUT_Msk (0x18000UL) /*!< FIELD_BPSYMBOL_LUT (Bitfield-Mask: 0x03)              */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_BS_SMPL_NO_ERROR_Pos (14UL)  /*!< FIELD_BS_SMPL_NO_ERROR (Bit 14)                       */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_BS_SMPL_NO_ERROR_Msk (0x4000UL) /*!< FIELD_BS_SMPL_NO_ERROR (Bitfield-Mask: 0x01)       */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_EXC_ON_THR_Pos (13UL)        /*!< FIELD_EXC_ON_THR (Bit 13)                             */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_EXC_ON_THR_Msk (0x2000UL)    /*!< FIELD_EXC_ON_THR (Bitfield-Mask: 0x01)                */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_WINDOW_CNT_THR_Pos (8UL)     /*!< FIELD_WINDOW_CNT_THR (Bit 8)                          */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_WINDOW_CNT_THR_Msk (0x1f00UL) /*!< FIELD_WINDOW_CNT_THR (Bitfield-Mask: 0x1f)           */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_MSB_FIRST_Pos (7UL)          /*!< FIELD_MSB_FIRST (Bit 7)                               */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_MSB_FIRST_Msk (0x80UL)       /*!< FIELD_MSB_FIRST (Bitfield-Mask: 0x01)                 */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_LAST_Pos (6UL)               /*!< FIELD_LAST (Bit 6)                                    */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_LAST_Msk (0x40UL)            /*!< FIELD_LAST (Bitfield-Mask: 0x01)                      */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_VALID_Pos (5UL)              /*!< FIELD_VALID (Bit 5)                                   */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_VALID_Msk (0x20UL)           /*!< FIELD_VALID (Bitfield-Mask: 0x01)                     */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_SIZE_M1_Pos (0UL)            /*!< FIELD_SIZE_M1 (Bit 0)                                 */
#define CMAC_CM_FIELD_4_CTRL_REG_FIELD_SIZE_M1_Msk (0x1fUL)         /*!< FIELD_SIZE_M1 (Bitfield-Mask: 0x1f)                   */
/* ==================================================  CM_FIELD_4_DATA_REG  ================================================== */
#define CMAC_CM_FIELD_4_DATA_REG_FIELD_DATA_Pos (0UL)               /*!< FIELD_DATA (Bit 0)                                    */
#define CMAC_CM_FIELD_4_DATA_REG_FIELD_DATA_Msk (0xffffffffUL)      /*!< FIELD_DATA (Bitfield-Mask: 0xffffffff)                */
/* ================================================  CM_FIELD_PUSH_CTRL_REG  ================================================= */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_PHY_ATTR_SEL_Pos (31UL)   /*!< FIELD_PHY_ATTR_SEL (Bit 31)                           */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_PHY_ATTR_SEL_Msk (0x80000000UL) /*!< FIELD_PHY_ATTR_SEL (Bitfield-Mask: 0x01)        */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_SPR_Pos (28UL)            /*!< FIELD_SPR (Bit 28)                                    */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_SPR_Msk (0x10000000UL)    /*!< FIELD_SPR (Bitfield-Mask: 0x01)                       */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_EXC_ON_EXP_Pos (27UL)     /*!< FIELD_EXC_ON_EXP (Bit 27)                             */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_EXC_ON_EXP_Msk (0x8000000UL) /*!< FIELD_EXC_ON_EXP (Bitfield-Mask: 0x01)             */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_XL_AOAD_Pos (26UL)        /*!< FIELD_XL_AOAD (Bit 26)                                */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_XL_AOAD_Msk (0x4000000UL) /*!< FIELD_XL_AOAD (Bitfield-Mask: 0x01)                   */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_XL_CORR_Pos (25UL)        /*!< FIELD_XL_CORR (Bit 25)                                */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_XL_CORR_Msk (0x2000000UL) /*!< FIELD_XL_CORR (Bitfield-Mask: 0x01)                   */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_XL_CRC_Pos (24UL)         /*!< FIELD_XL_CRC (Bit 24)                                 */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_XL_CRC_Msk (0x1000000UL)  /*!< FIELD_XL_CRC (Bitfield-Mask: 0x01)                    */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_XL_DMA_CRYPTO_Pos (23UL)  /*!< FIELD_XL_DMA_CRYPTO (Bit 23)                          */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_XL_DMA_CRYPTO_Msk (0x800000UL) /*!< FIELD_XL_DMA_CRYPTO (Bitfield-Mask: 0x01)        */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_XL_DMA_MEM_Pos (22UL)     /*!< FIELD_XL_DMA_MEM (Bit 22)                             */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_XL_DMA_MEM_Msk (0x400000UL) /*!< FIELD_XL_DMA_MEM (Bitfield-Mask: 0x01)              */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_XL_WHITENING_Pos (21UL)   /*!< FIELD_XL_WHITENING (Bit 21)                           */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_XL_WHITENING_Msk (0x200000UL) /*!< FIELD_XL_WHITENING (Bitfield-Mask: 0x01)          */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_TX_DATA_SRC_Pos (19UL)    /*!< FIELD_TX_DATA_SRC (Bit 19)                            */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_TX_DATA_SRC_Msk (0x180000UL) /*!< FIELD_TX_DATA_SRC (Bitfield-Mask: 0x03)            */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_EVPSYMBOL_LUT_Pos (17UL)  /*!< FIELD_EVPSYMBOL_LUT (Bit 17)                          */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_EVPSYMBOL_LUT_Msk (0x60000UL) /*!< FIELD_EVPSYMBOL_LUT (Bitfield-Mask: 0x03)         */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_BPSYMBOL_LUT_Pos (15UL)   /*!< FIELD_BPSYMBOL_LUT (Bit 15)                           */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_BPSYMBOL_LUT_Msk (0x18000UL) /*!< FIELD_BPSYMBOL_LUT (Bitfield-Mask: 0x03)           */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_BS_SMPL_NO_ERROR_Pos (14UL) /*!< FIELD_BS_SMPL_NO_ERROR (Bit 14)                     */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_BS_SMPL_NO_ERROR_Msk (0x4000UL) /*!< FIELD_BS_SMPL_NO_ERROR (Bitfield-Mask: 0x01)    */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_EXC_ON_THR_Pos (13UL)     /*!< FIELD_EXC_ON_THR (Bit 13)                             */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_EXC_ON_THR_Msk (0x2000UL) /*!< FIELD_EXC_ON_THR (Bitfield-Mask: 0x01)                */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_WINDOW_CNT_THR_Pos (8UL)  /*!< FIELD_WINDOW_CNT_THR (Bit 8)                          */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_WINDOW_CNT_THR_Msk (0x1f00UL) /*!< FIELD_WINDOW_CNT_THR (Bitfield-Mask: 0x1f)        */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_MSB_FIRST_Pos (7UL)       /*!< FIELD_MSB_FIRST (Bit 7)                               */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_MSB_FIRST_Msk (0x80UL)    /*!< FIELD_MSB_FIRST (Bitfield-Mask: 0x01)                 */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_LAST_Pos (6UL)            /*!< FIELD_LAST (Bit 6)                                    */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_LAST_Msk (0x40UL)         /*!< FIELD_LAST (Bitfield-Mask: 0x01)                      */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_VALID_Pos (5UL)           /*!< FIELD_VALID (Bit 5)                                   */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_VALID_Msk (0x20UL)        /*!< FIELD_VALID (Bitfield-Mask: 0x01)                     */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_SIZE_M1_Pos (0UL)         /*!< FIELD_SIZE_M1 (Bit 0)                                 */
#define CMAC_CM_FIELD_PUSH_CTRL_REG_FIELD_SIZE_M1_Msk (0x1fUL)      /*!< FIELD_SIZE_M1 (Bitfield-Mask: 0x1f)                   */
/* ================================================  CM_FIELD_PUSH_DATA_REG  ================================================= */
#define CMAC_CM_FIELD_PUSH_DATA_REG_FIELD_DATA_Pos (0UL)            /*!< FIELD_DATA (Bit 0)                                    */
#define CMAC_CM_FIELD_PUSH_DATA_REG_FIELD_DATA_Msk (0xffffffffUL)   /*!< FIELD_DATA (Bitfield-Mask: 0xffffffff)                */
/* ====================================================  CM_FRAME_1_REG  ===================================================== */
#define CMAC_CM_FRAME_1_REG_FRAME_VALID_Pos (31UL)                  /*!< FRAME_VALID (Bit 31)                                  */
#define CMAC_CM_FRAME_1_REG_FRAME_VALID_Msk (0x80000000UL)          /*!< FRAME_VALID (Bitfield-Mask: 0x01)                     */
#define CMAC_CM_FRAME_1_REG_FRAME_TX_Pos  (30UL)                    /*!< FRAME_TX (Bit 30)                                     */
#define CMAC_CM_FRAME_1_REG_FRAME_TX_Msk  (0x40000000UL)            /*!< FRAME_TX (Bitfield-Mask: 0x01)                        */
#define CMAC_CM_FRAME_1_REG_FRAME_EXC_ON_BS_START_Pos (29UL)        /*!< FRAME_EXC_ON_BS_START (Bit 29)                        */
#define CMAC_CM_FRAME_1_REG_FRAME_EXC_ON_BS_START_Msk (0x20000000UL) /*!< FRAME_EXC_ON_BS_START (Bitfield-Mask: 0x01)          */
#define CMAC_CM_FRAME_1_REG_FRAME_DMA_REQS_MASKED_Pos (28UL)        /*!< FRAME_DMA_REQS_MASKED (Bit 28)                        */
#define CMAC_CM_FRAME_1_REG_FRAME_DMA_REQS_MASKED_Msk (0x10000000UL) /*!< FRAME_DMA_REQS_MASKED (Bitfield-Mask: 0x01)          */
#define CMAC_CM_FRAME_1_REG_FRAME_COEX_PTI_Pos (27UL)               /*!< FRAME_COEX_PTI (Bit 27)                               */
#define CMAC_CM_FRAME_1_REG_FRAME_COEX_PTI_Msk (0x8000000UL)        /*!< FRAME_COEX_PTI (Bitfield-Mask: 0x01)                  */
#define CMAC_CM_FRAME_1_REG_FRAME_START_OFFSET_Pos (0UL)            /*!< FRAME_START_OFFSET (Bit 0)                            */
#define CMAC_CM_FRAME_1_REG_FRAME_START_OFFSET_Msk (0x7ffUL)        /*!< FRAME_START_OFFSET (Bitfield-Mask: 0x7ff)             */
/* ====================================================  CM_FRAME_2_REG  ===================================================== */
#define CMAC_CM_FRAME_2_REG_FRAME_VALID_Pos (31UL)                  /*!< FRAME_VALID (Bit 31)                                  */
#define CMAC_CM_FRAME_2_REG_FRAME_VALID_Msk (0x80000000UL)          /*!< FRAME_VALID (Bitfield-Mask: 0x01)                     */
#define CMAC_CM_FRAME_2_REG_FRAME_TX_Pos  (30UL)                    /*!< FRAME_TX (Bit 30)                                     */
#define CMAC_CM_FRAME_2_REG_FRAME_TX_Msk  (0x40000000UL)            /*!< FRAME_TX (Bitfield-Mask: 0x01)                        */
#define CMAC_CM_FRAME_2_REG_FRAME_EXC_ON_BS_START_Pos (29UL)        /*!< FRAME_EXC_ON_BS_START (Bit 29)                        */
#define CMAC_CM_FRAME_2_REG_FRAME_EXC_ON_BS_START_Msk (0x20000000UL) /*!< FRAME_EXC_ON_BS_START (Bitfield-Mask: 0x01)          */
#define CMAC_CM_FRAME_2_REG_FRAME_DMA_REQS_MASKED_Pos (28UL)        /*!< FRAME_DMA_REQS_MASKED (Bit 28)                        */
#define CMAC_CM_FRAME_2_REG_FRAME_DMA_REQS_MASKED_Msk (0x10000000UL) /*!< FRAME_DMA_REQS_MASKED (Bitfield-Mask: 0x01)          */
#define CMAC_CM_FRAME_2_REG_FRAME_COEX_PTI_Pos (27UL)               /*!< FRAME_COEX_PTI (Bit 27)                               */
#define CMAC_CM_FRAME_2_REG_FRAME_COEX_PTI_Msk (0x8000000UL)        /*!< FRAME_COEX_PTI (Bitfield-Mask: 0x01)                  */
#define CMAC_CM_FRAME_2_REG_FRAME_START_OFFSET_Pos (0UL)            /*!< FRAME_START_OFFSET (Bit 0)                            */
#define CMAC_CM_FRAME_2_REG_FRAME_START_OFFSET_Msk (0x7ffUL)        /*!< FRAME_START_OFFSET (Bitfield-Mask: 0x7ff)             */
/* =================================================  CM_LL_INT_MSK_CLR_REG  ================================================= */
#define CMAC_CM_LL_INT_MSK_CLR_REG_LL_TIMER1_EQ_Y_SEL_Pos (8UL)     /*!< LL_TIMER1_EQ_Y_SEL (Bit 8)                            */
#define CMAC_CM_LL_INT_MSK_CLR_REG_LL_TIMER1_EQ_Y_SEL_Msk (0x100UL) /*!< LL_TIMER1_EQ_Y_SEL (Bitfield-Mask: 0x01)              */
#define CMAC_CM_LL_INT_MSK_CLR_REG_LL_TIMER1_EQ_X_SEL_Pos (7UL)     /*!< LL_TIMER1_EQ_X_SEL (Bit 7)                            */
#define CMAC_CM_LL_INT_MSK_CLR_REG_LL_TIMER1_EQ_X_SEL_Msk (0x80UL)  /*!< LL_TIMER1_EQ_X_SEL (Bitfield-Mask: 0x01)              */
#define CMAC_CM_LL_INT_MSK_CLR_REG_LL_TIMER1_36_10_EQ_Z_SEL_Pos (6UL) /*!< LL_TIMER1_36_10_EQ_Z_SEL (Bit 6)                    */
#define CMAC_CM_LL_INT_MSK_CLR_REG_LL_TIMER1_36_10_EQ_Z_SEL_Msk (0x40UL) /*!< LL_TIMER1_36_10_EQ_Z_SEL (Bitfield-Mask: 0x01)   */
#define CMAC_CM_LL_INT_MSK_CLR_REG_LL_TIMER1_36_10_EQ_Y_SEL_Pos (5UL) /*!< LL_TIMER1_36_10_EQ_Y_SEL (Bit 5)                    */
#define CMAC_CM_LL_INT_MSK_CLR_REG_LL_TIMER1_36_10_EQ_Y_SEL_Msk (0x20UL) /*!< LL_TIMER1_36_10_EQ_Y_SEL (Bitfield-Mask: 0x01)   */
#define CMAC_CM_LL_INT_MSK_CLR_REG_LL_TIMER1_36_10_EQ_X_SEL_Pos (4UL) /*!< LL_TIMER1_36_10_EQ_X_SEL (Bit 4)                    */
#define CMAC_CM_LL_INT_MSK_CLR_REG_LL_TIMER1_36_10_EQ_X_SEL_Msk (0x10UL) /*!< LL_TIMER1_36_10_EQ_X_SEL (Bitfield-Mask: 0x01)   */
#define CMAC_CM_LL_INT_MSK_CLR_REG_LL_TIMER1_36_10_EQ_0_SEL_Pos (3UL) /*!< LL_TIMER1_36_10_EQ_0_SEL (Bit 3)                    */
#define CMAC_CM_LL_INT_MSK_CLR_REG_LL_TIMER1_36_10_EQ_0_SEL_Msk (0x8UL) /*!< LL_TIMER1_36_10_EQ_0_SEL (Bitfield-Mask: 0x01)    */
#define CMAC_CM_LL_INT_MSK_CLR_REG_LL_TIMER1_9_0_EQ_Y_SEL_Pos (2UL) /*!< LL_TIMER1_9_0_EQ_Y_SEL (Bit 2)                        */
#define CMAC_CM_LL_INT_MSK_CLR_REG_LL_TIMER1_9_0_EQ_Y_SEL_Msk (0x4UL) /*!< LL_TIMER1_9_0_EQ_Y_SEL (Bitfield-Mask: 0x01)        */
#define CMAC_CM_LL_INT_MSK_CLR_REG_LL_TIMER1_9_0_EQ_X_SEL_Pos (1UL) /*!< LL_TIMER1_9_0_EQ_X_SEL (Bit 1)                        */
#define CMAC_CM_LL_INT_MSK_CLR_REG_LL_TIMER1_9_0_EQ_X_SEL_Msk (0x2UL) /*!< LL_TIMER1_9_0_EQ_X_SEL (Bitfield-Mask: 0x01)        */
#define CMAC_CM_LL_INT_MSK_CLR_REG_LL_TIMER1_9_0_EQ_0_SEL_Pos (0UL) /*!< LL_TIMER1_9_0_EQ_0_SEL (Bit 0)                        */
#define CMAC_CM_LL_INT_MSK_CLR_REG_LL_TIMER1_9_0_EQ_0_SEL_Msk (0x1UL) /*!< LL_TIMER1_9_0_EQ_0_SEL (Bitfield-Mask: 0x01)        */
/* =================================================  CM_LL_INT_MSK_SET_REG  ================================================= */
#define CMAC_CM_LL_INT_MSK_SET_REG_LL_TIMER1_EQ_Y_SEL_Pos (8UL)     /*!< LL_TIMER1_EQ_Y_SEL (Bit 8)                            */
#define CMAC_CM_LL_INT_MSK_SET_REG_LL_TIMER1_EQ_Y_SEL_Msk (0x100UL) /*!< LL_TIMER1_EQ_Y_SEL (Bitfield-Mask: 0x01)              */
#define CMAC_CM_LL_INT_MSK_SET_REG_LL_TIMER1_EQ_X_SEL_Pos (7UL)     /*!< LL_TIMER1_EQ_X_SEL (Bit 7)                            */
#define CMAC_CM_LL_INT_MSK_SET_REG_LL_TIMER1_EQ_X_SEL_Msk (0x80UL)  /*!< LL_TIMER1_EQ_X_SEL (Bitfield-Mask: 0x01)              */
#define CMAC_CM_LL_INT_MSK_SET_REG_LL_TIMER1_36_10_EQ_Z_SEL_Pos (6UL) /*!< LL_TIMER1_36_10_EQ_Z_SEL (Bit 6)                    */
#define CMAC_CM_LL_INT_MSK_SET_REG_LL_TIMER1_36_10_EQ_Z_SEL_Msk (0x40UL) /*!< LL_TIMER1_36_10_EQ_Z_SEL (Bitfield-Mask: 0x01)   */
#define CMAC_CM_LL_INT_MSK_SET_REG_LL_TIMER1_36_10_EQ_Y_SEL_Pos (5UL) /*!< LL_TIMER1_36_10_EQ_Y_SEL (Bit 5)                    */
#define CMAC_CM_LL_INT_MSK_SET_REG_LL_TIMER1_36_10_EQ_Y_SEL_Msk (0x20UL) /*!< LL_TIMER1_36_10_EQ_Y_SEL (Bitfield-Mask: 0x01)   */
#define CMAC_CM_LL_INT_MSK_SET_REG_LL_TIMER1_36_10_EQ_X_SEL_Pos (4UL) /*!< LL_TIMER1_36_10_EQ_X_SEL (Bit 4)                    */
#define CMAC_CM_LL_INT_MSK_SET_REG_LL_TIMER1_36_10_EQ_X_SEL_Msk (0x10UL) /*!< LL_TIMER1_36_10_EQ_X_SEL (Bitfield-Mask: 0x01)   */
#define CMAC_CM_LL_INT_MSK_SET_REG_LL_TIMER1_36_10_EQ_0_SEL_Pos (3UL) /*!< LL_TIMER1_36_10_EQ_0_SEL (Bit 3)                    */
#define CMAC_CM_LL_INT_MSK_SET_REG_LL_TIMER1_36_10_EQ_0_SEL_Msk (0x8UL) /*!< LL_TIMER1_36_10_EQ_0_SEL (Bitfield-Mask: 0x01)    */
#define CMAC_CM_LL_INT_MSK_SET_REG_LL_TIMER1_9_0_EQ_Y_SEL_Pos (2UL) /*!< LL_TIMER1_9_0_EQ_Y_SEL (Bit 2)                        */
#define CMAC_CM_LL_INT_MSK_SET_REG_LL_TIMER1_9_0_EQ_Y_SEL_Msk (0x4UL) /*!< LL_TIMER1_9_0_EQ_Y_SEL (Bitfield-Mask: 0x01)        */
#define CMAC_CM_LL_INT_MSK_SET_REG_LL_TIMER1_9_0_EQ_X_SEL_Pos (1UL) /*!< LL_TIMER1_9_0_EQ_X_SEL (Bit 1)                        */
#define CMAC_CM_LL_INT_MSK_SET_REG_LL_TIMER1_9_0_EQ_X_SEL_Msk (0x2UL) /*!< LL_TIMER1_9_0_EQ_X_SEL (Bitfield-Mask: 0x01)        */
#define CMAC_CM_LL_INT_MSK_SET_REG_LL_TIMER1_9_0_EQ_0_SEL_Pos (0UL) /*!< LL_TIMER1_9_0_EQ_0_SEL (Bit 0)                        */
#define CMAC_CM_LL_INT_MSK_SET_REG_LL_TIMER1_9_0_EQ_0_SEL_Msk (0x1UL) /*!< LL_TIMER1_9_0_EQ_0_SEL (Bitfield-Mask: 0x01)        */
/* ===================================================  CM_LL_INT_SEL_REG  =================================================== */
#define CMAC_CM_LL_INT_SEL_REG_LL_TIMER1_EQ_Y_SEL_Pos (8UL)         /*!< LL_TIMER1_EQ_Y_SEL (Bit 8)                            */
#define CMAC_CM_LL_INT_SEL_REG_LL_TIMER1_EQ_Y_SEL_Msk (0x100UL)     /*!< LL_TIMER1_EQ_Y_SEL (Bitfield-Mask: 0x01)              */
#define CMAC_CM_LL_INT_SEL_REG_LL_TIMER1_EQ_X_SEL_Pos (7UL)         /*!< LL_TIMER1_EQ_X_SEL (Bit 7)                            */
#define CMAC_CM_LL_INT_SEL_REG_LL_TIMER1_EQ_X_SEL_Msk (0x80UL)      /*!< LL_TIMER1_EQ_X_SEL (Bitfield-Mask: 0x01)              */
#define CMAC_CM_LL_INT_SEL_REG_LL_TIMER1_36_10_EQ_Z_SEL_Pos (6UL)   /*!< LL_TIMER1_36_10_EQ_Z_SEL (Bit 6)                      */
#define CMAC_CM_LL_INT_SEL_REG_LL_TIMER1_36_10_EQ_Z_SEL_Msk (0x40UL) /*!< LL_TIMER1_36_10_EQ_Z_SEL (Bitfield-Mask: 0x01)       */
#define CMAC_CM_LL_INT_SEL_REG_LL_TIMER1_36_10_EQ_Y_SEL_Pos (5UL)   /*!< LL_TIMER1_36_10_EQ_Y_SEL (Bit 5)                      */
#define CMAC_CM_LL_INT_SEL_REG_LL_TIMER1_36_10_EQ_Y_SEL_Msk (0x20UL) /*!< LL_TIMER1_36_10_EQ_Y_SEL (Bitfield-Mask: 0x01)       */
#define CMAC_CM_LL_INT_SEL_REG_LL_TIMER1_36_10_EQ_X_SEL_Pos (4UL)   /*!< LL_TIMER1_36_10_EQ_X_SEL (Bit 4)                      */
#define CMAC_CM_LL_INT_SEL_REG_LL_TIMER1_36_10_EQ_X_SEL_Msk (0x10UL) /*!< LL_TIMER1_36_10_EQ_X_SEL (Bitfield-Mask: 0x01)       */
#define CMAC_CM_LL_INT_SEL_REG_LL_TIMER1_36_10_EQ_0_SEL_Pos (3UL)   /*!< LL_TIMER1_36_10_EQ_0_SEL (Bit 3)                      */
#define CMAC_CM_LL_INT_SEL_REG_LL_TIMER1_36_10_EQ_0_SEL_Msk (0x8UL) /*!< LL_TIMER1_36_10_EQ_0_SEL (Bitfield-Mask: 0x01)        */
#define CMAC_CM_LL_INT_SEL_REG_LL_TIMER1_9_0_EQ_Y_SEL_Pos (2UL)     /*!< LL_TIMER1_9_0_EQ_Y_SEL (Bit 2)                        */
#define CMAC_CM_LL_INT_SEL_REG_LL_TIMER1_9_0_EQ_Y_SEL_Msk (0x4UL)   /*!< LL_TIMER1_9_0_EQ_Y_SEL (Bitfield-Mask: 0x01)          */
#define CMAC_CM_LL_INT_SEL_REG_LL_TIMER1_9_0_EQ_X_SEL_Pos (1UL)     /*!< LL_TIMER1_9_0_EQ_X_SEL (Bit 1)                        */
#define CMAC_CM_LL_INT_SEL_REG_LL_TIMER1_9_0_EQ_X_SEL_Msk (0x2UL)   /*!< LL_TIMER1_9_0_EQ_X_SEL (Bitfield-Mask: 0x01)          */
#define CMAC_CM_LL_INT_SEL_REG_LL_TIMER1_9_0_EQ_0_SEL_Pos (0UL)     /*!< LL_TIMER1_9_0_EQ_0_SEL (Bit 0)                        */
#define CMAC_CM_LL_INT_SEL_REG_LL_TIMER1_9_0_EQ_0_SEL_Msk (0x1UL)   /*!< LL_TIMER1_9_0_EQ_0_SEL (Bitfield-Mask: 0x01)          */
/* ==================================================  CM_LL_INT_STAT_REG  =================================================== */
#define CMAC_CM_LL_INT_STAT_REG_LL_TIMER1_EQ_Y_SEL_Pos (8UL)        /*!< LL_TIMER1_EQ_Y_SEL (Bit 8)                            */
#define CMAC_CM_LL_INT_STAT_REG_LL_TIMER1_EQ_Y_SEL_Msk (0x100UL)    /*!< LL_TIMER1_EQ_Y_SEL (Bitfield-Mask: 0x01)              */
#define CMAC_CM_LL_INT_STAT_REG_LL_TIMER1_EQ_X_SEL_Pos (7UL)        /*!< LL_TIMER1_EQ_X_SEL (Bit 7)                            */
#define CMAC_CM_LL_INT_STAT_REG_LL_TIMER1_EQ_X_SEL_Msk (0x80UL)     /*!< LL_TIMER1_EQ_X_SEL (Bitfield-Mask: 0x01)              */
#define CMAC_CM_LL_INT_STAT_REG_LL_TIMER1_36_10_EQ_Z_SEL_Pos (6UL)  /*!< LL_TIMER1_36_10_EQ_Z_SEL (Bit 6)                      */
#define CMAC_CM_LL_INT_STAT_REG_LL_TIMER1_36_10_EQ_Z_SEL_Msk (0x40UL) /*!< LL_TIMER1_36_10_EQ_Z_SEL (Bitfield-Mask: 0x01)      */
#define CMAC_CM_LL_INT_STAT_REG_LL_TIMER1_36_10_EQ_Y_SEL_Pos (5UL)  /*!< LL_TIMER1_36_10_EQ_Y_SEL (Bit 5)                      */
#define CMAC_CM_LL_INT_STAT_REG_LL_TIMER1_36_10_EQ_Y_SEL_Msk (0x20UL) /*!< LL_TIMER1_36_10_EQ_Y_SEL (Bitfield-Mask: 0x01)      */
#define CMAC_CM_LL_INT_STAT_REG_LL_TIMER1_36_10_EQ_X_SEL_Pos (4UL)  /*!< LL_TIMER1_36_10_EQ_X_SEL (Bit 4)                      */
#define CMAC_CM_LL_INT_STAT_REG_LL_TIMER1_36_10_EQ_X_SEL_Msk (0x10UL) /*!< LL_TIMER1_36_10_EQ_X_SEL (Bitfield-Mask: 0x01)      */
#define CMAC_CM_LL_INT_STAT_REG_LL_TIMER1_36_10_EQ_0_SEL_Pos (3UL)  /*!< LL_TIMER1_36_10_EQ_0_SEL (Bit 3)                      */
#define CMAC_CM_LL_INT_STAT_REG_LL_TIMER1_36_10_EQ_0_SEL_Msk (0x8UL) /*!< LL_TIMER1_36_10_EQ_0_SEL (Bitfield-Mask: 0x01)       */
#define CMAC_CM_LL_INT_STAT_REG_LL_TIMER1_9_0_EQ_Y_SEL_Pos (2UL)    /*!< LL_TIMER1_9_0_EQ_Y_SEL (Bit 2)                        */
#define CMAC_CM_LL_INT_STAT_REG_LL_TIMER1_9_0_EQ_Y_SEL_Msk (0x4UL)  /*!< LL_TIMER1_9_0_EQ_Y_SEL (Bitfield-Mask: 0x01)          */
#define CMAC_CM_LL_INT_STAT_REG_LL_TIMER1_9_0_EQ_X_SEL_Pos (1UL)    /*!< LL_TIMER1_9_0_EQ_X_SEL (Bit 1)                        */
#define CMAC_CM_LL_INT_STAT_REG_LL_TIMER1_9_0_EQ_X_SEL_Msk (0x2UL)  /*!< LL_TIMER1_9_0_EQ_X_SEL (Bitfield-Mask: 0x01)          */
#define CMAC_CM_LL_INT_STAT_REG_LL_TIMER1_9_0_EQ_0_SEL_Pos (0UL)    /*!< LL_TIMER1_9_0_EQ_0_SEL (Bit 0)                        */
#define CMAC_CM_LL_INT_STAT_REG_LL_TIMER1_9_0_EQ_0_SEL_Msk (0x1UL)  /*!< LL_TIMER1_9_0_EQ_0_SEL (Bitfield-Mask: 0x01)          */
/* ==============================================  CM_LL_TIMER1_36_10_EQ_X_REG  ============================================== */
#define CMAC_CM_LL_TIMER1_36_10_EQ_X_REG_LL_TIMER1_36_10_BF_Pos (0UL) /*!< LL_TIMER1_36_10_BF (Bit 0)                          */
#define CMAC_CM_LL_TIMER1_36_10_EQ_X_REG_LL_TIMER1_36_10_BF_Msk (0x7ffffffUL) /*!< LL_TIMER1_36_10_BF (Bitfield-Mask: 0x7ffffff) */
/* ==============================================  CM_LL_TIMER1_36_10_EQ_Y_REG  ============================================== */
#define CMAC_CM_LL_TIMER1_36_10_EQ_Y_REG_LL_TIMER1_36_10_BF_Pos (0UL) /*!< LL_TIMER1_36_10_BF (Bit 0)                          */
#define CMAC_CM_LL_TIMER1_36_10_EQ_Y_REG_LL_TIMER1_36_10_BF_Msk (0x7ffffffUL) /*!< LL_TIMER1_36_10_BF (Bitfield-Mask: 0x7ffffff) */
/* ==============================================  CM_LL_TIMER1_36_10_EQ_Z_REG  ============================================== */
#define CMAC_CM_LL_TIMER1_36_10_EQ_Z_REG_LL_TIMER1_36_10_BF_Pos (0UL) /*!< LL_TIMER1_36_10_BF (Bit 0)                          */
#define CMAC_CM_LL_TIMER1_36_10_EQ_Z_REG_LL_TIMER1_36_10_BF_Msk (0x7ffffffUL) /*!< LL_TIMER1_36_10_BF (Bitfield-Mask: 0x7ffffff) */
/* ================================================  CM_LL_TIMER1_36_10_REG  ================================================= */
#define CMAC_CM_LL_TIMER1_36_10_REG_LL_TIMER1_36_10_BF_Pos (0UL)    /*!< LL_TIMER1_36_10_BF (Bit 0)                            */
#define CMAC_CM_LL_TIMER1_36_10_REG_LL_TIMER1_36_10_BF_Msk (0x7ffffffUL) /*!< LL_TIMER1_36_10_BF (Bitfield-Mask: 0x7ffffff)    */
/* ===============================================  CM_LL_TIMER1_9_0_EQ_X_REG  =============================================== */
#define CMAC_CM_LL_TIMER1_9_0_EQ_X_REG_LL_TIMER1_9_0_BF_Pos (0UL)   /*!< LL_TIMER1_9_0_BF (Bit 0)                              */
#define CMAC_CM_LL_TIMER1_9_0_EQ_X_REG_LL_TIMER1_9_0_BF_Msk (0x3ffUL) /*!< LL_TIMER1_9_0_BF (Bitfield-Mask: 0x3ff)             */
/* ===============================================  CM_LL_TIMER1_9_0_EQ_Y_REG  =============================================== */
#define CMAC_CM_LL_TIMER1_9_0_EQ_Y_REG_LL_TIMER1_9_0_BF_Pos (0UL)   /*!< LL_TIMER1_9_0_BF (Bit 0)                              */
#define CMAC_CM_LL_TIMER1_9_0_EQ_Y_REG_LL_TIMER1_9_0_BF_Msk (0x3ffUL) /*!< LL_TIMER1_9_0_BF (Bitfield-Mask: 0x3ff)             */
/* =================================================  CM_LL_TIMER1_9_0_REG  ================================================== */
#define CMAC_CM_LL_TIMER1_9_0_REG_LL_TIMER1_9_0_BF_Pos (0UL)        /*!< LL_TIMER1_9_0_BF (Bit 0)                              */
#define CMAC_CM_LL_TIMER1_9_0_REG_LL_TIMER1_9_0_BF_Msk (0x3ffUL)    /*!< LL_TIMER1_9_0_BF (Bitfield-Mask: 0x3ff)               */
/* ===============================================  CM_LL_TIMER1_EQ_X_HI_REG  ================================================ */
#define CMAC_CM_LL_TIMER1_EQ_X_HI_REG_LL_TIMER1_36_10_BF_Pos (0UL)  /*!< LL_TIMER1_36_10_BF (Bit 0)                            */
#define CMAC_CM_LL_TIMER1_EQ_X_HI_REG_LL_TIMER1_36_10_BF_Msk (0x7ffffffUL) /*!< LL_TIMER1_36_10_BF (Bitfield-Mask: 0x7ffffff)  */
/* ===============================================  CM_LL_TIMER1_EQ_X_LO_REG  ================================================ */
#define CMAC_CM_LL_TIMER1_EQ_X_LO_REG_LL_TIMER1_9_0_BF_Pos (0UL)    /*!< LL_TIMER1_9_0_BF (Bit 0)                              */
#define CMAC_CM_LL_TIMER1_EQ_X_LO_REG_LL_TIMER1_9_0_BF_Msk (0x3ffUL) /*!< LL_TIMER1_9_0_BF (Bitfield-Mask: 0x3ff)              */
/* ==============================================  CM_LL_TIMER1_EQ_Y_CTRL_REG  =============================================== */
#define CMAC_CM_LL_TIMER1_EQ_Y_CTRL_REG_LL_TIMER1_EQ_Y_36_15_EN_Pos (6UL) /*!< LL_TIMER1_EQ_Y_36_15_EN (Bit 6)                 */
#define CMAC_CM_LL_TIMER1_EQ_Y_CTRL_REG_LL_TIMER1_EQ_Y_36_15_EN_Msk (0x40UL) /*!< LL_TIMER1_EQ_Y_36_15_EN (Bitfield-Mask: 0x01) */
#define CMAC_CM_LL_TIMER1_EQ_Y_CTRL_REG_LL_TIMER1_EQ_Y_14_EN_Pos (5UL) /*!< LL_TIMER1_EQ_Y_14_EN (Bit 5)                       */
#define CMAC_CM_LL_TIMER1_EQ_Y_CTRL_REG_LL_TIMER1_EQ_Y_14_EN_Msk (0x20UL) /*!< LL_TIMER1_EQ_Y_14_EN (Bitfield-Mask: 0x01)      */
#define CMAC_CM_LL_TIMER1_EQ_Y_CTRL_REG_LL_TIMER1_EQ_Y_13_EN_Pos (4UL) /*!< LL_TIMER1_EQ_Y_13_EN (Bit 4)                       */
#define CMAC_CM_LL_TIMER1_EQ_Y_CTRL_REG_LL_TIMER1_EQ_Y_13_EN_Msk (0x10UL) /*!< LL_TIMER1_EQ_Y_13_EN (Bitfield-Mask: 0x01)      */
#define CMAC_CM_LL_TIMER1_EQ_Y_CTRL_REG_LL_TIMER1_EQ_Y_12_EN_Pos (3UL) /*!< LL_TIMER1_EQ_Y_12_EN (Bit 3)                       */
#define CMAC_CM_LL_TIMER1_EQ_Y_CTRL_REG_LL_TIMER1_EQ_Y_12_EN_Msk (0x8UL) /*!< LL_TIMER1_EQ_Y_12_EN (Bitfield-Mask: 0x01)       */
#define CMAC_CM_LL_TIMER1_EQ_Y_CTRL_REG_LL_TIMER1_EQ_Y_11_EN_Pos (2UL) /*!< LL_TIMER1_EQ_Y_11_EN (Bit 2)                       */
#define CMAC_CM_LL_TIMER1_EQ_Y_CTRL_REG_LL_TIMER1_EQ_Y_11_EN_Msk (0x4UL) /*!< LL_TIMER1_EQ_Y_11_EN (Bitfield-Mask: 0x01)       */
#define CMAC_CM_LL_TIMER1_EQ_Y_CTRL_REG_LL_TIMER1_EQ_Y_10_EN_Pos (1UL) /*!< LL_TIMER1_EQ_Y_10_EN (Bit 1)                       */
#define CMAC_CM_LL_TIMER1_EQ_Y_CTRL_REG_LL_TIMER1_EQ_Y_10_EN_Msk (0x2UL) /*!< LL_TIMER1_EQ_Y_10_EN (Bitfield-Mask: 0x01)       */
#define CMAC_CM_LL_TIMER1_EQ_Y_CTRL_REG_LL_TIMER1_EQ_Y_9_0_EN_Pos (0UL) /*!< LL_TIMER1_EQ_Y_9_0_EN (Bit 0)                     */
#define CMAC_CM_LL_TIMER1_EQ_Y_CTRL_REG_LL_TIMER1_EQ_Y_9_0_EN_Msk (0x1UL) /*!< LL_TIMER1_EQ_Y_9_0_EN (Bitfield-Mask: 0x01)     */
/* ===============================================  CM_LL_TIMER1_EQ_Y_HI_REG  ================================================ */
#define CMAC_CM_LL_TIMER1_EQ_Y_HI_REG_LL_TIMER1_36_10_BF_Pos (0UL)  /*!< LL_TIMER1_36_10_BF (Bit 0)                            */
#define CMAC_CM_LL_TIMER1_EQ_Y_HI_REG_LL_TIMER1_36_10_BF_Msk (0x7ffffffUL) /*!< LL_TIMER1_36_10_BF (Bitfield-Mask: 0x7ffffff)  */
/* ===============================================  CM_LL_TIMER1_EQ_Y_LO_REG  ================================================ */
#define CMAC_CM_LL_TIMER1_EQ_Y_LO_REG_LL_TIMER1_9_0_BF_Pos (0UL)    /*!< LL_TIMER1_9_0_BF (Bit 0)                              */
#define CMAC_CM_LL_TIMER1_EQ_Y_LO_REG_LL_TIMER1_9_0_BF_Msk (0x3ffUL) /*!< LL_TIMER1_9_0_BF (Bitfield-Mask: 0x3ff)              */
/* ===================================================  CM_PHY_CTRL2_REG  ==================================================== */
#define CMAC_CM_PHY_CTRL2_REG_CORR_WINDOW_Pos (18UL)                /*!< CORR_WINDOW (Bit 18)                                  */
#define CMAC_CM_PHY_CTRL2_REG_CORR_WINDOW_Msk (0xfffc0000UL)        /*!< CORR_WINDOW (Bitfield-Mask: 0x3fff)                   */
#define CMAC_CM_PHY_CTRL2_REG_CORR_ERRORS_ALLOW_Pos (15UL)          /*!< CORR_ERRORS_ALLOW (Bit 15)                            */
#define CMAC_CM_PHY_CTRL2_REG_CORR_ERRORS_ALLOW_Msk (0x38000UL)     /*!< CORR_ERRORS_ALLOW (Bitfield-Mask: 0x07)               */
#define CMAC_CM_PHY_CTRL2_REG_CORR_CLK_MODE_Pos (13UL)              /*!< CORR_CLK_MODE (Bit 13)                                */
#define CMAC_CM_PHY_CTRL2_REG_CORR_CLK_MODE_Msk (0x6000UL)          /*!< CORR_CLK_MODE (Bitfield-Mask: 0x03)                   */
#define CMAC_CM_PHY_CTRL2_REG_CORR_SMPL_MODE_Pos (10UL)             /*!< CORR_SMPL_MODE (Bit 10)                               */
#define CMAC_CM_PHY_CTRL2_REG_CORR_SMPL_MODE_Msk (0x1c00UL)         /*!< CORR_SMPL_MODE (Bitfield-Mask: 0x07)                  */
#define CMAC_CM_PHY_CTRL2_REG_TXRX_EN_0_FROM_FRAME_Pos (9UL)        /*!< TXRX_EN_0_FROM_FRAME (Bit 9)                          */
#define CMAC_CM_PHY_CTRL2_REG_TXRX_EN_0_FROM_FRAME_Msk (0x200UL)    /*!< TXRX_EN_0_FROM_FRAME (Bitfield-Mask: 0x01)            */
#define CMAC_CM_PHY_CTRL2_REG_PHY_MODE_Pos (8UL)                    /*!< PHY_MODE (Bit 8)                                      */
#define CMAC_CM_PHY_CTRL2_REG_PHY_MODE_Msk (0x100UL)                /*!< PHY_MODE (Bitfield-Mask: 0x01)                        */
#define CMAC_CM_PHY_CTRL2_REG_PHY_RF_CHANNEL_Pos (0UL)              /*!< PHY_RF_CHANNEL (Bit 0)                                */
#define CMAC_CM_PHY_CTRL2_REG_PHY_RF_CHANNEL_Msk (0x3fUL)           /*!< PHY_RF_CHANNEL (Bitfield-Mask: 0x3f)                  */
/* ====================================================  CM_PHY_CTRL_REG  ==================================================== */
#define CMAC_CM_PHY_CTRL_REG_PHY_PWR_DN_RX_M1_Pos (24UL)            /*!< PHY_PWR_DN_RX_M1 (Bit 24)                             */
#define CMAC_CM_PHY_CTRL_REG_PHY_PWR_DN_RX_M1_Msk (0x7f000000UL)    /*!< PHY_PWR_DN_RX_M1 (Bitfield-Mask: 0x7f)                */
#define CMAC_CM_PHY_CTRL_REG_PHY_PWR_DN_TX_M1_Pos (16UL)            /*!< PHY_PWR_DN_TX_M1 (Bit 16)                             */
#define CMAC_CM_PHY_CTRL_REG_PHY_PWR_DN_TX_M1_Msk (0x7f0000UL)      /*!< PHY_PWR_DN_TX_M1 (Bitfield-Mask: 0x7f)                */
#define CMAC_CM_PHY_CTRL_REG_PHY_PWR_UP_RX_M1_Pos (8UL)             /*!< PHY_PWR_UP_RX_M1 (Bit 8)                              */
#define CMAC_CM_PHY_CTRL_REG_PHY_PWR_UP_RX_M1_Msk (0x7f00UL)        /*!< PHY_PWR_UP_RX_M1 (Bitfield-Mask: 0x7f)                */
#define CMAC_CM_PHY_CTRL_REG_PHY_PWR_UP_TX_M1_Pos (0UL)             /*!< PHY_PWR_UP_TX_M1 (Bit 0)                              */
#define CMAC_CM_PHY_CTRL_REG_PHY_PWR_UP_TX_M1_Msk (0x7fUL)          /*!< PHY_PWR_UP_TX_M1 (Bitfield-Mask: 0x7f)                */
/* ======================================================  CM_STAT_REG  ====================================================== */
#define CMAC_CM_STAT_REG_CM_FRAME_TIMER_Pos (16UL)                  /*!< CM_FRAME_TIMER (Bit 16)                               */
#define CMAC_CM_STAT_REG_CM_FRAME_TIMER_Msk (0x3fff0000UL)          /*!< CM_FRAME_TIMER (Bitfield-Mask: 0x3fff)                */
#define CMAC_CM_STAT_REG_CORR_EYEDGRM_CNT_Pos (10UL)                /*!< CORR_EYEDGRM_CNT (Bit 10)                             */
#define CMAC_CM_STAT_REG_CORR_EYEDGRM_CNT_Msk (0xfc00UL)            /*!< CORR_EYEDGRM_CNT (Bitfield-Mask: 0x3f)                */
#define CMAC_CM_STAT_REG_COEX_EXT_ACT_Pos (6UL)                     /*!< COEX_EXT_ACT (Bit 6)                                  */
#define CMAC_CM_STAT_REG_COEX_EXT_ACT_Msk (0x40UL)                  /*!< COEX_EXT_ACT (Bitfield-Mask: 0x01)                    */
#define CMAC_CM_STAT_REG_SWD_ATTACHED_Pos (5UL)                     /*!< SWD_ATTACHED (Bit 5)                                  */
#define CMAC_CM_STAT_REG_SWD_ATTACHED_Msk (0x20UL)                  /*!< SWD_ATTACHED (Bitfield-Mask: 0x01)                    */
#define CMAC_CM_STAT_REG_TIMERS_HALT_Pos  (4UL)                     /*!< TIMERS_HALT (Bit 4)                                   */
#define CMAC_CM_STAT_REG_TIMERS_HALT_Msk  (0x10UL)                  /*!< TIMERS_HALT (Bitfield-Mask: 0x01)                     */
#define CMAC_CM_STAT_REG_FRAME_FSM_TRANSFER_Pos (3UL)               /*!< FRAME_FSM_TRANSFER (Bit 3)                            */
#define CMAC_CM_STAT_REG_FRAME_FSM_TRANSFER_Msk (0x8UL)             /*!< FRAME_FSM_TRANSFER (Bitfield-Mask: 0x01)              */
#define CMAC_CM_STAT_REG_FRAME_FSM_BUSY_Pos (2UL)                   /*!< FRAME_FSM_BUSY (Bit 2)                                */
#define CMAC_CM_STAT_REG_FRAME_FSM_BUSY_Msk (0x4UL)                 /*!< FRAME_FSM_BUSY (Bitfield-Mask: 0x01)                  */
#define CMAC_CM_STAT_REG_PHY_RDY4BS_FORCE_0_Pos (1UL)               /*!< PHY_RDY4BS_FORCE_0 (Bit 1)                            */
#define CMAC_CM_STAT_REG_PHY_RDY4BS_FORCE_0_Msk (0x2UL)             /*!< PHY_RDY4BS_FORCE_0 (Bitfield-Mask: 0x01)              */
#define CMAC_CM_STAT_REG_CALLBACK_IRQ_VALID_Pos (0UL)               /*!< CALLBACK_IRQ_VALID (Bit 0)                            */
#define CMAC_CM_STAT_REG_CALLBACK_IRQ_VALID_Msk (0x1UL)             /*!< CALLBACK_IRQ_VALID (Bitfield-Mask: 0x01)              */
/* ======================================================  CM_TS1_REG  ======================================================= */
#define CMAC_CM_TS1_REG_TS1_DIRTY_Pos     (31UL)                    /*!< TS1_DIRTY (Bit 31)                                    */
#define CMAC_CM_TS1_REG_TS1_DIRTY_Msk     (0x80000000UL)            /*!< TS1_DIRTY (Bitfield-Mask: 0x01)                       */
#define CMAC_CM_TS1_REG_TS1_CLK_CNT1MHZ_Pos (22UL)                  /*!< TS1_CLK_CNT1MHZ (Bit 22)                              */
#define CMAC_CM_TS1_REG_TS1_CLK_CNT1MHZ_Msk (0x400000UL)            /*!< TS1_CLK_CNT1MHZ (Bitfield-Mask: 0x01)                 */
#define CMAC_CM_TS1_REG_TS1_CLK_CNT2MHZ_Pos (16UL)                  /*!< TS1_CLK_CNT2MHZ (Bit 16)                              */
#define CMAC_CM_TS1_REG_TS1_CLK_CNT2MHZ_Msk (0x3f0000UL)            /*!< TS1_CLK_CNT2MHZ (Bitfield-Mask: 0x3f)                 */
#define CMAC_CM_TS1_REG_TS1_TIMER1_10_Pos (10UL)                    /*!< TS1_TIMER1_10 (Bit 10)                                */
#define CMAC_CM_TS1_REG_TS1_TIMER1_10_Msk (0x400UL)                 /*!< TS1_TIMER1_10 (Bitfield-Mask: 0x01)                   */
#define CMAC_CM_TS1_REG_TS1_TIMER1_9_0_Pos (0UL)                    /*!< TS1_TIMER1_9_0 (Bit 0)                                */
#define CMAC_CM_TS1_REG_TS1_TIMER1_9_0_Msk (0x3ffUL)                /*!< TS1_TIMER1_9_0 (Bitfield-Mask: 0x3ff)                 */
/* ===================================================  CM_WHITENING_REG  ==================================================== */
#define CMAC_CM_WHITENING_REG_WHITENING_LFSR_Pos (0UL)              /*!< WHITENING_LFSR (Bit 0)                                */
#define CMAC_CM_WHITENING_REG_WHITENING_LFSR_Msk (0x7fUL)           /*!< WHITENING_LFSR (Bitfield-Mask: 0x7f)                  */

/* ----------------------------  CMAC_CM_CTRL_SYS_REG  ---------------------------- */
#define CMAC_CM_CTRL_SYS_REG_CMAC2SYS_IRQ_STATE_Pos (0UL)               /*!< CMAC CM_CTRL_SYS_REG: CMAC2SYS_IRQ_STATE (Bit 0)            */
#define CMAC_CM_CTRL_SYS_REG_CMAC2SYS_IRQ_STATE_Msk (0x1UL)             /*!< CMAC CM_CTRL_SYS_REG: CMAC2SYS_IRQ_STATE (Bitfield-Mask: 0x01) */
#define CMAC_CM_CTRL_SYS_REG_CMAC2SYS_IRQ_CLR_Pos (1UL)                 /*!< CMAC CM_CTRL_SYS_REG: CMAC2SYS_IRQ_CLR (Bit 1)              */
#define CMAC_CM_CTRL_SYS_REG_CMAC2SYS_IRQ_CLR_Msk (0x2UL)               /*!< CMAC CM_CTRL_SYS_REG: CMAC2SYS_IRQ_CLR (Bitfield-Mask: 0x01) */
#define CMAC_CM_CTRL_SYS_REG_CMAC_RST_BS_STATE_Pos (7UL)                /*!< CMAC CM_CTRL_SYS_REG: CMAC_RST_BS_STATE (Bit 7)             */
#define CMAC_CM_CTRL_SYS_REG_CMAC_RST_BS_STATE_Msk (0x80UL)             /*!< CMAC CM_CTRL_SYS_REG: CMAC_RST_BS_STATE (Bitfield-Mask: 0x01) */
#define CMAC_CM_CTRL_SYS_REG_CMAC_RST_MCPU_STATE_Pos (8UL)              /*!< CMAC CM_CTRL_SYS_REG: CMAC_RST_MCPU_STATE (Bit 8)           */
#define CMAC_CM_CTRL_SYS_REG_CMAC_RST_MCPU_STATE_Msk (0x100UL)          /*!< CMAC CM_CTRL_SYS_REG: CMAC_RST_MCPU_STATE (Bitfield-Mask: 0x01) */
#define CMAC_CM_CTRL_SYS_REG_MCPU_SLEEPING_STATE_Pos (9UL)              /*!< CMAC CM_CTRL_SYS_REG: MCPU_SLEEPING_STATE (Bit 9)           */
#define CMAC_CM_CTRL_SYS_REG_MCPU_SLEEPING_STATE_Msk (0x200UL)          /*!< CMAC CM_CTRL_SYS_REG: MCPU_SLEEPING_STATE (Bitfield-Mask: 0x01) */
#define CMAC_CM_CTRL_SYS_REG_CMAC_FW_ERROR_STATE_Pos (10UL)             /*!< CMAC CM_CTRL_SYS_REG: CMAC_FW_ERROR_STATE (Bit 10)          */
#define CMAC_CM_CTRL_SYS_REG_CMAC_FW_ERROR_STATE_Msk (0x400UL)          /*!< CMAC CM_CTRL_SYS_REG: CMAC_FW_ERROR_STATE (Bitfield-Mask: 0x01) */
#define CMAC_CM_CTRL_SYS_REG_CMAC_BS_ERROR_STATE_Pos (11UL)             /*!< CMAC CM_CTRL_SYS_REG: CMAC_BS_ERROR_STATE (Bit 11)          */
#define CMAC_CM_CTRL_SYS_REG_CMAC_BS_ERROR_STATE_Msk (0x800UL)          /*!< CMAC CM_CTRL_SYS_REG: CMAC_BS_ERROR_STATE (Bitfield-Mask: 0x01) */
#define CMAC_CM_CTRL_SYS_REG_CMAC_CPU_ERROR_STATE_Pos (12UL)            /*!< CMAC CM_CTRL_SYS_REG: CMAC_CPU_ERROR_STATE (Bit 12)         */
#define CMAC_CM_CTRL_SYS_REG_CMAC_CPU_ERROR_STATE_Msk (0x1000UL)        /*!< CMAC CM_CTRL_SYS_REG: CMAC_CPU_ERROR_STATE (Bitfield-Mask: 0x01) */
#define CMAC_CM_CTRL_SYS_REG_CMAC_SYSMEMCTRL_ERROR_STATE_Pos (13UL)     /*!< CMAC CM_CTRL_SYS_REG: CMAC_SYSMEMCTRL_ERROR_STATE (Bit 13)  */
#define CMAC_CM_CTRL_SYS_REG_CMAC_SYSMEMCTRL_ERROR_STATE_Msk (0x2000UL) /*!< CMAC CM_CTRL_SYS_REG: CMAC_SYSMEMCTRL_ERROR_STATE (Bitfield-Mask: 0x01) */
#define CMAC_CM_CTRL_SYS_REG_CMAC_WDOG_EXPIRE_STATE_Pos (14UL)          /*!< CMAC CM_CTRL_SYS_REG: CMAC_WDOG_EXPIRE_STATE (Bit 14)       */
#define CMAC_CM_CTRL_SYS_REG_CMAC_WDOG_EXPIRE_STATE_Msk (0x4000UL)      /*!< CMAC CM_CTRL_SYS_REG: CMAC_WDOG_EXPIRE_STATE (Bitfield-Mask: 0x01) */
#define CMAC_CM_CTRL_SYS_REG_CMAC_LOCKUP_STATE_Pos (15UL)               /*!< CMAC CM_CTRL_SYS_REG: CMAC_LOCKUP_STATE (Bit 15)            */
#define CMAC_CM_CTRL_SYS_REG_CMAC_LOCKUP_STATE_Msk (0x8000UL)           /*!< CMAC CM_CTRL_SYS_REG: CMAC_LOCKUP_STATE (Bitfield-Mask: 0x01) */
#define CMAC_CM_CTRL_SYS_REG_CMAC_CONST_1_Pos (31UL)                    /*!< CMAC CM_CTRL_SYS_REG: CMAC_CONST_1 (Bit 31)                 */
#define CMAC_CM_CTRL_SYS_REG_CMAC_CONST_1_Msk (0x80000000UL)            /*!< CMAC CM_CTRL_SYS_REG: CMAC_CONST_1 (Bitfield-Mask: 0x01)    */

/* ------------------------------  CMAC_CM_WDOG_REG  ------------------------------ */
#define CMAC_CM_WDOG_REG_CM_WDOG_CNT_Pos      (0UL)                     /*!< CMAC CM_WDOG_REG: CM_WDOG_CNT (Bit 0)                       */
#define CMAC_CM_WDOG_REG_CM_WDOG_CNT_Msk      (0x1fffUL)                /*!< CMAC CM_WDOG_REG: CM_WDOG_CNT (Bitfield-Mask: 0x1fff)       */
#define CMAC_CM_WDOG_REG_CM_WDOG_WRITE_VALID_Pos (17UL)                 /*!< CMAC CM_WDOG_REG: CM_WDOG_WRITE_VALID (Bit 17)              */
#define CMAC_CM_WDOG_REG_CM_WDOG_WRITE_VALID_Msk (0x60000UL)            /*!< CMAC CM_WDOG_REG: CM_WDOG_WRITE_VALID (Bitfield-Mask: 0x03) */
#define CMAC_CM_WDOG_REG_CM_WDOG_SYS_RST_REQ_Pos (28UL)                 /*!< CMAC CM_WDOG_REG: CM_WDOG_SYS_RST_REQ (Bit 28)              */
#define CMAC_CM_WDOG_REG_CM_WDOG_SYS_RST_REQ_Msk (0x10000000UL)         /*!< CMAC CM_WDOG_REG: CM_WDOG_SYS_RST_REQ (Bitfield-Mask: 0x01) */
#define CMAC_CM_WDOG_REG_CM_WDOG_EXPIRE_Pos   (29UL)                    /*!< CMAC CM_WDOG_REG: CM_WDOG_EXPIRE (Bit 29)                   */
#define CMAC_CM_WDOG_REG_CM_WDOG_EXPIRE_Msk   (0x20000000UL)            /*!< CMAC CM_WDOG_REG: CM_WDOG_EXPIRE (Bitfield-Mask: 0x01)      */
#define CMAC_CM_WDOG_REG_SYS2CMAC_WDOG_FREEZE_DIS_Pos (30UL)            /*!< CMAC CM_WDOG_REG: SYS2CMAC_WDOG_FREEZE_DIS (Bit 30)         */
#define CMAC_CM_WDOG_REG_SYS2CMAC_WDOG_FREEZE_DIS_Msk (0x40000000UL)    /*!< CMAC CM_WDOG_REG: SYS2CMAC_WDOG_FREEZE_DIS (Bitfield-Mask: 0x01) */
#define CMAC_CM_WDOG_REG_SYS2CMAC_WDOG_FREEZE_Pos (31UL)                /*!< CMAC CM_WDOG_REG: SYS2CMAC_WDOG_FREEZE (Bit 31)             */
#define CMAC_CM_WDOG_REG_SYS2CMAC_WDOG_FREEZE_Msk (0x80000000UL)        /*!< CMAC CM_WDOG_REG: SYS2CMAC_WDOG_FREEZE (Bitfield-Mask: 0x01) */

/* -------------------------  CMAC_CM_DIAG_IRQ1_WORD_REG  ------------------------- */
#define CMAC_CM_DIAG_IRQ1_WORD_REG_DIAG1_DCF_21_Pos (0UL)               /*!< CMAC CM_DIAG_IRQ1_WORD_REG: DIAG1_DCF_21 (Bit 0)            */
#define CMAC_CM_DIAG_IRQ1_WORD_REG_DIAG1_DCF_21_Msk (0x1UL)             /*!< CMAC CM_DIAG_IRQ1_WORD_REG: DIAG1_DCF_21 (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_WORD_REG_DIAG1_DCF_22_Pos (1UL)               /*!< CMAC CM_DIAG_IRQ1_WORD_REG: DIAG1_DCF_22 (Bit 1)            */
#define CMAC_CM_DIAG_IRQ1_WORD_REG_DIAG1_DCF_22_Msk (0x2UL)             /*!< CMAC CM_DIAG_IRQ1_WORD_REG: DIAG1_DCF_22 (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_WORD_REG_DIAG1_DCF_23_Pos (2UL)               /*!< CMAC CM_DIAG_IRQ1_WORD_REG: DIAG1_DCF_23 (Bit 2)            */
#define CMAC_CM_DIAG_IRQ1_WORD_REG_DIAG1_DCF_23_Msk (0x4UL)             /*!< CMAC CM_DIAG_IRQ1_WORD_REG: DIAG1_DCF_23 (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_WORD_REG_DIAG1_DCF_24_Pos (3UL)               /*!< CMAC CM_DIAG_IRQ1_WORD_REG: DIAG1_DCF_24 (Bit 3)            */
#define CMAC_CM_DIAG_IRQ1_WORD_REG_DIAG1_DCF_24_Msk (0x8UL)             /*!< CMAC CM_DIAG_IRQ1_WORD_REG: DIAG1_DCF_24 (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_WORD_REG_DIAG1_DCF_25_Pos (4UL)               /*!< CMAC CM_DIAG_IRQ1_WORD_REG: DIAG1_DCF_25 (Bit 4)            */
#define CMAC_CM_DIAG_IRQ1_WORD_REG_DIAG1_DCF_25_Msk (0x10UL)            /*!< CMAC CM_DIAG_IRQ1_WORD_REG: DIAG1_DCF_25 (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_WORD_REG_DIAG1_DCF_26_Pos (5UL)               /*!< CMAC CM_DIAG_IRQ1_WORD_REG: DIAG1_DCF_26 (Bit 5)            */
#define CMAC_CM_DIAG_IRQ1_WORD_REG_DIAG1_DCF_26_Msk (0x20UL)            /*!< CMAC CM_DIAG_IRQ1_WORD_REG: DIAG1_DCF_26 (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_WORD_REG_DIAG1_PHY_RX_EN_RFCU_Pos (6UL)       /*!< CMAC CM_DIAG_IRQ1_WORD_REG: DIAG1_PHY_RX_EN_RFCU (Bit 6)    */
#define CMAC_CM_DIAG_IRQ1_WORD_REG_DIAG1_PHY_RX_EN_RFCU_Msk (0x40UL)    /*!< CMAC CM_DIAG_IRQ1_WORD_REG: DIAG1_PHY_RX_EN_RFCU (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_WORD_REG_DIAG1_PHY_TX_EN_RFCU_Pos (7UL)       /*!< CMAC CM_DIAG_IRQ1_WORD_REG: DIAG1_PHY_TX_EN_RFCU (Bit 7)    */
#define CMAC_CM_DIAG_IRQ1_WORD_REG_DIAG1_PHY_TX_EN_RFCU_Msk (0x80UL)    /*!< CMAC CM_DIAG_IRQ1_WORD_REG: DIAG1_PHY_TX_EN_RFCU (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_WORD_REG_DIAG1_SYNC_FOUND_Pos (8UL)           /*!< CMAC CM_DIAG_IRQ1_WORD_REG: DIAG1_SYNC_FOUND (Bit 8)        */
#define CMAC_CM_DIAG_IRQ1_WORD_REG_DIAG1_SYNC_FOUND_Msk (0x100UL)       /*!< CMAC CM_DIAG_IRQ1_WORD_REG: DIAG1_SYNC_FOUND (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_WORD_REG_DIAG1_MATCH0101_Pos (9UL)            /*!< CMAC CM_DIAG_IRQ1_WORD_REG: DIAG1_MATCH0101 (Bit 9)         */
#define CMAC_CM_DIAG_IRQ1_WORD_REG_DIAG1_MATCH0101_Msk (0x200UL)        /*!< CMAC CM_DIAG_IRQ1_WORD_REG: DIAG1_MATCH0101 (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_WORD_REG_DIAG1_SIGNAL_DETECTED_Pos (10UL)     /*!< CMAC CM_DIAG_IRQ1_WORD_REG: DIAG1_SIGNAL_DETECTED (Bit 10)  */
#define CMAC_CM_DIAG_IRQ1_WORD_REG_DIAG1_SIGNAL_DETECTED_Msk (0x400UL)  /*!< CMAC CM_DIAG_IRQ1_WORD_REG: DIAG1_SIGNAL_DETECTED (Bitfield-Mask: 0x01) */

/* -------------------------  CMAC_CM_DIAG_IRQ1_EDGE_REG  ------------------------- */
#define CMAC_CM_DIAG_IRQ1_EDGE_REG_DIAG1_DCF_21_Pos (0UL)               /*!< CMAC CM_DIAG_IRQ1_EDGE_REG: DIAG1_DCF_21 (Bit 0)            */
#define CMAC_CM_DIAG_IRQ1_EDGE_REG_DIAG1_DCF_21_Msk (0x1UL)             /*!< CMAC CM_DIAG_IRQ1_EDGE_REG: DIAG1_DCF_21 (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_EDGE_REG_DIAG1_DCF_22_Pos (1UL)               /*!< CMAC CM_DIAG_IRQ1_EDGE_REG: DIAG1_DCF_22 (Bit 1)            */
#define CMAC_CM_DIAG_IRQ1_EDGE_REG_DIAG1_DCF_22_Msk (0x2UL)             /*!< CMAC CM_DIAG_IRQ1_EDGE_REG: DIAG1_DCF_22 (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_EDGE_REG_DIAG1_DCF_23_Pos (2UL)               /*!< CMAC CM_DIAG_IRQ1_EDGE_REG: DIAG1_DCF_23 (Bit 2)            */
#define CMAC_CM_DIAG_IRQ1_EDGE_REG_DIAG1_DCF_23_Msk (0x4UL)             /*!< CMAC CM_DIAG_IRQ1_EDGE_REG: DIAG1_DCF_23 (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_EDGE_REG_DIAG1_DCF_24_Pos (3UL)               /*!< CMAC CM_DIAG_IRQ1_EDGE_REG: DIAG1_DCF_24 (Bit 3)            */
#define CMAC_CM_DIAG_IRQ1_EDGE_REG_DIAG1_DCF_24_Msk (0x8UL)             /*!< CMAC CM_DIAG_IRQ1_EDGE_REG: DIAG1_DCF_24 (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_EDGE_REG_DIAG1_DCF_25_Pos (4UL)               /*!< CMAC CM_DIAG_IRQ1_EDGE_REG: DIAG1_DCF_25 (Bit 4)            */
#define CMAC_CM_DIAG_IRQ1_EDGE_REG_DIAG1_DCF_25_Msk (0x10UL)            /*!< CMAC CM_DIAG_IRQ1_EDGE_REG: DIAG1_DCF_25 (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_EDGE_REG_DIAG1_DCF_26_Pos (5UL)               /*!< CMAC CM_DIAG_IRQ1_EDGE_REG: DIAG1_DCF_26 (Bit 5)            */
#define CMAC_CM_DIAG_IRQ1_EDGE_REG_DIAG1_DCF_26_Msk (0x20UL)            /*!< CMAC CM_DIAG_IRQ1_EDGE_REG: DIAG1_DCF_26 (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_EDGE_REG_DIAG1_PHY_RX_EN_RFCU_Pos (6UL)       /*!< CMAC CM_DIAG_IRQ1_EDGE_REG: DIAG1_PHY_RX_EN_RFCU (Bit 6)    */
#define CMAC_CM_DIAG_IRQ1_EDGE_REG_DIAG1_PHY_RX_EN_RFCU_Msk (0x40UL)    /*!< CMAC CM_DIAG_IRQ1_EDGE_REG: DIAG1_PHY_RX_EN_RFCU (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_EDGE_REG_DIAG1_PHY_TX_EN_RFCU_Pos (7UL)       /*!< CMAC CM_DIAG_IRQ1_EDGE_REG: DIAG1_PHY_TX_EN_RFCU (Bit 7)    */
#define CMAC_CM_DIAG_IRQ1_EDGE_REG_DIAG1_PHY_TX_EN_RFCU_Msk (0x80UL)    /*!< CMAC CM_DIAG_IRQ1_EDGE_REG: DIAG1_PHY_TX_EN_RFCU (Bitfield-Mask: 0x01) */

/* -------------------------  CMAC_CM_DIAG_IRQ1_STAT_REG  ------------------------- */
#define CMAC_CM_DIAG_IRQ1_STAT_REG_DIAG1_DCF_21_Pos (0UL)               /*!< CMAC CM_DIAG_IRQ1_STAT_REG: DIAG1_DCF_21 (Bit 0)            */
#define CMAC_CM_DIAG_IRQ1_STAT_REG_DIAG1_DCF_21_Msk (0x1UL)             /*!< CMAC CM_DIAG_IRQ1_STAT_REG: DIAG1_DCF_21 (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_STAT_REG_DIAG1_DCF_22_Pos (1UL)               /*!< CMAC CM_DIAG_IRQ1_STAT_REG: DIAG1_DCF_22 (Bit 1)            */
#define CMAC_CM_DIAG_IRQ1_STAT_REG_DIAG1_DCF_22_Msk (0x2UL)             /*!< CMAC CM_DIAG_IRQ1_STAT_REG: DIAG1_DCF_22 (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_STAT_REG_DIAG1_DCF_23_Pos (2UL)               /*!< CMAC CM_DIAG_IRQ1_STAT_REG: DIAG1_DCF_23 (Bit 2)            */
#define CMAC_CM_DIAG_IRQ1_STAT_REG_DIAG1_DCF_23_Msk (0x4UL)             /*!< CMAC CM_DIAG_IRQ1_STAT_REG: DIAG1_DCF_23 (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_STAT_REG_DIAG1_DCF_24_Pos (3UL)               /*!< CMAC CM_DIAG_IRQ1_STAT_REG: DIAG1_DCF_24 (Bit 3)            */
#define CMAC_CM_DIAG_IRQ1_STAT_REG_DIAG1_DCF_24_Msk (0x8UL)             /*!< CMAC CM_DIAG_IRQ1_STAT_REG: DIAG1_DCF_24 (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_STAT_REG_DIAG1_DCF_25_Pos (4UL)               /*!< CMAC CM_DIAG_IRQ1_STAT_REG: DIAG1_DCF_25 (Bit 4)            */
#define CMAC_CM_DIAG_IRQ1_STAT_REG_DIAG1_DCF_25_Msk (0x10UL)            /*!< CMAC CM_DIAG_IRQ1_STAT_REG: DIAG1_DCF_25 (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_STAT_REG_DIAG1_DCF_26_Pos (5UL)               /*!< CMAC CM_DIAG_IRQ1_STAT_REG: DIAG1_DCF_26 (Bit 5)            */
#define CMAC_CM_DIAG_IRQ1_STAT_REG_DIAG1_DCF_26_Msk (0x20UL)            /*!< CMAC CM_DIAG_IRQ1_STAT_REG: DIAG1_DCF_26 (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_STAT_REG_DIAG1_PHY_RX_EN_RFCU_Pos (6UL)       /*!< CMAC CM_DIAG_IRQ1_STAT_REG: DIAG1_PHY_RX_EN_RFCU (Bit 6)    */
#define CMAC_CM_DIAG_IRQ1_STAT_REG_DIAG1_PHY_RX_EN_RFCU_Msk (0x40UL)    /*!< CMAC CM_DIAG_IRQ1_STAT_REG: DIAG1_PHY_RX_EN_RFCU (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_STAT_REG_DIAG1_PHY_TX_EN_RFCU_Pos (7UL)       /*!< CMAC CM_DIAG_IRQ1_STAT_REG: DIAG1_PHY_TX_EN_RFCU (Bit 7)    */
#define CMAC_CM_DIAG_IRQ1_STAT_REG_DIAG1_PHY_TX_EN_RFCU_Msk (0x80UL)    /*!< CMAC CM_DIAG_IRQ1_STAT_REG: DIAG1_PHY_TX_EN_RFCU (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_STAT_REG_DIAG1_SYNC_FOUND_Pos (8UL)           /*!< CMAC CM_DIAG_IRQ1_STAT_REG: DIAG1_SYNC_FOUND (Bit 8)        */
#define CMAC_CM_DIAG_IRQ1_STAT_REG_DIAG1_SYNC_FOUND_Msk (0x100UL)       /*!< CMAC CM_DIAG_IRQ1_STAT_REG: DIAG1_SYNC_FOUND (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_STAT_REG_DIAG1_MATCH0101_Pos (9UL)            /*!< CMAC CM_DIAG_IRQ1_STAT_REG: DIAG1_MATCH0101 (Bit 9)         */
#define CMAC_CM_DIAG_IRQ1_STAT_REG_DIAG1_MATCH0101_Msk (0x200UL)        /*!< CMAC CM_DIAG_IRQ1_STAT_REG: DIAG1_MATCH0101 (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_STAT_REG_DIAG1_SIGNAL_DETECTED_Pos (10UL)     /*!< CMAC CM_DIAG_IRQ1_STAT_REG: DIAG1_SIGNAL_DETECTED (Bit 10)  */
#define CMAC_CM_DIAG_IRQ1_STAT_REG_DIAG1_SIGNAL_DETECTED_Msk (0x400UL)  /*!< CMAC CM_DIAG_IRQ1_STAT_REG: DIAG1_SIGNAL_DETECTED (Bitfield-Mask: 0x01) */

/* -------------------------  CMAC_CM_DIAG_IRQ1_MASK_REG  ------------------------- */
#define CMAC_CM_DIAG_IRQ1_MASK_REG_DIAG1_DCF_21_Pos (0UL)               /*!< CMAC CM_DIAG_IRQ1_MASK_REG: DIAG1_DCF_21 (Bit 0)            */
#define CMAC_CM_DIAG_IRQ1_MASK_REG_DIAG1_DCF_21_Msk (0x1UL)             /*!< CMAC CM_DIAG_IRQ1_MASK_REG: DIAG1_DCF_21 (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_MASK_REG_DIAG1_DCF_22_Pos (1UL)               /*!< CMAC CM_DIAG_IRQ1_MASK_REG: DIAG1_DCF_22 (Bit 1)            */
#define CMAC_CM_DIAG_IRQ1_MASK_REG_DIAG1_DCF_22_Msk (0x2UL)             /*!< CMAC CM_DIAG_IRQ1_MASK_REG: DIAG1_DCF_22 (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_MASK_REG_DIAG1_DCF_23_Pos (2UL)               /*!< CMAC CM_DIAG_IRQ1_MASK_REG: DIAG1_DCF_23 (Bit 2)            */
#define CMAC_CM_DIAG_IRQ1_MASK_REG_DIAG1_DCF_23_Msk (0x4UL)             /*!< CMAC CM_DIAG_IRQ1_MASK_REG: DIAG1_DCF_23 (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_MASK_REG_DIAG1_DCF_24_Pos (3UL)               /*!< CMAC CM_DIAG_IRQ1_MASK_REG: DIAG1_DCF_24 (Bit 3)            */
#define CMAC_CM_DIAG_IRQ1_MASK_REG_DIAG1_DCF_24_Msk (0x8UL)             /*!< CMAC CM_DIAG_IRQ1_MASK_REG: DIAG1_DCF_24 (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_MASK_REG_DIAG1_DCF_25_Pos (4UL)               /*!< CMAC CM_DIAG_IRQ1_MASK_REG: DIAG1_DCF_25 (Bit 4)            */
#define CMAC_CM_DIAG_IRQ1_MASK_REG_DIAG1_DCF_25_Msk (0x10UL)            /*!< CMAC CM_DIAG_IRQ1_MASK_REG: DIAG1_DCF_25 (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_MASK_REG_DIAG1_DCF_26_Pos (5UL)               /*!< CMAC CM_DIAG_IRQ1_MASK_REG: DIAG1_DCF_26 (Bit 5)            */
#define CMAC_CM_DIAG_IRQ1_MASK_REG_DIAG1_DCF_26_Msk (0x20UL)            /*!< CMAC CM_DIAG_IRQ1_MASK_REG: DIAG1_DCF_26 (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_MASK_REG_DIAG1_PHY_RX_EN_RFCU_Pos (6UL)       /*!< CMAC CM_DIAG_IRQ1_MASK_REG: DIAG1_PHY_RX_EN_RFCU (Bit 6)    */
#define CMAC_CM_DIAG_IRQ1_MASK_REG_DIAG1_PHY_RX_EN_RFCU_Msk (0x40UL)    /*!< CMAC CM_DIAG_IRQ1_MASK_REG: DIAG1_PHY_RX_EN_RFCU (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_MASK_REG_DIAG1_PHY_TX_EN_RFCU_Pos (7UL)       /*!< CMAC CM_DIAG_IRQ1_MASK_REG: DIAG1_PHY_TX_EN_RFCU (Bit 7)    */
#define CMAC_CM_DIAG_IRQ1_MASK_REG_DIAG1_PHY_TX_EN_RFCU_Msk (0x80UL)    /*!< CMAC CM_DIAG_IRQ1_MASK_REG: DIAG1_PHY_TX_EN_RFCU (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_MASK_REG_DIAG1_SYNC_FOUND_Pos (8UL)           /*!< CMAC CM_DIAG_IRQ1_MASK_REG: DIAG1_SYNC_FOUND (Bit 8)        */
#define CMAC_CM_DIAG_IRQ1_MASK_REG_DIAG1_SYNC_FOUND_Msk (0x100UL)       /*!< CMAC CM_DIAG_IRQ1_MASK_REG: DIAG1_SYNC_FOUND (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_MASK_REG_DIAG1_MATCH0101_Pos (9UL)            /*!< CMAC CM_DIAG_IRQ1_MASK_REG: DIAG1_MATCH0101 (Bit 9)         */
#define CMAC_CM_DIAG_IRQ1_MASK_REG_DIAG1_MATCH0101_Msk (0x200UL)        /*!< CMAC CM_DIAG_IRQ1_MASK_REG: DIAG1_MATCH0101 (Bitfield-Mask: 0x01) */
#define CMAC_CM_DIAG_IRQ1_MASK_REG_DIAG1_SIGNAL_DETECTED_Pos (10UL)     /*!< CMAC CM_DIAG_IRQ1_MASK_REG: DIAG1_SIGNAL_DETECTED (Bit 10)  */
#define CMAC_CM_DIAG_IRQ1_MASK_REG_DIAG1_SIGNAL_DETECTED_Msk (0x400UL)  /*!< CMAC CM_DIAG_IRQ1_MASK_REG: DIAG1_SIGNAL_DETECTED (Bitfield-Mask: 0x01) */


/* ================================================================================ */
/* ================     struct 'CMAC_TIMER_SLP' Position & Mask    ================ */
/* ================================================================================ */


/* -----------------------  CMAC_TIMER_SLP_CM_SLP_CTRL_REG  ----------------------- */
#define CMAC_TIMER_SLP_CM_SLP_CTRL_REG_SLP_TIMER_SW_Pos (0UL)           /*!< CMAC_TIMER_SLP CM_SLP_CTRL_REG: SLP_TIMER_SW (Bit 0)        */
#define CMAC_TIMER_SLP_CM_SLP_CTRL_REG_SLP_TIMER_SW_Msk (0x1UL)         /*!< CMAC_TIMER_SLP CM_SLP_CTRL_REG: SLP_TIMER_SW (Bitfield-Mask: 0x01) */
#define CMAC_TIMER_SLP_CM_SLP_CTRL_REG_SLP_TIMER_CNT_SIGN_Pos (5UL)     /*!< CMAC_TIMER_SLP CM_SLP_CTRL_REG: SLP_TIMER_CNT_SIGN (Bit 5)  */
#define CMAC_TIMER_SLP_CM_SLP_CTRL_REG_SLP_TIMER_CNT_SIGN_Msk (0x20UL)  /*!< CMAC_TIMER_SLP CM_SLP_CTRL_REG: SLP_TIMER_CNT_SIGN (Bitfield-Mask: 0x01) */
#define CMAC_TIMER_SLP_CM_SLP_CTRL_REG_LP_CLK_STATE_Pos (6UL)           /*!< CMAC_TIMER_SLP CM_SLP_CTRL_REG: LP_CLK_STATE (Bit 6)        */
#define CMAC_TIMER_SLP_CM_SLP_CTRL_REG_LP_CLK_STATE_Msk (0x40UL)        /*!< CMAC_TIMER_SLP CM_SLP_CTRL_REG: LP_CLK_STATE (Bitfield-Mask: 0x01) */
#define CMAC_TIMER_SLP_CM_SLP_CTRL_REG_SLP_TIMER_ACTIVE_Pos (7UL)       /*!< CMAC_TIMER_SLP CM_SLP_CTRL_REG: SLP_TIMER_ACTIVE (Bit 7)    */
#define CMAC_TIMER_SLP_CM_SLP_CTRL_REG_SLP_TIMER_ACTIVE_Msk (0x80UL)    /*!< CMAC_TIMER_SLP CM_SLP_CTRL_REG: SLP_TIMER_ACTIVE (Bitfield-Mask: 0x01) */
#define CMAC_TIMER_SLP_CM_SLP_CTRL_REG_TCLK_FROM_PCLK_Pos (8UL)         /*!< CMAC_TIMER_SLP CM_SLP_CTRL_REG: TCLK_FROM_PCLK (Bit 8)      */
#define CMAC_TIMER_SLP_CM_SLP_CTRL_REG_TCLK_FROM_PCLK_Msk (0x100UL)     /*!< CMAC_TIMER_SLP CM_SLP_CTRL_REG: TCLK_FROM_PCLK (Bitfield-Mask: 0x01) */
#define CMAC_TIMER_SLP_CM_SLP_CTRL_REG_TCLK_FROM_LPCLK_Pos (9UL)        /*!< CMAC_TIMER_SLP CM_SLP_CTRL_REG: TCLK_FROM_LPCLK (Bit 9)     */
#define CMAC_TIMER_SLP_CM_SLP_CTRL_REG_TCLK_FROM_LPCLK_Msk (0x200UL)    /*!< CMAC_TIMER_SLP CM_SLP_CTRL_REG: TCLK_FROM_LPCLK (Bitfield-Mask: 0x01) */
#define CMAC_TIMER_SLP_CM_SLP_CTRL_REG_CMAC_WAKEUP_ON_SWD_EN_Pos (24UL) /*!< CMAC_TIMER_SLP CM_SLP_CTRL_REG: CMAC_WAKEUP_ON_SWD_EN (Bit 24) */
#define CMAC_TIMER_SLP_CM_SLP_CTRL_REG_CMAC_WAKEUP_ON_SWD_EN_Msk (0x1000000UL) /*!< CMAC_TIMER_SLP CM_SLP_CTRL_REG: CMAC_WAKEUP_ON_SWD_EN (Bitfield-Mask: 0x01) */

/* -----------------------  CMAC_TIMER_SLP_CM_SLP_CTRL2_REG  ---------------------- */
#define CMAC_TIMER_SLP_CM_SLP_CTRL2_REG_SLP_TIMER_IRQ_STATE_Pos (0UL)   /*!< CMAC_TIMER_SLP CM_SLP_CTRL2_REG: SLP_TIMER_IRQ_STATE (Bit 0) */
#define CMAC_TIMER_SLP_CM_SLP_CTRL2_REG_SLP_TIMER_IRQ_STATE_Msk (0x1UL) /*!< CMAC_TIMER_SLP CM_SLP_CTRL2_REG: SLP_TIMER_IRQ_STATE (Bitfield-Mask: 0x01) */
#define CMAC_TIMER_SLP_CM_SLP_CTRL2_REG_SLP_TIMER_IRQ_CLR_Pos (1UL)     /*!< CMAC_TIMER_SLP CM_SLP_CTRL2_REG: SLP_TIMER_IRQ_CLR (Bit 1)  */
#define CMAC_TIMER_SLP_CM_SLP_CTRL2_REG_SLP_TIMER_IRQ_CLR_Msk (0x2UL)   /*!< CMAC_TIMER_SLP CM_SLP_CTRL2_REG: SLP_TIMER_IRQ_CLR (Bitfield-Mask: 0x01) */
#define CMAC_TIMER_SLP_CM_SLP_CTRL2_REG_SLP_TIMER_IRQ_SET_Pos (2UL)     /*!< CMAC_TIMER_SLP CM_SLP_CTRL2_REG: SLP_TIMER_IRQ_SET (Bit 2)  */
#define CMAC_TIMER_SLP_CM_SLP_CTRL2_REG_SLP_TIMER_IRQ_SET_Msk (0x4UL)   /*!< CMAC_TIMER_SLP CM_SLP_CTRL2_REG: SLP_TIMER_IRQ_SET (Bitfield-Mask: 0x01) */
#define CMAC_TIMER_SLP_CM_SLP_CTRL2_REG_SLP_TIMER_CNT_SIGN_Pos (5UL)    /*!< CMAC_TIMER_SLP CM_SLP_CTRL2_REG: SLP_TIMER_CNT_SIGN (Bit 5) */
#define CMAC_TIMER_SLP_CM_SLP_CTRL2_REG_SLP_TIMER_CNT_SIGN_Msk (0x20UL) /*!< CMAC_TIMER_SLP CM_SLP_CTRL2_REG: SLP_TIMER_CNT_SIGN (Bitfield-Mask: 0x01) */
#define CMAC_TIMER_SLP_CM_SLP_CTRL2_REG_LP_CLK_STATE_Pos (6UL)          /*!< CMAC_TIMER_SLP CM_SLP_CTRL2_REG: LP_CLK_STATE (Bit 6)       */
#define CMAC_TIMER_SLP_CM_SLP_CTRL2_REG_LP_CLK_STATE_Msk (0x40UL)       /*!< CMAC_TIMER_SLP CM_SLP_CTRL2_REG: LP_CLK_STATE (Bitfield-Mask: 0x01) */
#define CMAC_TIMER_SLP_CM_SLP_CTRL2_REG_SLP_TIMER_ACTIVE_Pos (7UL)      /*!< CMAC_TIMER_SLP CM_SLP_CTRL2_REG: SLP_TIMER_ACTIVE (Bit 7)   */
#define CMAC_TIMER_SLP_CM_SLP_CTRL2_REG_SLP_TIMER_ACTIVE_Msk (0x80UL)   /*!< CMAC_TIMER_SLP CM_SLP_CTRL2_REG: SLP_TIMER_ACTIVE (Bitfield-Mask: 0x01) */
#define CMAC_TIMER_SLP_CM_SLP_CTRL2_REG_CMAC_WAKEUP_ON_SWD_STATE_Pos (8UL) /*!< CMAC_TIMER_SLP CM_SLP_CTRL2_REG: CMAC_WAKEUP_ON_SWD_STATE (Bit 8) */
#define CMAC_TIMER_SLP_CM_SLP_CTRL2_REG_CMAC_WAKEUP_ON_SWD_STATE_Msk (0x100UL) /*!< CMAC_TIMER_SLP CM_SLP_CTRL2_REG: CMAC_WAKEUP_ON_SWD_STATE (Bitfield-Mask: 0x01) */

/* -----------------------  CMAC_TIMER_SLP_CM_SLP_TIMER_REG  ---------------------- */
#define CMAC_TIMER_SLP_CM_SLP_TIMER_REG_CM_SLP_TIMER_VALUE_Pos (0UL)    /*!< CMAC_TIMER_SLP CM_SLP_TIMER_REG: CM_SLP_TIMER_VALUE (Bit 0) */
#define CMAC_TIMER_SLP_CM_SLP_TIMER_REG_CM_SLP_TIMER_VALUE_Msk (0xffffffffUL) /*!< CMAC_TIMER_SLP CM_SLP_TIMER_REG: CM_SLP_TIMER_VALUE (Bitfield-Mask: 0xffffffff) */

/* ==================================================  PDC_ACKNOWLEDGE_REG  ================================================== */
#define PDC_PDC_ACKNOWLEDGE_REG_PDC_ACKNOWLEDGE_Pos (0UL)           /*!< PDC PDC_ACKNOWLEDGE_REG: PDC_ACKNOWLEDGE (Bit 0)      */
#define PDC_PDC_ACKNOWLEDGE_REG_PDC_ACKNOWLEDGE_Msk (0x1fUL)        /*!< PDC PDC_ACKNOWLEDGE_REG: PDC_ACKNOWLEDGE (Bitfield-Mask: 0x1f) */
/* =====================================================  PDC_CTRL0_REG  ===================================================== */
#define PDC_PDC_CTRL0_REG_PDC_MASTER_Pos  (11UL)                    /*!< PDC PDC_CTRL0_REG: PDC_MASTER (Bit 11)                */
#define PDC_PDC_CTRL0_REG_PDC_MASTER_Msk  (0x1800UL)                /*!< PDC PDC_CTRL0_REG: PDC_MASTER (Bitfield-Mask: 0x03)   */
#define PDC_PDC_CTRL0_REG_EN_COM_Pos      (10UL)                    /*!< PDC PDC_CTRL0_REG: EN_COM (Bit 10)                    */
#define PDC_PDC_CTRL0_REG_EN_COM_Msk      (0x400UL)                 /*!< PDC PDC_CTRL0_REG: EN_COM (Bitfield-Mask: 0x01)       */
#define PDC_PDC_CTRL0_REG_EN_PER_Pos      (9UL)                     /*!< PDC PDC_CTRL0_REG: EN_PER (Bit 9)                     */
#define PDC_PDC_CTRL0_REG_EN_PER_Msk      (0x200UL)                 /*!< PDC PDC_CTRL0_REG: EN_PER (Bitfield-Mask: 0x01)       */
#define PDC_PDC_CTRL0_REG_EN_TMR_Pos      (8UL)                     /*!< PDC PDC_CTRL0_REG: EN_TMR (Bit 8)                     */
#define PDC_PDC_CTRL0_REG_EN_TMR_Msk      (0x100UL)                 /*!< PDC PDC_CTRL0_REG: EN_TMR (Bitfield-Mask: 0x01)       */
#define PDC_PDC_CTRL0_REG_EN_XTAL_Pos     (7UL)                     /*!< PDC PDC_CTRL0_REG: EN_XTAL (Bit 7)                    */
#define PDC_PDC_CTRL0_REG_EN_XTAL_Msk     (0x80UL)                  /*!< PDC PDC_CTRL0_REG: EN_XTAL (Bitfield-Mask: 0x01)      */
#define PDC_PDC_CTRL0_REG_TRIG_ID_Pos     (2UL)                     /*!< PDC PDC_CTRL0_REG: TRIG_ID (Bit 2)                    */
#define PDC_PDC_CTRL0_REG_TRIG_ID_Msk     (0x7cUL)                  /*!< PDC PDC_CTRL0_REG: TRIG_ID (Bitfield-Mask: 0x1f)      */
#define PDC_PDC_CTRL0_REG_TRIG_SELECT_Pos (0UL)                     /*!< PDC PDC_CTRL0_REG: TRIG_SELECT (Bit 0)                */
#define PDC_PDC_CTRL0_REG_TRIG_SELECT_Msk (0x3UL)                   /*!< PDC PDC_CTRL0_REG: TRIG_SELECT (Bitfield-Mask: 0x03)  */
/* ====================================================  PDC_CTRL10_REG  ===================================================== */
#define PDC_PDC_CTRL10_REG_PDC_MASTER_Pos (11UL)                    /*!< PDC PDC_CTRL10_REG: PDC_MASTER (Bit 11)               */
#define PDC_PDC_CTRL10_REG_PDC_MASTER_Msk (0x1800UL)                /*!< PDC PDC_CTRL10_REG: PDC_MASTER (Bitfield-Mask: 0x03)  */
#define PDC_PDC_CTRL10_REG_EN_COM_Pos     (10UL)                    /*!< PDC PDC_CTRL10_REG: EN_COM (Bit 10)                   */
#define PDC_PDC_CTRL10_REG_EN_COM_Msk     (0x400UL)                 /*!< PDC PDC_CTRL10_REG: EN_COM (Bitfield-Mask: 0x01)      */
#define PDC_PDC_CTRL10_REG_EN_PER_Pos     (9UL)                     /*!< PDC PDC_CTRL10_REG: EN_PER (Bit 9)                    */
#define PDC_PDC_CTRL10_REG_EN_PER_Msk     (0x200UL)                 /*!< PDC PDC_CTRL10_REG: EN_PER (Bitfield-Mask: 0x01)      */
#define PDC_PDC_CTRL10_REG_EN_TMR_Pos     (8UL)                     /*!< PDC PDC_CTRL10_REG: EN_TMR (Bit 8)                    */
#define PDC_PDC_CTRL10_REG_EN_TMR_Msk     (0x100UL)                 /*!< PDC PDC_CTRL10_REG: EN_TMR (Bitfield-Mask: 0x01)      */
#define PDC_PDC_CTRL10_REG_EN_XTAL_Pos    (7UL)                     /*!< PDC PDC_CTRL10_REG: EN_XTAL (Bit 7)                   */
#define PDC_PDC_CTRL10_REG_EN_XTAL_Msk    (0x80UL)                  /*!< PDC PDC_CTRL10_REG: EN_XTAL (Bitfield-Mask: 0x01)     */
#define PDC_PDC_CTRL10_REG_TRIG_ID_Pos    (2UL)                     /*!< PDC PDC_CTRL10_REG: TRIG_ID (Bit 2)                   */
#define PDC_PDC_CTRL10_REG_TRIG_ID_Msk    (0x7cUL)                  /*!< PDC PDC_CTRL10_REG: TRIG_ID (Bitfield-Mask: 0x1f)     */
#define PDC_PDC_CTRL10_REG_TRIG_SELECT_Pos (0UL)                    /*!< PDC PDC_CTRL10_REG: TRIG_SELECT (Bit 0)               */
#define PDC_PDC_CTRL10_REG_TRIG_SELECT_Msk (0x3UL)                  /*!< PDC PDC_CTRL10_REG: TRIG_SELECT (Bitfield-Mask: 0x03) */
/* ====================================================  PDC_CTRL11_REG  ===================================================== */
#define PDC_PDC_CTRL11_REG_PDC_MASTER_Pos (11UL)                    /*!< PDC PDC_CTRL11_REG: PDC_MASTER (Bit 11)               */
#define PDC_PDC_CTRL11_REG_PDC_MASTER_Msk (0x1800UL)                /*!< PDC PDC_CTRL11_REG: PDC_MASTER (Bitfield-Mask: 0x03)  */
#define PDC_PDC_CTRL11_REG_EN_COM_Pos     (10UL)                    /*!< PDC PDC_CTRL11_REG: EN_COM (Bit 10)                   */
#define PDC_PDC_CTRL11_REG_EN_COM_Msk     (0x400UL)                 /*!< PDC PDC_CTRL11_REG: EN_COM (Bitfield-Mask: 0x01)      */
#define PDC_PDC_CTRL11_REG_EN_PER_Pos     (9UL)                     /*!< PDC PDC_CTRL11_REG: EN_PER (Bit 9)                    */
#define PDC_PDC_CTRL11_REG_EN_PER_Msk     (0x200UL)                 /*!< PDC PDC_CTRL11_REG: EN_PER (Bitfield-Mask: 0x01)      */
#define PDC_PDC_CTRL11_REG_EN_TMR_Pos     (8UL)                     /*!< PDC PDC_CTRL11_REG: EN_TMR (Bit 8)                    */
#define PDC_PDC_CTRL11_REG_EN_TMR_Msk     (0x100UL)                 /*!< PDC PDC_CTRL11_REG: EN_TMR (Bitfield-Mask: 0x01)      */
#define PDC_PDC_CTRL11_REG_EN_XTAL_Pos    (7UL)                     /*!< PDC PDC_CTRL11_REG: EN_XTAL (Bit 7)                   */
#define PDC_PDC_CTRL11_REG_EN_XTAL_Msk    (0x80UL)                  /*!< PDC PDC_CTRL11_REG: EN_XTAL (Bitfield-Mask: 0x01)     */
#define PDC_PDC_CTRL11_REG_TRIG_ID_Pos    (2UL)                     /*!< PDC PDC_CTRL11_REG: TRIG_ID (Bit 2)                   */
#define PDC_PDC_CTRL11_REG_TRIG_ID_Msk    (0x7cUL)                  /*!< PDC PDC_CTRL11_REG: TRIG_ID (Bitfield-Mask: 0x1f)     */
#define PDC_PDC_CTRL11_REG_TRIG_SELECT_Pos (0UL)                    /*!< PDC PDC_CTRL11_REG: TRIG_SELECT (Bit 0)               */
#define PDC_PDC_CTRL11_REG_TRIG_SELECT_Msk (0x3UL)                  /*!< PDC PDC_CTRL11_REG: TRIG_SELECT (Bitfield-Mask: 0x03) */
/* ====================================================  PDC_CTRL12_REG  ===================================================== */
#define PDC_PDC_CTRL12_REG_PDC_MASTER_Pos (11UL)                    /*!< PDC PDC_CTRL12_REG: PDC_MASTER (Bit 11)               */
#define PDC_PDC_CTRL12_REG_PDC_MASTER_Msk (0x1800UL)                /*!< PDC PDC_CTRL12_REG: PDC_MASTER (Bitfield-Mask: 0x03)  */
#define PDC_PDC_CTRL12_REG_EN_COM_Pos     (10UL)                    /*!< PDC PDC_CTRL12_REG: EN_COM (Bit 10)                   */
#define PDC_PDC_CTRL12_REG_EN_COM_Msk     (0x400UL)                 /*!< PDC PDC_CTRL12_REG: EN_COM (Bitfield-Mask: 0x01)      */
#define PDC_PDC_CTRL12_REG_EN_PER_Pos     (9UL)                     /*!< PDC PDC_CTRL12_REG: EN_PER (Bit 9)                    */
#define PDC_PDC_CTRL12_REG_EN_PER_Msk     (0x200UL)                 /*!< PDC PDC_CTRL12_REG: EN_PER (Bitfield-Mask: 0x01)      */
#define PDC_PDC_CTRL12_REG_EN_TMR_Pos     (8UL)                     /*!< PDC PDC_CTRL12_REG: EN_TMR (Bit 8)                    */
#define PDC_PDC_CTRL12_REG_EN_TMR_Msk     (0x100UL)                 /*!< PDC PDC_CTRL12_REG: EN_TMR (Bitfield-Mask: 0x01)      */
#define PDC_PDC_CTRL12_REG_EN_XTAL_Pos    (7UL)                     /*!< PDC PDC_CTRL12_REG: EN_XTAL (Bit 7)                   */
#define PDC_PDC_CTRL12_REG_EN_XTAL_Msk    (0x80UL)                  /*!< PDC PDC_CTRL12_REG: EN_XTAL (Bitfield-Mask: 0x01)     */
#define PDC_PDC_CTRL12_REG_TRIG_ID_Pos    (2UL)                     /*!< PDC PDC_CTRL12_REG: TRIG_ID (Bit 2)                   */
#define PDC_PDC_CTRL12_REG_TRIG_ID_Msk    (0x7cUL)                  /*!< PDC PDC_CTRL12_REG: TRIG_ID (Bitfield-Mask: 0x1f)     */
#define PDC_PDC_CTRL12_REG_TRIG_SELECT_Pos (0UL)                    /*!< PDC PDC_CTRL12_REG: TRIG_SELECT (Bit 0)               */
#define PDC_PDC_CTRL12_REG_TRIG_SELECT_Msk (0x3UL)                  /*!< PDC PDC_CTRL12_REG: TRIG_SELECT (Bitfield-Mask: 0x03) */
/* ====================================================  PDC_CTRL13_REG  ===================================================== */
#define PDC_PDC_CTRL13_REG_PDC_MASTER_Pos (11UL)                    /*!< PDC PDC_CTRL13_REG: PDC_MASTER (Bit 11)               */
#define PDC_PDC_CTRL13_REG_PDC_MASTER_Msk (0x1800UL)                /*!< PDC PDC_CTRL13_REG: PDC_MASTER (Bitfield-Mask: 0x03)  */
#define PDC_PDC_CTRL13_REG_EN_COM_Pos     (10UL)                    /*!< PDC PDC_CTRL13_REG: EN_COM (Bit 10)                   */
#define PDC_PDC_CTRL13_REG_EN_COM_Msk     (0x400UL)                 /*!< PDC PDC_CTRL13_REG: EN_COM (Bitfield-Mask: 0x01)      */
#define PDC_PDC_CTRL13_REG_EN_PER_Pos     (9UL)                     /*!< PDC PDC_CTRL13_REG: EN_PER (Bit 9)                    */
#define PDC_PDC_CTRL13_REG_EN_PER_Msk     (0x200UL)                 /*!< PDC PDC_CTRL13_REG: EN_PER (Bitfield-Mask: 0x01)      */
#define PDC_PDC_CTRL13_REG_EN_TMR_Pos     (8UL)                     /*!< PDC PDC_CTRL13_REG: EN_TMR (Bit 8)                    */
#define PDC_PDC_CTRL13_REG_EN_TMR_Msk     (0x100UL)                 /*!< PDC PDC_CTRL13_REG: EN_TMR (Bitfield-Mask: 0x01)      */
#define PDC_PDC_CTRL13_REG_EN_XTAL_Pos    (7UL)                     /*!< PDC PDC_CTRL13_REG: EN_XTAL (Bit 7)                   */
#define PDC_PDC_CTRL13_REG_EN_XTAL_Msk    (0x80UL)                  /*!< PDC PDC_CTRL13_REG: EN_XTAL (Bitfield-Mask: 0x01)     */
#define PDC_PDC_CTRL13_REG_TRIG_ID_Pos    (2UL)                     /*!< PDC PDC_CTRL13_REG: TRIG_ID (Bit 2)                   */
#define PDC_PDC_CTRL13_REG_TRIG_ID_Msk    (0x7cUL)                  /*!< PDC PDC_CTRL13_REG: TRIG_ID (Bitfield-Mask: 0x1f)     */
#define PDC_PDC_CTRL13_REG_TRIG_SELECT_Pos (0UL)                    /*!< PDC PDC_CTRL13_REG: TRIG_SELECT (Bit 0)               */
#define PDC_PDC_CTRL13_REG_TRIG_SELECT_Msk (0x3UL)                  /*!< PDC PDC_CTRL13_REG: TRIG_SELECT (Bitfield-Mask: 0x03) */
/* ====================================================  PDC_CTRL14_REG  ===================================================== */
#define PDC_PDC_CTRL14_REG_PDC_MASTER_Pos (11UL)                    /*!< PDC PDC_CTRL14_REG: PDC_MASTER (Bit 11)               */
#define PDC_PDC_CTRL14_REG_PDC_MASTER_Msk (0x1800UL)                /*!< PDC PDC_CTRL14_REG: PDC_MASTER (Bitfield-Mask: 0x03)  */
#define PDC_PDC_CTRL14_REG_EN_COM_Pos     (10UL)                    /*!< PDC PDC_CTRL14_REG: EN_COM (Bit 10)                   */
#define PDC_PDC_CTRL14_REG_EN_COM_Msk     (0x400UL)                 /*!< PDC PDC_CTRL14_REG: EN_COM (Bitfield-Mask: 0x01)      */
#define PDC_PDC_CTRL14_REG_EN_PER_Pos     (9UL)                     /*!< PDC PDC_CTRL14_REG: EN_PER (Bit 9)                    */
#define PDC_PDC_CTRL14_REG_EN_PER_Msk     (0x200UL)                 /*!< PDC PDC_CTRL14_REG: EN_PER (Bitfield-Mask: 0x01)      */
#define PDC_PDC_CTRL14_REG_EN_TMR_Pos     (8UL)                     /*!< PDC PDC_CTRL14_REG: EN_TMR (Bit 8)                    */
#define PDC_PDC_CTRL14_REG_EN_TMR_Msk     (0x100UL)                 /*!< PDC PDC_CTRL14_REG: EN_TMR (Bitfield-Mask: 0x01)      */
#define PDC_PDC_CTRL14_REG_EN_XTAL_Pos    (7UL)                     /*!< PDC PDC_CTRL14_REG: EN_XTAL (Bit 7)                   */
#define PDC_PDC_CTRL14_REG_EN_XTAL_Msk    (0x80UL)                  /*!< PDC PDC_CTRL14_REG: EN_XTAL (Bitfield-Mask: 0x01)     */
#define PDC_PDC_CTRL14_REG_TRIG_ID_Pos    (2UL)                     /*!< PDC PDC_CTRL14_REG: TRIG_ID (Bit 2)                   */
#define PDC_PDC_CTRL14_REG_TRIG_ID_Msk    (0x7cUL)                  /*!< PDC PDC_CTRL14_REG: TRIG_ID (Bitfield-Mask: 0x1f)     */
#define PDC_PDC_CTRL14_REG_TRIG_SELECT_Pos (0UL)                    /*!< PDC PDC_CTRL14_REG: TRIG_SELECT (Bit 0)               */
#define PDC_PDC_CTRL14_REG_TRIG_SELECT_Msk (0x3UL)                  /*!< PDC PDC_CTRL14_REG: TRIG_SELECT (Bitfield-Mask: 0x03) */
/* ====================================================  PDC_CTRL15_REG  ===================================================== */
#define PDC_PDC_CTRL15_REG_PDC_MASTER_Pos (11UL)                    /*!< PDC PDC_CTRL15_REG: PDC_MASTER (Bit 11)               */
#define PDC_PDC_CTRL15_REG_PDC_MASTER_Msk (0x1800UL)                /*!< PDC PDC_CTRL15_REG: PDC_MASTER (Bitfield-Mask: 0x03)  */
#define PDC_PDC_CTRL15_REG_EN_COM_Pos     (10UL)                    /*!< PDC PDC_CTRL15_REG: EN_COM (Bit 10)                   */
#define PDC_PDC_CTRL15_REG_EN_COM_Msk     (0x400UL)                 /*!< PDC PDC_CTRL15_REG: EN_COM (Bitfield-Mask: 0x01)      */
#define PDC_PDC_CTRL15_REG_EN_PER_Pos     (9UL)                     /*!< PDC PDC_CTRL15_REG: EN_PER (Bit 9)                    */
#define PDC_PDC_CTRL15_REG_EN_PER_Msk     (0x200UL)                 /*!< PDC PDC_CTRL15_REG: EN_PER (Bitfield-Mask: 0x01)      */
#define PDC_PDC_CTRL15_REG_EN_TMR_Pos     (8UL)                     /*!< PDC PDC_CTRL15_REG: EN_TMR (Bit 8)                    */
#define PDC_PDC_CTRL15_REG_EN_TMR_Msk     (0x100UL)                 /*!< PDC PDC_CTRL15_REG: EN_TMR (Bitfield-Mask: 0x01)      */
#define PDC_PDC_CTRL15_REG_EN_XTAL_Pos    (7UL)                     /*!< PDC PDC_CTRL15_REG: EN_XTAL (Bit 7)                   */
#define PDC_PDC_CTRL15_REG_EN_XTAL_Msk    (0x80UL)                  /*!< PDC PDC_CTRL15_REG: EN_XTAL (Bitfield-Mask: 0x01)     */
#define PDC_PDC_CTRL15_REG_TRIG_ID_Pos    (2UL)                     /*!< PDC PDC_CTRL15_REG: TRIG_ID (Bit 2)                   */
#define PDC_PDC_CTRL15_REG_TRIG_ID_Msk    (0x7cUL)                  /*!< PDC PDC_CTRL15_REG: TRIG_ID (Bitfield-Mask: 0x1f)     */
#define PDC_PDC_CTRL15_REG_TRIG_SELECT_Pos (0UL)                    /*!< PDC PDC_CTRL15_REG: TRIG_SELECT (Bit 0)               */
#define PDC_PDC_CTRL15_REG_TRIG_SELECT_Msk (0x3UL)                  /*!< PDC PDC_CTRL15_REG: TRIG_SELECT (Bitfield-Mask: 0x03) */
/* =====================================================  PDC_CTRL1_REG  ===================================================== */
#define PDC_PDC_CTRL1_REG_PDC_MASTER_Pos  (11UL)                    /*!< PDC PDC_CTRL1_REG: PDC_MASTER (Bit 11)                */
#define PDC_PDC_CTRL1_REG_PDC_MASTER_Msk  (0x1800UL)                /*!< PDC PDC_CTRL1_REG: PDC_MASTER (Bitfield-Mask: 0x03)   */
#define PDC_PDC_CTRL1_REG_EN_COM_Pos      (10UL)                    /*!< PDC PDC_CTRL1_REG: EN_COM (Bit 10)                    */
#define PDC_PDC_CTRL1_REG_EN_COM_Msk      (0x400UL)                 /*!< PDC PDC_CTRL1_REG: EN_COM (Bitfield-Mask: 0x01)       */
#define PDC_PDC_CTRL1_REG_EN_PER_Pos      (9UL)                     /*!< PDC PDC_CTRL1_REG: EN_PER (Bit 9)                     */
#define PDC_PDC_CTRL1_REG_EN_PER_Msk      (0x200UL)                 /*!< PDC PDC_CTRL1_REG: EN_PER (Bitfield-Mask: 0x01)       */
#define PDC_PDC_CTRL1_REG_EN_TMR_Pos      (8UL)                     /*!< PDC PDC_CTRL1_REG: EN_TMR (Bit 8)                     */
#define PDC_PDC_CTRL1_REG_EN_TMR_Msk      (0x100UL)                 /*!< PDC PDC_CTRL1_REG: EN_TMR (Bitfield-Mask: 0x01)       */
#define PDC_PDC_CTRL1_REG_EN_XTAL_Pos     (7UL)                     /*!< PDC PDC_CTRL1_REG: EN_XTAL (Bit 7)                    */
#define PDC_PDC_CTRL1_REG_EN_XTAL_Msk     (0x80UL)                  /*!< PDC PDC_CTRL1_REG: EN_XTAL (Bitfield-Mask: 0x01)      */
#define PDC_PDC_CTRL1_REG_TRIG_ID_Pos     (2UL)                     /*!< PDC PDC_CTRL1_REG: TRIG_ID (Bit 2)                    */
#define PDC_PDC_CTRL1_REG_TRIG_ID_Msk     (0x7cUL)                  /*!< PDC PDC_CTRL1_REG: TRIG_ID (Bitfield-Mask: 0x1f)      */
#define PDC_PDC_CTRL1_REG_TRIG_SELECT_Pos (0UL)                     /*!< PDC PDC_CTRL1_REG: TRIG_SELECT (Bit 0)                */
#define PDC_PDC_CTRL1_REG_TRIG_SELECT_Msk (0x3UL)                   /*!< PDC PDC_CTRL1_REG: TRIG_SELECT (Bitfield-Mask: 0x03)  */
/* =====================================================  PDC_CTRL2_REG  ===================================================== */
#define PDC_PDC_CTRL2_REG_PDC_MASTER_Pos  (11UL)                    /*!< PDC PDC_CTRL2_REG: PDC_MASTER (Bit 11)                */
#define PDC_PDC_CTRL2_REG_PDC_MASTER_Msk  (0x1800UL)                /*!< PDC PDC_CTRL2_REG: PDC_MASTER (Bitfield-Mask: 0x03)   */
#define PDC_PDC_CTRL2_REG_EN_COM_Pos      (10UL)                    /*!< PDC PDC_CTRL2_REG: EN_COM (Bit 10)                    */
#define PDC_PDC_CTRL2_REG_EN_COM_Msk      (0x400UL)                 /*!< PDC PDC_CTRL2_REG: EN_COM (Bitfield-Mask: 0x01)       */
#define PDC_PDC_CTRL2_REG_EN_PER_Pos      (9UL)                     /*!< PDC PDC_CTRL2_REG: EN_PER (Bit 9)                     */
#define PDC_PDC_CTRL2_REG_EN_PER_Msk      (0x200UL)                 /*!< PDC PDC_CTRL2_REG: EN_PER (Bitfield-Mask: 0x01)       */
#define PDC_PDC_CTRL2_REG_EN_TMR_Pos      (8UL)                     /*!< PDC PDC_CTRL2_REG: EN_TMR (Bit 8)                     */
#define PDC_PDC_CTRL2_REG_EN_TMR_Msk      (0x100UL)                 /*!< PDC PDC_CTRL2_REG: EN_TMR (Bitfield-Mask: 0x01)       */
#define PDC_PDC_CTRL2_REG_EN_XTAL_Pos     (7UL)                     /*!< PDC PDC_CTRL2_REG: EN_XTAL (Bit 7)                    */
#define PDC_PDC_CTRL2_REG_EN_XTAL_Msk     (0x80UL)                  /*!< PDC PDC_CTRL2_REG: EN_XTAL (Bitfield-Mask: 0x01)      */
#define PDC_PDC_CTRL2_REG_TRIG_ID_Pos     (2UL)                     /*!< PDC PDC_CTRL2_REG: TRIG_ID (Bit 2)                    */
#define PDC_PDC_CTRL2_REG_TRIG_ID_Msk     (0x7cUL)                  /*!< PDC PDC_CTRL2_REG: TRIG_ID (Bitfield-Mask: 0x1f)      */
#define PDC_PDC_CTRL2_REG_TRIG_SELECT_Pos (0UL)                     /*!< PDC PDC_CTRL2_REG: TRIG_SELECT (Bit 0)                */
#define PDC_PDC_CTRL2_REG_TRIG_SELECT_Msk (0x3UL)                   /*!< PDC PDC_CTRL2_REG: TRIG_SELECT (Bitfield-Mask: 0x03)  */
/* =====================================================  PDC_CTRL3_REG  ===================================================== */
#define PDC_PDC_CTRL3_REG_PDC_MASTER_Pos  (11UL)                    /*!< PDC PDC_CTRL3_REG: PDC_MASTER (Bit 11)                */
#define PDC_PDC_CTRL3_REG_PDC_MASTER_Msk  (0x1800UL)                /*!< PDC PDC_CTRL3_REG: PDC_MASTER (Bitfield-Mask: 0x03)   */
#define PDC_PDC_CTRL3_REG_EN_COM_Pos      (10UL)                    /*!< PDC PDC_CTRL3_REG: EN_COM (Bit 10)                    */
#define PDC_PDC_CTRL3_REG_EN_COM_Msk      (0x400UL)                 /*!< PDC PDC_CTRL3_REG: EN_COM (Bitfield-Mask: 0x01)       */
#define PDC_PDC_CTRL3_REG_EN_PER_Pos      (9UL)                     /*!< PDC PDC_CTRL3_REG: EN_PER (Bit 9)                     */
#define PDC_PDC_CTRL3_REG_EN_PER_Msk      (0x200UL)                 /*!< PDC PDC_CTRL3_REG: EN_PER (Bitfield-Mask: 0x01)       */
#define PDC_PDC_CTRL3_REG_EN_TMR_Pos      (8UL)                     /*!< PDC PDC_CTRL3_REG: EN_TMR (Bit 8)                     */
#define PDC_PDC_CTRL3_REG_EN_TMR_Msk      (0x100UL)                 /*!< PDC PDC_CTRL3_REG: EN_TMR (Bitfield-Mask: 0x01)       */
#define PDC_PDC_CTRL3_REG_EN_XTAL_Pos     (7UL)                     /*!< PDC PDC_CTRL3_REG: EN_XTAL (Bit 7)                    */
#define PDC_PDC_CTRL3_REG_EN_XTAL_Msk     (0x80UL)                  /*!< PDC PDC_CTRL3_REG: EN_XTAL (Bitfield-Mask: 0x01)      */
#define PDC_PDC_CTRL3_REG_TRIG_ID_Pos     (2UL)                     /*!< PDC PDC_CTRL3_REG: TRIG_ID (Bit 2)                    */
#define PDC_PDC_CTRL3_REG_TRIG_ID_Msk     (0x7cUL)                  /*!< PDC PDC_CTRL3_REG: TRIG_ID (Bitfield-Mask: 0x1f)      */
#define PDC_PDC_CTRL3_REG_TRIG_SELECT_Pos (0UL)                     /*!< PDC PDC_CTRL3_REG: TRIG_SELECT (Bit 0)                */
#define PDC_PDC_CTRL3_REG_TRIG_SELECT_Msk (0x3UL)                   /*!< PDC PDC_CTRL3_REG: TRIG_SELECT (Bitfield-Mask: 0x03)  */
/* =====================================================  PDC_CTRL4_REG  ===================================================== */
#define PDC_PDC_CTRL4_REG_PDC_MASTER_Pos  (11UL)                    /*!< PDC PDC_CTRL4_REG: PDC_MASTER (Bit 11)                */
#define PDC_PDC_CTRL4_REG_PDC_MASTER_Msk  (0x1800UL)                /*!< PDC PDC_CTRL4_REG: PDC_MASTER (Bitfield-Mask: 0x03)   */
#define PDC_PDC_CTRL4_REG_EN_COM_Pos      (10UL)                    /*!< PDC PDC_CTRL4_REG: EN_COM (Bit 10)                    */
#define PDC_PDC_CTRL4_REG_EN_COM_Msk      (0x400UL)                 /*!< PDC PDC_CTRL4_REG: EN_COM (Bitfield-Mask: 0x01)       */
#define PDC_PDC_CTRL4_REG_EN_PER_Pos      (9UL)                     /*!< PDC PDC_CTRL4_REG: EN_PER (Bit 9)                     */
#define PDC_PDC_CTRL4_REG_EN_PER_Msk      (0x200UL)                 /*!< PDC PDC_CTRL4_REG: EN_PER (Bitfield-Mask: 0x01)       */
#define PDC_PDC_CTRL4_REG_EN_TMR_Pos      (8UL)                     /*!< PDC PDC_CTRL4_REG: EN_TMR (Bit 8)                     */
#define PDC_PDC_CTRL4_REG_EN_TMR_Msk      (0x100UL)                 /*!< PDC PDC_CTRL4_REG: EN_TMR (Bitfield-Mask: 0x01)       */
#define PDC_PDC_CTRL4_REG_EN_XTAL_Pos     (7UL)                     /*!< PDC PDC_CTRL4_REG: EN_XTAL (Bit 7)                    */
#define PDC_PDC_CTRL4_REG_EN_XTAL_Msk     (0x80UL)                  /*!< PDC PDC_CTRL4_REG: EN_XTAL (Bitfield-Mask: 0x01)      */
#define PDC_PDC_CTRL4_REG_TRIG_ID_Pos     (2UL)                     /*!< PDC PDC_CTRL4_REG: TRIG_ID (Bit 2)                    */
#define PDC_PDC_CTRL4_REG_TRIG_ID_Msk     (0x7cUL)                  /*!< PDC PDC_CTRL4_REG: TRIG_ID (Bitfield-Mask: 0x1f)      */
#define PDC_PDC_CTRL4_REG_TRIG_SELECT_Pos (0UL)                     /*!< PDC PDC_CTRL4_REG: TRIG_SELECT (Bit 0)                */
#define PDC_PDC_CTRL4_REG_TRIG_SELECT_Msk (0x3UL)                   /*!< PDC PDC_CTRL4_REG: TRIG_SELECT (Bitfield-Mask: 0x03)  */
/* =====================================================  PDC_CTRL5_REG  ===================================================== */
#define PDC_PDC_CTRL5_REG_PDC_MASTER_Pos  (11UL)                    /*!< PDC PDC_CTRL5_REG: PDC_MASTER (Bit 11)                */
#define PDC_PDC_CTRL5_REG_PDC_MASTER_Msk  (0x1800UL)                /*!< PDC PDC_CTRL5_REG: PDC_MASTER (Bitfield-Mask: 0x03)   */
#define PDC_PDC_CTRL5_REG_EN_COM_Pos      (10UL)                    /*!< PDC PDC_CTRL5_REG: EN_COM (Bit 10)                    */
#define PDC_PDC_CTRL5_REG_EN_COM_Msk      (0x400UL)                 /*!< PDC PDC_CTRL5_REG: EN_COM (Bitfield-Mask: 0x01)       */
#define PDC_PDC_CTRL5_REG_EN_PER_Pos      (9UL)                     /*!< PDC PDC_CTRL5_REG: EN_PER (Bit 9)                     */
#define PDC_PDC_CTRL5_REG_EN_PER_Msk      (0x200UL)                 /*!< PDC PDC_CTRL5_REG: EN_PER (Bitfield-Mask: 0x01)       */
#define PDC_PDC_CTRL5_REG_EN_TMR_Pos      (8UL)                     /*!< PDC PDC_CTRL5_REG: EN_TMR (Bit 8)                     */
#define PDC_PDC_CTRL5_REG_EN_TMR_Msk      (0x100UL)                 /*!< PDC PDC_CTRL5_REG: EN_TMR (Bitfield-Mask: 0x01)       */
#define PDC_PDC_CTRL5_REG_EN_XTAL_Pos     (7UL)                     /*!< PDC PDC_CTRL5_REG: EN_XTAL (Bit 7)                    */
#define PDC_PDC_CTRL5_REG_EN_XTAL_Msk     (0x80UL)                  /*!< PDC PDC_CTRL5_REG: EN_XTAL (Bitfield-Mask: 0x01)      */
#define PDC_PDC_CTRL5_REG_TRIG_ID_Pos     (2UL)                     /*!< PDC PDC_CTRL5_REG: TRIG_ID (Bit 2)                    */
#define PDC_PDC_CTRL5_REG_TRIG_ID_Msk     (0x7cUL)                  /*!< PDC PDC_CTRL5_REG: TRIG_ID (Bitfield-Mask: 0x1f)      */
#define PDC_PDC_CTRL5_REG_TRIG_SELECT_Pos (0UL)                     /*!< PDC PDC_CTRL5_REG: TRIG_SELECT (Bit 0)                */
#define PDC_PDC_CTRL5_REG_TRIG_SELECT_Msk (0x3UL)                   /*!< PDC PDC_CTRL5_REG: TRIG_SELECT (Bitfield-Mask: 0x03)  */
/* =====================================================  PDC_CTRL6_REG  ===================================================== */
#define PDC_PDC_CTRL6_REG_PDC_MASTER_Pos  (11UL)                    /*!< PDC PDC_CTRL6_REG: PDC_MASTER (Bit 11)                */
#define PDC_PDC_CTRL6_REG_PDC_MASTER_Msk  (0x1800UL)                /*!< PDC PDC_CTRL6_REG: PDC_MASTER (Bitfield-Mask: 0x03)   */
#define PDC_PDC_CTRL6_REG_EN_COM_Pos      (10UL)                    /*!< PDC PDC_CTRL6_REG: EN_COM (Bit 10)                    */
#define PDC_PDC_CTRL6_REG_EN_COM_Msk      (0x400UL)                 /*!< PDC PDC_CTRL6_REG: EN_COM (Bitfield-Mask: 0x01)       */
#define PDC_PDC_CTRL6_REG_EN_PER_Pos      (9UL)                     /*!< PDC PDC_CTRL6_REG: EN_PER (Bit 9)                     */
#define PDC_PDC_CTRL6_REG_EN_PER_Msk      (0x200UL)                 /*!< PDC PDC_CTRL6_REG: EN_PER (Bitfield-Mask: 0x01)       */
#define PDC_PDC_CTRL6_REG_EN_TMR_Pos      (8UL)                     /*!< PDC PDC_CTRL6_REG: EN_TMR (Bit 8)                     */
#define PDC_PDC_CTRL6_REG_EN_TMR_Msk      (0x100UL)                 /*!< PDC PDC_CTRL6_REG: EN_TMR (Bitfield-Mask: 0x01)       */
#define PDC_PDC_CTRL6_REG_EN_XTAL_Pos     (7UL)                     /*!< PDC PDC_CTRL6_REG: EN_XTAL (Bit 7)                    */
#define PDC_PDC_CTRL6_REG_EN_XTAL_Msk     (0x80UL)                  /*!< PDC PDC_CTRL6_REG: EN_XTAL (Bitfield-Mask: 0x01)      */
#define PDC_PDC_CTRL6_REG_TRIG_ID_Pos     (2UL)                     /*!< PDC PDC_CTRL6_REG: TRIG_ID (Bit 2)                    */
#define PDC_PDC_CTRL6_REG_TRIG_ID_Msk     (0x7cUL)                  /*!< PDC PDC_CTRL6_REG: TRIG_ID (Bitfield-Mask: 0x1f)      */
#define PDC_PDC_CTRL6_REG_TRIG_SELECT_Pos (0UL)                     /*!< PDC PDC_CTRL6_REG: TRIG_SELECT (Bit 0)                */
#define PDC_PDC_CTRL6_REG_TRIG_SELECT_Msk (0x3UL)                   /*!< PDC PDC_CTRL6_REG: TRIG_SELECT (Bitfield-Mask: 0x03)  */
/* =====================================================  PDC_CTRL7_REG  ===================================================== */
#define PDC_PDC_CTRL7_REG_PDC_MASTER_Pos  (11UL)                    /*!< PDC PDC_CTRL7_REG: PDC_MASTER (Bit 11)                */
#define PDC_PDC_CTRL7_REG_PDC_MASTER_Msk  (0x1800UL)                /*!< PDC PDC_CTRL7_REG: PDC_MASTER (Bitfield-Mask: 0x03)   */
#define PDC_PDC_CTRL7_REG_EN_COM_Pos      (10UL)                    /*!< PDC PDC_CTRL7_REG: EN_COM (Bit 10)                    */
#define PDC_PDC_CTRL7_REG_EN_COM_Msk      (0x400UL)                 /*!< PDC PDC_CTRL7_REG: EN_COM (Bitfield-Mask: 0x01)       */
#define PDC_PDC_CTRL7_REG_EN_PER_Pos      (9UL)                     /*!< PDC PDC_CTRL7_REG: EN_PER (Bit 9)                     */
#define PDC_PDC_CTRL7_REG_EN_PER_Msk      (0x200UL)                 /*!< PDC PDC_CTRL7_REG: EN_PER (Bitfield-Mask: 0x01)       */
#define PDC_PDC_CTRL7_REG_EN_TMR_Pos      (8UL)                     /*!< PDC PDC_CTRL7_REG: EN_TMR (Bit 8)                     */
#define PDC_PDC_CTRL7_REG_EN_TMR_Msk      (0x100UL)                 /*!< PDC PDC_CTRL7_REG: EN_TMR (Bitfield-Mask: 0x01)       */
#define PDC_PDC_CTRL7_REG_EN_XTAL_Pos     (7UL)                     /*!< PDC PDC_CTRL7_REG: EN_XTAL (Bit 7)                    */
#define PDC_PDC_CTRL7_REG_EN_XTAL_Msk     (0x80UL)                  /*!< PDC PDC_CTRL7_REG: EN_XTAL (Bitfield-Mask: 0x01)      */
#define PDC_PDC_CTRL7_REG_TRIG_ID_Pos     (2UL)                     /*!< PDC PDC_CTRL7_REG: TRIG_ID (Bit 2)                    */
#define PDC_PDC_CTRL7_REG_TRIG_ID_Msk     (0x7cUL)                  /*!< PDC PDC_CTRL7_REG: TRIG_ID (Bitfield-Mask: 0x1f)      */
#define PDC_PDC_CTRL7_REG_TRIG_SELECT_Pos (0UL)                     /*!< PDC PDC_CTRL7_REG: TRIG_SELECT (Bit 0)                */
#define PDC_PDC_CTRL7_REG_TRIG_SELECT_Msk (0x3UL)                   /*!< PDC PDC_CTRL7_REG: TRIG_SELECT (Bitfield-Mask: 0x03)  */
/* =====================================================  PDC_CTRL8_REG  ===================================================== */
#define PDC_PDC_CTRL8_REG_PDC_MASTER_Pos  (11UL)                    /*!< PDC PDC_CTRL8_REG: PDC_MASTER (Bit 11)                */
#define PDC_PDC_CTRL8_REG_PDC_MASTER_Msk  (0x1800UL)                /*!< PDC PDC_CTRL8_REG: PDC_MASTER (Bitfield-Mask: 0x03)   */
#define PDC_PDC_CTRL8_REG_EN_COM_Pos      (10UL)                    /*!< PDC PDC_CTRL8_REG: EN_COM (Bit 10)                    */
#define PDC_PDC_CTRL8_REG_EN_COM_Msk      (0x400UL)                 /*!< PDC PDC_CTRL8_REG: EN_COM (Bitfield-Mask: 0x01)       */
#define PDC_PDC_CTRL8_REG_EN_PER_Pos      (9UL)                     /*!< PDC PDC_CTRL8_REG: EN_PER (Bit 9)                     */
#define PDC_PDC_CTRL8_REG_EN_PER_Msk      (0x200UL)                 /*!< PDC PDC_CTRL8_REG: EN_PER (Bitfield-Mask: 0x01)       */
#define PDC_PDC_CTRL8_REG_EN_TMR_Pos      (8UL)                     /*!< PDC PDC_CTRL8_REG: EN_TMR (Bit 8)                     */
#define PDC_PDC_CTRL8_REG_EN_TMR_Msk      (0x100UL)                 /*!< PDC PDC_CTRL8_REG: EN_TMR (Bitfield-Mask: 0x01)       */
#define PDC_PDC_CTRL8_REG_EN_XTAL_Pos     (7UL)                     /*!< PDC PDC_CTRL8_REG: EN_XTAL (Bit 7)                    */
#define PDC_PDC_CTRL8_REG_EN_XTAL_Msk     (0x80UL)                  /*!< PDC PDC_CTRL8_REG: EN_XTAL (Bitfield-Mask: 0x01)      */
#define PDC_PDC_CTRL8_REG_TRIG_ID_Pos     (2UL)                     /*!< PDC PDC_CTRL8_REG: TRIG_ID (Bit 2)                    */
#define PDC_PDC_CTRL8_REG_TRIG_ID_Msk     (0x7cUL)                  /*!< PDC PDC_CTRL8_REG: TRIG_ID (Bitfield-Mask: 0x1f)      */
#define PDC_PDC_CTRL8_REG_TRIG_SELECT_Pos (0UL)                     /*!< PDC PDC_CTRL8_REG: TRIG_SELECT (Bit 0)                */
#define PDC_PDC_CTRL8_REG_TRIG_SELECT_Msk (0x3UL)                   /*!< PDC PDC_CTRL8_REG: TRIG_SELECT (Bitfield-Mask: 0x03)  */
/* =====================================================  PDC_CTRL9_REG  ===================================================== */
#define PDC_PDC_CTRL9_REG_PDC_MASTER_Pos  (11UL)                    /*!< PDC PDC_CTRL9_REG: PDC_MASTER (Bit 11)                */
#define PDC_PDC_CTRL9_REG_PDC_MASTER_Msk  (0x1800UL)                /*!< PDC PDC_CTRL9_REG: PDC_MASTER (Bitfield-Mask: 0x03)   */
#define PDC_PDC_CTRL9_REG_EN_COM_Pos      (10UL)                    /*!< PDC PDC_CTRL9_REG: EN_COM (Bit 10)                    */
#define PDC_PDC_CTRL9_REG_EN_COM_Msk      (0x400UL)                 /*!< PDC PDC_CTRL9_REG: EN_COM (Bitfield-Mask: 0x01)       */
#define PDC_PDC_CTRL9_REG_EN_PER_Pos      (9UL)                     /*!< PDC PDC_CTRL9_REG: EN_PER (Bit 9)                     */
#define PDC_PDC_CTRL9_REG_EN_PER_Msk      (0x200UL)                 /*!< PDC PDC_CTRL9_REG: EN_PER (Bitfield-Mask: 0x01)       */
#define PDC_PDC_CTRL9_REG_EN_TMR_Pos      (8UL)                     /*!< PDC PDC_CTRL9_REG: EN_TMR (Bit 8)                     */
#define PDC_PDC_CTRL9_REG_EN_TMR_Msk      (0x100UL)                 /*!< PDC PDC_CTRL9_REG: EN_TMR (Bitfield-Mask: 0x01)       */
#define PDC_PDC_CTRL9_REG_EN_XTAL_Pos     (7UL)                     /*!< PDC PDC_CTRL9_REG: EN_XTAL (Bit 7)                    */
#define PDC_PDC_CTRL9_REG_EN_XTAL_Msk     (0x80UL)                  /*!< PDC PDC_CTRL9_REG: EN_XTAL (Bitfield-Mask: 0x01)      */
#define PDC_PDC_CTRL9_REG_TRIG_ID_Pos     (2UL)                     /*!< PDC PDC_CTRL9_REG: TRIG_ID (Bit 2)                    */
#define PDC_PDC_CTRL9_REG_TRIG_ID_Msk     (0x7cUL)                  /*!< PDC PDC_CTRL9_REG: TRIG_ID (Bitfield-Mask: 0x1f)      */
#define PDC_PDC_CTRL9_REG_TRIG_SELECT_Pos (0UL)                     /*!< PDC PDC_CTRL9_REG: TRIG_SELECT (Bit 0)                */
#define PDC_PDC_CTRL9_REG_TRIG_SELECT_Msk (0x3UL)                   /*!< PDC PDC_CTRL9_REG: TRIG_SELECT (Bitfield-Mask: 0x03)  */
/* =================================================  PDC_PENDING_CM33_REG  ================================================== */
#define PDC_PDC_PENDING_CM33_REG_PDC_PENDING_Pos (0UL)              /*!< PDC PDC_PENDING_CM33_REG: PDC_PENDING (Bit 0)         */
#define PDC_PDC_PENDING_CM33_REG_PDC_PENDING_Msk (0xffffUL)         /*!< PDC PDC_PENDING_CM33_REG: PDC_PENDING (Bitfield-Mask: 0xffff) */
/* =================================================  PDC_PENDING_CMAC_REG  ================================================== */
#define PDC_PDC_PENDING_CMAC_REG_PDC_PENDING_Pos (0UL)              /*!< PDC PDC_PENDING_CMAC_REG: PDC_PENDING (Bit 0)         */
#define PDC_PDC_PENDING_CMAC_REG_PDC_PENDING_Msk (0xffffUL)         /*!< PDC PDC_PENDING_CMAC_REG: PDC_PENDING (Bitfield-Mask: 0xffff) */
/* ====================================================  PDC_PENDING_REG  ==================================================== */
#define PDC_PDC_PENDING_REG_PDC_PENDING_Pos (0UL)                   /*!< PDC PDC_PENDING_REG: PDC_PENDING (Bit 0)              */
#define PDC_PDC_PENDING_REG_PDC_PENDING_Msk (0xffffUL)              /*!< PDC PDC_PENDING_REG: PDC_PENDING (Bitfield-Mask: 0xffff) */
/* ==================================================  PDC_PENDING_SNC_REG  ================================================== */
#define PDC_PDC_PENDING_SNC_REG_PDC_PENDING_Pos (0UL)               /*!< PDC PDC_PENDING_SNC_REG: PDC_PENDING (Bit 0)          */
#define PDC_PDC_PENDING_SNC_REG_PDC_PENDING_Msk (0xffffUL)          /*!< PDC PDC_PENDING_SNC_REG: PDC_PENDING (Bitfield-Mask: 0xffff) */
/* ==================================================  PDC_SET_PENDING_REG  ================================================== */
#define PDC_PDC_SET_PENDING_REG_PDC_SET_PENDING_Pos (0UL)           /*!< PDC PDC_SET_PENDING_REG: PDC_SET_PENDING (Bit 0)      */
#define PDC_PDC_SET_PENDING_REG_PDC_SET_PENDING_Msk (0x1fUL)        /*!< PDC PDC_SET_PENDING_REG: PDC_SET_PENDING (Bitfield-Mask: 0x1f) */

/** @} */ /* End of group PosMask_peripherals */


#ifdef __cplusplus
}
#endif

#endif /* D2763X_H */


/** @} */ /* End of group D2763x */

/** @} */ /* End of group Dialog */
