/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.classfile;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import jpt.sun.tools.classfile.ClassReader;

public class AccessFlags {
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SUPER = 32;
    public static final int ACC_SYNCHRONIZED = 32;
    public static final int ACC_VOLATILE = 64;
    public static final int ACC_BRIDGE = 64;
    public static final int ACC_TRANSIENT = 128;
    public static final int ACC_VARARGS = 128;
    public static final int ACC_NATIVE = 256;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;
    public static final int ACC_STRICT = 2048;
    public static final int ACC_SYNTHETIC = 4096;
    public static final int ACC_ANNOTATION = 8192;
    public static final int ACC_ENUM = 16384;
    public static final int ACC_MANDATED = 32768;
    public static final int ACC_MODULE = 32768;
    private static final int[] classModifiers = new int[]{1, 16, 1024};
    private static final int[] classFlags = new int[]{1, 16, 32, 512, 1024, 4096, 8192, 16384, 32768};
    private static final int[] innerClassModifiers = new int[]{1, 2, 4, 8, 16, 1024};
    private static final int[] innerClassFlags = new int[]{1, 2, 4, 8, 16, 32, 512, 1024, 4096, 8192, 16384};
    private static final int[] fieldModifiers = new int[]{1, 2, 4, 8, 16, 64, 128};
    private static final int[] fieldFlags = new int[]{1, 2, 4, 8, 16, 64, 128, 4096, 16384};
    private static final int[] methodModifiers = new int[]{1, 2, 4, 8, 16, 32, 256, 1024, 2048};
    private static final int[] methodFlags = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 1024, 2048, 4096};
    public final int flags;

    AccessFlags(ClassReader cr) throws IOException {
        this(cr.readUnsignedShort());
    }

    public AccessFlags(int flags) {
        this.flags = flags;
    }

    public AccessFlags ignore(int mask) {
        return new AccessFlags(this.flags & ~mask);
    }

    public boolean is(int mask) {
        return (this.flags & mask) != 0;
    }

    public int byteLength() {
        return 2;
    }

    public Set<String> getClassModifiers() {
        int f = (this.flags & 0x200) != 0 ? this.flags & 0xFFFFFBFF : this.flags;
        return AccessFlags.getModifiers(f, classModifiers, Kind.Class);
    }

    public Set<String> getClassFlags() {
        return this.getFlags(classFlags, Kind.Class);
    }

    public Set<String> getInnerClassModifiers() {
        int f = (this.flags & 0x200) != 0 ? this.flags & 0xFFFFFBFF : this.flags;
        return AccessFlags.getModifiers(f, innerClassModifiers, Kind.InnerClass);
    }

    public Set<String> getInnerClassFlags() {
        return this.getFlags(innerClassFlags, Kind.InnerClass);
    }

    public Set<String> getFieldModifiers() {
        return this.getModifiers(fieldModifiers, Kind.Field);
    }

    public Set<String> getFieldFlags() {
        return this.getFlags(fieldFlags, Kind.Field);
    }

    public Set<String> getMethodModifiers() {
        return this.getModifiers(methodModifiers, Kind.Method);
    }

    public Set<String> getMethodFlags() {
        return this.getFlags(methodFlags, Kind.Method);
    }

    private Set<String> getModifiers(int[] modifierFlags, Kind t) {
        return AccessFlags.getModifiers(this.flags, modifierFlags, t);
    }

    private static Set<String> getModifiers(int flags, int[] modifierFlags, Kind t) {
        LinkedHashSet<String> s = new LinkedHashSet<String>();
        for (int m : modifierFlags) {
            if ((flags & m) == 0) continue;
            s.add(AccessFlags.flagToModifier(m, t));
        }
        return s;
    }

    private Set<String> getFlags(int[] expectedFlags, Kind t) {
        LinkedHashSet<String> s = new LinkedHashSet<String>();
        int f = this.flags;
        for (int e : expectedFlags) {
            if ((f & e) == 0) continue;
            s.add(AccessFlags.flagToName(e, t));
            f &= ~e;
        }
        while (f != 0) {
            int bit = Integer.highestOneBit(f);
            s.add("0x" + Integer.toHexString(bit));
            f &= ~bit;
        }
        return s;
    }

    private static String flagToModifier(int flag, Kind t) {
        switch (flag) {
            case 1: {
                return "public";
            }
            case 2: {
                return "private";
            }
            case 4: {
                return "protected";
            }
            case 8: {
                return "static";
            }
            case 16: {
                return "final";
            }
            case 32: {
                return "synchronized";
            }
            case 128: {
                return t == Kind.Field ? "transient" : null;
            }
            case 64: {
                return "volatile";
            }
            case 256: {
                return "native";
            }
            case 1024: {
                return "abstract";
            }
            case 2048: {
                return "strictfp";
            }
            case 32768: {
                return "mandated";
            }
        }
        return null;
    }

    private static String flagToName(int flag, Kind t) {
        switch (flag) {
            case 1: {
                return "ACC_PUBLIC";
            }
            case 2: {
                return "ACC_PRIVATE";
            }
            case 4: {
                return "ACC_PROTECTED";
            }
            case 8: {
                return "ACC_STATIC";
            }
            case 16: {
                return "ACC_FINAL";
            }
            case 32: {
                return t == Kind.Class ? "ACC_SUPER" : "ACC_SYNCHRONIZED";
            }
            case 64: {
                return t == Kind.Field ? "ACC_VOLATILE" : "ACC_BRIDGE";
            }
            case 128: {
                return t == Kind.Field ? "ACC_TRANSIENT" : "ACC_VARARGS";
            }
            case 256: {
                return "ACC_NATIVE";
            }
            case 512: {
                return "ACC_INTERFACE";
            }
            case 1024: {
                return "ACC_ABSTRACT";
            }
            case 2048: {
                return "ACC_STRICT";
            }
            case 4096: {
                return "ACC_SYNTHETIC";
            }
            case 8192: {
                return "ACC_ANNOTATION";
            }
            case 16384: {
                return "ACC_ENUM";
            }
            case 32768: {
                return t == Kind.Class ? "ACC_MODULE" : "ACC_MANDATED";
            }
        }
        return null;
    }

    public static enum Kind {
        Class,
        InnerClass,
        Field,
        Method;

    }
}

