/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.php.codeception.ui;

import java.awt.EventQueue;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.modules.php.codeception.commands.Codecept;
import org.netbeans.modules.php.codeception.commands.Codecept.GenerateCommand;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class CodeceptionCreateTestPanel extends JPanel {

    public CodeceptionCreateTestPanel(List<GenerateCommand> commands, List<String> suites) {
        assert EventQueue.isDispatchThread();
        assert suites != null;
        assert commands != null;

        initComponents();
        init(commands, suites);
    }

    private void init(List<GenerateCommand> commands, List<String> suites) {
        for (String suite : suites) {
            suitesComboBox.addItem(suite);
        }
        for (GenerateCommand command : commands) {
            generateComboBox.addItem(command);
        }
    }

    public String getSelectedSuite() {
        return (String) suitesComboBox.getSelectedItem();
    }

    public GenerateCommand getSelectedCommand() {
        return (GenerateCommand) generateComboBox.getSelectedItem();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        commandLabel = new JLabel();
        generateComboBox = new JComboBox<Codecept.GenerateCommand>();
        suiteLabel = new JLabel();
        suitesComboBox = new JComboBox<String>();

        commandLabel.setLabelFor(generateComboBox);
        Mnemonics.setLocalizedText(commandLabel, NbBundle.getMessage(CodeceptionCreateTestPanel.class, "CodeceptionCreateTestPanel.commandLabel.text")); // NOI18N

        suiteLabel.setLabelFor(suitesComboBox);
        Mnemonics.setLocalizedText(suiteLabel, NbBundle.getMessage(CodeceptionCreateTestPanel.class, "CodeceptionCreateTestPanel.suiteLabel.text")); // NOI18N

        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING)
                    .addComponent(commandLabel)
                    .addComponent(suiteLabel))
                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING)
                    .addComponent(generateComboBox, 0, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(suitesComboBox, 0, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addGap(0, 0, 0))
        );
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                    .addComponent(commandLabel)
                    .addComponent(generateComboBox, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                    .addComponent(suiteLabel)
                    .addComponent(suitesComboBox, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)))
        );
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private JLabel commandLabel;
    private JComboBox<Codecept.GenerateCommand> generateComboBox;
    private JLabel suiteLabel;
    private JComboBox<String> suitesComboBox;
    // End of variables declaration//GEN-END:variables

}
