/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.authentication.ott;

import java.util.Collection;
import java.util.List;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.authentication.ott.OneTimeTokenAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.server.authentication.ServerAuthenticationConverter;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public final class ServerOneTimeTokenAuthenticationConverter
implements ServerAuthenticationConverter {
    private static final String TOKEN = "token";

    @Override
    public Mono<Authentication> convert(ServerWebExchange exchange) {
        Assert.notNull((Object)exchange, (String)"exchange cannot be null");
        if (this.isFormEncodedRequest(exchange.getRequest())) {
            return exchange.getFormData().map(data -> OneTimeTokenAuthenticationToken.unauthenticated((String)((String)data.getFirst((Object)TOKEN))));
        }
        String token = this.resolveTokenFromRequest(exchange.getRequest());
        if (!StringUtils.hasText((String)token)) {
            return Mono.empty();
        }
        return Mono.just((Object)OneTimeTokenAuthenticationToken.unauthenticated((String)token));
    }

    private String resolveTokenFromRequest(ServerHttpRequest request) {
        List parameterTokens = (List)request.getQueryParams().get((Object)TOKEN);
        if (CollectionUtils.isEmpty((Collection)parameterTokens)) {
            return null;
        }
        if (parameterTokens.size() == 1) {
            return (String)parameterTokens.get(0);
        }
        return null;
    }

    private boolean isFormEncodedRequest(ServerHttpRequest request) {
        return HttpMethod.POST.equals((Object)request.getMethod()) && "application/x-www-form-urlencoded".equals(request.getHeaders().getFirst("Content-Type"));
    }
}

