/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.client.impl;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.toolkit.client.RequestConfig;

public class AbstractJerseyClient {
    private static final RequestConfig EMPTY_REQUEST_CONFIG = () -> Collections.emptyMap();
    private final RequestConfig requestConfig;

    public AbstractJerseyClient(RequestConfig requestConfig) {
        this.requestConfig = requestConfig == null ? EMPTY_REQUEST_CONFIG : requestConfig;
    }

    protected RequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    protected Invocation.Builder getRequestBuilder(WebTarget webTarget) {
        Invocation.Builder requestBuilder = webTarget.request();
        Map<String, String> headers = this.requestConfig.getHeaders();
        headers.entrySet().stream().forEach(e -> requestBuilder.header((String)e.getKey(), e.getValue()));
        return requestBuilder;
    }

    protected <T> T executeAction(String errorMessage, NiFiAction<T> action) throws NiFiClientException, IOException {
        try {
            return action.execute();
        }
        catch (Exception e) {
            Throwable ioeCause = this.getIOExceptionCause(e);
            if (ioeCause == null) {
                StringBuilder errorMessageBuilder = new StringBuilder(errorMessage);
                if (e instanceof WebApplicationException) {
                    Response response = ((WebApplicationException)e).getResponse();
                    String responseBody = (String)response.readEntity(String.class);
                    errorMessageBuilder.append(": ").append(responseBody);
                }
                throw new NiFiClientException(errorMessageBuilder.toString(), e);
            }
            throw (IOException)ioeCause;
        }
    }

    protected Throwable getIOExceptionCause(Throwable e) {
        if (e == null) {
            return null;
        }
        if (e instanceof IOException) {
            return e;
        }
        return this.getIOExceptionCause(e.getCause());
    }

    protected String getContentDispositionFilename(Response response) {
        String contentDispositionHeader = response.getHeaderString("Content-Disposition");
        if (StringUtils.isBlank((CharSequence)contentDispositionHeader)) {
            throw new IllegalStateException("Content-Disposition header was blank or missing");
        }
        int equalsIndex = contentDispositionHeader.lastIndexOf("=");
        String filenameValue = contentDispositionHeader.substring(equalsIndex + 1).trim();
        StringBuilder filename = new StringBuilder(filenameValue);
        if (!filename.isEmpty() && filename.charAt(0) == '\"') {
            filename.deleteCharAt(0);
        }
        if (!filename.isEmpty() && filename.charAt(filename.length() - 1) == '\"') {
            filename.setLength(filename.length() - 1);
        }
        return filename.toString();
    }

    protected static interface NiFiAction<T> {
        public T execute() throws IOException;
    }
}

