/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util.file.monitor;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.nifi.util.file.monitor.UpdateMonitor;

public class CompoundUpdateMonitor
implements UpdateMonitor {
    private final List<UpdateMonitor> monitors = new ArrayList<UpdateMonitor>();

    public CompoundUpdateMonitor(UpdateMonitor first, UpdateMonitor ... others) {
        this.monitors.add(first);
        for (UpdateMonitor monitor : others) {
            this.monitors.add(monitor);
        }
    }

    @Override
    public Object getCurrentState(Path path) throws IOException {
        return new DeferredMonitorAction(this.monitors, path);
    }

    private static class DeferredMonitorAction {
        private static final Object NON_COMPUTED_VALUE = new Object();
        private final List<UpdateMonitor> monitors;
        private final Path path;
        private final Object[] preCalculated;

        public DeferredMonitorAction(List<UpdateMonitor> monitors, Path path) {
            this.monitors = monitors;
            this.path = path;
            this.preCalculated = new Object[monitors.size()];
            for (int i = 0; i < this.preCalculated.length; ++i) {
                this.preCalculated[i] = NON_COMPUTED_VALUE;
            }
        }

        private Object getCalculatedValue(int i) throws IOException {
            if (this.preCalculated[i] == NON_COMPUTED_VALUE) {
                this.preCalculated[i] = this.monitors.get(i).getCurrentState(this.path);
            }
            return this.preCalculated[i];
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof DeferredMonitorAction)) {
                return false;
            }
            DeferredMonitorAction other = (DeferredMonitorAction)obj;
            try {
                for (int i = 0; i < this.preCalculated.length; ++i) {
                    Object theirs;
                    Object mine = this.getCalculatedValue(i);
                    if (mine == (theirs = other.getCalculatedValue(i))) {
                        return true;
                    }
                    if (mine == null && theirs == null) {
                        return true;
                    }
                    if (!mine.equals(theirs)) continue;
                    return true;
                }
            }
            catch (IOException e) {
                return false;
            }
            return false;
        }
    }
}

