/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.bootstrap;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.nifi.stateless.bootstrap.BootstrapConfiguration;
import org.apache.nifi.stateless.bootstrap.StatelessBootstrap;
import org.apache.nifi.stateless.config.ParameterOverride;
import org.apache.nifi.stateless.config.PropertiesFileEngineConfigurationParser;
import org.apache.nifi.stateless.config.StatelessConfigurationException;
import org.apache.nifi.stateless.engine.StatelessEngineConfiguration;
import org.apache.nifi.stateless.flow.DataflowDefinition;
import org.apache.nifi.stateless.flow.DataflowTrigger;
import org.apache.nifi.stateless.flow.StatelessDataflow;
import org.apache.nifi.stateless.flow.StatelessDataflowInitializationContext;
import org.apache.nifi.stateless.flow.StatelessDataflowValidation;
import org.apache.nifi.stateless.flow.TriggerResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunStatelessFlow {
    private static final Logger logger = LoggerFactory.getLogger(RunStatelessFlow.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, StatelessConfigurationException, InterruptedException {
        BootstrapConfiguration bootstrapConfiguration;
        try {
            bootstrapConfiguration = BootstrapConfiguration.fromCommandLineArgs(args);
        }
        catch (IllegalArgumentException iae) {
            System.out.println("* " + iae.getMessage());
            System.out.println();
            BootstrapConfiguration.printUsage();
            System.exit(1);
            return;
        }
        PropertiesFileEngineConfigurationParser engineConfigParser = new PropertiesFileEngineConfigurationParser();
        StatelessEngineConfiguration engineConfiguration = engineConfigParser.parseEngineConfiguration(bootstrapConfiguration.getEngineConfigFile());
        StatelessDataflow dataflow = RunStatelessFlow.createDataflow(engineConfiguration, bootstrapConfiguration.getFlowDefinitionFile(), bootstrapConfiguration.getParameterOverrides());
        try {
            if (bootstrapConfiguration.isRunContinuous()) {
                RunStatelessFlow.triggerContinuously(dataflow);
            } else {
                RunStatelessFlow.triggerOnce(dataflow);
            }
        }
        finally {
            dataflow.shutdown();
        }
    }

    private static void triggerContinuously(StatelessDataflow dataflow) throws InterruptedException {
        while (true) {
            try {
                while (true) {
                    RunStatelessFlow.triggerOnce(dataflow);
                }
            }
            catch (InterruptedException ie) {
                throw ie;
            }
            catch (Exception e) {
                logger.error("Failed to run dataflow", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private static void triggerOnce(StatelessDataflow dataflow) throws InterruptedException {
        DataflowTrigger trigger = dataflow.trigger();
        TriggerResult result = trigger.getResult();
        result.acknowledge();
    }

    public static StatelessDataflow createDataflow(StatelessEngineConfiguration engineConfiguration, File flowDefinitionFile, List<ParameterOverride> parameterOverrides) throws IOException, StatelessConfigurationException {
        long initializeStart = System.currentTimeMillis();
        StatelessBootstrap bootstrap = StatelessBootstrap.bootstrap(engineConfiguration);
        DataflowDefinition dataflowDefinition = bootstrap.parseDataflowDefinition(flowDefinitionFile, parameterOverrides);
        StatelessDataflow dataflow = bootstrap.createDataflow(dataflowDefinition);
        dataflow.initialize(new StatelessDataflowInitializationContext(){

            public boolean isEnableControllerServices() {
                return true;
            }
        });
        StatelessDataflowValidation validation = dataflow.performValidation();
        if (!validation.isValid()) {
            logger.error("{}", (Object)validation);
            throw new IllegalStateException("Dataflow is not valid");
        }
        long initializeMillis = System.currentTimeMillis() - initializeStart;
        logger.info("Initialized Stateless NiFi in {} millis", (Object)initializeMillis);
        return dataflow;
    }
}

