/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.resource.ResourceType;
import org.apache.nifi.components.PortFunction;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.controller.BackoffMechanism;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.util.CharacterFilterUtils;
import org.apache.nifi.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPort
implements Port {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPort.class);
    public static final Relationship PORT_RELATIONSHIP = new Relationship.Builder().description("The relationship through which all FlowFiles are transferred").name("").build();
    private static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.MILLISECONDS;
    private static final String DEFAULT_MAX_BACKOFF_PERIOD = "10 mins";
    private final List<Relationship> relationships;
    private final String id;
    private final ConnectableType type;
    private final AtomicReference<String> name;
    private final AtomicReference<Position> position;
    private final AtomicReference<String> comments;
    private final AtomicReference<ProcessGroup> processGroup = new AtomicReference();
    private final AtomicBoolean lossTolerant;
    private final AtomicReference<ScheduledState> scheduledState;
    private final AtomicInteger concurrentTaskCount;
    private final AtomicReference<String> penalizationPeriod;
    private final AtomicReference<String> yieldPeriod;
    private final AtomicReference<String> schedulingPeriod;
    private final AtomicReference<String> versionedComponentId = new AtomicReference();
    private final AtomicLong schedulingNanos;
    private final AtomicLong yieldExpiration;
    private final AtomicReference<PortFunction> portFunction = new AtomicReference<PortFunction>(PortFunction.STANDARD);
    private final ProcessScheduler processScheduler;
    private final Set<Connection> outgoingConnections;
    private final List<Connection> incomingConnections;
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();

    public AbstractPort(String id, String name, ConnectableType type, ProcessScheduler scheduler) {
        this.id = Objects.requireNonNull(id);
        this.name = new AtomicReference<String>(Objects.requireNonNull(name));
        this.position = new AtomicReference<Position>(new Position(0.0, 0.0));
        this.outgoingConnections = new HashSet<Connection>();
        this.incomingConnections = new ArrayList<Connection>();
        this.comments = new AtomicReference();
        this.lossTolerant = new AtomicBoolean(false);
        this.concurrentTaskCount = new AtomicInteger(1);
        this.processScheduler = scheduler;
        ArrayList<Relationship> relationshipList = new ArrayList<Relationship>();
        relationshipList.add(PORT_RELATIONSHIP);
        this.relationships = Collections.unmodifiableList(relationshipList);
        this.type = type;
        this.penalizationPeriod = new AtomicReference<String>("30 sec");
        this.yieldPeriod = new AtomicReference<String>("1 sec");
        this.yieldExpiration = new AtomicLong(0L);
        this.schedulingPeriod = new AtomicReference<String>("0 millis");
        this.schedulingNanos = new AtomicLong(1L);
        this.scheduledState = new AtomicReference<ScheduledState>(ScheduledState.STOPPED);
    }

    @Override
    public String getIdentifier() {
        return this.id;
    }

    public String getProcessGroupIdentifier() {
        ProcessGroup procGroup = this.getProcessGroup();
        return procGroup == null ? null : procGroup.getIdentifier();
    }

    @Override
    public String getName() {
        return this.name.get();
    }

    @Override
    public void setName(String name) {
        if (this.name.get().equals(name)) {
            return;
        }
        ProcessGroup parentGroup = this.processGroup.get();
        if (this.getConnectableType() == ConnectableType.INPUT_PORT ? parentGroup.getInputPortByName(name) != null : this.getConnectableType() == ConnectableType.OUTPUT_PORT && parentGroup.getOutputPortByName(name) != null) {
            throw new IllegalStateException("A port with the same name already exists.");
        }
        this.name.set(name);
    }

    public Authorizable getParentAuthorizable() {
        return this.getProcessGroup();
    }

    public Resource getResource() {
        ResourceType resourceType = ConnectableType.INPUT_PORT.equals((Object)this.getConnectableType()) ? ResourceType.InputPort : ResourceType.OutputPort;
        return ResourceFactory.getComponentResource((ResourceType)resourceType, (String)this.getIdentifier(), (String)this.getName());
    }

    @Override
    public ProcessGroup getProcessGroup() {
        return this.processGroup.get();
    }

    @Override
    public void setProcessGroup(ProcessGroup newGroup) {
        if (this.processGroup.get() != null && !Objects.equals(newGroup, this.processGroup.get())) {
            this.versionedComponentId.set(null);
        }
        this.processGroup.set(newGroup);
    }

    @Override
    public String getComments() {
        return this.comments.get();
    }

    @Override
    public void setComments(String comments) {
        this.comments.set(CharacterFilterUtils.filterInvalidXmlCharacters(comments));
    }

    @Override
    public Collection<Relationship> getRelationships() {
        return this.relationships;
    }

    @Override
    public Relationship getRelationship(String relationshipName) {
        if (PORT_RELATIONSHIP.getName().equals(relationshipName)) {
            return PORT_RELATIONSHIP;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnection(Connection connection) throws IllegalArgumentException {
        this.writeLock.lock();
        try {
            if (!Objects.requireNonNull(connection).getSource().equals(this)) {
                if (connection.getDestination().equals(this)) {
                    if (!this.incomingConnections.contains(connection)) {
                        this.incomingConnections.add(connection);
                    }
                    return;
                }
                throw new IllegalArgumentException("Cannot add a connection to a LocalPort for which the LocalPort is neither the Source nor the Destination");
            }
            for (Relationship relationship : connection.getRelationships()) {
                if (relationship.equals((Object)PORT_RELATIONSHIP)) continue;
                throw new IllegalArgumentException("No relationship with name " + String.valueOf(relationship) + " exists for Local Ports");
            }
            if (!this.outgoingConnections.contains(connection)) {
                this.outgoingConnections.add(connection);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean hasIncomingConnection() {
        this.readLock.lock();
        try {
            boolean bl = !this.incomingConnections.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) throws ProcessException {
        ProcessSession session = sessionFactory.createSession();
        try {
            this.onTrigger(context, session);
        }
        catch (Throwable t) {
            session.rollback();
            throw t;
        }
        session.commitAsync();
    }

    public abstract void onTrigger(ProcessContext var1, ProcessSession var2) throws ProcessException;

    @Override
    public void updateConnection(Connection connection) throws IllegalStateException {
        if (Objects.requireNonNull(connection).getSource().equals(this)) {
            this.writeLock.lock();
            try {
                if (!this.outgoingConnections.remove(connection)) {
                    throw new IllegalStateException("No Connection with ID " + connection.getIdentifier() + " is currently registered with this Port");
                }
                this.outgoingConnections.add(connection);
            }
            finally {
                this.writeLock.unlock();
            }
        } else if (connection.getDestination().equals(this)) {
            this.writeLock.lock();
            try {
                if (!this.incomingConnections.remove(connection)) {
                    throw new IllegalStateException("No Connection with ID " + connection.getIdentifier() + " is currently registered with this Port");
                }
                this.incomingConnections.add(connection);
            }
            finally {
                this.writeLock.unlock();
            }
        } else {
            throw new IllegalStateException("The given connection is not currently registered for this Port");
        }
    }

    @Override
    public void removeConnection(Connection connection) throws IllegalArgumentException, IllegalStateException {
        this.writeLock.lock();
        try {
            if (!Objects.requireNonNull(connection).getSource().equals(this)) {
                boolean existed = this.incomingConnections.remove(connection);
                if (!existed) {
                    throw new IllegalStateException("The given connection is not currently registered for this Port");
                }
                return;
            }
            if (!this.canConnectionBeRemoved(connection)) {
                throw new IllegalStateException("Connection " + connection.getIdentifier() + " cannot be removed");
            }
            boolean removed = this.outgoingConnections.remove(connection);
            if (!removed) {
                throw new IllegalStateException("Connection " + connection.getIdentifier() + " is not registered with " + this.getIdentifier());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private boolean canConnectionBeRemoved(Connection connection) {
        Connectable source = connection.getSource();
        if (!source.isRunning()) {
            return true;
        }
        for (Relationship relationship : source.getRelationships()) {
            Set<Connection> connectionsForRelationship;
            if (source.isAutoTerminated(relationship) || (connectionsForRelationship = source.getConnections(relationship)) != null && !connectionsForRelationship.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<Connection> getConnections() {
        this.readLock.lock();
        try {
            Set<Connection> set = Collections.unmodifiableSet(this.outgoingConnections);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Set<Connection> getConnections(Relationship relationship) {
        this.readLock.lock();
        try {
            if (relationship.equals((Object)PORT_RELATIONSHIP)) {
                Set<Connection> set = Collections.unmodifiableSet(this.outgoingConnections);
                return set;
            }
            throw new IllegalArgumentException("No relationship with name " + relationship.getName() + " exists for Local Ports");
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Position getPosition() {
        return this.position.get();
    }

    @Override
    public void setPosition(Position position) {
        this.position.set(position);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", (Object)this.getIdentifier()).toString();
    }

    @Override
    public List<Connection> getIncomingConnections() {
        this.readLock.lock();
        try {
            List<Connection> list = Collections.unmodifiableList(this.incomingConnections);
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public abstract boolean isValid();

    @Override
    public boolean isAutoTerminated(Relationship relationship) {
        return false;
    }

    @Override
    public boolean isLossTolerant() {
        return this.lossTolerant.get();
    }

    @Override
    public void setLossTolerant(boolean lossTolerant) {
        this.lossTolerant.set(lossTolerant);
    }

    public void setMaxConcurrentTasks(int taskCount) {
        if (taskCount < 1) {
            throw new IllegalArgumentException();
        }
        this.concurrentTaskCount.set(taskCount);
    }

    public int getMaxConcurrentTasks() {
        return this.concurrentTaskCount.get();
    }

    @Override
    public void shutdown() {
        this.scheduledState.set(ScheduledState.STOPPED);
        logger.info("{} shutdown", (Object)this);
    }

    @Override
    public void onSchedulingStart() {
        this.scheduledState.set(ScheduledState.RUNNING);
        logger.info("{} started", (Object)this);
    }

    @Override
    public void disable() {
        boolean updated = this.scheduledState.compareAndSet(ScheduledState.STOPPED, ScheduledState.DISABLED);
        if (!updated) {
            throw new IllegalStateException("Port cannot be disabled because it is not stopped");
        }
        logger.info("{} disabled", (Object)this);
    }

    public void enable() {
        boolean updated = this.scheduledState.compareAndSet(ScheduledState.DISABLED, ScheduledState.STOPPED);
        if (!updated) {
            throw new IllegalStateException("Port cannot be enabled because it is not disabled");
        }
        logger.info("{} enabled", (Object)this);
    }

    public boolean isRunning() {
        return this.getScheduledState().equals((Object)ScheduledState.RUNNING) || this.processScheduler.getActiveThreadCount(this) > 0;
    }

    public ScheduledState getScheduledState() {
        return this.scheduledState.get();
    }

    @Override
    public ConnectableType getConnectableType() {
        return this.type;
    }

    @Override
    public void setYieldPeriod(String yieldPeriod) {
        long yieldMillis = FormatUtils.getTimeDuration((String)Objects.requireNonNull(yieldPeriod), (TimeUnit)TimeUnit.MILLISECONDS);
        if (yieldMillis < 0L) {
            throw new IllegalArgumentException("Yield duration must be positive");
        }
        this.yieldPeriod.set(yieldPeriod);
    }

    public void setSchedulingPeriod(String schedulingPeriod) {
        long schedulingNanos = FormatUtils.getTimeDuration((String)Objects.requireNonNull(schedulingPeriod), (TimeUnit)TimeUnit.NANOSECONDS);
        if (schedulingNanos < 0L) {
            throw new IllegalArgumentException("Scheduling Period must be positive");
        }
        this.schedulingPeriod.set(schedulingPeriod);
        this.schedulingNanos.set(Math.max(1L, schedulingNanos));
    }

    @Override
    public long getPenalizationPeriod(TimeUnit timeUnit) {
        return FormatUtils.getTimeDuration((String)this.getPenalizationPeriod(), (TimeUnit)(timeUnit == null ? DEFAULT_TIME_UNIT : timeUnit));
    }

    @Override
    public String getPenalizationPeriod() {
        return this.penalizationPeriod.get();
    }

    @Override
    public void yield() {
        long yieldMillis = this.getYieldPeriod(TimeUnit.MILLISECONDS);
        this.yield(yieldMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void yield(long yieldDuration, TimeUnit timeUnit) {
        long yieldMillis = timeUnit.toMillis(yieldDuration);
        this.yieldExpiration.set(Math.max(this.yieldExpiration.get(), System.currentTimeMillis() + yieldMillis));
    }

    @Override
    public long getYieldExpiration() {
        return this.yieldExpiration.get();
    }

    public long getSchedulingPeriod(TimeUnit timeUnit) {
        return timeUnit.convert(this.schedulingNanos.get(), TimeUnit.NANOSECONDS);
    }

    public String getSchedulingPeriod() {
        return this.schedulingPeriod.get();
    }

    @Override
    public void setPenalizationPeriod(String penalizationPeriod) {
        this.penalizationPeriod.set(penalizationPeriod);
    }

    @Override
    public String getYieldPeriod() {
        return this.yieldPeriod.get();
    }

    @Override
    public long getYieldPeriod(TimeUnit timeUnit) {
        return FormatUtils.getTimeDuration((String)this.getYieldPeriod(), (TimeUnit)(timeUnit == null ? DEFAULT_TIME_UNIT : timeUnit));
    }

    @Override
    public void verifyCanDelete() throws IllegalStateException {
        this.verifyCanDelete(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void verifyCanDelete(boolean ignoreConnections) {
        this.readLock.lock();
        try {
            if (this.isRunning()) {
                throw new IllegalStateException(this.getIdentifier() + " is running");
            }
            if (!ignoreConnections) {
                for (Connection connection : this.outgoingConnections) {
                    connection.verifyCanDelete();
                }
                for (Connection connection : this.incomingConnections) {
                    if (connection.getSource().equals(this)) {
                        connection.verifyCanDelete();
                        continue;
                    }
                    throw new IllegalStateException(this.getIdentifier() + " is the destination of another component");
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void verifyCanStart() {
        this.readLock.lock();
        try {
            switch (this.scheduledState.get()) {
                case DISABLED: {
                    throw new IllegalStateException(this.getIdentifier() + " cannot be started because it is disabled");
                }
                case RUNNING: {
                    throw new IllegalStateException(this.getIdentifier() + " cannot be started because it is already running");
                }
            }
            this.verifyNoActiveThreads();
            Collection<ValidationResult> validationResults = this.getValidationErrors();
            if (!validationResults.isEmpty()) {
                String portType = this.getConnectableType() == ConnectableType.INPUT_PORT ? "Input Port" : "Output Port";
                String message = String.format("%s %s is not in a valid state: %s", portType, this.getIdentifier(), validationResults.iterator().next().getExplanation());
                throw new IllegalStateException(message);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void verifyCanStop() {
        if (this.getScheduledState() != ScheduledState.RUNNING) {
            throw new IllegalStateException(this.getIdentifier() + " is not scheduled to run");
        }
    }

    @Override
    public void verifyCanUpdate() {
        this.readLock.lock();
        try {
            if (this.isRunning()) {
                throw new IllegalStateException(this.getIdentifier() + " is not stopped");
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void verifyCanEnable() {
        this.readLock.lock();
        try {
            if (this.getScheduledState() != ScheduledState.DISABLED) {
                throw new IllegalStateException(this.getIdentifier() + " is not disabled");
            }
            this.verifyNoActiveThreads();
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void verifyCanDisable() {
        this.readLock.lock();
        try {
            if (this.getScheduledState() != ScheduledState.STOPPED) {
                throw new IllegalStateException(this.getIdentifier() + " is not stopped");
            }
            this.verifyNoActiveThreads();
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void verifyNoActiveThreads() throws IllegalStateException {
        int threadCount = this.processScheduler.getActiveThreadCount(this);
        if (threadCount > 0) {
            throw new IllegalStateException(this.getIdentifier() + " has " + threadCount + " threads still active");
        }
    }

    @Override
    public void verifyCanClearState() {
    }

    public Optional<String> getVersionedComponentId() {
        return Optional.ofNullable(this.versionedComponentId.get());
    }

    public void setVersionedComponentId(String versionedComponentId) {
        boolean updated = false;
        while (!updated) {
            String currentId = this.versionedComponentId.get();
            if (currentId == null) {
                updated = this.versionedComponentId.compareAndSet(null, versionedComponentId);
                continue;
            }
            if (currentId.equals(versionedComponentId)) {
                return;
            }
            if (versionedComponentId == null) {
                updated = this.versionedComponentId.compareAndSet(currentId, null);
                continue;
            }
            throw new IllegalStateException(String.valueOf(this) + " is already under version control");
        }
    }

    @Override
    public int getRetryCount() {
        return 0;
    }

    @Override
    public void setRetryCount(Integer retryCount) {
    }

    @Override
    public Set<String> getRetriedRelationships() {
        return Collections.EMPTY_SET;
    }

    @Override
    public void setRetriedRelationships(Set<String> retriedRelationships) {
    }

    @Override
    public boolean isRelationshipRetried(Relationship relationship) {
        return false;
    }

    @Override
    public BackoffMechanism getBackoffMechanism() {
        return BackoffMechanism.PENALIZE_FLOWFILE;
    }

    @Override
    public void setBackoffMechanism(BackoffMechanism backoffMechanism) {
    }

    @Override
    public String getMaxBackoffPeriod() {
        return DEFAULT_MAX_BACKOFF_PERIOD;
    }

    @Override
    public void setMaxBackoffPeriod(String maxBackoffPeriod) {
    }

    @Override
    public String evaluateParameters(String value) {
        return value;
    }

    @Override
    public PortFunction getPortFunction() {
        return this.portFunction.get();
    }

    @Override
    public void setPortFunction(PortFunction portFunction) {
        this.portFunction.set(Objects.requireNonNull(portFunction));
    }
}

