/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.operation;

import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.internal.config.MapConfigReadOnly;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.spi.impl.operationservice.AbstractLocalOperation;
import java.util.Map;

public class GetMapConfigOperation
extends AbstractLocalOperation {
    private final String mapName;
    private MapConfig mapConfig;

    public GetMapConfigOperation(String mapName) {
        this.mapName = mapName;
    }

    @Override
    public void run() throws Exception {
        MapService service = (MapService)this.getService();
        MapServiceContext mapServiceContext = service.getMapServiceContext();
        MapContainer mapContainer = mapServiceContext.getMapContainer(this.mapName);
        this.mapConfig = mapContainer.getMapConfig();
        this.mapConfig = GetMapConfigOperation.addIndexConfig(this.mapConfig, mapContainer.getIndexDefinitions());
    }

    private static MapConfig addIndexConfig(MapConfig mapConfig, Map<String, IndexConfig> indexDefinitions) {
        if (MapUtil.isNullOrEmpty(indexDefinitions)) {
            return mapConfig;
        }
        MapConfig mapConfigWithIndexes = new MapConfig(mapConfig);
        mapConfigWithIndexes.getIndexConfigs().clear();
        for (IndexConfig indexConfig : indexDefinitions.values()) {
            mapConfigWithIndexes.addIndexConfig(indexConfig);
        }
        return new MapConfigReadOnly(mapConfigWithIndexes);
    }

    @Override
    public Object getResponse() {
        return this.mapConfig;
    }
}

