/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl.iterator;

import com.hazelcast.internal.iteration.IterationResult;
import com.hazelcast.internal.iteration.IteratorWithCursor;
import com.hazelcast.internal.iteration.IteratorWithCursorManager;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.replicatedmap.impl.ReplicatedMapService;
import com.hazelcast.replicatedmap.impl.record.ReplicatedMapEntryViewHolder;
import com.hazelcast.replicatedmap.impl.record.ReplicatedRecord;
import com.hazelcast.replicatedmap.impl.record.ReplicatedRecordStore;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ReplicatedMapIterationService {
    public static final HazelcastProperty ITERATOR_CLEANUP_PERIOD_SECONDS = new HazelcastProperty("hazelcast.replicatedmap.iterator.cleanup.period.seconds", 30, TimeUnit.SECONDS);
    public static final HazelcastProperty ITERATOR_CLEANUP_TIMEOUT_MILLIS = new HazelcastProperty("hazelcast.replicatedmap.iterator.cleanup.timeout.millis", 300000, TimeUnit.MILLISECONDS);
    private final ReplicatedMapService replicatedMapService;
    private final SerializationService serializationService;
    private final IteratorWithCursorManager<ReplicatedRecord> iteratorManager;
    private final HazelcastProperties properties;
    private final NodeEngine nodeEngine;
    private final AtomicBoolean noIteratorCreated = new AtomicBoolean(true);
    private ScheduledFuture iteratorCleanupFuture;

    public ReplicatedMapIterationService(ReplicatedMapService replicatedMapService, SerializationService serializationService, NodeEngine nodeEngine) {
        this.replicatedMapService = replicatedMapService;
        this.serializationService = serializationService;
        this.properties = nodeEngine.getProperties();
        this.iteratorManager = new IteratorWithCursorManager(replicatedMapService.getNodeEngine());
        this.nodeEngine = nodeEngine;
    }

    public void createIterator(String name, int partitionId, UUID cursorId) {
        ReplicatedRecordStore store;
        if (this.noIteratorCreated.getAndSet(false)) {
            this.iteratorCleanupFuture = this.nodeEngine.getExecutionService().getGlobalTaskScheduler().scheduleWithRepetition(this::removeStaleIterators, 0L, this.nodeEngine.getProperties().getInteger(ITERATOR_CLEANUP_PERIOD_SECONDS), TimeUnit.SECONDS);
        }
        if ((store = this.replicatedMapService.getReplicatedRecordStore(name, false, partitionId)) == null) {
            throw new IllegalStateException("There is no ReplicatedRecordStore for " + name + " on partitionId " + partitionId + " on member " + this.replicatedMapService.getNodeEngine().getThisAddress() + ".");
        }
        this.iteratorManager.createIterator(store.recordIterator(), cursorId);
    }

    public IterationResult<ReplicatedMapEntryViewHolder> iterate(UUID cursorId, int maxCount) {
        IterationResult<ReplicatedRecord> result = this.iteratorManager.iterate(cursorId, maxCount);
        List<ReplicatedRecord> page = result.getPage();
        return new IterationResult<ReplicatedMapEntryViewHolder>(this.convertToHolder(page), result.getCursorId(), result.getCursorIdToForget());
    }

    private List<ReplicatedMapEntryViewHolder> convertToHolder(List<ReplicatedRecord> page) {
        if (page.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ReplicatedMapEntryViewHolder> result = new ArrayList<ReplicatedMapEntryViewHolder>(page.size());
        for (ReplicatedRecord record : page) {
            result.add(this.toEntryViewHolder(record));
        }
        return result;
    }

    public void removeStaleIterators() {
        ConcurrentHashMap.KeySetView<UUID, IteratorWithCursor<ReplicatedRecord>> keySetView = this.iteratorManager.getKeySet();
        for (UUID iteratorId : keySetView) {
            IteratorWithCursor<ReplicatedRecord> paginator = this.iteratorManager.getIterator(iteratorId);
            if (paginator.getLastAccessTime() >= System.currentTimeMillis() - this.properties.getLong(ITERATOR_CLEANUP_TIMEOUT_MILLIS)) continue;
            keySetView.remove(iteratorId);
        }
    }

    public IteratorWithCursorManager<ReplicatedRecord> getIteratorManager() {
        return this.iteratorManager;
    }

    private ReplicatedMapEntryViewHolder toEntryViewHolder(ReplicatedRecord record) {
        return new ReplicatedMapEntryViewHolder(this.toData(record.getKey()), this.toData(record.getValue()), record.getCreationTime(), record.getHits(), record.getLastAccessTime(), record.getUpdateTime(), record.getTtlMillis());
    }

    private Data toData(Object object) {
        return this.serializationService.toData(object);
    }

    public void shutdown() {
        if (this.iteratorCleanupFuture != null) {
            this.iteratorCleanupFuture.cancel(true);
        }
    }
}

