/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl.operation;

import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.replicatedmap.impl.ReplicatedMapService;
import com.hazelcast.replicatedmap.impl.iterator.ReplicatedMapIterationService;
import com.hazelcast.replicatedmap.impl.operation.AbstractNamedSerializableOperation;
import com.hazelcast.spi.impl.operationservice.ReadonlyOperation;
import java.io.IOException;
import java.util.UUID;

public class EndEntryViewIterationOperation
extends AbstractNamedSerializableOperation
implements ReadonlyOperation {
    private UUID cursorId;
    private String name;

    public EndEntryViewIterationOperation() {
    }

    public EndEntryViewIterationOperation(String name, UUID cursorId) {
        this.name = name;
        this.cursorId = cursorId;
    }

    @Override
    public int getClassId() {
        return 30;
    }

    @Override
    public void run() throws Exception {
        ReplicatedMapService service = (ReplicatedMapService)this.getService();
        ReplicatedMapIterationService iterationService = service.getIterationService();
        iterationService.getIteratorManager().cleanupIterator(this.cursorId);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:replicatedMapService";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        UUIDSerializationUtil.writeUUID(out, this.cursorId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        this.cursorId = UUIDSerializationUtil.readUUID(in);
    }
}

